/*
This is a Example program to retrieve and display the data. 
Press the Run button on the right of the screen (described the behavior of the Example program below). 
Please create a new application rewrite this program work. 
*/

function getLocPoint.  
// 表示するデータの分類（デフォルトは「区」）
var selCategory = "区";
// パッケージのロード
google.load('visualization', '1', {'packages':['motionchart']});
google.setOnLoadCallback(drawVisualization);

function setCategory(){
	selCategory = $("#category")[0].value;
//	alert(selCategory);
}

function drawVisualization() {
	var tabdata = new google.visualization.DataTable();
	var limit = 8;
	var count = 0;
	var category = '';
	var ku = '';
	var year = 0;
	var place = 0;
	var employee = 0;
	var ship  = 0;
	var added = 0;

	tabdata.addColumn('string','区');
	tabdata.addColumn('number','年度');
	tabdata.addColumn('number','事業所数');
	tabdata.addColumn('number','従業員数');
	tabdata.addColumn('number','製造品出荷額等');
	tabdata.addColumn('number','事業所付加価値額');

	$.each(LinkData.getWorks(), function(workKey, workValue) {
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				count = 0;
				$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					if(count++ > limit) {
						return false;
					}
					$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {

						if(propValue == 'http://lodosaka.hozo.jp/category'){
							category = objValue;
						}

						if(propValue == 'http://lodosaka.hozo.jp/name'){
							ku = objValue;
						}

						if(propValue == 'http://lodosaka.hozo.jp/year'){
							year = Number(objValue);
						}

						if(propValue == 'http://lodosaka.hozo.jp/num_of_business_place'){
							place = Number(objValue);
						}

						if(propValue == 'http://lodosaka.hozo.jp/num_of_employee'){
							employee = Number(objValue);
						}

						if(propValue == 'http://lodosaka.hozo.jp/shipment_value'){
							ship = Number(objValue);
						}

						if(propValue == 'http://lodosaka.hozo.jp/added_value'){
							added = Number(objValue);
						}

					});

				});

				// データのフィルタ
				if(category == selCategory){
					tabdata.addRow([ ku, year, place, employee, ship, added ]);
				}

			});
		});
	});
	
	// 描画サイズの調整
	var motionchart = new google.visualization.MotionChart(
		document.getElementById('visualization'));
	motionchart.draw(tabdata, {'width': 900, 'height': 500});

}
