//グローバル変数
var map;
var arrDay = new Array( 7,1,2,3,4,5,6 ); 

//読み込むファイル名
var BSLfile = "Kushima_Community_Bus_BusStopList";
var BRLfile = "Kushima_Community_Bus_RouteList";

//よくつかう連想配列のkey
var LabelKey = "http://www.w3.org/2000/01/rdf-schema#label";
var DescriptionKey = "http://purl.org/dc/elements/1.1/description";
var FeeKey = "http://linkdata.org/property/rdf1s1008i#fee";
var TimetableKey = "http://linkdata.org/property/rdf1s1008i#TimetableRef";
var ServiceDayKey = "http://linkdata.org/property/rdf1s1008i#day_8601";
var LatitudeKey = "http://www.w3.org/2003/01/geo/wgs84_pos#lat";
var LongitudeKey = "http://www.w3.org/2003/01/geo/wgs84_pos#long";

$(document).ready(function(){

	//今日の日付
	var nowdate = new Date();
	$("#today").text( nowdate.toLocaleString() );
	
	//Datepicker
	$( "#datepicker" ).datepicker();
	$( "#datepicker" ).datepicker( "option", "dateFormat", "yy/m/d" );
	$( "#datepicker" ).datepicker( "setDate", nowdate );
	var defaultDate = $( "#datepicker" ).datepicker( "getDate" );
	$( "#datepicker" ).val( toLocaleString(defaultDate));
	$( "#datepicker" ).change(function() { createActiveRouteTable(); });
	
	//Google Map 
	map = new GMaps({
		div: '#map',
 		zoom: 14,
 		lat: 31.4646457,
 		lng:131.218161
 	});
	
	createActiveRouteTable();
	
});

//運行中の路線を描画
function createActiveRouteTable(){

	//今日の日付
	var nowdate = $( "#datepicker" ).datepicker( "getDate" );
	var whatday = arrDay[nowdate.getDay()];
	
	//呼び出すオープンデータが保存されているプロジェクトのID
	var workValue = "rdf1s1008i";
	//バス停情報を呼び出すためのKeyを配列に保存
	var BusStopKeyList = LinkData.getSubjects(workValue, BSLfile );
	//取得できたか確認するために、配列の長さを吐き出させるテスト
	$("#test").append( BusStopKeyList.length + "戸　" );
	

	//テーブルから行を消す
	$("#result_tbody").empty();
	//マップをリセット
	map.removePolylines();
	map.removeMarkers();
	
	//路線情報を呼び出すためのKeyを配列に保存
	var RouteList = LinkData.getSubjects(workValue, BRLfile );
	var ActiveTimetableList=[];var ActiveRouteColor=[];
	//路線情報を総当たり攻撃
	$.each( RouteList , function(i){
		//運行する曜日を取得
		var check = LinkData.getObjects(workValue, BRLfile, RouteList[i], ServiceDayKey )[0];
		if( check.indexOf( whatday ) >= 0 ){ //運行してない路線はここで除外
			var Name = LinkData.getObjects(workValue, BRLfile, RouteList[i], LabelKey )[1];
			var NameEN = LinkData.getObjects(workValue, BRLfile, RouteList[i], LabelKey )[2]
			var Bound = LinkData.getObjects(workValue, BRLfile, RouteList[i], DescriptionKey )[0];
			var Fee = LinkData.getObjects(workValue, BRLfile, RouteList[i], FeeKey )[0];
			var Timetable = LinkData.getObjects(workValue, BRLfile, RouteList[i], TimetableKey )[0];
			var TimetableFile = LinkData.getObjects(workValue, BRLfile, RouteList[i], "http://linkdata.org/property/rdf1s1008i#TimetableFileRef" )[0];
			var ThemeColor = LinkData.getObjects(workValue, BRLfile, RouteList[i], "http://linkdata.org/property/rdf1s1008i#ThemeColor")[0];
			//運行している路線だけをテーブルに挿入
			$("#result_tbody").append(
				'<tr style="border-left:15px solid '+ThemeColor+'"><td><ruby>'+ Name +'<rt>'+ NameEN+'</rt></ruby></td><td>'+ Bound +'</td><td>'+ Fee +'</td></tr>'
			);
			ActiveTimetableList.push( [TimetableFile, Timetable] );
			ActiveRouteColor.push( ThemeColor );
		}
		//↑ここまで
		
	});
	
	
	
	//運行している路線が通過するバス停を地図に表示（コードテスト）
	$.each(ActiveTimetableList, function(k){
		var TimeTableFile = ActiveTimetableList[k][0];
		var TimeTableID = ActiveTimetableList[k][1];
		//初期化
		var pathpoints =[];
		var ActiveBusStopIDs=[];
		
		var ActiveBusStopKey = LinkData.getSubjects(TimeTableFile, TimeTableID );
		//バス停IDを抽出して配列に保存
		$.each( ActiveBusStopKey , function(i){
			//バス停IDを取得してpush
			ActiveBusStopIDs.push( 
				LinkData.getObjects(TimeTableFile, TimeTableID, ActiveBusStopKey[i], "http://linkdata.org/property/"+TimeTableFile+"#refID" )[0]
			);
		
		});
		//重複を削除
		ActiveBusStopIDs = unique(ActiveBusStopIDs);
	
		//マーカーを配置する
		$.each( ActiveBusStopIDs , function(i){
			//バス停IDを取得
			var ActiveBusStopID = ActiveBusStopIDs[i];
		
			//バス停IDと対応する情報を取得
			var Lat = LinkData.getObjects(workValue, BSLfile, "http://linkdata.org/resource/rdf1s1008i#"+ ActiveBusStopID, LatitudeKey )[0];
			var Long = LinkData.getObjects(workValue, BSLfile, "http://linkdata.org/resource/rdf1s1008i#"+ ActiveBusStopID, LongitudeKey )[0];
			var Title = LinkData.getObjects(workValue, BSLfile, "http://linkdata.org/resource/rdf1s1008i#"+ ActiveBusStopID, LabelKey )[1];
		
			//Polyline用
			pathpoints.push( [Lat,Long]);
		
			//地図に追加
			map.addMarker({
				lat: Lat, lng: Long, title: Title,
				infoWindow: { content: '<p>'+Title+'</p>' },/*HTML*/
				icon: "https://chart.googleapis.com/chart?chst=d_simple_text_icon_left&chld=|30|000|bus|16|FFF|333"
			});
		
		});
		map.drawPolyline({
			path: pathpoints,  strokeColor: ActiveRouteColor[k],  strokeOpacity: 0.6,  strokeWeight: 6,
		});
	
	});

}

//重複を取り除く関数
function unique(array) {
　var storage = {};
　var uniqueArray = [];
　var i,value;
　for ( i=0; i<array.length; i++) {
   　value = array[i];
      if (!(value in storage)) {
      　storage[value] = true;
         uniqueArray.push(value);
       }
   }
   return uniqueArray;
}
//連想配列の要素数を返す
function hashLength(array){
	var len = 0;
	for(var key in array) { len++; }
	return len;
}
// 出力例:2008/5/1 2:00:00
function toLocaleString( date )
{
    return [
        date.getFullYear(),
        date.getMonth() + 1,
        date.getDate()
        ].join( '/' ) + ' '
        + date.toLocaleTimeString();
}
