/*
$(function() {
	var spinner = $( "#spinner" ).spinner();
});
*/
if(typeof Application==="undefined"||!Application){var Application= {};}
	Application.gc = function() {
	this._init.apply(this, arguments);
}

var data_array = new Array();

Application.gc.prototype = {
	
	_data : null,
	_options : null,
	
	_init : function() {
		this._data = this._getGoogleDataTable();
		this._options = this._getGoogleOption();
	},
	
	_configArray : function() {
		var array = [			
			{
				"caption" : "Latitude",
				"property" : "lat"
			},
			{
				"caption" : "Longitude",
				"property" : "long"
			},
			{
				"caption" : "Location",
				"property" : "label"
			},
			{
				"caption" : "人口",
				"property" : "population"
			}
		];
		return array;
	},
	
	_getGoogleOption : function() {
		var options = {
			region: 'JP',
		   	displayMode: 'markers',
			colorAxis: {colors: ['yellow', 'red']}
      	};
		return options;
	},
	
	_getGoogleDataTable : function() {
		var configArray = this._configArray();
		var main = [];
		var array = [];
		$.each(configArray, function(index, obj) {
			array.push(obj.caption);
		});
		main.push(array);

		
		var mainArray = this._getObjectArray();
			$.each(mainArray, function(i, objArray) {
				array = [];
				$.each(objArray, function(j, objData) {
					$.each(configArray, function(k, obj) {
						if (objData.property === obj.property) {
							var val = objData.value;
							if (! isNaN(val)) {
								if (Math.floor(val).toString() == val.toString()) {
   									 // yay! we have an int
									val = parseInt(val);
								} else {
    								// it's a float or something else.
									val = parseFloat(val);
								} 
								/*if (val.substr(0,1) == "H") {
									console.log(val);
									continue;
								}*/
							}
							array[k] = val;
						}
					});
				});
				main.push(array);
			});
		return main;
	},
	
	_getObjectArray : function() {
		var main = [];
		$.each(LinkData.getWorks(), function(workKey, workValue) {
			$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
				$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
					var array = [];
					$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
						var obj = {};
						var propLabel = propValue;
						var arr = propValue.split("#");
						if (arr.length > 1) {
							propLabel = decodeURIComponent(arr[1]);
						}
						var objValue = LinkData.getObjects(workValue, fileValue, subjValue, propValue)[0];
						obj.property = propLabel;
						obj.value = objValue;
						array.push(obj);
					});
					main.push(array);
				});
			});
		});
		return main;
	},
	
	getData : function() {
		data_array = new Array();
		for (var i = 1920; i < 2001; i++) {
			data_array.push(sliceYear(this._data, i));
		}
	},
	
	getOptions : function() {
		return this._options;
	}
	
}

function sliceYear(data, year) {
	var start = year - 1920 + 1;
	var end = start + 48;
	var y_data = data.slice(0,1).concat(data.slice(start, end));
	//console.log(y_data);
	return y_data;
}

var drawMarkersMap = function() {
	var gc = new Application.gc();
	gc.getData();
	var data = google.visualization.arrayToDataTable(data_array[0]);
	var options = gc.getOptions();
	var chart = new google.visualization.GeoChart(document.getElementById('chart_div'));
	chart.draw(data, options);
}

function switchYear(year) {
	var gc = new Application.gc();
	var data = google.visualization.arrayToDataTable(data_array[year-1920]);
	var options = gc.getOptions();
	var chart = new google.visualization.GeoChart(document.getElementById('chart_div'));
	chart.draw(data, options);
}


google.load('visualization', '1', {'packages': ['geochart']});
google.setOnLoadCallback(drawMarkersMap);
