if(typeof TIL==="undefined" || !TIL){var TIL = {};}

TIL = function() {
	"use strict";
	this._init.apply(this, arguments);
}

TIL.prototype = {
	_msg : "NONE",
	_locations : [],
	_imgMarker : "http://app.linkdata.org/asset/5e0cd4bf.png",
	_imgMaleFemale : "http://app.linkdata.org/asset/158feb8d.png",
	_imgMale : "http://app.linkdata.org/asset/b77bcf78.png",
	_imgFemale : "http://app.linkdata.org/asset/adf9cde1.png",

	_init : function() {
		"use strict";
		this._msg = "";
	},
	
	setMarkers : function(map, locations) {
		"use strict";
		var i = 0;
		var infoWindow = new google.maps.InfoWindow();
		for (i = 0; i < locations.length; i++) {
			var location = locations[i];
			this.setMarker(map, infoWindow, location);
		}
	},
	setMarker : function(map, infoWindow, location) {
		var no = location[0];
		var name = location[1];
		var man = location[4];
		var woman = location[5];
		var commonuse = location[6];
		var handicapped = location[7];
		var babybed = location[8];
		var ostomate = location[9];
		var notuse = location[10];
		var remarks = location[11];
		var url = location[12];
		var latLng = new google.maps.LatLng(location[2], location[3]);
		var marker = new google.maps.Marker({
			position: latLng,
			map: map,
			title: name,
			icon: this._imgMarker,
			zIndex: 4
		});
		var sb = [];
		sb[sb.length] = '<div class="balloon">';
		sb[sb.length] = '  <div class="title">' + name + '</div>';
		sb[sb.length] = '  <div class="toilet">';
		if (man) {
			sb[sb.length] = '    <img src="' + this._imgMale + '" />:&nbsp;' + man + '&nbsp;';
		}
		if (woman) {
			sb[sb.length] = '    <img src="' + this._imgFemale + '" />:&nbsp;' + woman + '&nbsp;';
		}
		if (commonuse) {
			sb[sb.length] = '    <img src="' + this._imgMaleFemale + '" />:&nbsp;' + commonuse;
		}
		sb[sb.length] = '  </div>';
		if (handicapped) {
			sb[sb.length] = '  <div class="handicapped">多目的トイレ:&nbsp;' + handicapped + '</div>';
		}
		if (babybed) {
			sb[sb.length] = '  <div class="babybed">赤ちゃんベッド:&nbsp;' + babybed + '</div>';
		}
		if (ostomate) {
			sb[sb.length] = '  <div class="ostomate">オストメイト対応:&nbsp;' + ostomate + '</div>';
		}
		sb[sb.length] = '  <div class="description">';
		if (remarks) {
			sb[sb.length] = '    <div class="notuse">使用不可時間帯:&nbsp;' + notuse + '</div>';
		}
		if (remarks) {
			sb[sb.length] = '    <div class="remarks">' + remarks + '</div>';
		}
		sb[sb.length] = '  </div>';
		sb[sb.length] = '</div>';
		google.maps.event.addListener(marker, 'click', function() {
			infoWindow.setContent(sb.join(""));
			infoWindow.open(map, marker);
			self = this;
			$(".comment ." + no).click(function() {
				comments_html = '<fb:comments href="' + url + '" num_posts="2" width="470"></fb:comments>';
				$(this).html(comments_html);
				FB.XFBML.parse($(this).get(0), function(){
					var commentbox = $("#commentDialog").html();
					$(this).html(commentbox);
				});
			});
		});
	},
	popup : function() {
		"use strict";
	},
	getLocations : function() {
		"use strict";
		return this._locations;
	},

	googleMapInitialize : function(locations) {
		"use strict";
		var startLatlng = new google.maps.LatLng(35.69401,139.753966);
		var myOptions = {
			center: startLatlng,
			zoom: 15,
			mapTypeId: google.maps.MapTypeId.ROADMAP
		};
		var map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
		this.setMarkers(map, locations);
	},
	
	dataload : function() {
		"use strict";
		var works = TIL.getWorkIds();
		var self = this;
		$.each(works, function(workKey, workValue) {
			$.each(TIL.getFiles(workValue), function(workId, fileName) {
				$.each(TIL.getFiles(workValue), function(fileKey, fileValue) {
					console.log(fileValue);
					var no = 0;
					$.each(TIL.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
						var name = "";
						var man = 0;
						var woman = 0;
						var commonuse = 0;
						var handicapped = 0;
						var babybed = 0;
						var ostomate = 0;
						var notuse = 0;
						var remarks = 0;
						var lat = 0;
						var long = 0;
						var url = "";
						$.each(TIL.getProperties(workValue, fileValue), function(propKey, propValue) {
							$.each(TIL.getObjects(workValue, fileValue, subjValue, propValue.url), function(objKey, objValue) {
								url = subjValue;
								if (propValue.url === "http://www.w3.org/2000/01/rdf-schema#label") {
									name = objValue;
								} else if (propValue.label === "language") {
								} else if (propValue.label === "localname") {
									name = objValue;
								} else if (propValue.url === "http://www3.city.sabae.fukui.jp/xml/toilet/man" ) {
									man = objValue;
								} else if (propValue.url === "http://www3.city.sabae.fukui.jp/xml/toilet/woman" ) {
									woman = objValue;
								} else if (propValue.url === "http://www3.city.sabae.fukui.jp/xml/toilet/commonuse" ) {
									commonuse = objValue;
								} else if (propValue.url === "http://www3.city.sabae.fukui.jp/xml/toilet/handicapped" ) {
									handicapped = objValue;
								} else if (propValue.url === "http://www3.city.sabae.fukui.jp/xml/toilet/babybed" ) {
									babybed = objValue;
								} else if (propValue.url === "http://www3.city.sabae.fukui.jp/xml/toilet/ostomate" ) {
									ostomate = objValue;
								} else if (propValue.url === "http://www3.city.sabae.fukui.jp/xml/toilet/notuse" ) {
									notuse = objValue;
								} else if (propValue.url === "http://www3.city.sabae.fukui.jp/xml/toilet/remarks" ) {
									remarks = objValue;
								} else if (propValue.label === "lat" ) {
									lat = objValue;
								} else if (propValue.label === "long" ) {
									long = objValue;
								} else {
								}
							});
						});
						self._locations.push([no, name, lat, long, man, woman, commonuse, handicapped, babybed, ostomate, notuse, remarks, url]);
						no++;
					});
				});
			});
		});
	}
}


TIL.getWorkIds = function() {
	"use strict";
	return LinkData.getWorks();
}
TIL.getFiles = function(workId) {
	"use strict";
	return LinkData.getFiles(workId);
}
TIL.getSubjects = function(workId, fileName) {
	"use strict";
	return LinkData.getSubjects(workId, fileName);
}
TIL.getProperties = function(workId, fileName) {
	"use strict";
	var result = [];
    $.each(LinkData.getProperties(workId, fileName), function(key, value) {
        var arr = value.split("#");
        if (arr.length > 1) {
            result.push({"url" : value, "label" : decodeURIComponent(arr[1])});
        } else {
			result.push({"url" : value, "label" : decodeURIComponent(value)});
		}
    });
    return result;
}
TIL.getObjects = function(workId, fileName, subject, property) {
	"use strict";
	return LinkData.getObjects(workId, fileName, subject, property);
}


var init = function() {
	"use strict";
	var t = new TIL();
	t.dataload();

	t.googleMapInitialize(t.getLocations());
}

	"use strict";
	init();
