if(typeof Application==="undefined"||!Application){var Application= {};}
   
   Application.gc = function() {
	this._init.apply(this, arguments);
}

Application.gc.prototype = {
	
	_data : null,
	_options : null,
	_prefecture : null,
	
	_init : function() {
		this._prefecture = this._getGooglePrefecture();
		this._data = this._getGoogleDataTable();
		this._options = this._getGoogleOption();
	},
	
	_configArray : function() {
		var array = [
			{
				"caption" : "Location",
				"property" : "label"
			},
			{
				"caption" : "幸福度",
				"property" : "http://www.unisys.co.jp/research/happiness_ranking/property/total_ranking"
			}
		];
		return array;
	},
	
	_getGoogleOption : function() {
		var options = {
			region: 'JP',
			width:'800px',
			height:'600px',
			colors: [0x267114,0x50AA00,0xA5EF63,0xE0FFD4]
      	};
		return options;
	},
	
	_getGoogleDataTable : function() {
		var configArray = getConfigArray();
		var prefectureArray = this._prefecture;
		var main = [];
		var array = [];
		$.each(configArray, function(index, obj) {
			array.push(obj.caption);
		});
		array.push("都道府県名");
		main.push(array);

		var mainArray = this._getObjectArray();
		$.each(mainArray, function(i, objArray) {
			array = [];
			$.each(objArray, function(j, objData) {
				$.each(configArray, function(k, obj) {
					if (objData.property === obj.property) {
						var val = null;
						if (obj.property === "label") {
							$.each(prefectureArray, function(l, prefecture) {
								if (objData.value === prefecture.name ) {
									val = prefecture.codename;
									array[2] = objData.value;
								}
							});
						} else {
							val = objData.value;
						}
						
						if (! isNaN(val)) {
							if (Math.floor(val).toString() == val.toString()) {
								// yay! we have an int
								val = parseInt(val);
								//a(val);
								//a(array[2]);
								setRanking(array[2],val);
							} else {
								// it's a float or something else.
								val = parseFloat(val);
							} 
						}
						array[k] = val;
					}
				});
			});
			main.push(array);
		});
		return main;
	},
	
	_getObjectArray : function() {
		var main = [];
		$.each(LinkData.getWorks(), function(workKey, workValue) {
			$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
				$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
					var array = [];
					$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
						var obj = {};
						var propLabel = propValue;
						var arr = propValue.split("#");
						if (arr.length > 1) {
							propLabel = decodeURIComponent(arr[1]);
						}
						var objValue = LinkData.getObjects(workValue, fileValue, subjValue, propValue)[0];
						obj.property = propLabel;
						obj.value = objValue;
						array.push(obj);
					});
					main.push(array);
				});
			});
		});
		return main;
	},
	
	getData : function() {
		return this._data;
	},

	_getPrefecture : function() {
		return this._prefecture;
	},
	
	getOptions : function() {
		return this._options;
	},
	_getGooglePrefecture : function() {
		var array = [
			{name:"北海道", codename:"Hokkaido", code:"JP-01"},
			{name:"青森県", codename:"Aomori", code:"JP-02"},
			{name:"岩手県", codename:"Iwate", code:"JP-03"},
			{name:"宮城県", codename:"Miyagi", code:"JP-04"},
			{name:"秋田県", codename:"Akita", code:"JP-05"},
			{name:"山形県", codename:"Yamagata", code:"JP-06"},
			{name:"福島県", codename:"Fukushima", code:"JP-07"},
			{name:"茨城県", codename:"Ibaraki", code:"JP-08"},
			{name:"栃木県", codename:"Tochigi", code:"JP-09"},
			{name:"群馬県", codename:"Gunma", code:"JP-10"},
			{name:"埼玉県", codename:"Saitama", code:"JP-11"},
			{name:"千葉県", codename:"Chiba", code:"JP-12"},
			{name:"東京都", codename:"Tokyo", code:"JP-13"},
			{name:"神奈川県", codename:"Kanagawa", code:"JP-14"},
			{name:"新潟県", codename:"Niigata", code:"JP-15"},
			{name:"富山県", codename:"Toyama", code:"JP-16"},
			{name:"石川県", codename:"Ishikawa", code:"JP-17"},
			{name:"福井県", codename:"Fukui", code:"JP-18"},
			{name:"山梨県", codename:"Yamanashi", code:"JP-19"},
			{name:"長野県", codename:"Nagano", code:"JP-20"},
			{name:"岐阜県", codename:"Gifu", code:"JP-21"},
			{name:"静岡県", codename:"Shizuoka", code:"JP-22"},
			{name:"愛知県", codename:"Aichi", code:"JP-23"},
			{name:"三重県", codename:"Mie", code:"JP-24"},
			{name:"滋賀県", codename:"Shiga", code:"JP-25"},
			{name:"京都府", codename:"Kyoto", code:"JP-26"},
			{name:"大阪府", codename:"Osaka", code:"JP-27"},
			{name:"兵庫県", codename:"Hyogo", code:"JP-28"},
			{name:"奈良県", codename:"Nara", code:"JP-29"},
			{name:"和歌山県", codename:"Wakayama", code:"JP-30"},
			{name:"鳥取県", codename:"Tottori", code:"JP-31"},
			{name:"島根県", codename:"Shimane", code:"JP-32"},
			{name:"岡山県", codename:"Okayama", code:"JP-33"},
			{name:"広島県", codename:"Hiroshima", code:"JP-34"},
			{name:"山口県", codename:"Yamaguchi", code:"JP-35"},
			{name:"徳島県", codename:"Tokushima", code:"JP-36"},
			{name:"香川県", codename:"Kagawa", code:"JP-37"},
			{name:"愛媛県", codename:"Ehime", code:"JP-38"},
			{name:"高知県", codename:"Kochi", code:"JP-39"},
			{name:"福岡県", codename:"Fukuoka", code:"JP-40"},
			{name:"佐賀県", codename:"Saga", code:"JP-41"},
			{name:"長崎県", codename:"Nagasaki", code:"JP-42"},
			{name:"熊本県", codename:"Kumamoto", code:"JP-43"},
			{name:"大分県", codename:"Oita", code:"JP-44"},
			{name:"宮崎県", codename:"Miyazaki", code:"JP-45"},
			{name:"鹿児島県", codename:"Kagoshima", code:"JP-46"},
			{name:"沖縄県", codename:"Okinawa", code:"JP-47"}
		];
		return array;
	}
}
var userPrefecture;
var rivalPrefecture;
var userAnswer;
var tryCnt = 5;
var item;
var item2;
var item3;
var gc;

initialize();

function initialize(){
	//aaa("init");
	$("#content1").empty();
	$("#content2").empty();
	$("#content3").empty();
	$("#content4").empty();
 	$("#content5").empty();

	var interaction1 = "<h3>質問：あなたの出身の都道府県はどこですか？</h3><div style='padding-left:50px;'><select name='prefecture' id='selPrefecture'><option value='北海道'>北海道</option><option value='青森県'>青森県</option><option value='秋田県'>秋田県</option><option value='岩手県'>岩手県</option><option value='山形県'>山形県</option><option value='宮城県'>宮城県</option><option value='福島県'>福島県</option><option value='茨城県'>茨城県</option><option value='栃木県'>栃木県</option><option value='群馬県'>群馬県</option><option value='埼玉県'>埼玉県</option><option value='神奈川県'>神奈川県</option><option value='千葉県'>千葉県</option><option value='東京都'>東京都</option><option value='山梨県'>山梨県</option><option value='長野県'>長野県</option><option value='新潟県'>新潟県</option><option value='富山県'>富山県</option><option value='石川県'>石川県</option><option value='福井県'>福井県</option><option value='岐阜県'>岐阜県</option><option value='静岡県'>静岡県</option><option value='愛知県'>愛知県</option><option value='三重県'>三重県</option><option value='滋賀県'>滋賀県</option><option value='京都府'>京都府</option><option value='大阪府'>大阪府</option><option value='兵庫県'>兵庫県</option><option value='奈良県'>奈良県</option><option value='和歌山県'>和歌山県</option><option value='鳥取県'>鳥取県</option><option value='島根県'>島根県</option><option value='岡山県'>岡山県</option><option value='広島県'>広島県</option><option value='山口県'>山口県</option><option value='徳島県'>徳島県</option><option value='香川県'>香川県</option><option value='愛媛県'>愛媛県</option><option value='高知県'>高知県</option><option value='福岡県'>福岡県</option><option value='佐賀県'>佐賀県</option><option value='長崎県'>長崎県</option><option value='熊本県'>熊本県</option><option value='大分県'>大分県</option><option value='宮崎県'>宮崎県</option><option value='鹿児島県'>鹿児島県</option><option value='沖縄県'>沖縄県</option></select><button id='submit1' onclick='setUserPrefecture();' style='margin-left:20px;'>決定</button></div>";
	$("#content1").append(interaction1);

	var drawMarkersMap = function() {
		gc = new Application.gc();
		var data = google.visualization.arrayToDataTable(gc.getData());
		var options = gc.getOptions();
		var chart = new google.visualization.GeoMap(document.getElementById('chart_div'));
		google.visualization.events.addListener( 
			chart, 'regionClick', function(e) { 
				var prefectureName = getPrefectureNameByCode(e['region']);
				//drawRadar(prefectureName, "radar");
				setPrefectureRank2(prefectureName);
			}
		); 
		chart.draw(data, options);
	}
	google.load('visualization', '1', {'packages': ['geomap']});
	google.setOnLoadCallback(drawMarkersMap);
	var selectObject = document.getElementById('sel1');
	selectObject.onchange=function(){
		//var gc = new Application.gc();
		gc._getGoogleDataTable();
		drawMarkersMap();
	}
}

function aaa(val){
	alert(val);
}
function setUserPrefecture(){
	tryCnt = 5;
	$("#content2").empty();
	$("#content3").empty();
	$("#content4").empty();
	$("#content5").empty();
	setHappinessMapOff();
	var selectObject = document.getElementById('selPrefecture');
	userPrefecture = selectObject.value;
	var interastion2= "<h3>問題：<font color='Blue'>" + userPrefecture + "</font>の幸福度ランキングは何位でしょうか？</h3><div style='padding-left:50px;'><select id='selRank' name='rank'><option value='1'>1位</option><option value='2'>2位</option><option value='3'>3位</option><option value='4'>4位</option><option value='5'>5位</option><option value='6'>6位</option><option value='7'>7位</option><option value='8'>8位</option><option value='9'>9位</option><option value='10'>10位</option><option value='11'>11位</option><option value='12'>12位</option><option value='13'>13位</option><option value='14'>14位</option><option value='15'>15位</option><option value='16'>16位</option><option value='17'>17位</option><option value='18'>18位</option><option value='19'>19位</option><option value='20'>20位</option><option value='21'>21位</option><option value='22'>22位</option><option value='23'>23位</option><option value='24'>24位</option><option value='25'>25位</option><option value='26'>26位</option><option value='27'>27位</option><option value='28'>28位</option><option value='29'>29位</option><option value='30'>30位</option><option value='31'>31位</option><option value='32'>32位</option><option value='33'>33位</option><option value='34'>34位</option><option value='35'>35位</option><option value='36'>36位</option><option value='37'>37位</option><option value='38'>38位</option><option value='39'>39位</option><option value='40'>40位</option><option value='41'>41位</option><option value='42'>42位</option><option value='43'>43位</option><option value='44'>44位</option><option value='45'>45位</option><option value='46'>46位</option><option value='47'>47位</option></select><button id='submit2' onclick='setUserAnswer();' style='margin-left:20px;'>回答</button></div>";
	$("#content2").append(interastion2);	
}
function setUserAnswer(){
	setHappinessMapOff();
	if(tryCnt > 0 ){
		$("#content3").empty();
		$("#content4").empty();
		$("#content5").empty();
		tryCnt--;
		var selectObject = document.getElementById('selRank');
		userAnswer = parseInt(selectObject.value);
		item = getPrefectureData(userPrefecture);
		var interaction3;
		var correctAnswer = parseInt(item[1]);
		if(correctAnswer == userAnswer){
			interaction3 = "<div style='padding:20px 0px 0px 50px;'><font color='red'>正解</font>です！！<font color='Blue'>" + userPrefecture + "</font>は<font color='red'>" + correctAnswer + "位</font>です。おめでとうございます！</div>";
			$("#content3").empty();
			$("#content3").append(interaction3);
			setPrefectureRank();

		}else if(correctAnswer > userAnswer){
			if(tryCnt != 0){
				interaction3 = "<div style='padding:20px 0px 0px 50px;'><font color='red'>不正解</font>です！！ <font color='Blue'>" + userPrefecture + "</font>はもっと<font color='red'>下位</font>です。あと<font color='red'>" + tryCnt + "回</font>挑戦できます！</div>";
			}else{
				interaction3 = "<div style='padding:20px 0px 0px 50px;'><font color='red'>不正解</font>です！！<font color='Blue'>" + userPrefecture + "</font>はもっと<font color='red'>下位</font>です。<font color='red'>5回</font>失敗しました.</div><div style='padding:20px 0px 0px 50px;'><button onclick='setUserPrefecture();'>もう一度チャレンジする</button><button onclick='setPrefectureRank();'>あきらめて" + userPrefecture + "の順位を見る</button></div>";
			}
			$("#content3").empty();
			$("#content3").append(interaction3);	
		}else if(correctAnswer < userAnswer){
			if(tryCnt != 0){
				interaction3 = "<div style='padding:20px 0px 0px 50px;'><font color='red'>不正解</font>です！！ <font color='Blue'>" + userPrefecture + "</font>はもっと<font color='red'>上位</font>です。あと<font color='red'>" + tryCnt + "回</font>挑戦できます！</div>";
			}else{
				interaction3 = "<div style='padding:20px 0px 0px 50px;'><font color='red'>不正解</font>です！！<font color='Blue'>" + userPrefecture + "</font>はもっと<font color='red'>上位</font>です。<font color='red'>5回</font>失敗しました.</div><div style='padding:20px 0px 0px 50px;'><button onclick='setUserPrefecture();'>もう一度チャレンジする</button><button onclick='setPrefectureRank();'>あきらめて" + userPrefecture + "の順位を見る</button></div>";
			}
			$("#content3").empty();
			$("#content3").append(interaction3);	
		}else{
		}
	}else{
	}
}
function setPrefectureRank(){
	var interaction4 = "<div style='padding:20px 20px 20px 20px;margin:20px 20px 20px 20px;'><h3><font color='Blue'>" + userPrefecture + "</font>の幸福度ランキングの順位</h3><table bgcolor='White'><tr><td><div id='prefecture_table' style='width: 200px; height: 200px;'><table border='1'><tr><th width='100px' bgcolor='PaleGreen'>総合</th><td align='center' width='100px'>" + item[1] + "位</td></tr><tr><th width='100px' bgcolor='PaleGreen'><a href='javascript:void(0)' onclick='explainBasic();'>基本指標</a></th><td align='center' width='100px'>" + item[2] + "位</td></tr><tr><th width='100px' bgcolor='PaleGreen'>健康分野</th><td align='center' width='100px'>" + item[3] + "位</td></tr><tr><th width='100px' bgcolor='PaleGreen'>文化分野</th><td align='center' width='100px'>" + item[4] + "位</td></tr><tr><th width='100px' bgcolor='PaleGreen'>仕事分野</th><td align='center' width='100px'>" + item[5] + "位</td></tr><tr><th width='100px' bgcolor='PaleGreen'>生活分野</th><td align='center' width='100px'>" + item[6] + "位</td></tr><tr><th width='100px' bgcolor='PaleGreen'>教育分野</th><td align='center' width='100px'>" + item[7] + "位</td></tr></table></td><td><div id='prefecture_radar' style='width: 200px; height: 200px;margin-left:20px'><canvas width='260' height='200' id='radarPrefecture'></canvas></div></td></tr></table><button id='submit4' onclick='setRivalRank();' style='margin-top:20px'>ライバル県と比較する</button><button id='submit3' onclick='setHappinessMap();' style='margin-top:20px'>都道府県別 幸福度ランキングを見る</button></div>";
	$("#content4").empty();
	$("#content4").append(interaction4);
	drawRadar(userPrefecture, "radarPrefecture"); 
}
function explainBasic(){
	alert('基本指標は,人口増加率・一人当たりの県民所得・選挙投票率・食料自給率・財政健全度の5つの指標で構成される.');
}
function setPrefectureRank2(prefectureName){
	item3 = getPrefectureData(prefectureName);
	var interaction5 = "<div style='padding:20px 20px 20px 20px;margin:20px 20px 20px 20px;'><h3><font color='Blue'>" + prefectureName + "</font>の幸福度ランキングの順位</h3><table bgcolor='White'><tr><td><div id='prefecture_table' style='width: 200px; height: 200px;'><table border='1'><tr><th width='100px' bgcolor='PaleGreen'>総合</th><td align='center' width='100px'>" + item3[1] + "位</td></tr><tr><th width='100px' bgcolor='PaleGreen'>基本指標</th><td align='center' width='100px'>" + item3[2] + "位</td></tr><tr><th width='100px' bgcolor='PaleGreen'>健康分野</th><td align='center' width='100px'>" + item3[3] + "位</td></tr><tr><th width='100px' bgcolor='PaleGreen'>文化分野</th><td align='center' width='100px'>" + item3[4] + "位</td></tr><tr><th width='100px' bgcolor='PaleGreen'>仕事分野</th><td align='center' width='100px'>" + item3[5] + "位</td></tr><tr><th width='100px' bgcolor='PaleGreen'>生活分野</th><td align='center' width='100px'>" + item3[6] + "位</td></tr><tr><th width='100px' bgcolor='PaleGreen'>教育分野</th><td align='center' width='100px'>" + item3[7] + "位</td></tr></table></td><td><div id='prefecture_radar' style='width: 200px; height: 200px;margin-left:20px'><canvas width='260' height='200' id='radarPrefecture2'></canvas></div></td></tr></table></div>";
	$("#content5").empty();
	$("#content5").append(interaction5);
	drawRadar(prefectureName, "radarPrefecture2"); 
}
function setRivalRank(){
	var interaction4 = "<div style='padding:20px 20px 20px 20px;margin:20px 20px 20px 20px;'><h3><font color='Blue'>" + userPrefecture + "</font>の幸福度ランキングの順位</h3><table bgcolor='White'><tr><td><div id='prefecture_table' style='width: 300px; height: 230px;'><table border='1'><tr><td width='100px'>&nbsp;&nbsp;</td><th bgcolor='Yellow' width='100px'>" + userPrefecture + "</th><th bgcolor='LightPink' width='100px'><select name='prefecture' id='selRivalPrefecture' onchange='changeRivalPrefecture()'><option value='-'>選択</option><option value='北海道'>北海道</option><option value='青森県'>青森県</option><option value='秋田県'>秋田県</option><option value='岩手県'>岩手県</option><option value='山形県'>山形県</option><option value='宮城県'>宮城県</option><option value='福島県'>福島県</option><option value='茨城県'>茨城県</option><option value='栃木県'>栃木県</option><option value='群馬県'>群馬県</option><option value='埼玉県'>埼玉県</option><option value='神奈川県'>神奈川県</option><option value='千葉県'>千葉県</option><option value='東京都'>東京都</option><option value='山梨県'>山梨県</option><option value='長野県'>長野県</option><option value='新潟県'>新潟県</option><option value='富山県'>富山県</option><option value='石川県'>石川県</option><option value='福井県'>福井県</option><option value='岐阜県'>岐阜県</option><option value='静岡県'>静岡県</option><option value='愛知県'>愛知県</option><option value='三重県'>三重県</option><option value='滋賀県'>滋賀県</option><option value='京都府'>京都府</option><option value='大阪府'>大阪府</option><option value='兵庫県'>兵庫県</option><option value='奈良県'>奈良県</option><option value='和歌山県'>和歌山県</option><option value='鳥取県'>鳥取県</option><option value='島根県'>島根県</option><option value='岡山県'>岡山県</option><option value='広島県'>広島県</option><option value='山口県'>山口県</option><option value='徳島県'>徳島県</option><option value='香川県'>香川県</option><option value='愛媛県'>愛媛県</option><option value='高知県'>高知県</option><option value='福岡県'>福岡県</option><option value='佐賀県'>佐賀県</option><option value='長崎県'>長崎県</option><option value='熊本県'>熊本県</option><option value='大分県'>大分県</option><option value='宮崎県'>宮崎県</option><option value='鹿児島県'>鹿児島県</option><option value='沖縄県'>沖縄県</option></select></th></tr><tr><th bgcolor='PaleGreen'>総合</th><td align='center' width='100px' id='user_total'>" + item[1] + "位</td><td align='center' width='100px'id='rival_total'>-</td></tr><tr><th width='100px' bgcolor='PaleGreen'><a href='javascript:void(0)' onclick='explainBasic();'>基本指標</a></th><td align='center' width='100px' id='user_basic'>" + item[2] + "位</td><td align='center' width='100px' id='rival_basic'>-</td></tr><tr><th width='100px' bgcolor='PaleGreen'>健康分野</th><td align='center' width='100px' id='user_health'>" + item[3] + "位</td><td align='center' id='rival_health' width='100px'>-</td></tr><tr><th width='100px' bgcolor='PaleGreen'>文化分野</th><td align='center' width='100px' id='user_culture'>" + item[4] + "位</td><td align='center' width='100px' id='rival_culture'>-</td></tr><tr><th width='100px' bgcolor='PaleGreen'>仕事分野</th><td align='center' width='100px' id='user_work'>" + item[5] + "位</td><td align='center' width='100px' id='rival_work'>-</td></tr><tr><th width='100px' bgcolor='PaleGreen'>生活分野</th><td align='center' width='100px' id='user_life'>" + item[6] + "位</td><td align='center' width='100px' id='rival_life'>-</td></tr><tr><th width='100px' bgcolor='PaleGreen'>教育分野</th><td align='center' width='100px' id='user_education'>" + item[7] + "位</td><td align='center' width='100px' id='rival_education'>-</td></tr></table></td><td><div id='prefecture_radar' style='width: 260px; height: 200px;margin-left:20px'><canvas width='260' height='200' id='radarPrefecture'></canvas></div></td></tr></table><button id='submit4' onclick='setRivalRank();' style='margin-top:20px'>ライバル県と比較する</button><button id='submit3' onclick='setHappinessMap();' style='margin-top:20px'>都道府県別 幸福度ランキングを見る</button></div>";
	$("#content4").empty();
	$("#content4").append(interaction4);
	drawRadar(userPrefecture, "radarPrefecture"); 
}
function changeRivalPrefecture(){
	var selectObject = document.getElementById('selRivalPrefecture');
	rivalPrefecture = selectObject.options[selectObject.selectedIndex].text;
	item2 = getPrefectureData(rivalPrefecture);
	$("#rival_total").empty();
	$("#rival_total").append(item2[1] + "位");
	$("#rival_basic").empty();
	$("#rival_basic").append(item2[2] + "位");
	$("#rival_health").empty();
	$("#rival_health").append(item2[3] + "位");
	$("#rival_culture").empty();
	$("#rival_culture").append(item2[4] + "位");
	$("#rival_work").empty();
	$("#rival_work").append(item2[5] + "位");
	$("#rival_life").empty();
	$("#rival_life").append(item2[6] + "位");
	$("#rival_education").empty();
	$("#rival_education").append(item2[7] + "位");
	setRivalRanking("user_total", "rival_total", item[1], item2[1]);
	setRivalRanking("user_basic", "rival_basic", item[2], item2[2]);
	setRivalRanking("user_health", "rival_health", item[3], item2[3]);
	setRivalRanking("user_culture", "rival_culture", item[4], item2[4]);
	setRivalRanking("user_work", "rival_work", item[5], item2[5]);
	setRivalRanking("user_life", "rival_life", item[6], item2[6]);
	setRivalRanking("user_education", "rival_education", item[7], item2[7]);
	$("#prefecture_radar").empty();
	$("#prefecture_radar").append("<canvas width='260' height='200' id='radarPrefecture'></canvas>");
	drawRadar2("radarPrefecture"); 
}
function setRivalRanking(element1, element2, rank1, rank2){
	$("#" + element1).empty();
	$("#" + element2).empty();
	if(rank1 < rank2){
		$("#" + element1).append("<font color='red'>" + rank1 + "位</font>");
		$("#" + element2).append(rank2 + "位");
	}else if(rank1 > rank2){
		$("#" + element1).append(rank1 + "位");
		$("#" + element2).append("<font color='red'>" + rank2 + "位</font>");
	}else{
		$("#" + element1).append(rank1 + "位");
		$("#" + element2).append(rank2 + "位");
	}
}
function setHappinessMap(){
	$(prefectureRankingMap).css("display", "block");
}
function setHappinessMapOff(){
	$(prefectureRankingMap).css("display", "none");
}
function getConfigArray(){
	var selectObject = document.getElementById('sel1');
	var lab = selectObject.options[selectObject.selectedIndex].text;
	var col = selectObject.value
	$('#rankTitle').text(lab);
	var array = [
		{
			"caption" : "Location",
			"property" : "label"
		},
		{
			"caption" : lab,
			"property" : col
		}
	];
	return array;
}
function drawMarkersMap() {
	//gc = new Application.gc();
	var data = google.visualization.arrayToDataTable(gc.getData());
	var options = gc.getOptions();
    var chart = new google.visualization.GeoMap(document.getElementById('chart_div'));
      chart.draw(data, options);
}
function setRanking(prefecture, rank){
	if(rank == 1){
		$('#rank1').text(prefecture);
	}else if(rank == 2){
		$('#rank2').text(prefecture);
	}else if(rank == 3){
		$('#rank3').text(prefecture);
	}else if(rank == 45){
		$('#rank45').text(prefecture);
	}else if(rank == 46){
		$('#rank46').text(prefecture);
	}else if(rank == 47){
		$('#rank47').text(prefecture);
	}
}
function drawRadar(prefecture, element) {
	var items = new Array();
	items[0] = getPrefectureData(prefecture);
	var rc = new html5jp.graph.radar(element);
	if( ! rc ) { return; }
	var params = {
		aCap: ["総合", "基本", "健康", "文化", "仕事", "生活", "教育"],
		aMax: 1,
    	aMin: 47,
		chartShape: "circle",
		faceColors: ["green", "olive"],
		//aLinePositions: [0,1,2,3,4,5,6]
	}
	rc.draw(items, params);
}
function drawRadar2(element){
	var items = new Array();
	items[0] = getPrefectureData(userPrefecture);
	items[1] = getPrefectureData(rivalPrefecture);
	var rc = new html5jp.graph.radar(element);
	if( ! rc ) { return; }
	var params = {
		aCap: ["総合", "基本", "健康", "文化", "仕事", "生活", "教育"],
		aMax: 1,
    	aMin: 47,
		chartShape: "circle",
		faceColors: ["green", "olive"],
		//aLinePositions: [0,1,2,3,4,5,6]
	}
	rc.draw(items, params);
}
function getPrefectureNameByCode(prefectureCode){
	//var gc = new Application.gc();
	var prefectureArray = gc._getPrefecture();
	var prefectureName = null;
	$.each(prefectureArray, function(l, prefecture) {
		if (prefecture.code === prefectureCode) {
			prefectureName = prefecture.name;
		}
	});
	return prefectureName;
}
function getPrefectureData(prefectureName){
	//var gc = new Application.gc();
	var main = [];
	var mainArray = gc._getObjectArray();
	var preFlag = false;
	var prefectureData = new Array();
	$.each(mainArray, function(i, objArray) {
		array = [];
		$.each(objArray, function(j, objData) {
			if(!preFlag){
				if(objData.property === "label"){
					if(objData.value === prefectureName){
						preFlag = true;
						prefectureData[0] = objData.value;
					}
				}
			}else{
				if(objData.property != "label"){
					if(objData.property === "http://www.unisys.co.jp/research/happiness_ranking/property/total_ranking"){
						prefectureData[1] = parseInt(objData.value);
					}else if(objData.property == "http://www.unisys.co.jp/research/happiness_ranking/property/basic_index"){
						prefectureData[2] = parseInt(objData.value);
					}else if(objData.property == "http://www.unisys.co.jp/research/happiness_ranking/property/health_index"){
						prefectureData[3] = parseInt(objData.value);
					}else if(objData.property == "http://www.unisys.co.jp/research/happiness_ranking/property/culture_index"){
						prefectureData[4] = parseInt(objData.value);
					}else if(objData.property == "http://www.unisys.co.jp/research/happiness_ranking/property/work_index"){
						prefectureData[5] = parseInt(objData.value);
					}else if(objData.property == "http://www.unisys.co.jp/research/happiness_ranking/property/life_index"){
						prefectureData[6] = parseInt(objData.value);
					}else if(objData.property == "http://www.unisys.co.jp/research/happiness_ranking/property/education_index"){
						prefectureData[7] = parseInt(objData.value);
					}
				}
			}
		});
		preFlag = false;
	});
	return prefectureData;
}
	
	
	
	
	
	
	
