if (!YP) {
	var YP = {};
}

YP.main = function() {
	this._init.apply(this, arguments);
};

YP.main.prototype = {
	
	_infoList : null,
	_property : null,
	_subjectList : null,
	
	_cons : {
		MAX_ITEM_COUNT			: 5,
		INFO_SELECTOR			: ".info",
		KEY_WORD_SELECTOR		: "#keyword",
		INFO_LIST_SELECTOR		: "#infoList",
		MORE_INFO_SELECTOR		: ".moreInfo",
		TAG_SELECTOR			: ".tag",
		SEARCH_IMAGE_SELECTOR	: ".searchImage",
		EXPAND_ALL_SELECTOR		: ".expandAll",
		EXTRA_INFO_SELECTOR		: ".extraInfo",
		PAGE_TITLE_SELECTOR		: ".pageTitle",
		SHOW_ALL_BUTTON_SELECTOR: ".showAllButton"
		
	},
	
	_init : function() {
		this._infoList = [];
		this._property = new YP.property();
		this._initInfoList();
		this._initView();
		this._initListener();
	},
	
	_initInfoList : function() {
		var self = this, workId = self._property.getWorkId(), fileName = self._property.getFileName();
		var subjectList = LinkData.getSubjects(workId, fileName);
		for (var i = 0; i < subjectList.length; i++) {
			var subject = subjectList[i];
			var info = new YP.info();
//			info.setTitle(LinkData.getObjects(workId, fileName, subject, self._property.getTitleProperty())[0]);
			info.setName(self._getLabel(subject));
			info.setEmail(LinkData.getObjects(workId, fileName, subject, self._property.getEmailProperty())[0]);
			info.setOrgName(LinkData.getObjects(workId, fileName, subject, self._property.getOrgNameProperty())[0]);
			info.setDescription(LinkData.getObjects(workId, fileName, subject, self._property.getDescriptionProperty())[0]);
			info.setDepiction(LinkData.getObjects(workId, fileName, subject, self._property.getDepictionProperty())[0]);
			info.setHomePage(LinkData.getObjects(workId, fileName, subject, self._property.getHomePageProperty())[0]);
			info.setAchievements(LinkData.getObjects(workId, fileName, subject, self._property.getAchievementsProperty())[0]);
			info.setCapabilityList(LinkData.getObjects(workId, fileName, subject, self._property.getCapabilitiesProperty()));
			info.setMainPaperList(LinkData.getObjects(workId, fileName, subject, self._property.getMainPaperProperty()));
			self._infoList.push(info);
		}
	},
	
	_initView : function() {
		var self = this;
		var infoList = self._getInfoListByIndex(1, self._cons.MAX_ITEM_COUNT);
		self._addHtml(infoList);
		$(self._cons.KEY_WORD_SELECTOR).val("");
	},
	
	_initListener : function() {
		this._initPageTitleListener();
		this._initShowAllButtonListener();
		this._initMoreInfoListener();
		this._initAutoCompleter();
		this._initKeywordListener();
		this._initSearchImageListener();
	},
	
	_initPageTitleListener : function() {
		var self = this;
		$(self._cons.PAGE_TITLE_SELECTOR).click(function() {
			$(self._cons.KEY_WORD_SELECTOR).val("");
			var infoList = self._getInfoListByIndex(1, self._cons.MAX_ITEM_COUNT);
			self._addHtml(infoList);
		});
	},
	
	_initShowAllButtonListener : function() {
		var self = this;
		$(self._cons.SHOW_ALL_BUTTON_SELECTOR).click(function() {
			$(self._cons.KEY_WORD_SELECTOR).val("");
			var infoList = self._getInfoListByIndex(1, self._cons.MAX_ITEM_COUNT);
			self._addHtml(infoList);
		});
	},
	
	_initMoreInfoListener : function() {
		var self = this, page = 2;
		$(self._cons.MORE_INFO_SELECTOR).unbind("click");
		$(self._cons.MORE_INFO_SELECTOR).click(function() {
			var keyword = $(self._cons.KEY_WORD_SELECTOR).val();
			var infoList = self._getInfoListByIndex(page, self._cons.MAX_ITEM_COUNT, keyword);
			if (infoList.length != 0) {
				self._appendHtml(infoList, keyword);
				page++;
			} else {
				$(this).hide();
			}
		});
	},
	
	_initAutoCompleter : function() {
		var self = this;
		$(self._cons.KEY_WORD_SELECTOR).autocomplete({
			minLength: 2,
			source: function(req, res) {
				var keyword = req.term;
				res(self._getMatchWordListByKeyword(keyword));
			},
			select : function(event, ui) {
				var keyword = ui.item.value;
				var infoList = self._getInfoListByIndex(1, self._cons.MAX_ITEM_COUNT, keyword);
				self._addHtml(infoList, keyword);
			}
		})
	},
	
	_initKeywordListener : function() {
		var self = this;
		$(self._cons.KEY_WORD_SELECTOR).keydown(function(evt) {
			if (evt.which == 13) {
				$(self._cons.KEY_WORD_SELECTOR).autocomplete("close");
				var keyword = $(this).val();
				var infoList = self._getInfoListByIndex(1, self._cons.MAX_ITEM_COUNT, keyword);
				self._addHtml(infoList, keyword);
			}
		});
	},
	
	_initSearchImageListener : function() {
		var self = this;
		$(self._cons.SEARCH_IMAGE_SELECTOR).click(function() {
			$(self._cons.KEY_WORD_SELECTOR).autocomplete("close");
			var keyword = $(self._cons.KEY_WORD_SELECTOR).val();
			var infoList = self._getInfoListByIndex(1, self._cons.MAX_ITEM_COUNT, keyword);
			self._addHtml(infoList, keyword);
		});
	},
	
	_initTagListener : function() {
		var self = this;
		$(self._cons.INFO_LIST_SELECTOR + " " + self._cons.TAG_SELECTOR).unbind("click");
		$(self._cons.INFO_LIST_SELECTOR + " " + self._cons.TAG_SELECTOR).click(function() {
			var keyword = $(this).text().trim();
			$(self._cons.KEY_WORD_SELECTOR).val(keyword);
			var infoList = self._getInfoListByIndex(1, self._cons.MAX_ITEM_COUNT, keyword);
			self._addHtml(infoList, keyword);
		});
	},
	
	_initExpandAllListener : function() {
		var self = this;
		$(self._cons.INFO_LIST_SELECTOR + " " + self._cons.EXPAND_ALL_SELECTOR).unbind("click");
		$(self._cons.INFO_LIST_SELECTOR + " " + self._cons.EXPAND_ALL_SELECTOR).click(function() {
			var parent = $(this).closest(self._cons.INFO_SELECTOR);
			$(parent).find(self._cons.EXTRA_INFO_SELECTOR).show();
			$(this).hide();
		});
	},
	
	_addHtml : function(infoList, keyword) {
		var self = this;
		if (infoList.length != 0) {
			var html = self._getContentHtml(infoList, keyword);
			$(self._cons.INFO_LIST_SELECTOR).html(html);
			self._initMoreInfoListener();
			self._initTagListener();
			self._hideUnNecessaryExpandAllButton();
			self._initExpandAllListener();
			$(self._cons.MORE_INFO_SELECTOR).show();
		} else {
			var html = self._getNotFoundHtml();
			$(self._cons.INFO_LIST_SELECTOR).html(html);
			$(self._cons.MORE_INFO_SELECTOR).hide();
		}
	},
	
	_appendHtml : function(infoList, keyword) {
		var self = this;
		var html = self._getContentHtml(infoList, keyword);
		$(self._cons.INFO_LIST_SELECTOR).append(html);
		self._initTagListener();
		self._hideUnNecessaryExpandAllButton();
		self._initExpandAllListener();
	},
	
	_hideUnNecessaryExpandAllButton : function() {
		var self = this;
		$.each($(self._cons.INFO_LIST_SELECTOR + " " + self._cons.EXPAND_ALL_SELECTOR), function() {
			var parent = $(this).closest(self._cons.INFO_SELECTOR);
			var html = $(parent).find(self._cons.EXTRA_INFO_SELECTOR).html();
			if (!html || html.trim().length == 0) {
				$(this).hide();
			}
		});
	},
	
	_getInfoList : function(start, itemCount) {
		var self = this, list = [];
		var workId = self._property.getWorkId(), fileName = self._property.getFileName();
		var sList = self._getSubjectList(start, itemCount);
		for (var i = 0; i < sList.length; i++) {
			var subject = sList[i];
			var info = new YP.info();
//			info.setTitle(LinkData.getObjects(workId, fileName, subject, self._property.getTitleProperty())[0]);
			info.setName(self._getLabel(subject));
			info.setEmail(LinkData.getObjects(workId, fileName, subject, self._property.getEmailProperty())[0]);
			info.setOrgName(LinkData.getObjects(workId, fileName, subject, self._property.getOrgNameProperty())[0]);
			info.setDescription(LinkData.getObjects(workId, fileName, subject, self._property.getDescriptionProperty())[0]);
			info.setDepiction(LinkData.getObjects(workId, fileName, subject, self._property.getDepictionProperty())[0]);
			info.setHomePage(LinkData.getObjects(workId, fileName, subject, self._property.getHomePageProperty())[0]);
			info.setAchievements(LinkData.getObjects(workId, fileName, subject, self._property.getAchievementsProperty())[0]);
			info.setCapabilityList(LinkData.getObjects(workId, fileName, subject, self._property.getCapabilitiesProperty()));
			info.setMainPaperList(LinkData.getObjects(workId, fileName, subject, self._property.getMainPaperProperty()));
			list.push(info);
		}
		return list;
	},
	
	_getMatchWordListByKeyword : function(keyword) {
		var self = this, list = [];
		var infoList = self._getInfoListByIndex(1, self._cons.MAX_ITEM_COUNT, keyword);
		$.each(infoList, function(key, info) {
			if (info.getName().toLowerCase().indexOf(keyword.toLowerCase()) > -1 && $.inArray(info.getName(), list)) {
				list.push(info.getName());
			} 
			if (info.getEmail().toLowerCase().indexOf(keyword.toLowerCase()) > -1 && $.inArray(info.getEmail(), list)) {
				list.push(info.getEmail());
			}
			if (info.getOrgName().toLowerCase().indexOf(keyword.toLowerCase()) > -1 && $.inArray(info.getOrgName(), list)) {
				list.push(info.getOrgName());
			}
			var capabilityList = info.getCapabilityList();
			$.each(capabilityList, function(key, value) {
				if (value.trim().toLowerCase().indexOf(keyword.toLowerCase()) > -1 && $.inArray(value, list)) {
					list.push(value.trim());
				}
			});
		});
		return list;
	},
	
	_getInfoListByIndex : function(page, itemCount, keyword) {
		var self = this, list = [], count = 0;
		var end = (page * itemCount) - 1;
		var start = end - itemCount + 1;
		for (var i = 0; i < self._infoList.length; i++) {
			var info = self._infoList[i];
			if ((!keyword || keyword.trim().length == 0) || self._isHitInfo(info, keyword)) {
				if (count >= start && count <= end) {
					list.push(info);
				}
				count++;
			}
			if (list.length == itemCount) {
				return list;
			}
		}
		return list;
	},
	
	_isHitInfo : function(info, keyword) {
		if (!keyword || keyword.trim().length == 0) {
			return false;
		}
		if (info.getName().toLowerCase().indexOf(keyword.toLowerCase()) > -1) {
			return true;
		} else if (info.getEmail().toLowerCase().indexOf(keyword.toLowerCase()) > -1) {
			return true;
		} else if (info.getOrgName().toLowerCase().indexOf(keyword.toLowerCase()) > -1) {
			return true;
		} else if ($.inArray(keyword, info.getCapabilityList()) > -1) {
			return true;
		}
		var capabilityList = info.getCapabilityList();
		for (var i = 0; i < capabilityList.length; i++) {
			var capability = capabilityList[i];
			if (capability.toLowerCase().indexOf(keyword.toLowerCase()) > -1) {
				return true;
			}
		}
		return false;
	},
	
	_getContentHtml : function(infoList, keyword) {
		var self = this, sb = [];
		for (var i = 0; i < infoList.length; i++) {
			var info = infoList[i];
			sb[sb.length] = "<div class='info cf'>";
			sb[sb.length] = "<div class='profileImageArea left'>";
			sb[sb.length] = "<img class='profileImage' src='" + info.getDepiction() + "'/>";
			sb[sb.length] = "</div>";
			sb[sb.length] = "<div class='profileInfoArea left'>";
			sb[sb.length] = "<div class='name'>" + self._getHighLightKeywordHtml(info.getDisplayName(), keyword) + "</div>";
			sb[sb.length] = "<div>";
			if (info.getOrgName().trim().length != 0) {
				sb[sb.length] = "<span class='orgName'><i class='icon icon-briefcase'></i>" + self._getHighLightKeywordHtml(info.getOrgName(), keyword) + "</span>";
			}
			if (info.getEmail().trim().length != 0) {
				sb[sb.length] = "<i class='icon icon-envelope'></i><a href='mailto:" + info.getEmail() + "' class='email'>" + self._getHighLightKeywordHtml(info.getEmail(), keyword) + "</a>";
			}
			sb[sb.length] = "</div>";
			sb[sb.length] = "<div class='cf'>";
			sb[sb.length] = "<div class='tagList cf left'>" + self._getTagListHtml(info.getCapabilityList(), keyword) + "</div>";
			sb[sb.length] = "<div class='expandAll right'>&gt;&gt; more</div>";
			sb[sb.length] = "</div>";
			sb[sb.length] = "<div class='extraInfo hide'>";
			if (info.getDescription().trim().length != 0) {
				sb[sb.length] = "<div><i class='icon icon-comment'></i>" + info.getDescription() + "</div>";
			}
			if (info.getHomePage().trim().length != 0) {
				sb[sb.length] = "<div>";
				sb[sb.length] = "<i class='icon icon-user'></i><a href='" + info.getHomePage() + "' target='_blank' class='homePage'>" + info.getHomePage() + "</a>";
				sb[sb.length] = "</div>";
			}
			var mainPaperHtml = self._getMainPaperHtml(info.getMainPaperList());
			if (mainPaperHtml.trim().length != 0) {
				sb[sb.length] = "<div class='cf'>";
				sb[sb.length] = "<div class='left'><i class='icon icon-list'></i></div>";
				sb[sb.length] = "<div class='left'>" + mainPaperHtml + "</div>";
				sb[sb.length] = "</div>";
			}
			if (info.getAchievements().trim().length != 0) {
				sb[sb.length] = "<div>";
				sb[sb.length] = "<a href='" + info.getAchievements() + "' class='achievement' target='_blank'>&gt;&gt; show more achievements..</a>";
				sb[sb.length] = "</div>";
			}
			sb[sb.length] = "</div>";
			sb[sb.length] = "</div>";
			sb[sb.length] = "</div>";
		}
		return sb.join("");
	},
	
	_getHighLightKeywordHtml : function(text, keyword) {
		if (!keyword || keyword.trim().length == 0) {
			return text;
		}
		var regex = new RegExp('(' + keyword + ')', 'gi');
		return text.replace(regex, "<span class='highlight'>$1</span>");
	},
	
	_getNotFoundHtml : function() {
		var sb = [];
		sb[sb.length] = "<div class='info error'>No Participant Found</div>";
		return sb.join("");
	},
	
	_getTagListHtml : function(tagList, keyword) {
		var self = this, sb = [];
		for (var i = 0; i < tagList.length; i++) {
			var tag = tagList[i];
			sb[sb.length] = "<span class='tag left'>" + self._getHighLightKeywordHtml(tag.trim(), keyword) + "</span>";
		}
		return sb.join("");
	},
	
	_getMainPaperHtml : function(paperList) {
		var sb = [];
		for (var i = 0; i < paperList.length; i++) {
			var paper = paperList[i];
			sb[sb.length] = "<div class='mainPaper'>" + paper + "</div>";
		}
		return sb.join("");
	},
	
	_getLabel : function(subject) {
		var label = subject;
		var arr = subject.split("#");
		if (arr.length > 1) {
			label = decodeURIComponent(arr[1]);
		}
		return label;
	}
	
};

YP.property = function() {
	this._init.apply(this, arguments);
};

YP.property.prototype = {
	
	_workId : null,
	_fileName : null,
//	_titleProperty : null,
	_emailProperty : null,
	_orgNameProperty : null,
	_descriptionProperty : null,
	_depictionProperty : null,
	_homePageProperty : null,
	_achievementsProperty : null,
	_capabilitiesProperty : null,
	_mainPaperProperty : null,
	
	_cons : {
//		TITLE				: "#title",
		EMAIL				: "#email",
		ORGANIZATION_NAME	: "#organization-name",
		DESCRIPTION			: "description",
		DEPICTION			: "depiction",
		HOME_PAGE			: "homepage",
		ACHIEVEMENT			: "#achievements",
		CAPABILITIES		: "#capabilities",
		MAIN_PAPER			: "#mainpaper"
	},
	
	_init : function() {
		this._initProperty();
	},
	
	_initProperty : function() {
		var self = this;
		$.each(LinkData.getWorks(), function(workKey, workId) {
			$.each(LinkData.getFiles(workId), function(fileKey, fileName) {
				self._workId = workId;
				self._fileName = fileName;
				$.each(LinkData.getProperties(workId, fileName), function(propKey, propValue) {
//					if (propValue.indexOf(self._cons.TITLE) > -1) {
//						self._titleProperty = propValue;
//					} else 
					if (propValue.indexOf(self._cons.EMAIL) > -1) {
						self._emailProperty = propValue;
					} else if (propValue.indexOf(self._cons.ORGANIZATION_NAME) > -1) {
						self._orgNameProperty = propValue;
					} else if (propValue.indexOf(self._cons.DESCRIPTION) > -1) {
						self._descriptionProperty = propValue;
					} else if (propValue.indexOf(self._cons.DEPICTION) > -1) {
						self._depictionProperty = propValue;
					} else if (propValue.indexOf(self._cons.HOME_PAGE) > -1) {
						self._homePageProperty = propValue;
					} else if (propValue.indexOf(self._cons.ACHIEVEMENT) > -1) {
						self._achievementsProperty = propValue;
					} else if (propValue.indexOf(self._cons.CAPABILITIES) > -1) {
						self._capabilitiesProperty = propValue;
					} else if (propValue.indexOf(self._cons.MAIN_PAPER) > -1) {
						self._mainPaperProperty = propValue;
					}
				});
				return false;
			});
			return false;
		});
	},
	
	getWorkId : function() {
		return this._workId;
	},
	
	getFileName : function() {
		return this._fileName;
	},
	
//	getTitleProperty : function() {
//		return this._titleProperty;
//	},
	
	getEmailProperty : function() {
		return this._emailProperty;
	},
	
	getOrgNameProperty : function() {
		return this._orgNameProperty;
	},
	
	getDescriptionProperty : function() {
		return this._descriptionProperty;
	},
	
	getDepictionProperty : function() {
		return this._depictionProperty;
	},
	
	getHomePageProperty : function() {
		return this._homePageProperty;
	},
	
	getAchievementsProperty : function() {
		return this._achievementsProperty;
	},
	
	getCapabilitiesProperty : function() {
		return this._capabilitiesProperty;
	},
	
	getMainPaperProperty : function() {
		return this._mainPaperProperty;
	}
	
};

YP.info = function() {
	this._init.apply(this, arguments);
};

YP.info.prototype = {
	
//	_title : null,
	_name : null,
	_email : null,
	_orgName : null,
	_description : null,
	_depiction : null,
	_homePage : null,
	_achievement : null,
	_capabilityList : null,
	_mainPaperList : null,
	
	_init : function() {},
	
//	getTitle : function() {
//		if (!this._title) {
//			this._title = "";
//		}
//		return this._title;
//	},
	
//	setTitle : function(title) {
//		this._title = title;
//	},
	
	getName : function() {
		if (!this._name) {
			this._name = "";
		}
		return this._name;
	},
	
	setName : function(name) {
		this._name = name;
	},
	
	getDisplayName : function() {
		return this._name;
	},
	
	getEmail : function() {
		if (!this._email) {
			this._email = "";
		}
		return this._email;
	},
	
	setEmail : function(email) {
		this._email = email;
	},
	
	getOrgName : function() {
		if (!this._orgName) {
			this._orgName = "";
		}
		return this._orgName;
	},
	
	setOrgName : function(orgName) {
		this._orgName = orgName;
	},
	
	getDescription : function() {
		if (!this._description) {
			this._description = "";
		}
		return this._description;
	},
	
	setDescription : function(description) {
		this._description = description;
	},
	
	getDepiction : function() {
		if (!this._depiction) {
			this._depiction = "http://app.linkdata.org/asset/d4a3f83b.png";
		}
		return this._depiction;
	},
	
	setDepiction : function(depiction) {
		this._depiction = depiction;
	},
	
	getHomePage : function() {
		if (!this._homePage) {
			this._homePage = "";
		}
		return this._homePage;
	},
	
	setHomePage : function(homePage) {
		this._homePage = homePage;
	},
	
	getAchievements : function() {
		if (!this._achievements) {
			this._achievements = "";
		}
		return this._achievements;
	},
	
	setAchievements : function(achievements) {
		this._achievements = achievements;
	},
	
	getCapabilityList : function() {
		return this._capabilityList;
	},
	
	setCapabilityList : function(capabilityList) {
		this._capabilityList = capabilityList;
	},
	
	getMainPaperList : function() {
		return this._mainPaperList;
	},
	
	setMainPaperList : function(mainPaperList) {
		this._mainPaperList = mainPaperList;
	}
	
};

$(document).ready(function() {
	new YP.main();
});
