var PG = PG || {};

// ※表示タイトル
PG.title = "ツバメシビューワ";

// ※プロパティの設定
PG.property = {
	name : "name",
	img_link : "img_link",
	recipe_link : "recipe_link"
}

window.onload = function() {
	var list = "";
	$("#container").prepend("<h3>" + PG.title + "</h3>");
	// 指定されたworkを全件取得
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		// workに含まれるfileを全件取得
		var propUri = stringToUri(PG.property, workValue);
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			// subjectを全件取得
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var name = "";
				var recipeUrl = "";
				var imageUrl = "";
				var str = "";

				$.each( LinkData.getTriplesBySubject(workValue, fileValue, subjValue), function( tripleKey, tripleValue ) {
					var prop = tripleValue.property;
					var obj = tripleValue.object;
					if ( prop == propUri.name )  name = obj;
					else if ( prop == propUri.img_link ) imageUrl = obj ;
					else if ( prop == propUri.recipe_link ) recipeUrl = obj ;
				});
				str += "<li class=\"flipImage\"><div class=\"front\"><a href='#'><img src=\"" + imageUrl + "\" alt=\"image\" /></a></div><div class=\"back\"><p class=\"label\">" + name + "<p class=\"detail\">" + "材料を載せたい"  + "</p>"  + "<span class=\"button\">" + "<a href=\"" + recipeUrl + "\" target=\"_blank\">レシピにジャンプ</a>" + "</span></div></li>"
				list += str;
			});
		});
	});
	$("#result").append( list );
	
	// 画像を正方形にトリミング
	$(".front").imgLiquid();
	
	// 画像が読み込めなかった時の処理
	$("img").error(function(){
		$(this).before("No Image");
	});
	
	$( 'a' )
	  .bind( 'touchstart', function(){
 	   $( this ).addClass( 'hover' );
	}).bind( 'touchend', function(){
	    $( this ).removeClass( 'hover' );
	});
};

// Google Mapのルート検索へのリンクを追加
function addLinkToMap( latitude, longitude )
{
	var str = "";
	if (latitude.length != 0 && longitude.length != 0) {
		str = "<a target=\"_blank\" class=\"object\" href=\"http://maps.google.co.jp/maps?daddr=" + latitude + "," + longitude + "\">ルート検索</a>"
	}
	return str;
}

function stringToUri (p, workId) {
	$.each (p, function(propKey, propVal){
		if(propVal.indexOf("http") != 0){
			p[propKey] = "http://linkdata.org/property/" + workId + "#" + encodeURIComponent(propVal);
		}
	})
	return p;
}
