/*
このアプリは、科目の開講期を表にして表示します。
以下のプロパティを使用します。
http://purl.org/dc/terms/date : 開講期（1年前期、2年集中など）
http://purl.org/dc/terms/title : 科目名
http://purl.org/dc/terms/creator : 担当教員
*/
function Data(){
	this.title="";
	this.teacher="";
	this.row=-1;
	this.col=-1;
}

function MyMap(){
	var startLatlng=new google.maps.LatLng(31.570939930029475,130.54197843383793);  // 鹿児島大学工学部情報生体システム工学科
	var myOptions={
		center: startLatlng,
		zoom: 19,
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};
	var map=new google.maps.Map(document.getElementById("map"), myOptions);
}

// 要素の大きさの調整（未使用）
function adjustTableAndMap(){
	var tbl=document.getElementById("table");
	var map_div=document.getElementById("map");
	var td=map_div.parentNode;
	var tr=td.parentNode;
	alert(td.tagName+" w="+td.clientWidth+" "+tr.tagName+" w="+tr.clientWidth+" "+tbl.tagName+" w="+tbl.clientWidth);
	/*
	if(tbl.clientWidth<tr.clientWidth/2){
		map_div.clientWidth=tr.clientWidth-tbl.clientWidth;
	}
	else{
		tbl.clientWidth=tr.clientWidth*0.3;
		map_div.clientWidth=tr.clientWidth*0.7;
	}
	*/
}

// 読み込み時
window.onload=function() {
	makeMap();
	makeTable();
};

function makeMap(){
	new MyMap();
}

function makeTable(){
	var tab=document.getElementById("table");
	tab.border=1;
	var td=[];
	var tr0=document.createElement("tr");
	tr0.innerHTML="<th>学年</th><th>前期</th><th>後期</th>";
	tab.appendChild(tr0);
	for(var i=0;i<6;i++){
		var tr=document.createElement("tr");
		var th0=document.createElement("th");
		th0.innerHTML=(i<4)?((i+1)+"年"):((i==4)?"集中":"不明");
		tr.appendChild(th0);
		td[i]=[];
		for(var j=0;j<2;j++){
			if(i<4 || j!=1){
				td[i][j]=document.createElement("td");
				if(i>=4 && j==0)
					td[i][j].setAttribute("colspan",2);
				tr.appendChild(td[i][j]);
			}
		}
		tab.appendChild(tr);
	}
	
	var keyword=getParameterFromURL("subject"); // obtain keyword from the URL "?subject="
	$.each(LinkData.getWorks(),function(w_key,w_val){
		//$("#result").append("<p>work key="+w_key+" val="+w_val+"</p>");
		$.each(LinkData.getFiles(w_val),function(f_key,f_val){
			//$("#result").append("<p>file key="+f_key+" val="+f_val+"</p>");
			//alert("subject count="+LinkData.getSubjectsCount(w_val,f_val));
			$.each(LinkData.getSubjects(w_val,f_val),function(s_key,s_val){
				//$("#result").append("<p>subj key="+s_key+" val="+s_val+"</p>");
				var trip=LinkData.getTriplesBySubject(w_val,f_val,s_val);
				var data=[];
				for(var i in trip){
					var subj=trip[i].subject;
					var prop=trip[i].property;
					var obj=trip[i].object;
					if(data[subj]==null) data[subj]=new Data();
					var dt=data[subj];
					if(prop=="http://purl.org/dc/terms/date"){
						var s1=obj.substr(0,2);
						var s2=obj.substr(2,2);
						dt.row=5; dt.col=0;
						if(s1=="1年") dt.row=0;
						else if(s1=="2年") dt.row=1;
						else if(s1=="3年") dt.row=2;
						else if(s1=="4年") dt.row=3;
						if(s2=="前期") dt.col=0;
						else if(s2=="後期") dt.col=1;
						else if(s2=="集中"){ dt.row=4; dt.col=0; }
						//$("#result").append("<p>row="+dt.row+" col="+dt.col+" s2="+s2+"</p>");
					}
					if(prop=="http://purl.org/dc/terms/title"){
						dt.title=obj;
						//$("#result").append("<p>title="+dt.title+"</p>");
					}
					if(prop=="http://purl.org/dc/terms/creator"){
						dt.teacher=obj;
						//$("#result").append("<p>teacher="+dt.teacher+"</p>");
					}
				}
				for(var i in data){
					var dt=data[i];
					td[dt.row][dt.col].innerHTML+="<p>"+dt.title+"("+dt.teacher+")</p>";
				}
			});
		});
	});
}

// Get a parameter value in URL (e.g. ?paramString=value )
function getParameterFromURL( paramString )
{			
	var value = "";
	var topWindow = top.window.location.search;
	if( topWindow ){
		var q = decodeURIComponent(topWindow.substring(1,topWindow.length)).split("&");
		for ( var i = 0; i < q.length; i++ ){
			var r = q[i].split("=");
			if ( r[0] ==  paramString )
				value = r[1];
		}
	}
 	return value;
}

// Highlight keyword in the string
function highlight( string, keyword )
{
	if ( keyword.length > 0 ) {
		var ss = string.split(keyword);
		var len = ss.length;
		if ( len > 1 ) {
			string = ss[0];
			for ( i = 1; i < len; i++ )
//				string += "<font color=\"red\">"+keyword+"</font>"+ss[i];
				string += "<span class=\"highlight\">"+keyword+"</span>"+ss[i];
		}
	}
	return string;
}

// get the last name of the string separated with # and /
function getLastName( string )
{
	string = decodeURIComponent(string);
	var sharp = string.split("#");
	var slash = sharp[sharp.length-1].split("/");
	var lastName = slash[slash.length-1];
	return lastName;
}

// return a link to Google map search
function addLinkToMap( latitude, longitude )
{
	var s = "<br><a target=\"_blank\" href=\"http://www.google.com/maps/?q=" + latitude + "," + longitude + "\">Show map</a>";
	return s;
}

// shortening URL e.g. http://.../123.jpg
function shortenURL( url )
{
	url = decodeURIComponent(url);
	var slash = url.split("/");
	var lastName = slash[slash.length-1];
	return url.split(":")[0]+"://.../"+lastName;
}
