/*
This is a Example program to retrieve and display the list of the data. Press the play/reload button on the right of the upper screen, and the program is executed. The program first displayes the subjects that match the keyword completely. The program highlights the list fragments that match the keyword. The keyword is retrieved from the query following "subject=" in the URL, where the keyword must be encoded. Please create a new application by rewriting this program work. The following is the same content in Japanese.
このサンプルプログラムはデータを取得してリスト表示します。画面右上のplay又はreloadボタンを押すとプログラムが実行されます。プログラムはキーワードに完全一致するサブジェクトを最初に表示します。またプログラムはキーワードに部分一致するリスト中の部分をハイライトします。キーワードはURLの中で"subject="に続くクエリーから取得されます。ただし、キーワードはURIエンコードされている必要があります。このプログラムを書き変えて新しいアプリケーションを作成してください。
*/

window.onload = function() {
	var keyword = getParameterFromURL("subject"); // obtain keyword from the URL "?subject="
	var list = "<table border='1' width='500' cellspacing='0' cellpadding='5' bordercolor='#333333'>"; // list to be displayed
	// Work loop
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		$("#result").append("<h3>" + LinkData.getWorkName(workValue) + "</h3>");
		// File loop
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			var hit = ""; // list of subjects whose URI matches keyword
			var nHit = 0; // number of subjects whose URI matches keyword
			// Subject loop
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var longitude = null;
				var latitude = null;
				var s = ""; // subject to be displayed

				$.each( LinkData.getTriplesBySubject(workValue, fileValue, subjValue), function( tripleKey, tripleValue ) {
					var prop = tripleValue.property;
					var obj = tripleValue.object;
					if ("Latitude" != getLastName(prop)) {
						if ( obj.indexOf("http") == 0 ) {
							obj = "<a href=\"" + obj + "\" target=\"_blank\"><span class=\"object\">" + shortenURL(obj) + "</span></a>"; // Make it clicable if it starts from http
						} else {
							if ("Longitude" != getLastName(prop)){
								obj = "<span class=\"object\">" + highlight(obj, keyword) + "</span>";
							} else {
								longitude = obj;
								obj = addLinkToMap( latitude, longitude );
							}
						}

						s += "<td>" + obj + "</td>";
					} else {
						latitude = obj;
					}
				});
				list += "<tr>" + s + "</tr>"; //add to the list to be displayed
				if ( decodeURIComponent(subjValue) == keyword ) { // found subject whose URI matches keyword
					hit += s;
					nHit++;
				}
				//link to map display if coordinates exist
			});
		});
	});
	list += "</table>"
	$("#result").append( list );
	window.find(highlight);
};

// Get a parameter value in URL (e.g. ?paramString=value )
function getParameterFromURL( paramString )
{			
	var value = "";
	var topWindow = top.window.location.search;
	if( topWindow ){
		var q = decodeURIComponent(topWindow.substring(1,topWindow.length)).split("&");
		for ( var i = 0; i < q.length; i++ ){
			var r = q[i].split("=");
			if ( r[0] ==  paramString )
				value = r[1];
		}
	}
 	return value;
}

// Highlight keyword in the string
function highlight( string, keyword )
{
	if ( keyword.length > 0 ) {
		var ss = string.split(keyword);
		var len = ss.length;
		if ( len > 1 ) {
			string = ss[0];
			for ( i = 1; i < len; i++ )
//				string += "<font color=\"red\">"+keyword+"</font>"+ss[i];
				string += "<span class=\"highlight\">"+keyword+"</span>"+ss[i];
		}
	}
	return string;
}

// get the last name of the string separated with # and /
function getLastName( string )
{
	string = decodeURIComponent(string);
	var sharp = string.split("#");
	var slash = sharp[sharp.length-1].split("/");
	var lastName = slash[slash.length-1];
	return lastName;
}

// return a link to Google map search
function addLinkToMap( latitude, longitude )
{
	var s = "<br><a target=\"_blank\" href=\"http://www.google.com/maps/?q=" + latitude + "," + longitude + "\">Show map</a>";
	return s;
}

// shortening URL e.g. http://.../123.jpg
function shortenURL( url )
{
	url = decodeURIComponent(url);
	var slash = url.split("/");
	var lastName = slash[slash.length-1];
	return url.split(":")[0]+"://.../"+lastName;
}
