window.onload = function () {
    var keyword = getParameterFromURL("subject"); // obtain keyword from the URL "?subject="
    var count = 0; // number of subjects whose URI matches keyword
    // Work loop
    $.each(LinkData.getWorks(), function (workKey, workValue) {
        // File loop
        $.each(LinkData.getFiles(workValue), function (fileKey, fileValue) {
            // Subject loop
            $.each(LinkData.getSubjects(workValue, fileValue), function (subjKey, subjValue) {
                var s = ""; // subject to be displayed
                s += "<hr><a href=\"" + subjValue + "\" target=\"_top\"><span class=\"subject\">" +
                        highlight(decodeURIComponent(subjValue), keyword) + "</span></a>";
                var data = new Array();
                var tableRow = '<tr>';
                $.each(LinkData.getTriplesBySubject(workValue, fileValue, subjValue), function (tripleKey, tripleValue) {
                    var prop = tripleValue.property;
                    var obj = tripleValue.object;
                    var propertyName = getLastName(prop);
                    data[propertyName] = obj;
                });
                // 行の内容を生成
                tableRow += '<td>' + addLinkToSite(data['URL'], data['蔵元名']) + '<br>' +
                        '<span class="mainItem">【' + addLinkToAmazon(data['代表銘柄']) + '】</span></td>';
                tableRow += '<td>' + data['郵便番号'] + '<br>' + //data['住所'] + '</td>';
                        addLinkToMap(data['Latitude'], data['Longitude'], data['住所']) + '</td>';
                tableRow += '<td>' + data['電話番号'] + '</td>';
                tableRow += '<td>' + (data['営業時間'] ? data['営業時間'] : '&#160;') + '</td>';
                tableRow += '<td>' + (data['定休日'] ? data['定休日'] : '&#160;') + '</td>';
                tableRow += '</tr>';
                $('#kura tr:last').after(tableRow);
                ++count;
            });
        });
    });
    if (count > 0) {
        $("#resultCount").append(count + " 件のデータを表示しています。");
    }
    window.find(highlight);
};

// Get a parameter value in URL (e.g. ?paramString=value )
function getParameterFromURL(paramString)
{
    var value = "";
    var topWindow = top.window.location.search;
    if (topWindow) {
        var q = decodeURIComponent(topWindow.substring(1, topWindow.length)).split("&");
        for (var i = 0; i < q.length; i++) {
            var r = q[i].split("=");
            if (r[0] == paramString)
                value = r[1];
        }
    }
    return value;
}

// Highlight keyword in the string
function highlight(string, keyword)
{
    if (keyword.length > 0) {
        var ss = string.split(keyword);
        var len = ss.length;
        if (len > 1) {
            string = ss[0];
            for (i = 1; i < len; i++)
//				string += "<font color=\"red\">"+keyword+"</font>"+ss[i];
                string += "<span class=\"highlight\">" + keyword + "</span>" + ss[i];
        }
    }
    return string;
}

// get the last name of the string separated with # and /
function getLastName(string)
{
    string = decodeURIComponent(string);
    var sharp = string.split("#");
    var slash = sharp[sharp.length - 1].split("/");
    var lastName = slash[slash.length - 1];
    return lastName;
}

// return a link to Google map search
function addLinkToMap(latitude, longitude, subject)
{
    var s = '<a target="_blank" href="http://www.google.com/maps/?q=' + latitude + ',' + longitude + '">' +
            subject + '</a>';
    return s;
}

/**
 * 蔵の名前にサイトへのリンクを張る
 * @param {type} url
 * @param {type} subject
 * @returns {undefined}
 */
function addLinkToSite(url, subject)
{
    if (url) {
        return '<a target="_blank" href="' + url + '">' + subject + '</a>';
    } else {
        return subject;
    }
}

function addLinkToAmazon(subject)
{
    return '<a target="_blank" href="http://www.amazon.co.jp/s/ref=nb_sb_noss_1?url=search-alias%3Dfood-beverage&' +
            'field-keywords=' + subject + '">' + subject + '</a>';
}


// shortening URL e.g. http://.../123.jpg
function shortenURL(url)
{
    url = decodeURIComponent(url);
    var slash = url.split("/");
    var lastName = slash[slash.length - 1];
    return url.split(":")[0] + "://.../" + lastName;
}
