// このプログラムは東急電鉄のデータに特別に合せているので他のデータでは動作しません
var targetData = "乗降人員合計(2013年)";// スタンプの押せるサークル半径の元になる数値（このデータがない地点にはサークルが出ません）
var targetArea  = 1; // targetDataにこの値を掛けた面積のサークルを半径にします
var nameToShow = "station"; // ツイッターでシェアする際に、このプロパティの値を地点の名前としてツイッターに挿入します。省略（ヌル文字列）すればサブジェクト名が選択されます
var nameToShow1 = "line";
var nameToShow2 = "乗降人員合計(2013年)";

// Created by Tetsuro Toyoda Ver. 2015.01.22.2
var stampUrl = "http://app.linkdata.org/asset/4b2b5bcf.png";//スタンプの画像です。好きなものに変えてください
var circle = 200;// 目的地点との距離がこのメートル以下になればスタンプを押せます
var ageofstamp = 30; //この日数が経過するとスタンプはリセットされます
var currlat = null; //現在地点の緯度
var currlong = null; //現在地点の経度
var destlat = null; //目的地の緯度
var destlong = null; //目的地の経度
var points = new Array(); // スタンプのある地点のリスト
var timerid; // 現在地点を定期的に観測するためのタイマー
var lastTimeOfSuccess =""; // 前回現在位置を取得するのに成功した時刻
var timerInterval = 1;//位置情報を取得する間隔（秒単位）
var displayMode = "allLoc"; // 表示モード
var map = null; // 現在地の情報を表示するマップ
var mapCircle = null;//目的地のサークル群
var mapCircleIsStamped = null;//サークルがスタンプされていればtrue
var currPosMarker = null;// 現在位置を表すマーカー
var directionsService = null;
var directionsDisplay = null;
var travelMode = ['NOTHING','WALKING','DRIVING'];
var travelModeJ = ['解除','徒歩','自動車'];
var travelIndex = 0;
var destinationURI = "";
var destinationName = "";
var destinationRadius = 0;
var destButtonCaption = ['目的地に設定する','目的地設定を解除する'];
var debug = false; // デバッグ時にtrueでタイマーをオフにできる

function setDestination( i )
{
	var eid = 'destroutemap'+i.toString(10);
	document.getElementById('destroutebutton'+i.toString(10)).value = destButtonCaption[1];
	destinationURI = points[i][5];
	destinationName = points[i][4];
	destinationRadius = points[i][6];
	travelIndex = 1;
	curLoc();
}

window.onload = onload();
function onload() { 
	init();
	destinationURI = getParameterFromURL( "subject" );
	if ( destinationURI == "" )
		allLoc();
	else
	for ( i = 0; i < points.length; i++ )
	{
		if ( points[i][5] == destinationURI )
		{
			$("#result").append("<br><br>↓このボタンを押して目的地を指定してください");
			showAPoint(i,points[i]);
			$("#result").append("<br><hr><input type='button' value='ルール説明を見る' onclick='allLoc()'/>");
			$("#currInfo").hide();
			$("#map-canvas").hide();
		}
	}
}

function checkStamp()
{
		sortPoints();
		if ( points[0][7] < points[0][6] )
		{
			if ( mapCircleIsStamped[[points[0][5]]] == false ) // 近くのサークルのスタンプが押されていない！
			{
				$("#result").append("<a href='javascript:vieSta();'><font color='red'><b>"+points[0][4]+"のスタンプを入手しました！</b></font></a>");
				stampData();
				updateCircles();
			}
		}	
}

function showAPoint(i,p)
{
			$("#result").append("<hr>");
			if ( p[1] != null && p[2] != null ) // 緯度経度がある地点には目的地設定ボタンをつける
			{
				$("#result").append("<input id='destroutebutton"+i+"' type='button' value='"+destButtonCaption[0]+"' onclick='setDestination("+i+")'/>");
//				$("#result").append("<div id='destroutemap"+i+"'></div>");
			}
			$("#result").append(p[0]);
}

function displayData()
{
	if ( displayMode == "curLoc" )
	{
		$("#currInfo").show();
		$("#map-canvas").show();
		if ( map != null )
			google.maps.event.trigger(map, 'resize');
		sortPoints();
		$("#result").empty();
		$("#result").append("現在地を表示します<br>");
		checkStamp();
	}
	else
	{
		$("#currInfo").hide();
		$("#map-canvas").hide();
	}
	if ( displayMode == "allLoc" )
	{
		$("#result").empty();
		$("#result").append("ルール説明： 東急電鉄の各駅の一日平均乗降者数に応じた面積のサークルが各駅に表示されます。そのサークル内に入ると電子スタンプが押されます。サークルの面積は「乗降者数×１人あたり１㎡」です。サークルの大きさを体感することで、乗降者数の規模を体感してください。スタンプをもらったら、その駅の豆知識をツイッターでつぶやくことができます。スタンプの有効期限は"+ageofstamp+"日間です。<br><br>");
		$("#result").append("<input type='button' value='現在地を表示する' onclick='curLoc()'/><br><br>");
		$("#result").append("以下、登録順に各地点を表示します<br>");
		$.each(points, function(i, p) {
			showAPoint(i,p);
		});
	}
	if ( displayMode == "finDes" )
	{
		sortPoints();
		$("#result").empty();
		$("#result").append("未到達地点を近い順に表示します<br>");
		$.each(points, function(i, p) {
			if (p[3]==false)
			{
				showAPoint(i,p);
			}
		});
	}
	if ( displayMode == "vieSta" )
	{
		sortPoints();
		$("#result").empty();
		$("#result").append("取得したスタンプを表示します<br>");
		$.each(points, function(i, p) {
			if (p[3]==true)
			{
				showAPoint(i,p);
			}
		});
	}
	if ( displayMode == "seeApp" )
	{
		sortPoints();
		$("#result").empty();
		$("#result").append("関連アプリを表示します<br>");
		$.each(points, function(i, p) {
			if (p[5].indexOf("http://app.linkdata")==0)
			{
				showAPoint(i,p);
			}
		});
		$.each(points, function(i, p) {
			if (p[5].indexOf("http://app.linkdata")!=0)
			{
				showAPoint(i,p);
			}
		});
	}
}

function currTime() {
	DD = new Date();
	Month = DD.getMonth() + 1;
	Day = DD.getDate();
	Hours = DD.getHours();
	Minutes = DD.getMinutes();
	Seconds = DD.getSeconds();
	return Month+"月"+Day+"日"+Hours+"時"+Minutes+"分"+Seconds+"秒";
}

function showTravelMode()
{
	$("#result").empty();
	if ( travelIndex == travelMode.length || travelIndex == 0 ) {travelIndex = 0; return;}
	$("#result").append("「目的地」ボタンを押すと地図が拡大<br>");
	$("#result").append(destinationName+"のサークル半径は"+destinationRadius+"ｍです<br>");
	$.each(travelMode, function(i,mode){
		if ( i == travelIndex )
			$("#result").append("<b>"+travelModeJ[i]+"</b>");
		else
			$("#result").append("<input type='button' value='"+travelModeJ[i]+"' onclick='changeTravalMode("+i+")'/>");
	});
	$("#result").append("　<input type='button' value='目的地' onclick='zoomDestinationPos()'/>");
	$("#result").append("<input type='button' value='現在地' onclick='zoomCurrentPos()'/>");
	$("#result").append("　<input type='button' value='アプリ' onclick='top.window.open(\""+destinationURI+"\")'/><br>");
}

function zoomCurrentPos()
{
	var zoom = map.getZoom();
	zoom += 1;
	map.setZoom(zoom);
	map.setCenter(new google.maps.LatLng(currlat,currlong));
}

function zoomDestinationPos()
{
	var zoom = map.getZoom();
	zoom += 1;
	map.setZoom(zoom);
	map.setCenter(new google.maps.LatLng(destlat,destlong));
}
function changeTravalMode(i)
{
	travelIndex = i;
	showTravelMode();
	showRouteToDestinationFromURI();
}

//　目的地周辺のサークルオブジェクトを表示する
function newMapCircle( lat, long, isStamped, name, uri, radius )
{
	var col = "#FF0000";
	if ( isStamped == true ) col = "#0000FF";
	var locationCircle = {
			strokeColor: col,
			strokeOpacity: 0.20,
			strokeWeight: 2,
			fillColor: col,
			fillOpacity: 0.20,
			map: map,
			center: new google.maps.LatLng(lat,long),
			radius: radius
			};
	var mc = new google.maps.Circle(locationCircle);
	// サークルがクリックされたらルート検索する
	google.maps.event.addListener(mc, 'click', function() {
		travelIndex = 1;
		showRouteToDestination(lat,long);
		destinationURI = uri;
		destinationName = name;
		destinationRadius = radius;
		showTravelMode();
 	});
	return mc;
}
function showRouteToDestination( lat, long )
{
		destlat = null;
		destlong = null;
		showTravelMode();
		// 目的地のサークルをクリックしてルート検索
		directionsDisplay.setMap(null);
		if ( travelMode[travelIndex] != 'NOTHING' )
		{
			destlat = lat;
			destlong = long;
			directionsDisplay.setMap(map);
 			var request = {
      			origin: new google.maps.LatLng(currlat,currlong),
      			destination: new google.maps.LatLng(lat,long),
      			travelMode: google.maps.TravelMode[travelMode[travelIndex]]
  			};
 			directionsService.route(request, function(response, status){
				if (status == google.maps.DirectionsStatus.OK) {
					directionsDisplay.setDirections(response);
				}
			});
		}
}

function showRouteToDestinationFromURI()
{
	if ( destinationURI != "" )
	{
		var lat = null;
		var long = null;
			$.each(points, function(i, p) {
				if ( points[i][5] == destinationURI )
				{
					lat = points[i][1];
					long = points[i][2];
				}
			});
		if ( lat != null )
		showRouteToDestination(lat,long);
	}
}

//現在位置地図のイニシャライズ
function initMap()
{
			var mapOptions = {
	    	zoom: 15,
 		   	center: new google.maps.LatLng(currlat, currlong)
  			};
			$("#map-canvas").height("50%");
			$("#map-canvas").width("100%");
  			map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);
 			currPosMarker = new google.maps.Marker({
				position: new google.maps.LatLng(currlat,currlong),
				map: map,
				title: 'Current Position'
			});
			directionsService = new google.maps.DirectionsService();
			directionsDisplay = new google.maps.DirectionsRenderer();
//			stampData();
//			sortPoints();
			// スタンプポイントに円を描く
			mapCircle = new Array();
	mapCircleIsStamped = new Array();
			$.each(points, function(i, p) {
	    // mapCircleに各地点のURIをキーにしてCircleを登録
				mapCircle[p[5]] = newMapCircle(p[1],p[2],p[3],p[4],p[5],p[6]);
				mapCircleIsStamped[p[5]] = p[3];
			});
}

function init() {
	
	if ( debug == true )
	{
		$("#currInfo").empty();
		$("#currInfo").append("デバッグモードです");
		currlat = 35.906992; 
		currlong = 139.482894;
		return;
	}
	// スクロール禁止にする
	if ( debug == false )
	{
		document.addEventListener('touchmove', function(e) {
			if ( displayMode == "curLoc" )
    			e.preventDefault();
		}, false);
		parent.document.addEventListener('touchmove', function(e) {
			if ( displayMode == "curLoc" )
    			e.preventDefault();
		}, false);
	}
	stampData();
	$("#currInfo").empty();
	$("#currInfo").append("現在位置情報を取得中です..");
	//過去の現在位置の取得と地図表示
	var latlong = GetCookies()["http://linkdata.org/currentPosition/latlong"];
	if ( latlong ){
		var a = latlong.split(",");
		currlat = a[0];
		currlong = a[1];
		$("#currInfo").append("<br>前回の取得時刻は"+a[2]+"です");
	}
	else{
		currlat = points[0][1]; currlong = points[0][2];
	}
	initMap();
	currPosMarker.setPosition(new google.maps.LatLng(currlat,currlong));
		
	getCurrentPosition();
	timerid = setInterval( function() {
		getCurrentPosition();
	}, timerInterval*1000);
}

function updateCircles()
				{
			// Circleの色を更新
			if ( mapCircle != null )
			{
				$.each(points, function(i, p) {
					var mc = newMapCircle(p[1],p[2],p[3],p[4],p[5],p[6]);
					mapCircle[p[5]].setMap(null);
					mapCircle[p[5]] = mc;
					mapCircleIsStamped[p[5]] = p[3];
				});
			}
				}
	
function getCurrentPosition()
{
//		clearInterval(timerid);
	var optionObj = {
   "enableHighAccuracy": true,
   "timeout": timerInterval*800,
   "maximumAge": timerInterval*1200,
	};
	navigator.geolocation.getCurrentPosition(function(pos) {
    	currlat = pos.coords.latitude;
    	currlong = pos.coords.longitude;
		$("#currInfo").empty();
		lastTimeOfSuccess = currTime();
		$("#currInfo").append("現在位置情報の更新に成功しました<br>（"+lastTimeOfSuccess+"現在）");
		SetCookie( "http://linkdata.org/currentPosition/latlong", currlat.toString(10)+","+currlong.toString(10)+","+currTime());
		if ( map == null ) {
			initMap();
		}
		else if ( displayMode == "curLoc" )
		{
			// 現在位置のマーカー位置を更新
			currPosMarker.setPosition(new google.maps.LatLng(currlat,currlong));
			if (travelIndex == 0 )
				map.setCenter(new google.maps.LatLng(currlat,currlong));
			checkStamp();
//			showTravelMode();
		}
	}, function(error) {
		$("#currInfo").empty();
		$("#currInfo").append("位置情報の更新に失敗しました<br>（"+currTime()+"現在）");
		if ( lastTimeOfSuccess != "" )
			$("#currInfo").append("<br>前回の取得時刻は"+lastTimeOfSuccess+"です");
	}, optionObj );
}
// 現在地の情報
function curLoc() {
	displayMode = "curLoc";
	stampData();
	displayData();
	if ( map != null )
	{
		// 目的地がURIで指定されている場合の処理
		showRouteToDestinationFromURI();
		map.setCenter(new google.maps.LatLng(currlat,currlong));
	}
}

// 全地点を表示
function allLoc() {
	displayMode = "allLoc";
	stampData();
	displayData();
}

// 目的地を探す	
function finDes() {
	displayMode = "finDes";
	stampData();
	displayData();
}

// スタンプを見る	
function vieSta() {
	displayMode = "vieSta";
	stampData();
	displayData();
}

// アプリを見る	
function seeApp() {
	displayMode = "seeApp";
	stampData();
	displayData();
}

function sortPoints()
{
	$.each(points, function(i, p) {
		p[7] = Distance(currlong, currlat, p[2], p[1]);
	});
	points.sort(function(p1, p2) {
		return p1[7] - p2[7];
	});
}

function stampData()
{
	points.length = 0;
//	$("#result").empty();
	var cookies = GetCookies();
	
	var keyword = getParameterFromURL("subject"); // obtain keyword from the URL "?subject="
//	var list = ""; // list to be displayed
	// Work loop
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		// File loop
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			// Subject loop
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var targetRadius = 0;
				var isStamped = false;
				var longitude = null;
				var latitude = null;
				var nameForTwitter = getLastName(subjValue);
				var nameForTwitter1 = "";
				var nameForTwitter2 = "";
				var key = cookies[decodeURIComponent(subjValue)];
				if ( key && key.indexOf("true") == 0 )
					isStamped = true; //スタンプ取得済みのURI
					
				var s = "";
				if ( displayMode == "seeApp" || decodeURIComponent(subjValue).indexOf("linkdata.org/resource/") < 0)
					s += "<br><a href=\"" + subjValue + "\" target=\"_blank\"><span class=\"subject\">【アプリカタログ表示】</span></a>";
				$.each( LinkData.getTriplesBySubject(workValue, fileValue, subjValue), function( tripleKey, tripleValue ) {
					var prop = tripleValue.property;
					var obj = tripleValue.object;
					if ( getLastName(prop) == targetData ) targetRadius = Math.floor(Math.sqrt( obj*targetArea/Math.PI ));
					if ( prop == "http://www.w3.org/2003/01/geo/wgs84_pos#long" ) longitude = obj;// longitude found
					if ( prop == "http://www.w3.org/2003/01/geo/wgs84_pos#lat" ) latitude = obj;// latitude found
					if ( getLastName(prop) == nameToShow ) nameForTwitter = obj;
					if ( getLastName(prop) == nameToShow1 ) nameForTwitter1 = obj;
					if ( getLastName(prop) == nameToShow2 ) nameForTwitter2 = obj;
					if ( obj.indexOf("://www.youtube.com") != -1 && obj.indexOf("v=") != -1 ) { // Insert YouTube Thumbnail
						videoId = (obj.split("v=")[1]).split("&")[0]; // get video id
						obj = "<a href=\"" + obj + "\" target=\"_blank\"><span class=\"object\">" + highlight(decodeURIComponent(obj), keyword) + "<br><img src=\"http://img.youtube.com/vi/" + videoId + "/mqdefault.jpg\" alt=\"YouTube video\" /><br></span></a>";
						}
						else if ( obj.indexOf("http") == 0 ) {
							if ((obj.indexOf(".jpg" )>0 || obj.indexOf(".gif" )>0 || obj.indexOf(".png" )>0) || (obj.indexOf(".JPG" )>0 || obj.indexOf(".GIF" )>0 || obj.indexOf(".PNG" )>0)) // insert image
								 obj = "<a href=\"" + obj + "\" target=\"_blank\"><span class=\"object\">" +shortenURL(obj) + "<br><img width=\"200\" src=\"" + obj + "\" alt=\"image\" /><br></span></a>";
							else
								obj = "<a href=\"" + obj + "\" target=\"_blank\"><span class=\"object\">" + shortenURL(obj) + "</span></a>"; // Make it clicable if it starts from http
					}
					else
						obj = "<span class=\"object\">" + highlight(obj, keyword) + "</span>";
					s += "<br><span class=\"propertyName\">" + getLastName(prop) + ":\t</span>" +  obj;
				});
				if ( latitude != null && longitude != null ) {
						s += "<br>このサークルの半径: " + targetRadius + "m";
					if ( currlat != null )
					{
						var d = Math.floor(Distance( longitude, latitude, currlong, currlat ));
						s += "<br>ここからの距離: " + d + "m";
						if ( d <= targetRadius )
						{
							// Cookieは、URIをキーとして、値は、true,名前,緯度,経度,時刻
							SetCookie( decodeURIComponent(subjValue), "true,"+encodeURIComponent(nameForTwitter)+","+latitude.toString(10)+","+longitude.toString(10)+","+currTime() );
							isStamped = true;
						}
					}
					if ( isStamped == true )
					{
						s += "<br><a target=\"_blank\" href=\"https://twitter.com/intent/tweet?status=東急"+nameForTwitter1+nameForTwitter+"の１日平均乗降者数は"+nameForTwitter2+"人です。１人あたり１㎡として円を描くと半径は"+targetRadius+"ｍになります。その円の大きさを体感するには、こちらの電子スタンプラリーアプリが便利です→ "+" "+encodeURIComponent(subjValue)+"\"><b><br>ツイッターで<br>"+nameForTwitter+"の<br>豆知識を<br>つぶやこう！</b></a><br>";
					}
					else
						s += "<br><b>この地点のスタンプはまだ取得されていません</b><br>";
//					s += addLinkToMap( latitude, longitude );
				}
				if ( isStamped == true )
					s = "<div style=\"background-image:url("+stampUrl+"); background-repeat: no-repeat;\">" + s; // subject to be displayed
				else
					s = "<div>" + s;
				s += "</div>";
				if ( targetRadius > 0 )
				points.push([s,latitude,longitude,isStamped,nameForTwitter,decodeURIComponent(subjValue),targetRadius]);
				//link to map display if coordinates exist
			});
		});
	});
}

// Get a parameter value in URL (e.g. ?paramString=value )
function getParameterFromURL( paramString )
{			
	var value = "";
	var q = top.window.location.href.split("?");
	if ( q.length == 2 ){
		var r = q[1].split("&");
		for ( var i = 0; i < r.length; i++ ){
			var s = r[i].split("=");
			if ( decodeURIComponent(s[0]) ==  paramString )
				value = decodeURIComponent(s[1]);
		}
	}
 	return value;
}
function getCurrentAppURL()
{
	return decodeURIComponent(top.window.location).split("?")[0];
}

// Highlight keyword in the string
function highlight( string, keyword )
{
	if ( keyword.length > 0 ) {
		var ss = string.split(keyword);
		var len = ss.length;
		if ( len > 1 ) {
			string = ss[0];
			for ( i = 1; i < len; i++ )
//				string += "<font color=\"red\">"+keyword+"</font>"+ss[i];
				string += "<span class=\"highlight\">"+keyword+"</span>"+ss[i];
		}
	}
	return string;
}

// get the last name of the string separated with # and /
function getLastName( string )
{
	string = decodeURIComponent(string);
	var sharp = string.split("#");
	var slash = sharp[sharp.length-1].split("/");
	var lastName = slash[slash.length-1];
	return lastName;
}

// shortening URL e.g. http://.../123.jpg
function shortenURL( url )
{
	url = decodeURIComponent(url);
	var slash = url.split("/");
	var lastName = slash[slash.length-1];
	return url.split(":")[0]+"://.../"+lastName;
}

function SetCookie( uri, value )
{
	top.document.cookie = encodeURIComponent( uri ) + "=" + encodeURIComponent( value ) + "; max-age="+ageofstamp*24*3600;
}

function GetCookies()
{
    var result = new Array();
    var allcookies = top.document.cookie;
    if( allcookies != '' )
    {
        var cookies = allcookies.split( '; ' );

        for( var i = 0; i < cookies.length; i++ )
        {
            var cookie = cookies[ i ].split( '=' );

            // クッキーの名前をキーとして 配列に追加する
			var ck = decodeURIComponent(cookie[ 0 ]);
			if ( ck.indexOf("://linkdata.org") > 0 || ck.indexOf("://app.linkdata.org") > 0 )
				result[ ck ] = decodeURIComponent( cookie[ 1 ] );
      }
    }
    return result;
}

function Distance( long1, lat1, long2, lat2 )
{
	var r = 6378137; //地球の半径(m)
	var d = r * Math.acos( Math.sin(lat1/180*Math.PI)*Math.sin(lat2/180*Math.PI) + Math.cos(lat1/180*Math.PI)*Math.cos(lat2/180*Math.PI)*Math.cos((long2-long1)/180*Math.PI) );
	return d;
}

$(function(){
	$("#curloc").click(function(){ if ( $(window).width() <= 600 ) $("#menu").slideToggle(); curLoc(); return false;});
	$("#allloc").click(function(){ if ( $(window).width() <= 600 ) $("#menu").slideToggle(); allLoc(); return false;});
 	$("#findes").click(function(){ if ( $(window).width() <= 600 ) $("#menu").slideToggle(); finDes(); return false;});
 	$("#viesta").click(function(){ if ( $(window).width() <= 600 ) $("#menu").slideToggle(); vieSta(); return false;});
 	$("#seeapp").click(function(){ if ( $(window).width() <= 600 ) $("#menu").slideToggle(); seeApp(); return false;});
 $("#toggle").click(function(){
    $("#menu").slideToggle();
    return false;
  });
  $(window).resize(function(){
    var win = $(window).width();
    var p = 600;
    if(win > p){
      $("#menu").show();
    } else {
//      $("#menu").hide();
    }
	  		if ( map != null )
			google.maps.event.trigger(map, 'resize');

  });
});
