/*
1. LinkData.getSubjectsについて
　先頭から1万ちょっとまでしか取得できないっぽい
　ファイルを分割して対処
2. LinkData.getObjectsについて
　たまに500エラーで落ちる事がある（そうなるとコールバック関数は実行されない）
　エラートラップの仕方が分からんのでDeferredに頼らずデータが格納されたかどうかで成否を判別する
*/

var RDF = {
	"tree" : {
		"T000000I":{},
		"TF00000I":{
			"TFA0000I":{},
			"TFB0000I":{},
			"TFC0000I":{},
			"TFD0000I":{}
		},
		"TG00000I":{
			"TGA0000I":{"TGAA100I":{},"TGAA200I":{},"TGAB000I":{}},
			"TGB0000I":{"TGBA000I":{},"TGBB000I":{}},
			"TGC0000I":{"TGCA100I":{},"TGCA200I":{},"TGCB100I":{},"TGCB200I":{}},
			"TGD0000I":{},
			"TGE0000I":{"TGEA100I":{},"TGEA200I":{},"TGEA300I":{},"TGEB100I":{},"TGEB200I":{},"TGEC000I":{},"TGED100I":{},"TGED200I":{},"TGED300I":{}}
		},
		"TH00000I":{},
		"THA0000I":{
			"THAA000I":{"THAA110I":{},"THAA120I":{},"THAA210I":{}},
			"THAB000I":{"THAB100I":{},"THAB200I":{}},
			"THAC000I":{"THAC100I":{},"THAC200I":{}},
			"THAD000I":{"THAD110I":{},"THAD210I":{},"THAD220I":{}},
			"THAE000I":{"THAE110I":{},"THAE120I":{},"THAE210I":{},"THAE220I":{}},
			"THAF000I":{"THAF100I":{},"THAF200I":{}},
			"THAG000I":{"THAG100I":{},"THAG200I":{},"THAG310I":{},"THAG320I":{}},
			"THX1000I":{},
			"THX2000I":{}
		},
		"THB0000I":{},
		"TI00000I":{},
		"TIA0000I":{
			"TIAA000I":{},
			"TIAB000I":{"TIAB100I":{},"TIAB200I":{}},
			"TIAC000I":{"TIAC100I":{},"TIAC200I":{}},
			"TIAD000I":{"TIAD100I":{},"TIAD200I":{},"TIAD300I":{}},
			"TIAE000I":{"TIAE100I":{},"TIAE200I":{},"TIAE300I":{},"TIAE400I":{}},
			"TIAF000I":{},
			"TIAG000I":{},
			"TIAH000I":{}
		},
		"TIB0000I":{
			"TIBA000I":{},
			"TIBB000I":{},
			"TIBC000I":{},
			"TIBD000I":{},
			"TIBE000I":{},
			"TIBF000I":{},
			"TIBG000I":{},
			"TIBH000I":{}
		},
		"TJ00000I":{},
		"TJA0000I":{
			"TJAA000I":{"TJAA110I":{},"TJAA121I":{},"TJAA122I":{},"TJAA123I":{},"TJAA124I":{}},
			"TJAB000I":{"TJAB110I":{},"TJAB210I":{},"TJAB220I":{}},
			"TJAD000I":{"TJAD110I":{},"TJAD120I":{}}
		},
		"TJB0000I":{
			"TJBA000I":{},
			"TJBB000I":{}
		},
		"TK00000I":{},
		"TKA0000I":{
			"TKAA000I":{"TKAA110I":{},"TKAA120I":{},"TKAA130I":{},"TKAA210I":{}},
			"TKAB000I":{"TKAB100I":{},"TKAB200I":{},"TKAB300I":{}}
		},
		"TKX1000I":{
			"TKB0000I":{"TKBA110I":{},"TKBA120I":{},"TKBA130I":{},"TKBA140I":{},"TKBA210I":{},"TKBA220I":{},"TKBA300I":{},"TKBB000I":{},"TKBB100I":{},"TKBB200I":{},"TKBB300I":{},"TKBB400I":{}},
			"TKC0000I":{"TKCA000I":{},"TKCB000I":{}}
		},
		"TL00000I":{
			"TLA0000I":{},
			"TLB0000I":{"TLBA100I":{},"TLBA200I":{},"TLBB000I":{},"TLBC000I":{}},
			"TLC0000I":{"TLCA100I":{},"TLCA200I":{},"TLCA300I":{},"TLCA400I":{},"TLCB100I":{},"TLCB200I":{},"TLCB300I":{},"TLCB400I":{}},
			"TLD0000I":{"TLDA100I":{},"TLDA200I":{},"TLDA300I":{},"TLDB000I":{},"TLDC000I":{}}
		},
		"TM00000I":{
			"TMA0000I":{"TMAA000I":{},"TMAB000I":{}},
			"TMB0000I":{"TMBA000I":{},"TMBB000I":{},"TMBC000I":{},"TMBD000I":{}}
		},
		"TN00000I":{},
		"TNA0000I":{
			"TNAA000I":{},
			"TNAB000I":{},
			"TNAC000I":{},
			"TNAD000I":{}
		},
		"TNB0000I":{
			"TNBA000I":{"TNBA100I":{},"TNBA200I":{},"TNBA300I":{}},
			"TNBC000I":{"TNBC100I":{},"TNBC200I":{}},
			"TNBD000I":{}
		},
		"TNC0000I":{
			"TNCA000I":{},
			"TNCB000I":{"TNCB100I":{},"TNCB210I":{},"TNCB220I":{},"TNCB230I":{},"TNCB240I":{},"TNCB250I":{},"TNCB260I":{}},
			"TNCC000I":{"TNCC100I":{},"TNCC200I":{},"TNCC300I":{},"TNCC400I":{}},
			"TNCD000I":{"TNCD100I":{},"TNCD200I":{},"TNCD300I":{},"TNCD400I":{}},
			"TNCE000I":{},
			"TNCF000I":{}
		},
		"TO00000I":{
			"TOAA000I":{},
			"TOAB000I":{"TOAB100I":{},"TOAB200I":{}}
		},
		"TP00000I":{
			"TPA0000I":{"TPAA000I":{},"TPAB000I":{}},
			"TPB0000I":{"TPBA000I":{},"TPBB000I":{}}
		},
		"TQ00000I":{},
		"TR00000I":{
			"TRAA000I":{},
			"TRBA000I":{},
			"TRCA000I":{},
			"TRDA000I":{}
		},
		"TS00000I":{
			"TSAA510I":{},
			"TSAA610I":{}
		},
		"TTXA000I":{
			"TTXA100I":{},
			"TTXA200I":{}
		},
		"TTXC000I":{
			"TTXC100I":{},
			"TTXC200I":{}
		},
		"TTXD000I":{},
		"TTXE000I":{},
		"TXK0000I":{},
		"TXO0000I":{},
		"TXQ0000I":{
			"TXQA000I":{},
			"TXQB000I":{}
		},
		"UA00000I":{},
		"UB00000I":{}
	},
	"baseYear" : "2005",
	"minMonth" : "200501",
	"maxMonth" : "200512",
	"current" : {
		"year" : "2005",
		"item" : "1",
		"type" : "2",
		"unit" : "1"
	},
	"getWorks" : function() {
		var d = $.Deferred(),
			timer, count = 0;
		timer = setInterval(function() {
			if (typeof RDF.works !== "undefined") {
				d.resolve();
				clearInterval(timer);
			} else if (count === 0) {
				LinkData.getWorks(function(works) {
					RDF.works = works;
				});
				count = 50;
			} else {
				count--;
			}
		}, 100);
		return d.promise();
	},
	"getFiles" : function(work) {
		var d = $.Deferred(),
			timer, count = 0;
		RDF.files = RDF.files || {};
		timer = setInterval(function() {
			if (typeof RDF.files[work] !== "undefined") {
				d.resolve();
				clearInterval(timer);
			} else if (count === 0) {
				LinkData.getFiles(work, function(files) {
					RDF.files[work] = files;
				});
				count = 50;
			} else {
				count--;
			}
		}, 100);
		return d.promise();
	},
	"getSubjects" : function(work, file) {
		var d = $.Deferred(),
			timer, count = 0;
		RDF.subjects = RDF.subjects || {};
		RDF.subjects[work] = RDF.subjects[work] || {};
		timer = setInterval(function() {
			if (typeof RDF.subjects[work][file] !== "undefined") {
				d.resolve();
				clearInterval(timer);
			} else if (count === 0) {
				LinkData.getSubjects(work, file, function(subjs) {
					RDF.subjects[work][file] = subjs;
				});
				count = 50;
			} else {
				count--;
			}
		}, 100);
		return d.promise();
	},
	"getProperties" : function(work, file) {
		var d = $.Deferred(),
			timer, count = 0;
		RDF.properties = RDF.properties || {};
		RDF.properties[work] = RDF.properties[work] || {};
		timer = setInterval(function() {
			if (typeof RDF.properties[work][file] !== "undefined") {
				d.resolve();
				clearInterval(timer);
			} else if (count === 0) {
				LinkData.getProperties(work, file, function(props) {
					RDF.properties[work][file] = props;
				});
				count = 50;
			} else {
				count--;
			}
		}, 100);
		return d.promise();
	},
	"getObjects" : function(work, file, subj, prop) {
		var d = $.Deferred(),
			timer, count = 0;
		RDF.objects = RDF.objects || {};
		RDF.objects[work] = RDF.objects[work] || {};
		RDF.objects[work][file] = RDF.objects[work][file] || {};
		RDF.objects[work][file][subj] = RDF.objects[work][file][subj] || {};
		timer = setInterval(function() {
			if (typeof RDF.objects[work][file][subj][prop] !== "undefined") {
				d.resolve();
				clearInterval(timer);
			} else if (count === 0) {
				LinkData.getObjects(work, file, subj, prop, function(objes) {
					if (objes.length === 0) {
						RDF.objects[work][file][subj][prop] = null;
					} else {
						RDF.objects[work][file][subj][prop] = objes[0];
					}
				});
				count = 50;
			} else {
				count--;
			}
		}, 100);
		return d.promise();
	},
	//年月（YYYYMM）の最小値を調べる
	"getMin" : function() {
		var d = $.Deferred(),
			year = RDF.baseYear,
			i, j, work, file;
		//最小年を取得
		for (i = 0; i < RDF.works.length; i++) {
			for (j = 0; j < RDF.files[RDF.works[i]].length; j++) {
				if (year > RDF.files[RDF.works[i]][j].substr(17, 4)) {
					year = RDF.files[RDF.works[i]][j].substr(17, 4);
					work = RDF.works[i];
				}
			}
		}
		//最小年のファイルのサブジェクトから最小年月を取得
		file = "ITA_Base" + RDF.baseYear + "_Year" + year;
		RDF.getSubjects(work, file)
			.pipe(function() {
				for (i = 0; i < RDF.subjects[work][file].length; i++) {
					if (RDF.minMonth > RDF.subjects[work][file][i].substr(-6, 6)) {
						RDF.minMonth = RDF.subjects[work][file][i].substr(-6, 6);
					}
				}
				d.resolve();
			});
		return d.promise();
	},
	//年月（YYYYMM）の最大値を調べる
	"getMax" : function() {
		var d = $.Deferred(),
			year = RDF.baseYear,
			i, j, work, file;
		//最大年を取得
		for (i = 0; i < RDF.works.length; i++) {
			for (j = 0; j < RDF.files[RDF.works[i]].length; j++) {
				if (year < RDF.files[RDF.works[i]][j].substr(17, 4)) {
					year = RDF.files[RDF.works[i]][j].substr(17, 4);
					work = RDF.works[i];
				}
			}
		}
		//最大年のファイルのサブジェクトから最大年月を取得
		file = "ITA_Base" + RDF.baseYear + "_Year" + year;
		RDF.getSubjects(work, file)
			.pipe(function() {
				for (i = 0; i < RDF.subjects[work][file].length; i++) {
					if (RDF.maxMonth < RDF.subjects[work][file][i].substr(-6, 6)) {
						RDF.maxMonth = RDF.subjects[work][file][i].substr(-6, 6);
					}
				}
				d.resolve();
			});
		return d.promise();
	},
	//RDF.treeの中から指定された品目番号のノードを探して渡す
	"getNode" : function(code) {
		var lv1, lv2, lv3;
		for (lv1 in RDF.tree) {
			if (lv1 === code) {
				return RDF.tree[lv1];
			} else if (Object.keys(RDF.tree[lv1]).length !== 0) {
				for (lv2 in RDF.tree[lv1]) {
					if (lv2 === code) {
						return RDF.tree[lv1][lv2];
					} else if (Object.keys(RDF.tree[lv1][lv2]).length !== 0) {
						for (lv3 in RDF.tree[lv1][lv2]) {
							if (lv3 === code) {
								return RDF.tree[lv1][lv2][lv3];
							}
						}
					}
				}
			}
		}
		return false;
	},
	//指定されたファイルを含むワーク名を返す
	"getWorkFromFile" : function(file) {
		var i, j;
		for (i = 0; i < RDF.works.length; i++) {
			for (j = 0; j < RDF.files[RDF.works[i]].length; j++) {
				if (RDF.files[RDF.works[i]][j] === file) {
					return RDF.works[i];
				}
			}
		}
	},
	//品目の名称を取得してテーブルを埋める（基準年の生産のファイルから）
	"fillName" : function(code) {
		var d = $.Deferred(),
			work, file, subj, prop,
			deferreds;
		file = "ITA_Base" + RDF.baseYear + "_Year" + RDF.baseYear;
		work = RDF.getWorkFromFile(file);
		subj = "http://linkdata.org/resource/" + work + "#" + code + RDF.baseYear + "01";
		prop = "http://linkdata.org/property/" + work + "#name";
		if (typeof RDF.objects === "undefined" ||
			typeof RDF.objects[work] === "undefined" ||
			typeof RDF.objects[work][file] === "undefined" ||
			typeof RDF.objects[work][file][subj] === "undefined" ||
			typeof RDF.objects[work][file][subj][prop] === "undefined") {
			deferreds = [ RDF.getObjects(work, file, subj, prop) ];
			$.when.apply($, deferreds).done(function() {
				$("#" + code + " td:nth-child(2)").text(RDF.objects[work][file][subj][prop]);
				d.resolve();
			});
		} else {
			$("#" + code + " td:nth-child(2)").text(RDF.objects[work][file][subj][prop]);
			d.resolve();
		}
		return d.promise();
	},
	//データを取得してテーブルを埋める
	//currentJsonは関数呼び出し時点のRDF.currentをJSON文字列化したもの
	//データ取得に時間かかってRDF.currentが変化していたら書き込まない
	"fillData" : function(code, index, currentJson) {
		var d = $.Deferred(),
			work, file, subj, prop, deferreds,
			lastMonth, lastWork, lastFile, lastSubj,
			outerSize, tableSize,
			lastCurrent = JSON.parse(currentJson);
		//ファイル
		file = "ITA_Base" + RDF.baseYear + "_Year" + lastCurrent.year;
		/*
		switch (lastCurrent.item) {
			case "1":
				file = "IIP_Base" + RDF.baseYear + "_Year" + lastCurrent.year + "_Production";
				break;
			case "3":
				file = "IIP_Base" + RDF.baseYear + "_Year" + lastCurrent.year + "_Shipments";
				break;
			case "4":
				file = "IIP_Base" + RDF.baseYear + "_Year" + lastCurrent.year + "_Inventory";
				break;
			case "5":
				file = "IIP_Base" + RDF.baseYear + "_Year" + lastCurrent.year + "_InventoryRatio";
				break;
		}
		*/
		//ワーク
		work = RDF.getWorkFromFile(file);
		//サブジェクト
		subj = "http://linkdata.org/resource/" + work + "#" + code + (lastCurrent.year * 100 + index);
		//前月か前年同月
		if (lastCurrent.unit === "2") {
			if (index === 1) {
				lastMonth = String((lastCurrent.year - 1) * 100 + 12);
			} else {
				lastMonth = String(lastCurrent.year * 100 + index - 1);
			}
		} else if (lastCurrent.unit === "3") {
			lastMonth = String((lastCurrent.year - 1) * 100 + index);
		}
		//プロパティ
		switch (lastCurrent.type) {
			case "1":
				prop = "http://linkdata.org/property/" + work + "#original_index";
				break;
			case "2":
				prop = "http://linkdata.org/property/" + work + "#seasonally_adjusted_index";
				break;
		}
		//オブジェクトを問い合わせてテーブルに書き込み
		deferreds = [ RDF.getObjects(work, file, subj, prop) ];
		if (lastCurrent.unit !== "1") {
			lastFile = file.substr(0, 17) + lastMonth.substr(0, 4) + file.substr(21);
			lastWork = RDF.getWorkFromFile(lastFile);
			lastSubj = "http://linkdata.org/resource/" + lastWork + "#" + code + lastMonth;
			deferreds.push(RDF.getObjects(lastWork, lastFile, lastSubj, prop));
		}
		$.when.apply($, deferreds).done(function() {
			if (JSON.stringify(RDF.current) === currentJson) {
				if (lastCurrent.unit === "1") {
					if (RDF.objects[work][file][subj][prop] === null) {
						$("#" + code + " td:nth-child(" + (index + 2) + ")").text("-");
					} else {
						$("#" + code + " td:nth-child(" + (index + 2) + ")").text(Number(RDF.objects[work][file][subj][prop]).toFixed(1));
					}
				} else {
					if (RDF.objects[lastWork][lastFile][lastSubj][prop]) {
						if (RDF.objects[work][file][subj][prop] === null) {
							$("#" + code + " td:nth-child(" + (index + 2) + ")").text("-");
						} else {
							$("#" + code + " td:nth-child(" + (index + 2) + ")").text(Number(Math.round(RDF.objects[work][file][subj][prop] / RDF.objects[lastWork][lastFile][lastSubj][prop] * 1000) / 10).toFixed(1));
						}
					} else {
						$("#" + code + " td:nth-child(" + (index + 2) + ")").text("-");
					}
				}
			}
			//メニューをリサイズ
			outerSize = Math.floor(($("#outer").width() - 2) / 3);
			tableSize = Math.floor(($("table").width() - 2) / 3);
			if (outerSize < tableSize) {
				$(".hMenu").css("width", outerSize + "px");
			} else {
				$(".hMenu").css("width", tableSize + "px");
			}
			d.resolve();
		});
		return d.promise();
	},
	"repeat" : function(str, n) {
		var res = "", i;
		for (i = 0; i < n; i++) {
			res += str;
		}
		return res;
	},
	//RDF.currentの設定でテーブルを作って表示
	"makeTable" : function() {
		var colSize = 12, table, i, j, k, lv1s, lv2s, lv3s, lv1, lv2, lv3;
		if (RDF.current.year === RDF.maxMonth.substr(0, 4)) {
			colSize = Number(RDF.maxMonth.substr(4));
		}
		table = '<table><tr><th></th><th></th>';
		for (i = 1; i < colSize + 1; i++) {
			table += '<th class="data">' + i + '月</th>';
		}
		table += '</tr>';
		lv1s = Object.keys(RDF.tree);
		lv1s.sort();
		for (i = 0; i < lv1s.length; i++) {
			lv1 = lv1s[i];
			if (Object.keys(RDF.tree[lv1]).length === 0) {
				table += '<tr id="' + lv1 + '" class="lv1"><td class="icon"></td><td class="name"></td>' + RDF.repeat('<td></td>', colSize) + '</tr>';
			} else {
				table += '<tr id="' + lv1 + '" class="lv1 hasChild"><td class="icon">+</td><td class="name"></td>' + RDF.repeat('<td></td>', colSize) + '</tr>';
				lv2s = Object.keys(RDF.tree[lv1]);
				lv2s.sort();
				for (j = 0; j < lv2s.length; j++) {
					lv2 = lv2s[j];
					if (Object.keys(RDF.tree[lv1][lv2]).length === 0) {
						table += '<tr id="' + lv2 + '" class="lv2"><td class="icon"></td><td class="name"></td>' + RDF.repeat('<td></td>', colSize) + '</tr>';
					} else {
						table += '<tr id="' + lv2 + '" class="lv2 hasChild"><td class="icon">+</td><td class="name"></td>' + RDF.repeat('<td></td>', colSize) + '</tr>';
						lv3s = Object.keys(RDF.tree[lv1][lv2]);
						lv3s.sort();
						for (k = 0; k < lv3s.length; k++) {
							lv3 = lv3s[k];
							table += '<tr id="' + lv3 + '" class="lv3"><td class="icon"></td><td class="name"></td>' + RDF.repeat('<td></td>', colSize) + '</tr>';
						}
					}
				}
			}
		}
		$("#result").html(table + '</table>');
		$("tr.lv2").css("display", "none");
		$("tr.lv3").css("display", "none");
		$("tr.lv1").each(function() {
			var i;
			RDF.fillName($(this).attr("id"));
			for (i = 1; i <= colSize; i++) {
				RDF.fillData($(this).attr("id"), i, JSON.stringify(RDF.current));
			}
		});
		//子品目を持つ行に子の表示・非表示を切り替えるクリックイベントを設定
		$("tr.hasChild").children(".icon, .name").on("click", function() {
			var child, i, colSize = 12, childRow, grandChild,
				parent = $(this).parent(),
				node = RDF.getNode(parent.attr("id"));
			if (RDF.current.year === RDF.maxMonth.substr(0, 4)) {
				colSize = Number(RDF.maxMonth.substr(4));
			}
			if (parent.children().first().text() === "+") {
				parent.children().first().text("-");
			} else {
				parent.children().first().text("+");
			}
			for (child in node) {
				childRow = $("#" + child);
				if (childRow.css("display") === "none") {
					childRow.css("display", "");
					childRow.children().each(function(index) {
						if (index === 1) {
							RDF.fillName(child);
						} else if (index > 1) {
							RDF.fillData(child, index - 1, JSON.stringify(RDF.current));
						}
					});
				} else {
					childRow.children().first().text("+");
					if (Object.keys(node[child]).length !== 0) {
						for (grandChild in node[child]) {
							$("#" + grandChild).css("display", "none");
						}
					}
					childRow.css("display", "none");
				}
			}
		});
		//品目名にカーソルが乗ったら折り返し許可して全体を表示させる
		$("td.name").on("mouseenter", function() {
			$(this).css("white-space", "normal");
		});
		$("td.name").on("mouseleave", function() {
			$(this).css("white-space", "nowrap");
		});
	}
};

window.onload = function() {
	var deferreds, i, hMenu;
	//getWorksが終わってgetFilesが終わってgetMinとgetMaxが終わったら色々やる
	deferreds = [ RDF.getWorks() ];
	$.when.apply($, deferreds).done(function() {
		deferreds = [];
		for (i = 0; i < RDF.works.length; i++) {
			deferreds.push(RDF.getFiles(RDF.works[i]));
		}
		$.when.apply($, deferreds).done(function() {
			deferreds = [ RDF.getMin(), RDF.getMax() ];
			$.when.apply($, deferreds).done(function() {
				//最小・最大年を元に年選択のメニューを生成
				hMenu = $(".hMenu");
				RDF.current.year = RDF.maxMonth.substr(0, 4);
				hMenu.first().children("span").text(RDF.current.year + "年");
				for (i = RDF.maxMonth.substr(0, 4); i >= RDF.minMonth.substr(0, 4); i--) {
					hMenu.first().children("ul").append('<li id="year-' + i + '" class="vMenu">' + i + '年</li>');
				}
				hMenu.children("ul").css("display", "none");
				hMenu.each(function(index) {
					if (index > 0) {
						$(this).css("border-left", "solid 1px #FFFFFF");
					}
				});
				//オプションが変えられたら保存してテーブル再作成するイベントを設定
				$(".vMenu").on("click", function() {
					var idVal;
					if ($(this).parent().prev().text() !== $(this).text()) {
						idVal = $(this).attr("id").split("-");
						RDF.current[idVal[0]] = idVal[1];
						$(this).parent().prev().text($(this).text());
						RDF.makeTable();
					}
					$(".hMenu img").attr("src", "http://app.linkdata.org/asset/76df76ed.png");
					$(".hMenu span").css("color", "#FFFFFF");
					$(".hMenu ul").slideUp(300);
				});
				$(".vMenu").on({
					"mouseenter" : function() {
						$(this).css("color", "#FFFFFF");
					},
					"mouseleave" : function() {
						$(this).css("color", "#666666");
					}
				});
				//テーブル作成
				RDF.makeTable();
			});
		});
	});
}

//メニューの展開・折り畳み
$("li span").click(function() {
	if ($(this).next().css("display") === "none") {
		$(".hMenu img").attr("src", "http://app.linkdata.org/asset/64da7294.png");
		$(".hMenu span").css("color", "#666666");
		$(".hMenu ul").slideUp(300);
		$(this).next().slideDown(300);
	} else {
		$(".hMenu img").attr("src", "http://app.linkdata.org/asset/76df76ed.png");
		$(".hMenu span").css("color", "#FFFFFF");
		$(".hMenu ul").slideUp(300);
	}
});
