// グローバル変数http://app.linkdata.org/tutorial/api/2.0/index.html
spot_data		= new Array();	// スポットデータ
spotBus_data	= new Array();	// 最寄りスポットデータ
busRoute_data	= new Array();	// バス系統データ
busStop_data	= new Array();	// バス停データ
sta_data		= new Array();	// 駅データ

arSpot_data		= new Array();	// 近い順スポットデータ
arBusStop_data	= new Array();	// 近い順バス停データ
arBusStopL_data	= new Array();	// 近い順3件だけのバス停データ

var user_lat	= '';			// ユーザの緯度
var user_lng	= '';			// ユーザの経度

var imgSrcNoImg		= '<img src="http://app.linkdata.org/asset/135ff188.png">';	// 画像が無い時用の画像のURLタグ

// ページが表示されたときに関数を呼び出す
$('#around').bind('pageshow',showArData);
$('#moreArSpot').bind('pageshow',showMoreArSpotData);
$('#moreArBusStop').bind('pageshow',showMoreArBusStopData);
$('#spot').bind('pageshow',showSpotData);
$('#bus').bind('pageshow',showBusRouteData);
$('#sta').bind('pageshow',showStaData);


// 画面起動時の関数
window.onload = function() {
	// 現在位置の取得
	getGeoLocation();
	//setGeo1();
	//setGeo2();
	//setGeo3();
	//setGeo0();
	// データの読み込み
	loadSpotData();
	loadBusStopData();
	loadBusRouteData();
	loadSpotBusData();
}

//#######################################################################################
//  周辺情報ページ関連
//#######################################################################################
function showArData() {
	makeArSpotData();
	makeArBusStopData();
	showArList();
	showArBusStopList();
}


//---------------------
// 現在位置を取得
//---------------------
//user_lat	= '30';	user_lng	= '130';	// 遠く
//user_lat	= '35.183071';	user_lng	= '136.913776';	// 清水口らへん

// 位置情報の取得
function getGeoLocation(){
	// HTML5 geolocation 機能で現在地を取得
	if(navigator.geolocation) {
		navigator.geolocation.getCurrentPosition(function(position) {
			// ユーザの現在位置を取得
			user_lat = position.coords.latitude;
			user_lng = position.coords.longitude;
			$('.geoLocate').empty();
			$('.geoLocate').append('GPS');
		}, function() {
			handleNoGeolocation(true);
		});
	} else {
		// ブラウザがGeolocationをサポートしていない
		handleNoGeolocation(false);
	}
}

// 現在位置を清水口らへんにセット
function setGeo1(){
	user_lat	= '35.183071';
	user_lng	= '136.913776';
	$('.geoLocate').empty();
	$('.geoLocate').append('清水口');
}

// 現在位置を二葉館らへんにセット
function setGeo2(){
	user_lat	= '35.180327';
	user_lng	= '136.918491';
	$('.geoLocate').empty();
	$('.geoLocate').append('二葉館');
	
}

// 現在位置を赤塚らへんにセット
function setGeo3(){
	user_lat	= '35.183372';
	user_lng	= '136.924195';
	$('.geoLocate').empty();
	$('.geoLocate').append('赤塚');
}

// 現在位置を名大らへんにセット
function setGeo0(){
	user_lat	= '35.154633';
	user_lng	= '136.961577';
	$('.geoLocate').empty();
	$('.geoLocate').append('名大');
}

// 位置情報取得のエラー処理
function handleNoGeolocation(errorFlag) {
	if (errorFlag) {
		var content = '位置情報が取得できませんでした';
	} else {
		var content = 'ブラウザが位置情報機能に対応していません';
	}
	alert(content);
}

//-----------------------------------------------
// 近い順リストをリスト画面に表示
//-----------------------------------------------

//-----------------------
// 近い順スポットリストに代入
function makeArSpotData() {
	
	tmp_dataArray = new Array();
	
	for (var i in spot_data){
		
		if (spot_data[i].lat != '' && spot_data[i].lng != '') {
			
			var tmp_data = {}
			// 距離を計算
			var distance = geoDistance(user_lat, user_lng, spot_data[i].lat, spot_data[i].lng, -1);
			
			// リストに代入
			tmp_data['id']		= spot_data[i].id;
			tmp_data['name']	= spot_data[i].name;
			tmp_data['stamp']	= spot_data[i].stamp;
			tmp_data['comment']	= spot_data[i].comment;
			tmp_data['info']	= spot_data[i].info;
			tmp_data['open']	= spot_data[i].open;
			tmp_data['last']	= spot_data[i].last;
			tmp_data['close']	= spot_data[i].close;
			tmp_data['url']		= spot_data[i].url;
			tmp_data['img']		= spot_data[i].img;
			tmp_data['map']		= spot_data[i].map;
			tmp_data['distance'] = distance;
			
			// 500m未満の場合、近い順スポットリストに入れる
			if (distance < 500) {
				// 近い順に並び替える
				if (tmp_dataArray.length == 0) {
					// 空の場合は0番目に挿入
					tmp_dataArray.push(tmp_data);
				} else {
					for (var j in tmp_dataArray) {
						// j番目より近ければ、j番目に挿入
						if (distance < tmp_dataArray[j].distance) {
							tmp_dataArray.splice(j,0,tmp_data);
							break;
						} else if (j == tmp_dataArray.length - 1) {
							// 最後尾より遠ければ、最後尾に挿入
							tmp_dataArray.push(tmp_data);
							break;
						}
						
					}
					
				}
			}
		}
	}
	arSpot_data = tmp_dataArray; // スポットデータを代入
	
}



//-----------------------
// 近い順バス停リストに代入
function makeArBusStopData() {
	
	$('.arBusStopList').empty();
	
	tmp_dataArray	= new Array();
	
	for (var i in busStop_data){
		
		if (busStop_data[i].lat != '' && busStop_data[i].lng != '') {
			
			var tmp_data = {}
			// 距離を計算
			var distance = geoDistance(user_lat, user_lng, busStop_data[i].lat, busStop_data[i].lng, -1);
			// 500m未満の場合、近い順スポットリストに入れる
			if (distance < 500) {
				
					tmp_data['id']			= busStop_data[i].id;
					tmp_data['route_id']	= busStop_data[i].route_id
					tmp_data['route_name']	= busStop_data[i].route_name;
					tmp_data['stop_name']	= busStop_data[i].stop_name;
					tmp_data['stop_num']	= busStop_data[i].stop_num;
					tmp_data['url']			= busStop_data[i].url;
					tmp_data['dest']		= busStop_data[i].dest;
					tmp_data['lat']			= busStop_data[i].lat;
					tmp_data['lng']			= busStop_data[i].lng;
					tmp_data['img']			= getBusRouteImg(tmp_data['route_id']);
					tmp_data['distance'] = distance;
				
				// 近い順に並び替える
				// 空の場合は0番目に挿入
				if (tmp_dataArray.length == 0) {
					// 近い順リストに代入
					tmp_dataArray.push(tmp_data);
				} else {
					for (var j in tmp_dataArray) {
						
						// j番目より近ければ、j番目に挿入
						if (distance < tmp_dataArray[j].distance) {
							// 近い順リストに代入
							tmp_dataArray.splice(j,0,tmp_data);
							break;
						} else if (j == tmp_dataArray.length - 1) {
							// 最後尾より遠ければ、最後尾に挿入
							tmp_dataArray.push(tmp_data);
							break;
						}
						
					}
				}
			}
		}
	}
	
	arBusStop_data	= tmp_dataArray;	// バス停データを代入
	
	// 軽量版の作成
	tmpL_dataArray = new Array();
	
	for (var i in arBusStop_data){
		
		var tmp_data = {}
		
		tmp_data['id']			= arBusStop_data[i].id;
		tmp_data['route_id']	= arBusStop_data[i].route_id
		tmp_data['route_name']	= arBusStop_data[i].route_name;
		tmp_data['stop_name']	= arBusStop_data[i].stop_name;
		tmp_data['stop_num']	= arBusStop_data[i].stop_num;
		tmp_data['url']			= '<a href="#spotBus" onclick="showSpotBusList('+ arBusStop_data[i].route_id +')">';
		tmp_data['dest']		= arBusStop_data[i].dest;
		tmp_data['lat']			= arBusStop_data[i].lat;
		tmp_data['lng']			= arBusStop_data[i].lng;
		tmp_data['img']			= getBusRouteImg(tmp_data['route_id']);
		tmp_data['distance'] 	= arBusStop_data[i].distance;
		
		// 空の場合は0番目に挿入
		if (tmpL_dataArray.length == 0) {
			// 近い順リストに代入
			tmpL_dataArray.push(tmp_data);
		} else {
			
			for (var j in tmpL_dataArray) {
				// もし、系統名とバス停名の両方同じものがあった場合はループから抜けて挿入しない
				if (tmp_data['route_id'] == tmpL_dataArray[j].route_id && tmp_data['stop_name'] == tmpL_dataArray[j].stop_name) {
					break;
				} else if (j == tmpL_dataArray.length - 1) {
					// なければ、最後尾に挿入
					tmpL_dataArray.push(tmp_data);
				}
			}
		}
		
		// 3件になったらループから抜ける
		if (tmpL_dataArray.length >= 3) {
			break;
		}
	}
	
	arBusStopL_data	= tmpL_dataArray;	// バス停データを代入（軽量版）
	
}


//----------------------------------
// 近い順スポットリストを表示
function showArList() {
	
	// ページ初期化
	$('.arSpotList').empty();
	$('.moreArSpotBtn').empty();
	
	// 1件も無いときは「ないです」表示
	if (arSpot_data.length == 0) {
		var li = '<li><p>この近辺に会場はありません。名古屋市東区「文化のみち」エリアでご利用ください</p></li>';
		$('.arSpotList').append(li);
	} else {
		// 会場情報テーブルをループ
		for (var i in arSpot_data) {
			
			// 4件以上あるときは、もっと見るを表示してbreak
			if (i >= 3) {
				var str = '<a href="#moreArSpot" class="ui-btn ui-bar" style="margin-top:30px;">もっとみる（'+ arSpot_data.length +'件）</a>';
				$('.moreArSpotBtn').append(str)
				break;
			}
			
			//---------------------
			//  会場情報をリストに加えるところ
			//---------------------
			var li =  '<li>';
			/// 文化のみちページへのリンク
			if (arSpot_data[i].url) {
				li =  li + '<a href="'+  arSpot_data[i].url  + '" target="_blank">';
			} else {
				li =  li + '<a href="#">';
			}
			/// 画像 (無い場合は文化のみち画像)
			if (arSpot_data[i].img) {
				li = li + '<img src="'+ arSpot_data[i].img +'">';
			} else {
				li = li + imgSrcNoImg;
			}
			// スポット名・スタンプ番号
			li = li + '<h2>';
			if (arSpot_data[i].stamp) {
				li = li + '<span style="font-size:80%;">'+ arSpot_data[i].stamp +'. </span>';
			}
			li = li + arSpot_data[i].name +'</h2>';
			// 追加情報
			if (arSpot_data[i].comment || arSpot_data[i].info) {
				li = li + '<p>';
				if (arSpot_data[i].comment) {
					li = li + '【'+ arSpot_data[i].comment +'】';
				}
				if (arSpot_data[i].info) {
					li = li + arSpot_data[i].info;
				}
				li = li + '</p>';
			}
			// 開館時間
			if (arSpot_data[i].open || arSpot_data[i].last || arSpot_data[i].close) {
				li = li + '<p>';
				if (arSpot_data[i].open) {
					li = li + arSpot_data[i].open +'~';
				} else {
					li = li + ' ~';
				}
				if (arSpot_data[i].last) {
					li = li + arSpot_data[i].last +'(最終入場)';
				} else if (arSpot_data[i].close) {
					li = li + arSpot_data[i].close;
				}
				li = li + '</p>';
			}
			// 距離
			if (arSpot_data[i].distance) {
				li = li + '<p class="allsentence">●ここから'+ arSpot_data[i].distance +'m, 徒歩約'+ calcWalkTime(arSpot_data[i].distance) +'分</p>';
			}
			
			
			li = li + '</a>';
			
			// 経路
			if (arSpot_data[i].map) {
				li =  li + searchRoute(arSpot_data[i].map);
			} else {
				li =  li + searchRoute(arSpot_data[i].name);
			}
			
			// リストを閉じる
			li = li + '</li>';
			
			// リストに追加
			$('.arSpotList').append(li);
			
		}	// for
	}		// if
	
	// CSSの初期化
	$('.arSpotList').listview().listview('refresh');
}

//----------------------------------
// 近い順にバス停リストを表示
function showArBusStopList() {
	
	// ページ初期化
	$('.arBusStopList').empty();
	$('.moreArBusStopBtn').empty();
	
	// 1件も無いときは「ないです」表示
	if (arSpot_data.length == 0) {
		var li = '<li><p>この近辺にバス停はありません。名古屋市東区「文化のみち」エリアでご利用ください</p></li>';
		$('.arBusStopList').append(li);
		} else {
		// バス停テーブルをループ
		for (var i in arBusStopL_data) {
			
			//---------------------
			//  バス停をリストに加えるところ
			//---------------------
			var li =  '<li>';
			/// バス路線最寄ページへのリンク
			if (arBusStopL_data[i].url) {
				li =  li + arBusStopL_data[i].url;
			} else {
				li =  li + '<a href="#">';
			}
			/// 画像 (無い場合は文化のみち画像)
			if (arBusStopL_data[i].img) {
				li = li + '<img src="'+ arBusStopL_data[i].img +'">';
			} else {
				li = li + imgSrcNoImg;
			}
			// バス停名
			li = li + '<h2>';
			li = li + arBusStopL_data[i].stop_name +'</h2>';
			
			// 距離
			if (arBusStopL_data[i].distance) {
				li = li + '<p class="allsentence">●ここから'+ arBusStopL_data[i].distance +'m, 徒歩約'+ calcWalkTime(arBusStopL_data[i].distance) +'分</p>';
			}
			li = li + '</a>';
			
			// 経路
			li =  li + searchRoute(arBusStopL_data[i].lat+','+arBusStopL_data[i].lng);
			
			// リストを閉じる
			li = li + '</li>';
			
			// リストに追加
			$('.arBusStopList').append(li);
			
		}	// for
		
		// もっと見るを表示
		var str = '<a href="#moreArBusStop" class="ui-btn ui-bar" style="margin-top:30px;">もっとみる・時刻表（'+ arBusStop_data.length +'件）</a>';
		$('.moreArBusStopBtn').append(str)
		
	}		// if
	
	// CSSの初期化
	$('.arBusStopList').listview().listview('refresh');
}

//-----------------------------------------------
// もっとみる　近い順リストを詳細リスト画面に表示
//-----------------------------------------------

//----------------------------------
// もっとみる　近い順スポットリストをリスト画面に表示

function showMoreArSpotData() {
	
	// ページ初期化
	$('.moreArSpotList').empty();
	
	// 会場情報テーブルをループ
	for (var i in arSpot_data) {
		
		//---------------------
		//  会場情報をリストに加えるところ
		//---------------------
		var li =  '<li>';
		/// 文化のみちページへのリンク
		if (arSpot_data[i].url) {
			li =  li + '<a href="'+  arSpot_data[i].url  + '" target="_blank">';
		} else {
			li =  li + '<a href="#">';
		}
		/// 画像 (無い場合は文化のみち画像)
		if (arSpot_data[i].img) {
			li = li + '<img src="'+ arSpot_data[i].img +'">';
		} else {
			li = li + imgSrcNoImg;
		}
		// スポット名・スタンプ番号
		li = li + '<h2>';
		if (arSpot_data[i].stamp) {
			li = li + '<span style="font-size:80%;">'+ arSpot_data[i].stamp +'. </span>';
		}
		li = li + arSpot_data[i].name +'</h2>';
		// 追加情報
		if (arSpot_data[i].comment || arSpot_data[i].info) {
			li = li + '<p>';
			if (arSpot_data[i].comment) {
				li = li + '【'+ arSpot_data[i].comment +'】';
			}
			if (arSpot_data[i].info) {
				li = li + arSpot_data[i].info;
			}
			li = li + '</p>';
		}
		// 開館時間
		if (arSpot_data[i].open || arSpot_data[i].last || arSpot_data[i].close) {
			li = li + '<p>';
			if (arSpot_data[i].open) {
				li = li + arSpot_data[i].open +'~';
			} else {
				li = li + ' ~';
			}
			if (arSpot_data[i].last) {
				li = li + arSpot_data[i].last +'(最終入場)';
			} else if (arSpot_data[i].close) {
				li = li + arSpot_data[i].close;
			}
			li = li + '</p>';
		}
		// 距離
		if (arSpot_data[i].distance) {
			li = li + '<p class="allsentence">●ここから'+ arSpot_data[i].distance +'m, 徒歩約'+ calcWalkTime(arSpot_data[i].distance) +'分</p>';
		}
		
		
		li = li + '</a>';
		
		// 経路
		if (arSpot_data[i].map) {
			li =  li + searchRoute(arSpot_data[i].map);
		} else {
			li =  li + searchRoute(arSpot_data[i].name);
		}
		
		// リストを閉じる
		li = li + '</li>';
		
		// リストに追加
		$('.moreArSpotList').append(li);
	}
	
	// CSSの初期化
	$('.moreArSpotList').listview().listview('refresh');
}


//----------------------------------
// もっとみる　近い順バス停リストをリスト画面に表示
function showMoreArBusStopData() {
	
	// ページ初期化
	$('.moreArBusStopList').empty();
	
	// バス停テーブルをループ
	for (var i in arBusStop_data) {
		
		//---------------------
		//  バス停をリストに加えるところ
		//---------------------
		var li =  '<li>';
		/// 詳細ページへのリンク
		if (arBusStop_data[i].url) {
			li =  li + '<a href="'+  arBusStop_data[i].url  + '" target="_blank">';
		} else {
			li =  li + '<a href="#">';
		}
		/// 画像 (無い場合は文化のみち画像)
		if (arBusStop_data[i].img) {
			li = li + '<img src="'+ arBusStop_data[i].img +'">';
		} else {
			li = li + imgSrcNoImg;
		}
		// バス停名・行き先
		li = li + '<h2>'+ arBusStop_data[i].stop_name +'<span style="font-size:70%;">（'+ arBusStop_data[i].dest +' 時刻表）</span></h2>';
		
		
		// バス乗り場番号
		if (arBusStop_data[i].stop_num) {
			li = li + '<p class="allsentence">'+ arBusStop_data[i].stop_num +'番のりば</p>';
		}
		
		// 距離
		if (arBusStop_data[i].distance) {
			li = li + '<p class="allsentence">●ここから'+ arBusStop_data[i].distance +'m, 徒歩約'+ calcWalkTime(arBusStop_data[i].distance) +'分</p>';
		}
		li = li + '</a>';
		
		// 経路
		li =  li + searchRoute(arBusStop_data[i].lat+','+arBusStop_data[i].lng);
		
		// リストを閉じる
		li = li + '</li>';
		
		// リストに追加
		$('.moreArBusStopList').append(li);
	}
		
	// CSSの初期化
	$('.moreArBusStopList').listview().listview('refresh');
}




//-----------------------------------------------
// 位置情報関係の関数
//-----------------------------------------------
//----------------------------------
// GoogleMap経路リンク（徒歩）
function searchRoute(spot) {
	var url = '';
	if (user_lat==''||user_lng=='') {
		url = '<a href="https://maps.google.com/maps?daddr='+ spot +'&dirflg=w" target="_blank">経路></a>';
	} else {
		url = '<a href="https://maps.google.com/maps?saddr='+ user_lat +','+ user_lng +'&daddr='+ spot +'&dirflg=w" target="_blank">経路></a>';
	}
	return url;
}

// GoogleMap経路リンク（公共交通）
function searchBusRoute(spot) {
	var url = '';
	if (user_lat==''||user_lng=='') {
		url = '<a href="https://maps.google.com/maps?daddr='+ spot +'&dirflg=r" target="_blank">経路></a>';
	} else {
		url = '<a href="https://maps.google.com/maps?saddr='+ user_lat +','+ user_lng +'&daddr='+ spot +'&dirflg=r" target="_blank">経路></a>';
	}
	return url;
}

//----------------------------------
// 徒歩自分の計算
function calcWalkTime(distance) {
	var walk_time = Math.round(distance / 60);
	return walk_time;
}

//----------------------------------
// 位置情報の取得
function getGeoLocation(){
	
	// HTML5 geolocation 機能で現在地を取得
	if(navigator.geolocation) {
		navigator.geolocation.getCurrentPosition(function(position) {
			// ユーザの現在位置を取得
			user_lat = position.coords.latitude;
			user_lng = position.coords.longitude;
			var user_pos = new google.maps.LatLng(user_lat, user_lng);
			
		}, function() {
			handleNoGeolocation(true);
		});
	} else {
		// ブラウザがGeolocationをサポートしていない
		handleNoGeolocation(false);
	}
	
}

//----------------------------------
// 位置情報取得のエラー処理
function handleNoGeolocation(errorFlag) {
	if (errorFlag) {
		var content = '位置情報が取得できませんでした';
	} else {
		var content = 'ブラウザが位置情報機能に対応していません';
	}
	alert(content);
}

//----------------------------------
// 測地線航海算法の公式（2地点間の距離を求める）
function geoDistance(lat1, lng1, lat2, lng2, precision) {
  // 引数　precision は小数点以下の桁数（距離の精度）
  var distance = 0;
  if ((Math.abs(lat1 - lat2) < 0.00001) && (Math.abs(lng1 - lng2) < 0.00001)) {
    distance = 0;
  } else {
    lat1 = lat1 * Math.PI / 180;
    lng1 = lng1 * Math.PI / 180;
    lat2 = lat2 * Math.PI / 180;
    lng2 = lng2 * Math.PI / 180;
 
    var A = 6378140;
    var B = 6356755;
    var F = (A - B) / A;
 
    var P1 = Math.atan((B / A) * Math.tan(lat1));
    var P2 = Math.atan((B / A) * Math.tan(lat2));
 
    var X = Math.acos(Math.sin(P1) * Math.sin(P2) + Math.cos(P1) * Math.cos(P2) * Math.cos(lng1 - lng2));
    var L = (F / 8) * ((Math.sin(X) - X) * Math.pow((Math.sin(P1) + Math.sin(P2)), 2) / Math.pow(Math.cos(X / 2), 2) - (Math.sin(X) - X) * Math.pow(Math.sin(P1) - Math.sin(P2), 2) / Math.pow(Math.sin(X), 2));
 
    distance = A * (X + L);
    var decimal_no = Math.pow(10, precision);
    distance = Math.round(decimal_no * distance / 1) / decimal_no;   // kmに変換するときは(1000で割る)
  }
  return distance;
}

//----------------------------------
// バス系統IDから画像URLを導く
function getBusRouteImg(route_id) {
	var url = '';
	for (var i in busRoute_data) {
		if (route_id == busRoute_data[i].id) {
			url = busRoute_data[i].img;
			break;
		}
	}
	return url;
}

//#######################################################################################
//  会場ページ関連
//#######################################################################################

function showSpotData() {
	
	// ページ初期化
	$('.spotList').empty();
	
	// 会場情報テーブルをループ
	for (var i in spot_data) {
		
		
		//---------------------
		//  会場情報をリストに加えるところ
		//---------------------
		var li =  '<li>';
		/// 文化のみちページへのリンク
		if (spot_data[i].url) {
			li =  li + '<a href="'+  spot_data[i].url  + '" target="_blank">';
		} else {
			li =  li + '<a href="#">';
		}
		/// 画像 (無い場合は文化のみち画像)
		if (spot_data[i].img) {
			li = li + '<img src="'+ spot_data[i].img +'">';
		} else {
			li = li + imgSrcNoImg;
		}
		// スポット名・スタンプ番号
		li = li + '<h2>';
		if (spot_data[i].stamp) {
			li = li + '<span style="font-size:80%;">'+ spot_data[i].stamp +'. </span>';
		}
		li = li + spot_data[i].name +'</h2>';
		// 追加情報
		if (spot_data[i].comment || spot_data[i].info) {
			li = li + '<p>';
			if (spot_data[i].comment) {
				li = li + '【'+ spot_data[i].comment +'】';
			}
			if (spot_data[i].info) {
				li = li + spot_data[i].info;
			}
			li = li + '</p>';
		}
		// 開館時間
		if (spot_data[i].open || spot_data[i].last || spot_data[i].close) {
			li = li + '<p>';
			if (spot_data[i].open) {
				li = li + spot_data[i].open +'~';
			} else {
				li = li + ' ~';
			}
			if (spot_data[i].last) {
				li = li + spot_data[i].last +'(最終入場)';
			} else if (spot_data[i].close) {
				li = li + spot_data[i].close;
			}
			li = li + '</p>';
		}
		li = li + '</a>';
		
		// 経路
		if (spot_data[i].map) {
			li =  li + searchBusRoute(spot_data[i].map);
		} else {
			li =  li + searchBusRoute(spot_data[i].name);
		}
		
		// リストを閉じる
		li = li + '</li>';
		
		// リストに追加
		$('.spotList').append(li);
	}
	
	// CSSの初期化
	$('.spotList').listview().listview('refresh');
}

//#######################################################################################
//  バス情報ページ関連
//#######################################################################################

function showBusRouteData() {

	showBusRouteList();
}

// バス系統情報の読み込み
function showBusRouteList() {
	
	// ページ初期化
	$('.busRouteList').empty();
	
	// バス系統テーブルをループ
	for (var i in busRoute_data) {
		//---------------------
		//  バス系統情報をリストに加えるところ
		//---------------------
		var li =  '<li><a href="#spotBus" onclick="showSpotBusList('+ busRoute_data[i].id +')">';
		/// 画像 (無い場合は文化のみち画像)
		if (busRoute_data[i].img) {
			li = li + '<img src="'+ busRoute_data[i].img +'">';
		} else {
			li = li + imgSrcNoImg;
		}
		// 系統名
		li = li + '<h2>'+ busRoute_data[i].route_name +'</h2>';
		// 接続駅
		li = li + '<p><b>接続駅</b> '+ busRoute_data[i].sta +'</p>';
		// 最寄り会場
		li = li + '<p><b>最寄り会場</b> '+ busRoute_data[i].via +'</p>';
		// リストを閉じる
		li = li + '</a></li>';
		
		// リストに追加
		$('.busRouteList').append(li);
	}
	
	// CSSの初期化
	$('.busRouteList').listview().listview('refresh');
	
}

//---------------------
// 最寄情報表示
//---------------------
function showSpotBusList(route_id) {

	// ページ初期化
	$('.busRoute_info').empty();
	$('.spotBusList').empty();
	$('.busRouteName').empty();
	
	// バス路線情報
	var infoStr = '';
	infoStr = '<li><img src="'+ busRoute_data[route_id -1].img +'"><h5>'+ busRoute_data[route_id -1].route_name +'</h5><p><b>出発</b> '+ busRoute_data[route_id -1].dept +'<br><b>終点</b> '+ busRoute_data[route_id -1].dest +'</p></li>';
	$('.busRoute_info').append(infoStr);
	// CSSの初期化
	$('.busRoute_info').listview().listview('refresh');
	
	// 最寄情報テーブルをループ
	var str = '';
	for (var i in spotBus_data) {
		
		// 選択されたバス路線の情報を抽出
		if (spotBus_data[i].route_id == route_id) {
			
			// ヘッダー部分に路線名を表示
			if (str == '') {
				str = spotBus_data[i].route_name + 'で行ける会場';
				$('.busRouteName').append(str);
			}
			
			//---------------------
			//  最寄情報をリストに加えるところ
			//---------------------
			var li =  '<li>';
			/// 文化のみちページへのリンク
			if (spotBus_data[i].url) {
				li =  li + '<a href="'+  spotBus_data[i].url  + '" target="_blank">';
			} else {
				li =  li + '<a href="#">';
			}
			/// 画像 (無い場合は文化のみち画像)
			if (spotBus_data[i].img) {
				li = li + '<img src="'+ spotBus_data[i].img +'">';
			} else {
				li = li + imgSrcNoImg;
			}
			// スポット名
			li = li + '<h2>'+ spotBus_data[i].spot_name +'</h2>';
			// 追加情報
			if (spotBus_data[i].comment || spotBus_data[i].info) {
				li = li + '<p>';
				if (spotBus_data[i].comment) {
					li = li + '【'+ spotBus_data[i].comment +'】';
				}
				if (spotBus_data[i].info) {
					li = li + spotBus_data[i].info;
				}
				li = li + '</p>';
			}
			// 開館時間
			if (spotBus_data[i].open || spotBus_data[i].last || spotBus_data[i].close) {
				li = li + '<p>';
				if (spotBus_data[i].open) {
					li = li + spotBus_data[i].open +'~';
				} else {
					li = li + ' ~';
				}
				if (spotBus_data[i].last) {
					li = li + spotBus_data[i].last +'(最終入場)';
				} else if (spotBus_data[i].close) {
					li = li + spotBus_data[i].close;
				}
				li = li + '</p>';
			}
			// アクセス
			if (spotBus_data[i].bus) {
				li = li + '<p class="allsentence"><b>●'+ spotBus_data[i].bus +'</b></p>';
			}
			li = li + '</a>';
			
			// 経路
			if (spotBus_data[i].map) {
				li =  li + searchBusRoute(spotBus_data[i].map);
			} else {
				li =  li + searchBusRoute(spotBus_data[i].spot_name);
			}
			
			// リストを閉じる
			li = li + '</li>';
			
			// リストに追加
			$('.spotBusList').append(li);
		}
	}
	
	// CSSの初期化
	$('.spotBusList').listview().listview('refresh');
}



//#######################################################################################
//  駅情報ページ関連
//#######################################################################################

function showStaData() {
	// 駅情報データの読み込み
	loadStaData();
	showStaList();
}

// 駅情報の読み込み
function showStaList() {
	
	// ページ初期化
	$('.staList').empty();
	
	// 駅情報テーブルをループ
	for (var i in sta_data) {
		
		//---------------------
		//  駅情報をリストに加えるところ
		//---------------------
		var li =  '<li><a href="https://maps.google.com/maps?saddr='+ user_lat +','+ user_lng +'&daddr='+ sta_data[i].name +'&dirflg=r" target="_blank">';
		// 駅名
		li = li + '<h2>'+ sta_data[i].name +'</h2>';
		// 接続路線
		li = li + '<p>'+ sta_data[i].line +'</p></a>';
		// リストを閉じる
		li = li + '</li>';
		
		// リストに追加
		$('.staList').append(li);
	}
	
	// CSSの初期化
	$('.staList').listview().listview('refresh');
	
}


//#######################################################################################
//  データ読み込み関連
//#######################################################################################
//--------------------------------------------
// データの読み込み
//--------------------------------------------

// LinkDataからデータの読み込み
function loadData() {
}


//---------------------------------------------------
// スポットデータの読み込み
//---------------------------------------------------

function loadSpotData() {
	// LinkDataからのデータの取得
	var workValue = 'rdf1s1870i';
	var fileValue = 'bunkanomichi_event_spot_list';
	
	tmp_dataArray = new Array();
	
	$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
		var tmp_data = {}
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
					tmp_data['id'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#spot_name'){
					tmp_data['name'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#stamp'){
					tmp_data['stamp'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#comment'){
					tmp_data['comment'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#info'){
					tmp_data['info'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#open'){
					var array = objValue.split(":");
					tmp_data['open'] = array[0] +':'+ array[1];
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#last_admission'){
					var array = objValue.split(":");
					tmp_data['last'] = array[0] +':'+ array[1];
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#close'){
					var array = objValue.split(":");
					tmp_data['close'] = array[0] +':'+ array[1];
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#url'){
					tmp_data['url'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#img'){
					tmp_data['img'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#map'){
					tmp_data['map'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#lat'){
					tmp_data['lat'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#lng'){
					tmp_data['lng'] = objValue;
				}
			});
		});
		
		tmp_dataArray.push(tmp_data);
	});
	
	spot_data = tmp_dataArray; // スポットデータを代入
}

//---------------------------------------------------
// 最寄スポットデータの読み込み
//---------------------------------------------------
function loadSpotBusData() {
	// LinkDataからのデータの取得
	var workValue = 'rdf1s1870i';
	var fileValue = 'bunkanomichi_event_spot_bus';
	
	tmp_dataArray = new Array();
	
	$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
		var tmp_data = {}
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
					tmp_data['id'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#route_id'){
					tmp_data['route_id'] = objValue;	// バス系統ID
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#route_name'){
					tmp_data['route_name'] = objValue;	// バス系統名
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#spot_id'){
					tmp_data['spot_id'] = objValue;		// スポットID
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#spot_name'){
					tmp_data['spot_name'] = objValue;	// スポット名
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#stamp'){
					tmp_data['stamp'] = objValue;		// スタンプ番号
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#comment'){
					tmp_data['comment'] = objValue;		// 特別開園情報
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#info'){
					tmp_data['info'] = objValue;		// 追加情報
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#bus'){
					tmp_data['bus'] = objValue;			// バスアクセス情報
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#open'){
					var array = objValue.split(":");	// 開館時間
					tmp_data['open'] = array[0] +':'+ array[1];
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#last_admission'){
					var array = objValue.split(":");	// 最終入場時間
					tmp_data['last'] = array[0] +':'+ array[1];
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#close'){
					var array = objValue.split(":");	// 閉館時間
					tmp_data['close'] = array[0] +':'+ array[1];
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#url'){
					tmp_data['url'] = objValue;			// 詳細ページURL
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#img'){
					tmp_data['img'] = objValue;			// 画像URL
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#map'){
					tmp_data['map'] = objValue;			// 地図検索ワード
				}
			});
		});
		
		tmp_dataArray.push(tmp_data);
	});
	
	spotBus_data = tmp_dataArray; // 最寄スポットデータを代入
}

//---------------------------------------------------
// バス系統データの読み込み
//---------------------------------------------------
function loadBusRouteData() {
	// LinkDataからのデータの取得
	var workValue = 'rdf1s1870i';
	var fileValue = 'bunkanomichi_bus_route';
	
	tmp_dataArray = new Array();
	
	$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
		var tmp_data = {}
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
					tmp_data['id'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#route_name'){
					tmp_data['route_name'] = objValue;	// バス系統名 
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#station'){
					tmp_data['sta'] = objValue;			// 接続駅
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#departure'){
					tmp_data['dept'] = objValue;		// 出発地
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#destination'){
					tmp_data['dest'] = objValue;		// 目的地
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#via'){
					tmp_data['via'] = objValue;			// 経由地
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#img'){
					tmp_data['img'] = objValue;			// 画像URL
				}
			});
		});
		
		tmp_dataArray.push(tmp_data);
	});
	
	busRoute_data = tmp_dataArray; // バス系統データを代入

}

//---------------------------------------------------
// バス停データの読み込み
//---------------------------------------------------
function loadBusStopData() {
	// LinkDataからのデータの取得
	var workValue = 'rdf1s1870i';
	var fileValue = 'bunkanomichi_bus_stop';
	
	tmp_dataArray = new Array();
	
	$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
		var tmp_data = {}
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
					tmp_data['id'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#route_id'){
					tmp_data['route_id'] = objValue;	// バス系統ID
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#route_name'){
					tmp_data['route_name'] = objValue;	// バス系統名
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#destination'){
					tmp_data['dest'] = objValue;		// バス目的地
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#stop_name'){
					tmp_data['stop_name'] = objValue;	// バス停名
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#stop_num'){
					tmp_data['stop_num'] = objValue;	// 乗り場番号
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#url'){
					tmp_data['url'] = objValue;			// 時刻表URL
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#lat'){
					tmp_data['lat'] = objValue;			// バス停緯度
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#lng'){
					tmp_data['lng'] = objValue;			// バス停経度
				}
			});
		});
		
		tmp_dataArray.push(tmp_data);
	});
	
	busStop_data = tmp_dataArray; // バス停スポットデータを代入

}

//---------------------------------------------------
// 駅データの読み込み
//---------------------------------------------------
function loadStaData() {
	// LinkDataからのデータの取得
	var workValue = 'rdf1s1870i';
	var fileValue = 'bunkanomichi_station';
	
	tmp_dataArray = new Array();
	
	$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
		var tmp_data = {}
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
					tmp_data['id'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#name'){
					tmp_data['name'] = objValue;	// 駅名
				} else if (propValue == 'http://linkdata.org/property/rdf1s1870i#line'){
					tmp_data['line'] = objValue;	// 接続路線
				}
			});
		});
		
		tmp_dataArray.push(tmp_data);
	});
	
	sta_data = tmp_dataArray; // 駅データを代入
}
