if(typeof Application==="undefined"||!Application){var Application = {};}

// map
var map = null;

//
var cityMasterArray = null;
var cityMarketArray = null;
var cityObservationArray = null;

// アプリケーションのビジネスロジック
Application.faamo = function(){this.init();};

// faamoメイン
Application.faamo.prototype = {
	// 初期化処理
	init : function(){
		this._loadStart();
		var isSuccess = this._loadData();
		if(!isSuccess){
			this._loadError();
		} else {
			this._loadEnd();
		}
	},
	// ロード時のローディング画面
	_loadStart : function(){
		console.log('now loading');
		$('#main_contents').hide();
	},
	_loadEnd : function(){
		$("#loading").delay(600).fadeOut(700);
		$('#main_contents').show();
		console.log('load success');
	},
	_loadError : function(){
		alert('load error');
	},
	
	// データロード
	_loadData : function(){
		var application = new Application.faamo.LinkData();
		// 
//		if(this.isEmpty(cityMaster)){
		cityMasterArray = application.getDataResult('city_master');
//		}
		//
//		if(this.isEmpty(cityMarket)){
		cityMarketArray = application.getDataResult('city_market');
//		}
		//
//		if(this.isEmpty(cityObservation)){
		cityObservationArray = application.getDataResult('city_observation');
//		}
		return true;
	},

};

// LinkData関連
Application.faamo.LinkData = function(){};
Application.faamo.LinkData.prototype = {
	/** 
	 * 指定ファイル内のデータを取得
	 * @param dataname 取得するデータソースのファイル名
	 * @result データソースファイル内の全データの配列
	 */
	getDataResult : function(dataname){
		var resultArray = null;
		$.each(LinkData.getWorks(), function(wKey, workId){
			$.each(LinkData.getFiles(workId), function(fKey, filename){
				if(filename == dataname){
					$.each(LinkData.getSubjects(workId, filename), function(sKey, subject){
						if(resultArray == null) resultArray = new Array();
						var objArray = [];
						$.each(LinkData.getProperties(workId, filename), function(pKey, property){
							var obj = LinkData.getObjects(workId, filename, subject, property);
							var prop = property.split('#')[1];
							objArray[prop] = obj;
						});
						resultArray.push(objArray);
					});
				}
			});
		});
		return resultArray;
	}
};

Application.faamo.Draw = function(){this._init();};

Application.faamo.Draw.prototype = {

	_init : function(){
	},

	_markerArray : new google.maps.MVCArray(),
	
	drawMap : function(){
		//表示するGoogleMapの定義
		//latlng型（経度・緯度） latlng
		var latlng = new google.maps.LatLng(39, 138);
		var opts = {
			zoom: 2,
			mapTypeId: google.maps.MapTypeId.SATELLITE,
			center: latlng
		};
		//Google map表示　htmlのmapに対応
		map = new google.maps.Map(document.getElementById("map"), opts);
		
		
		//シティマスタを読み込み、マーカーをデータ数分作成する
		for(var i = 0; i < cityMasterArray.length; i++){
			//国コード
			var cityMaster = cityMasterArray[i];
			//
			var markerOpt = new google.maps.Marker({
					position: new google.maps.LatLng(cityMaster.lat, cityMaster.long),
					map: map,
					icon: 'http://labs.google.com/ridefinder/images/mm_20_red.png'
			});
			
			var marker = new google.maps.Marker(markerOpt);
			this._markerArray.push(marker);
			
			
			google.maps.event.addListener(marker, 'click', function(event){
				// クリックしたマーカーのクラスを作る
				var cityCluster = cityMaster.cluster;
				
				var heatmapData = new Array();
				cityMasterArray.forEach(function(cityMaster, idx){
					if(cityMaster.cluster == cityCluster){
						heatmapData.push(new google.maps.LatLng(cityMaster.lat, cityMaster.long));
					}
				});
				var heatmap = new google.maps.visualization.HeatmapLayer({
					data: heatmapData,
					radius:25
				});
				heatmap.setMap(map);
				
				
				
				//壹岐追記
				
				var infowindow = new google.maps.InfoWindow({
				content: "国名：なんたら共和帝国<br/>カテゴリー：A"
	//			content: "<img src= 'http://voiceyourchoice.jp/images/ico_atoxic02.png'> </img>"
				//content: "<div style='background-color:#cccccc;'>てすとー</div>" 
				//background-color: #5599ff;
					
					//boxClass: "{ background: url('http://blankcoin.com/mn/mn_img/sora/mn_sora_23.jpg') no-repeat"
				});
				infowindow.open(map, marker);
				
				
			});
			
			marker.setMap(map);
		}
		
//		var heatmap = new google.maps.visualization.HeatmapLayer({
//			data: this.heatmapData
//		});
//		heatmap.setMap(map);
	}
};


google.load("visualization", "1", {packages:["corechart"]});

var application = new Application.faamo();
var draw = new Application.faamo.Draw();
google.setOnLoadCallback(draw.drawMap());
