google.load("jquery", "1");
google.load("jqueryui", "1");
google.load("visualization", "1", {'packages' : [ 'motionchart' ]});

$(window).load(function() {
	sparql = new Sparql();
 	
	//SPARQL検索の実行
	$('#find_query').click(function(){
		var category = $('#category').val();
		
		//sparql.findByQuery($('#query_area').val().replace(/[\n\r]/g,""));
		//使用するSPARQLクエリの設定
		query = 'select ?s ?name ?year ?people ?male ?female ?kekkaku ?akusei ?syokudo\n'
+'where{\n'
 + '?s <http://lodosaka.hozo.jp/kind> "死因"@ja.\n'
 + '?s <http://lodosaka.hozo.jp/city> ?name;\n'
 + '  <http://lodosaka.hozo.jp/year> ?year;\n'
 +    '<http://lodosaka.hozo.jp/people> ?people;\n'
 +    '<http://lodosaka.hozo.jp/male> ?male;\n'
 +    '<http://lodosaka.hozo.jp/female> ?female;\n'
 +    '<http://lodosaka.hozo.jp/kekkaku> ?kekkaku;\n'
 +    '<http://lodosaka.hozo.jp/akusei> ?akusei;\n'
 +    '<http://lodosaka.hozo.jp/syokudo> ?syokudo;\n'
 + '}'
		//結果を表示する欄の設定
		sparql.result_div = $('#result_div');
		//クエリの実行
		sparql.findByQuery(query);
	});

	$('#result_div').hide();

	init();
});


function init(){
	// Servletサーバアドレス
	sparql.server = "http://lod.hozo.jp";

	// 検索対象エンドポイント（途中での改行は不可）
 	//var endpoint = $('#endpoint_url').val();
	sparql.endpoint = {"endpoint": "http://lod.hozo.jp/repositories/IODD14Osaka", "namespaces": ""};
	sparql.init();
	
	//結果表示処理を行う関数を指定
//	sparql.result_func = result_table;
	sparql.result_func = motion_chart;
	
}

function motion_chart(data){
	var category = $('#category').val();
	
	$('#result_div').show();
	var datatable = new google.visualization.DataTable();

	
	datatable.addColumn('string', data[0].kind);
	datatable.addColumn('number', '年');
	datatable.addColumn('number', '総数');
	datatable.addColumn('number', '男性');
	datatable.addColumn('number', '女性');
	datatable.addColumn('number', '結核');
	datatable.addColumn('number', '悪性新生物');
	datatable.addColumn('number', '食道の悪性新生物');

	for(var i=0; i<data.length; i++){
		datatable.addRow(
			[data[i].name, 
			 parseInt(data[i].year, 10), 
			 parseInt(data[i].people, 10),
			 parseInt(data[i].male, 10),
		 	 parseInt(data[i].female, 10),
			 parseInt(data[i].kekkaku, 10),
			 parseInt(data[i].akusei, 10),
			 parseInt(data[i].syokudo, 10)
			]);
	}
	

	var chart = new google.visualization.MotionChart(
	 document.getElementById('result_div'));
	 chart.draw(datatable, {'width': 900, 'height': 400});

}
