/*
簡易LOD検索サイト作成ツール　　
http://sourceforge.jp/projects/easylod/wiki/EasyLODSite
を用いたサンプルアプリケーションです
*/

function init(){
	
// Servletサーバアドレス
sparql.server = "http://lod.hozo.jp";

	
// 検索対象エンドポイント
sparql.endpoint = {"endpoint": "http://lod.hozo.jp/repositories/OsakaCityMap",
				   "namespaces": "http://linkdata.org/work/rdf1s933i"};
	
		
// 固定検索条件
sparql.sparqlConditionHead = "{?s <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://lodosaka.hozo.jp/class/施設情報>}";

// 検索条件述語
sparql.predicates = [
	{"label":"施設名", "pred":"<http://schema.org/name>"},
	{"label":"大分類", "pred":"<http://lodosaka.hozo.jp/category_1>", 
	 	"types":["官公庁","学校・保育所","公園・スポーツ","会館・ホール",
				 "文化・観光","警察・消防","医療・福祉","名所・旧跡",
				 "駅・バス停","駐車場・駐輪場","公衆トイレ","環境・リサイクル",
				 "その他"]},	
	{"label":"小分類", "pred":"<http://lodosaka.hozo.jp/category_2>", 
	 	"types":["国の機関","府の機関","市の機関","幼稚園","保育所","小学校",
				 "中学校","高等学校","大学","学校(その他)","スポーツ施設",
				 "公園","児童遊園・広場","会館・ホール","地域集会所・老人憩いの家",
				 "図書館","美術館・博物館","都市景観資源","その他施設","警察・交番",
				 "消防署","病院・診療所","福祉施設","特別養護老人ホーム",
				 "介護老人保健施設","社寺","名所・旧跡","駅","バス停","バイク駐車場",
				 "駅周辺駐輪場","駅周辺駐輪場（その他）","自転車保管所",
				 "パーク＆ライド駐車場","公衆便所","車いす対応公衆便所",
				 "古紙回収協力店","無線LANスポット"]},			
	{"label":"区","pred":"<http://lodosaka.hozo.jp/ku>",
	 	"types":["阿倍野区","旭区","港区","此花区","住吉区","住之江区","城東区",
				 "生野区","西区","西成区","西淀川区","大正区","中央区","鶴見区",
				 "天王寺区","都島区","東住吉区","東成区","東淀川区","福島区",
				 "平野区","北区","淀川区","浪速区","大阪市以外"]},
	{"label":"住所","pred":"<http://schema.org/address>"},
	];

// 表示項目
sparql.viewPreds = {
	"link":false,
	"data":[
		//{"label":"ID",        "valiable":"subject", "link":false},
		{"label":"施設名",  "valiable":"name", 
			"pred":"<http://schema.org/name>"},
		{"label":"大分類",  "valiable":"c1",   
			"pred":"<http://lodosaka.hozo.jp/category_1>"},			
		{"label":"小分類",  "valiable":"c2",   
			"pred":"<http://lodosaka.hozo.jp/category_2>"},			
		{"label":"住所",      "valiable":"ad",   
			"pred":"<http://schema.org/address>"},
		{"label":"ホームページ",      "valiable":"hp",   
			"pred":"<http://xmlns.com/foaf/0.1/homepage>"},
		//{"label":"緯度",      "valiable":"lat",   
		//	"pred":"<http://www.w3.org/2003/01/geo/wgs84_pos#lat>"},
		//{"label":"経度",      "valiable":"long",   
		//	"pred":"<http://www.w3.org/2003/01/geo/wgs84_pos#long>"},	 
		]};


// 特定検索条件リスト
sparql.menuCondition = [
    ];


sparql.init();
	
sparql.addCondition(0);
}

