$(window).load(function() {

	sparql = new Sparql();
 	
	//SPARQL検索の実行
	$('#find_query').click(function(){
		var endpoint = $('#endpoint_url').val();
		sparql.endpoint = {"endpoint": endpoint, "namespaces": ""};
		sparql.findByQuery($('#query_area').val().replace(/[\n\r]/g,""));
	});

	$('#result_div').hide();

	init();
});


function init(){
	// Servletサーバアドレス
	sparql.server = "http://lod.hozo.jp";

	// 検索対象エンドポイント（途中での改行は不可）
 	var endpoint = $('#endpoint_url').val();
	sparql.endpoint = {"endpoint": endpoint, "namespaces": ""};
	
	//結果表示処理を行う関数を指定
	sparql.result_func = result_table;

	sparql.init();
}

//結果表示用の関数
function result_table(data){
	 var result_div = $('#result_div');

	var table = $('#result_list')[0];


	if (table == undefined) {
		result_div.append($('<table border="1"></table>').attr({
			'id' : 'result_list',
			'class' : 'table'
		}));
		table = $('#result_list')[0];
	}

	while (table.rows.length > 0) {
		table.deleteRow(0); // 行を追加
	}

	if (data instanceof Array) {
		result_div.show();
		// ヘッダ
		var header = table.createTHead(); // 行を追加
		var headerRow = header.insertRow(0);

		id = 1;
		for (var d = 0; d < data.length; d++) {
			var row1 = table.insertRow(d + 1); // 行を追加

			if (d == 0) {
				for ( var key in data[0]) {
					var th = document.createElement('th');
					var label = key;
					th.innerHTML = key;
					headerRow.appendChild(th);
				}
			}
	
			var i = 0;
			// ID
			for ( var key in data[d]) {
				var cell = row1.insertCell(i++); // ２つ目以降のセルを追加
				var value = data[d][key];
				if (value.uri != undefined){
					value = value.uri;
				}
				if (value == null) {
					value = '';
				}
	
				var link = true;
				if (link) {
					if (value != null && value.indexOf("http://") == 0) {
						value = '<a href="'+value+'" target="_blank">'
								+ value + '</a>';
					}
				}
				cell.innerHTML = value;
			}
		}
	}
};
