if(typeof Application==="undefined"||!Application){var Application = {};}

// 
var cityData = [];	// 都市データ
// 降水量、土壌水分量、積雪深は以下のようなデータ構造
// [dataType:dataType, data:[cityCode: cccccc, dataList:[{month:YYYYMM, data:xxxxxx}]]]
var dataMap = [];
// 類似データ
// [cityCode: ccccc, data: [{type: ttttt, data: sssssss}]]
var similarityDataMap = [];

// map
var map = null;

// アプリケーションのビジネスロジック
Application.lc = function(){this.init();};

Application.lc.prototype = {
	// 初期化処理
	init : function(){
		this.loadData();
	},
	// データロード
	loadData : function(){
		var application = new Application.lc.LinkData();
		var cityDataArray = application.getLinkDataResult('world_city');
		cityData = this._structCityData(cityDataArray);
		
		var preDataArray = application.getLinkDataResult('precipitation');
		dataMap.push({dataType: 'precipitation', data: this._structPreData(preDataArray)});
		var smcDataArray = application.getLinkDataResult('soil_moisture_content');
		dataMap.push({dataType: 'soil_moisture_content', data: this._structSmcData(smcDataArray)});
		var sndDataArray = application.getLinkDataResult('snow_depth');
		dataMap.push({dataType: 'snow_depth', data: this._structSndData(sndDataArray)});

		var simPrcArray = application.getLinkDataResult('similarity_prc');
		similarityDataMap = this._modifiedSimilarity(similarityDataMap, 'similarity_prc', simPrcArray);
		var simSmcArray = application.getLinkDataResult('similarity_smc');
		similarityDataMap = this._modifiedSimilarity(similarityDataMap, 'similarity_smc', simSmcArray);
		var simSnd = application.getLinkDataResult('similarity_snd');
		similarityDataMap = this._modifiedSimilarity(similarityDataMap, 'similarity_snd', simSnd);
		var simSndSmc = application.getLinkDataResult('similarity_snd_smc');
		similarityDataMap = this._modifiedSimilarity(similarityDataMap, 'similarity_snd_smc', simSndSmc);
		var simPrcSmcArray = application.getLinkDataResult('similarity_prc_smc');
		similarityDataMap = this._modifiedSimilarity(similarityDataMap, 'similarity_prc_smc', simPrcSmcArray);
		var simPrcSndArray = application.getLinkDataResult('similarity_prc_snd');
		similarityDataMap = this._modifiedSimilarity(similarityDataMap, 'similarity_prc_snd', simPrcSndArray);
		var simPrcSndSmcArray = application.getLinkDataResult('similarity_prc_snd_smc');
		similarityDataMap = this._modifiedSimilarity(similarityDataMap, 'similarity_prc_snd_smc', simPrcSndSmcArray);
		
		similarityDataMap = this._appendCityLocation(similarityDataMap, cityData);
	},
	// 都市データを構造化
	_structCityData : function(array){
		var result = null;
		for(var i = 0; (array != null && i < array.length); i++){
			var cityCode = '';
			var dataArray = null;
			for(var j = 0; (array[i] != null && j < array[i].length); j++){
				if(array[i][j].key == 'label'){
					cityCode = array[i][j].data[0];
					continue;
				}
				if(dataArray == null) dataArray = new Array();
				dataArray.push({key: array[i][j].key, data: array[i][j].data[0]});
			}
			if(result == null) result = new Array();
			result.push({cityCode: cityCode, data: dataArray});
		}
		return result;
	},
	
	// 降水量データを構造化
	_structPreData : function(array){
		return this._structMonthlyData(array);
	},
	// 土壌水分量データを構造化
	_structSmcData : function(array){
		return this._structMonthlyData(array);
	},
	// 積雪深データを構造化
	_structSndData : function(array){
		return this._structMonthlyData(array);
	},
	// 月別データを構造化
	_structMonthlyData : function(array){
		var result = null;
		
		for(var i = 0; (array != null && i < array.length); i++){
			var cityCode = '';
			var monthData = [];
			for(var j = 0; (array[i] != null && j < array[i].length); j++){
				if(array[i][j].key == 'label'){
					cityCode = array[i][j].data[0];
					continue;
				}
				var month = array[i][j].key.substring('proc-'.length-1);
				var data = array[i][j].data[0];
				monthData.push({month: month, data: parseFloat(data)});
			}
			if(result == null) result = new Array();
			result.push({city: cityCode, data: monthData});
		}
		
		return result;
	},
	_modifiedSimilarity : function(simiData, dataType, dataArray){
		var resultArray = simiData;
		for(var i = 0; i < dataArray.length; i++){
			// cityCodeを取得して配列から除外
			var cityCode = '';
			for(var j = 0; dataArray[i].length; i++){
				if(dataArray[i][j].key == 'label'){
					cityCode = dataArray[i][j].data[0];
					dataArray[i].splice(j, 1);
					break;
				}
			}
			
			// simiDataを更新
			var isNodata = false;
			for(var si = 0; si < resultArray.length; si++){
				if(resultArray[si].cityCode == cityCode){
					resultArray[si].data.push({type: dataType, data: this._sortSimiData(dataArray[i])});
					isNodata = false;
					break;
				} else {
					isNodata = true;
				}
			}
			// データがまだなかった場合
			if(resultArray == null || resultArray.length == 0 || isNodata){
				var datas = new Array({type: dataType, data: this._sortSimiData(dataArray[i])});
				resultArray.push({cityCode: cityCode, data: datas});
			}
		}
		return resultArray;
	},
	
	_appendCityLocation : function(simiDataMap, cityData){
		var resultData = simiDataMap;
		for(var si = 0; si < resultData.length; si++){
			for(var ci = 0; ci < cityData.length; ci++){
				if(resultData[si].cityCode == cityData[ci].cityCode){
					resultData[si].cityData = cityData[ci].data;
					break;
				}
			}
		}
		return resultData;
	},
	
	_sortSimiData : function(dataArray){
		if(dataArray == null) return null;

		for(var i = 0; i < dataArray.length; i++){
			var bigger = i;
			for(var j = i + 1; j < dataArray.length; j++){
				if(dataArray[bigger].data[0] < dataArray[j].data[0]){
					bigger = j;
				}
			}
			var data = dataArray[i];
			dataArray[i] = dataArray[bigger];
			dataArray[bigger] = data;
		}
		
		return dataArray;
	}
};

// LinkData関連
Application.lc.LinkData = function(){};

Application.lc.LinkData.prototype = {
	/** 
	 * 指定ファイル内のデータを取得
	 * @param dataname 取得するデータソースのファイル名
	 * @result データソースファイル内の全データの配列
	 */
	getLinkDataResult : function(dataname){
		var resultArray = null;
		$.each(LinkData.getWorks(), function(wKey, workId){
			$.each(LinkData.getFiles(workId), function(fKey, filename){
				if(filename == dataname){
					$.each(LinkData.getSubjects(workId, filename), function(sKey, subject){
						if(resultArray == null) resultArray = new Array();
						var objArray = [];
						$.each(LinkData.getProperties(workId, filename), function(pKey, property){
							var obj = LinkData.getObjects(workId, filename, subject, property);
							var prop = property.split('#')[1];
							objArray.push({key: prop, data: obj});
						});
						resultArray.push(objArray)
					});
				}
			});
		});
		return resultArray;
	}
};

Application.lc.Draw = function(){this._init();};

Application.lc.Draw.prototype = {
	_init : function(){
		//google.maps.event._setCityBox = this._setCity;
	},

	drawMap : function(cityData){
		var latlng = new google.maps.LatLng(39, 138);
		var opts = {
			zoom: 2,
			mapTypeId: google.maps.MapTypeId.SATELLITE,
			center: latlng
		};
		map = new google.maps.Map(document.getElementById("map"), opts);
		
		this._plotMarker(map, cityData, '|AFAFFF|000000');
	},
	
	_markerArray : new Array(),

	_plotMarker : function(map, mapDataList, markerIcon){
		for(var i = 0; i < mapDataList.length; i++){
			var cityData = {};
			cityData.cityCode = mapDataList[i].cityCode;
			for(var mi = 0; mi < mapDataList[i].data.length; mi++){
				if(mapDataList[i].data[mi].key == 'city_name_ja') cityData.cityName = mapDataList[i].data[mi].data;
				if(mapDataList[i].data[mi].key == 'country_ja') cityData.countryName = mapDataList[i].data[mi].data;
				if(mapDataList[i].data[mi].key == 'lat') cityData.lat = mapDataList[i].data[mi].data;
				if(mapDataList[i].data[mi].key == 'long') cityData.lng = mapDataList[i].data[mi].data;
			}
			this.attachMarker(map, cityData, markerIcon);
		}
	},
	
	
	_openInfoWindow : null,

	attachMarker : function(map, cityData, iconInfo){
		var markerOpt = null;
		if(iconInfo == null){
			markerOpt = {
				position: new google.maps.LatLng(cityData.lat, cityData.lng),
				map: map,
			};
		} else {
			markerOpt = {
				position: new google.maps.LatLng(cityData.lat, cityData.lng),
				map: map,
				icon: 'http://chart.apis.google.com/chart?chst=d_map_pin_letter&chld=' + iconInfo
			};
		}
		var marker = new google.maps.Marker(markerOpt);

		var app = this;	// イベントハンドラのクラスに_setCityBoxを追加したいけど、型がわからん・・・
		google.maps.event.addListener(marker, 'click', function(event){
			_setCityBox(cityData.cityCode, cityData.cityName, cityData.countryName);
			if(app._openInfoWindow) app._openInfoWindow.close();
			app._openInfoWindow = new google.maps.InfoWindow({
				content: cityData.cityName + "<br>" + cityData.countryName
			});
			google.maps.event.addListener(app._openInfoWindow, 'closeclick', function(){
				app._openInfoWindow = null;
			});
			app._openInfoWindow.open(marker.getMap(), marker);
		});
		
		this._markerArray.push(marker);
	},
	
	_getSimilarityDatasource : function(selectDataType){
		var datasource = null;
		var isPrc = false;
		var isSnd = false;
		var isSmc = false;
		selectDataType.forEach(function(dataType, idx){
			if(dataType == 'precipitation') isPrc = true;
			if(dataType == 'snow_depth') isSnd = true;
			if(dataType == 'soil_moisture_content') isSmc = true;
		});
		
		if(isPrc || isSnd || isSmc){
			datasource = 'similarity' + (isPrc ? '_prc' : '') + (isSnd ? '_snd' : '') + (isSmc ? '_smc' : '');
		}
		
		return datasource;
	},

	
	resetMarker : function(selectCityCode, selectDataType){
		this.clearMarker();
		
		var simiDatasourceName = this._getSimilarityDatasource(selectDataType);
		
		var cityDataArray = null;
		for(var mi = 0; mi < similarityDataMap.length; mi++){
			if(similarityDataMap[mi].cityCode == selectCityCode){
				if(cityDataArray == null) cityDataArray = new Array();
				cityDataArray.push({cityCode: similarityDataMap[mi].cityCode, data: similarityDataMap[mi].cityData});
				for(var di = 0; di < similarityDataMap[mi].data.length; di++){
					if(similarityDataMap[mi].data[di].type == simiDatasourceName){
						for(var si = 0; si < similarityDataMap[mi].data[di].data.length; si++){
							// データ内の都市コードの座標を取得
							for(var ci = 0; ci < cityData.length; ci++){
								if(similarityDataMap[mi].data[di].data[si].key == cityData[ci].cityCode){
									cityDataArray.push(cityData[ci]);
								}
							}
						}
					}
				}
			}
		}
		
		
		for(var i = 0; i < cityDataArray.length; i++){
			var convData = {};
			convData.cityCode = cityDataArray[i].cityCode;
			for(var mi = 0; mi < cityDataArray[i].data.length; mi++){
				if(cityDataArray[i].data[mi].key == 'city_name_ja') convData.cityName = cityDataArray[i].data[mi].data;
				if(cityDataArray[i].data[mi].key == 'country_ja') convData.countryName = cityDataArray[i].data[mi].data;
				if(cityDataArray[i].data[mi].key == 'lat') convData.lat = cityDataArray[i].data[mi].data;
				if(cityDataArray[i].data[mi].key == 'long') convData.lng = cityDataArray[i].data[mi].data;
			}
			
			var markerStyle = '|AFAFFF|000000';
			if(i == 0) markerStyle = null;
			if(i >= 1 && i <= 4) markerStyle = i + '|FFAFAF|000000';
			if(i >= 5 && i <= 6) markerStyle = i + '|FF8C00|000000';
			if(i >= 7 && i <= 8) markerStyle = i + '|FAFFFA|000000';
			if(i >= 9 && i <= 10) markerStyle = i + '|77FF77|000000';
			this.attachMarker(map, convData, markerStyle);
		}
		
		
		
//		this._markerArray = new Array();
//		this._plotMarker(map, cityDataArray, '|FFAFAF|000000');

		this._markerArray.forEach(function(marker, idx){
			marker.setMap(map);
		});
	},
	
	clearMarker : function(){
		this._markerArray.forEach(function(marker, idx){
			marker.setMap(null);
		});
	},

	drawChart : function(selectCityCode){
		var dataList = this._getDataList(selectCityCode);
		if(dataList == null || dataList.length == 0){
			console.log('気象データがありません');
			return;
		}

		var parentDom = document.getElementById('chart');
		for(var i = 0; i < dataList.length; i++){
			var childNode = document.createElement("div");
			childNode.setAttribute('id', dataList[i].type);
			parentDom.appendChild(childNode);
			
			var dataTypeString = this._dataTypeToString(dataList[i].type);
			var data = google.visualization.arrayToDataTable(dataList[i].dataList);
			var options = {
							lineWidth: 5,
							colors: ['#41adc0'],
							legend: {position:'none'},
							title: dataTypeString
						  };
			var chart = new google.visualization.LineChart(childNode);
			chart.draw(data, options);
		}
	},
	
	_getDataList : function(cityCode){
		if(cityCode == null || cityCode == '') return null;
		var checkedList = this.getCheckDataTypeList();
		if(checkedList == null || checkedList.length == 0) return null;

		var result = null;
		for(var i = 0; i < checkedList.length; i++){
			if(result == null) result = new Array();
			var checked = checkedList[i];
			var obj = {
				type: checked,
				dataList: this._getData(cityCode, checked)
			};
			result.push(obj);
		}
		
		return result;
	},
	
	_getData : function(cityCode, dataType){
		var dataArray = null;
		
		var dataTypeList = this._getDataTypeList(dataType);
		if(dataTypeList == null) return null;

		var cityDataList = this._getCityDataList(dataTypeList, cityCode);
		if(cityDataList == null) return null;
		
		dataArray = new Array();
		dataArray.push(new Array('年月', this._dataTypeToString(dataType)));
		return dataArray.concat(cityDataList);
	},
	
	_getDataTypeList : function(dataType){
		for(var i = 0; i < dataMap.length; i++){
			if(dataMap[i].dataType == dataType) return dataMap[i].data;
		}
		return null;
	},
	
	_getCityDataList : function(dataTypeList, cityCode){
		for(var i = 0; i < dataTypeList.length; i++){
			if(dataTypeList[i].city == cityCode){
				var dataResult = [];
				for(var di = 0; di < dataTypeList[i].data.length; di++){
					dataResult.push(new Array(dataTypeList[i].data[di].month, dataTypeList[i].data[di].data));
				}
				return dataResult;
			}
		}
		return null;
	},
	
	clearChart : function(){
		var parentNode = document.getElementById("chart");
		for(var i = parentNode.childNodes.length-1; i >= 0; i--){
			parentNode.removeChild(parentNode.childNodes[i]);
		}
	},
	
	_dataTypeToString : function(dataType){
		var string = '';
		if(dataType == 'precipitation') string = '降水量 (mm/day)';
		else if(dataType == 'soil_moisture_content') string = '土壌水分量 (%)';
		else if(dataType == 'snow_depth') string = '積雪深 (cm)';
		return string;
	},
	
	getCheckDataTypeList : function(){
		var checkedList = [];
		$('input:checkbox[name="dataType"]:checked').each(function() {
			checkedList.push($(this).val());
		});
		return checkedList;
	}
};


google.load("visualization", "1", {packages:["corechart"]});

var application = new Application.lc();
var draw = new Application.lc.Draw();
google.setOnLoadCallback(draw.drawMap(cityData));


function _setCityBox(cityCode, cityName, countryName){
	var countryNameBox = $('#country_name');
	var cityCodeBox = $('#city_code');
	countryNameBox.empty();
	cityCodeBox.val('');
	countryNameBox.append(cityName + '(' + countryName + ')');
	cityCodeBox.val(cityCode);
}
// 都市選択ボックスのクリア
$('#city_clear').click(function(event){
	var countryName = $('#country_name');
	countryName.empty();
	countryName.append('都市名, 国名');
	$('#city_code').val('');
});

// 
$('#apply').click(function(){
	draw.clearChart();
	
	var cityCode = $('#city_code').val();
	var checkedDataTypeList = draw.getCheckDataTypeList();
	var dataType 
	draw.drawChart(cityCode);
	draw.resetMarker(cityCode, checkedDataTypeList);
});


// checkbox styling

$(function(){
	$('img.checked').hide();
	$('#param_check label').toggle(
		function () {
			$(this).addClass('checked').prev('input').attr('checked','checked');
			$(this).find('img.default').hide();
			$(this).find('img.checked').show();
		},
		function () {
			$(this).removeClass('checked').prev('input').removeAttr('checked');
			$(this).find('img.default').show();
			$(this).find('img.checked').hide();
		}
	);
});
