/*
challengemap.js

The MIT License (MIT)

Copyright (c) 2013 Digital und MeeR Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

(function(global) {

var works = LinkData.getWorks(), fileData = {}
_(works).each(function(work){
	var files = LinkData.getFiles(work), workName = LinkData.getWorkName(work)
	_(files).each(function(file){
		var city = { challenge_data: [] }, latStore = [], longStore = [], latSum = 0, longSum = 0
		,subjects = LinkData.getSubjects(work, file)
		,colorScale = chroma.scale("Set3").mode("hsv")
		_(subjects).each(function(sub){
			var obj = {}, props = LinkData.getProperties(work, file)
			_(props).each(function(prop){
				propLabel = prop.split("#")[1]
				obj[propLabel] = LinkData.getObjects(work, file, sub, prop)[0]
			})
			obj.color = colorScale(Math.random())
			latStore.push(parseFloat(obj.lat))
			latSum += parseFloat(obj.lat)
			longStore.push(parseFloat(obj.long))
			longSum += parseFloat(obj.long)
			city.challenge_data.push(obj)
		})
		city.name = city.challenge_data[0].city
		city.year = city.challenge_data[0].year
		city.lat = latSum / city.challenge_data.length
		city.long = longSum / city.challenge_data.length
		city.bounds = {
			s: _.min(latStore),
			w: _.min(longStore),
			n: _.max(latStore),
			e: _.max(longStore)
		}
		city.id = work + "|" + file
		fileData[city.id] = city
		$(".file-selector").each(function(idx, el){
			$(el).append('<option value="' + city.id + '">' + workName + " | " + file + '</option>')
		})
	})
})

$("#submit-match").on("click", function(){
	var submitData = []
	$(".file-selector").each(function(idx, el){
		var val = $(el).val(), data = null, id = $(el).attr("id")
		if(val) {
			data = fileData[val]
			data.selector = id
			submitData.push(data)
		}
		$("#" + id + "-total-count").html("-")
		$("#" + id + "-total-percentage").html("--")
		$("#" + id + "-total-population").html("-")
		$("#" + id + "-winner").hide()
	})
	__app.match.reset(submitData)
	$("#data-section").slideDown()
	$("#selector-section").slideUp()
})

$(".file-selector").on("change", function(){
	var selfValue = $(this).val(), otherSelectors = $(".file-selector").not(this)
	if($(this).attr("id") == "c1") {
		otherSelectors.each(function(idx, el){
			if(selfValue)
				$(el).prop("disabled", false)
			else
				$(el).prop("disabled", true).val("").trigger("change")
		})
	}
	otherSelectors.find("option").each(function(idx, el){
		var optionValue = $(el).attr("value")
		if(optionValue) {
			if(optionValue == selfValue)
				$(el).prop("disabled", true)
			else
				$(el).prop("disabled", false)
		}
	})
}).trigger("change")

$("#show-selector").on("click", function(){
	$("#data-section").slideUp()
	$("#selector-section").slideDown()
	__app.match.reset([])
})

var challengeMap = {}
, map = new google.maps.Map(document.getElementById("map_canvas"), {
	center: new google.maps.LatLng(39.25128944533077, 140.62528600000005),
	draggable: false,
	zoom: 11,
	maxZoom: null,
	minZoom: null,
	disableDefaultUI: true,
	mapTypeControl: true,
	disableDoubleClickZoom: false,
	mapTypeId: google.maps.MapTypeId.ROADMAP
})
, defaultState = {
	displayValue: "percentage",
	displayMode: "region",
	selectedCity: null
}
, __app = null

, City = Backbone.Model.extend({
	initialize: function() {
		var paper = __app.graph.paper, bounds = this.get("bounds")
			, sw = new google.maps.LatLng(bounds.s - 0.02, bounds.w - 0.02)
			, ne = new google.maps.LatLng(bounds.n + 0.02, bounds.e + 0.02)
		this.regions = new RegionCollection()
		this.regions.city = this
		this.regions.reset(this.get("challenge_data"))
		this.totalGraphPosition = new google.maps.LatLng(this.get("lat"), this.get("long"))
		this.position = new google.maps.LatLng(parseFloat(this.get("lat")), parseFloat(this.get("long")))
		this.bounds = new google.maps.LatLngBounds(sw, ne)
		this.selector = new CitySelect({model: this})
		this.kml = new google.maps.KmlLayer({
			url: location.protocol + "//" + location.host + challengeMap.appPath + "kml/city-" + this.id + ".kml",
			clickable: false,
			preserveViewport: true,
			map: map
		})
		this.elements = {
			circle: paper.circle(0, 0, 0).attr({
				fill: "#c00",
				stroke: 0,
				"fill-opacity": 0.8,
				"stroke-width": 4
			}),
			label: paper.text(0, 0, this.get("name")).attr({"font-size": 18}),
			value: null
		}
		this.showInformation()
		this.on("select", this.select)
		this.on("unfocus", this.unfocus)
		this.on("unload", this.unload)
	},
	select: function() {
		var changed = this.collection._changingState
		, regionClickHandler = this.collection.getStateHandler({displayMode:"region"})
		if(_.isEmpty(changed))
			return null
		if(changed.displayMode && this.regionGraphTimer) {//地域-全体の高速切り替え対策
			clearTimeout(this.regionGraphTimer)
			this.regionGraphTimer = null
		}
		if(changed.selectedCity) {
			if(this.isSingle()) {
				changed.displayMode = "total"
				$("#display-region").off("click").prop("disabled", true).addClass("disabled")
			} else {
				$("#display-region").on("click", regionClickHandler).prop("disabled", false).removeClass("disabled")
			}
			google.maps.event.addListenerOnce(map, "idle", _.bind(function(){//mapの位置変更を待つ
				this.resetCircle()
				this.showGraph(changed.displayMode, changed.displayValue)
				map.setOptions({
					maxZoom: map.getZoom(),
					minZoom: map.getZoom()
				})
				console.log(map.getZoom())
			}, this))
			console.log(this.bounds)
			map.setOptions({
				maxZoom: 11,
				minZoom: null
			})
			map.panTo(this.position)
			map.fitBounds(this.bounds)
			map.panBy(1,0)
		} else {
			this.showGraph(changed.displayMode, changed.displayValue)
		}
	},
	unfocus: function() {
		this.regions.each(function(mdl){
			_.each(mdl.elements, function(el){
				if(el) el.hide()
			})
		})
		_.each(this.elements, function(el){
			if(el) el.hide()
		})
	},
	unload: function() {
		this.regions.each(function(mdl){
			_.each(mdl.elements, function(el){
				if(el) el.remove()
			})
		})
		_.each(this.elements, function(el){
			if(el) el.remove()
		})
		this.kml.setMap(null)
	},
	showInformation: function() {
		var selector = this.get("selector")
		$("#" + selector + "-total-count").html(this.getTotalValue("count"))
		$("#" + selector + "-total-percentage").html(this.getTotalPercentage())
		$("#" + selector + "-total-population").html(this.getTotalValue("population"))
	},
	getTotalValue: function(attr){
		var result = 0
		this.regions.each(function(mdl){
			result += parseInt(mdl.get(attr))
		})
		return result
	},
	getTotalPercentage: function() {
		return Math.round(this.getTotalValue("count") / this.getTotalValue("population") * 10000) / 100
	},
	getCircleRadius: function(value) {
		var worldWidth = __app.graph.getProjection().getWorldWidth(), result = 0
		if(value == "percentage") {
			result = worldWidth / 200000 * this.getTotalPercentage()
		} else if(value == "count") {
			result = worldWidth / 140000000 * this.getTotalValue("count")
		}
		return result
	},
	resetCircle: function(){
		var proj = __app.graph.getProjection()
		,center = proj.fromLatLngToDivPixel(this.totalGraphPosition)
		,el = this.elements

		el.circle.attr({
			cx: center.x,
			cy: center.y,
			r: 0
		})
		this.regions.each(function(mdl){
			var el = mdl.elements
			el.circle.attr({
				cx: center.x,
				cy: center.y,
				r: 0
			})
		})
	},
	showGraph: function(mode, value){
		mode = mode || this.collection.state.displayMode
		value = value || this.collection.state.displayValue
		if(mode == "total")
			this.showTotalGraph(value)
		else if(mode == "region")
			this.showRegionGraph(value)
	},
	showTotalGraph: function(value){
		var center = __app.graph.getProjection().fromLatLngToDivPixel(this.totalGraphPosition)
			,paper = __app.graph.paper
			,el = this.elements

		this.regions.each(function(mdl){
			var el = mdl.elements
			el.label.hide()
			if(el.value) el.value.hide()
			el.circle.animate({
				cx: center.x,
				cy: center.y,
				r: 0
			}, 200, ">", function(){this.hide()})
		})

		el.circle.show().animate({
			cx: center.x,
			cy: center.y,
			r: this.getCircleRadius(value)
		}, 500, "bounce")
		el.label.attr({
			x: center.x,
			y: center.y - 48
		}).show()
		if(el.value) el.value.remove()

		if(value == "percentage") {
			el.value = paper.print(
				center.x, center.y, this.getTotalPercentage() + "%",
				paper.getFont("Lato"), 64
			).attr({
				fill: "#fff",
				stroke: "#333",
				"stroke-width": 2,
				"stroke-linejoin": "round"
			})
		} else if(value == "count") {
			el.value = paper.print(
				center.x, center.y, this.getTotalValue("count"),
				paper.getFont("Lato"), 64
			).attr({
				fill: "#fff",
				stroke: "#333",
				"stroke-width": 2,
				"stroke-linejoin": "round"
			})
		}
		el.value.transform("t-" + el.value.getBBox().width / 2 + ",0")
	},
	showRegionGraph: function(value) {
		var el = this.elements
			, paper = __app.graph.paper
			, self = this

		el.label.hide()
		if(el.value) el.value.hide()
		el.circle.animate({
			r: 0
		}, 200, ">", function(){this.hide()})

		;(function iter(i){
			var mdl = self.regions.at(i)
			if(mdl === undefined) {
				self.regionGraphTimer = null
				return true
			}
			var pos = __app.graph.getProjection().fromLatLngToDivPixel(mdl.position)
				,el = mdl.elements
				,callee = arguments.callee

			el.label.attr({
				x: pos.x,
				y: pos.y - 32
			}).show()
			el.circle.show().animate({
				cx: pos.x,
				cy: pos.y,
				r: mdl.getCircleRadius(value)
			}, 500, "bounce")
			if(el.value) el.value.remove()
			if(value == "percentage") {
				el.value = paper.print(
					pos.x, pos.y, mdl.getPercentage() + "%",
					paper.getFont("Lato"), 42 * Math.pow(map.getZoom() / 11, 2)
				).attr({
					fill: "#fff",
					stroke: "#333",
					"stroke-width": 2,
					"stroke-linejoin": "round"
				})
			} else if(value == "count") {
				el.value = paper.print(
					pos.x, pos.y, mdl.get("count"),
					paper.getFont("Lato"), 42 * Math.pow(map.getZoom() / 11, 2)
				).attr({
					fill: "#fff",
					stroke: "#333",
					"stroke-width": 2,
					"stroke-linejoin": "round"
				})
			}
			el.value.transform("t-" + el.value.getBBox().width / 2 + ",0")
			self.regionGraphTimer = setTimeout(function(){
				iter(++i)
			}, 50)
		})(0)
	},
	getTimestamp: function() {
		var result = new Date(0)
		this.regions.each(function(mdl) {
			var time = new Date()
			if(result < time) result = time
		})
		return result
	},
	isSingle: function() {
		return this.regions.length == 1
	}
})

, Region = Backbone.Model.extend({
	initialize: function() {
		var paper = __app.graph.paper
			,fontSize = 18 * Math.pow(map.getZoom() / 11, 2)
		this.position = new google.maps.LatLng(this.get("lat"), this.get("long"))
		this.elements = {
			circle: paper.circle(0, 0, 0).attr({
				fill: this.get("color"),
				stroke: 0,
				"fill-opacity": 0.8,
				"stroke-width": 4
			}),
			label: paper.text(0, 0, this.get("region")).attr({"font-size": fontSize}),
			percentage: null,
			count: null
		}
	},
	getPercentage: function() {
		return Math.round(parseInt(this.get("count")) / parseInt(this.get("population")) * 100)
	},
	getCircleRadius: function(value) {
		var worldWidth = __app.graph.getProjection().getWorldWidth()
		if(value == "percentage") {
			return worldWidth / 600000 * this.getPercentage()
		} else if(value == "count") {
			return worldWidth / 100000000 * this.get("count")
		}
	}
})

, Match = Backbone.Collection.extend({
	model: City,
	initialize: function() {
		this.on("reset", function(col, opt){
			this.resetState()
			_.each(opt.previousModels, function(pmdl){
				pmdl.trigger("unload")
			})
			if(col.length) {
				this.setState(_.defaults({selectedCity: this.at(0).id}, defaultState))
				$("#switch-city").show()
			} else {
				$("#switch-city").hide()
			}
			if(col.length > 1) {
				this.judgement()
			}
		})

		$("#display-percentage").on("click", this.getStateHandler({displayValue: "percentage"}))
		$("#display-count").on("click", this.getStateHandler({displayValue: "count"}))
		$("#display-region").on("click", this.getStateHandler({displayMode: "region"}))
		$("#display-total").on("click", this.getStateHandler({displayMode: "total"}))
	},
	judgement: function(){
		var winner = [], highest = 0
		this.each(function(mdl){
			var totalPercentage = mdl.getTotalPercentage()
			if(highest <= totalPercentage) {
				if(highest == totalPercentage)
					winner.push(mdl)
				else
					winner = [mdl]
				highest = totalPercentage
			}
		})
		_(winner).each(function(mdl){
			$("#" + mdl.get("selector") + "-winner").fadeIn()
		})
	},
	state: {},
	setState: function(state) {
		var changed = {}, selectedCity
		_.each(this.state, function(val, key){
			if(state[key] && state[key] != val)
				changed[key] = state[key]
		})
		selectedCity = changed.selectedCity || this.state.selectedCity
		this._changingState = changed
		this.each(function(mdl){
			if(mdl.id == selectedCity) {
				mdl.trigger("select")
			} else {
				mdl.trigger("unfocus")
			}
		})
		_.extend(this.state, this._changingState)
		$("#display-" + this.state.displayMode).button("toggle")
		$("#display-" + this.state.displayValue).button("toggle")
	},
	resetState: function() {
		this.state = {displayMode: null, displayValue: null, selectedCity: null}
	},
	loadData: function(year) {
		__app.loadedYear = (year && year != thisYear) ? year : thisYear
		this.reset(city)
	},
	getStateHandler: function(state) {
		var self = this

		return function(ev){
			self.setState(state)
		}
	},
	getLoadHandler: function(year) {
		var self = this

		return function(){
			var loadYear = year || thisYear
			self.loadData(loadYear)
		}
	}
})

, RegionCollection = Backbone.Collection.extend({
	model: Region
})

, CitySelect = Backbone.View.extend({
	initialize: function(){
		_.bindAll(this, "toggle", "unload")
		this.model.on("unload", this.unload)
		this.model.on("select", this.toggle)
		this.render()
		this.select = __app.match.getStateHandler({selectedCity: this.model.id})
	},
	events: {
		"click": "select"
	},
	className: "btn btn-large btn-primary span6 toggle-button",
	render: function(){
		$("#switch-city > div")
			.append(this.$el.html(this.model.get("year") + "<br>" + this.model.get("name")))
	},
	toggle: function(){
		this.$el.button("toggle")
	},
	unload: function(){
		this.$el.remove()
	}
})

, App = Backbone.Router.extend({
	initialize: function() {
		this.loadedYear = null
		this.match = null
		this.graph = new GraphOverlay(map, _.bind(function(){
			this.match = new Match()
		}, this))
	}
})

, GraphOverlay = function(map, callback) {
	this.callback = callback
	this.setMap(map)
}
GraphOverlay.prototype = new google.maps.OverlayView()
GraphOverlay.prototype.onAdd = function(){
	var proj = this.getProjection()
	var paper = Raphael(0, 0, 2000, 2000)

	this.paper = paper
	var panes = this.getPanes()
	panes.overlayMouseTarget.appendChild(this.paper.canvas)

	this.callback()
}
GraphOverlay.prototype.draw = function(){
	this.paper.canvas.style.left = "0px"
	this.paper.canvas.style.top = "0px"
	this.paper.canvas.style.overflow = "visible"
}
GraphOverlay.prototype.onRemove = function(){
	this.paper.remove()
	this.paper = null
}

challengeMap.boot = function() {
	if(challengeMap.instance) return false
	challengeMap.instance = __app = new App()
	Backbone.history.start({
		pushState: true,
		root: "/" + location.pathname
	})
}
global.challengeMap = challengeMap

})(this)
	
challengeMap.boot()
