var drawMarkersMap = function(rawData) {
	if(! rawData) {
		rawData =[];
	}
	var data = google.visualization.arrayToDataTable(rawData);

	var options = {backgroundColor : '#0B173B', minValue: 0,  colors: ['#F2F5A9', '#DF013A']};
    var chart = new google.visualization.GeoChart(document.getElementById('paintedMap'));
    chart.draw(data, options);
}
	
	google.load('visualization', '1', {packages: ['geochart']});
	google.setOnLoadCallback(drawMarkersMap);

window.onload = function() {
	GenerateHeatmap.initFileList();
};

GenerateHeatmap = {};
GenerateHeatmap.fileName = "";

GenerateHeatmap.initFileList = function(){
	var sb =[];
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			sb[sb.length] = "<option value=\"" + fileValue + "\">"+ fileValue +"</option>";
		});
	});
	
	$("#fileOptions").append(sb.join(""));
	$("#fileOptions").change(GenerateHeatmap.drawMap);	
	$("#generate").click(generatePng);
	$("#generate").click(function(){
		$(".downloadButton").css("display", "");
	});
}
GenerateHeatmap.drawMap = function(event){
	var fileValue = event.currentTarget.value;
	if(fileValue == ""){
		return ;
	}
	GenerateHeatmap.fileName = fileValue;
	var data = [];
	data[data.length] = ["Country", fileValue];
	
	var workId = "rdf1s795i";
	
	$.each(LinkData.getSubjects( workId, fileValue), function(subjKey, subjValue) {
		var countryCode ="";
		var measured =0;
		
		var propAry = LinkData.getProperties(workId, fileValue);
		for(var i = 0 ; i < propAry.length ; i++){
			var propValue = propAry[i]
			if(propValue == "http://www.geonames.org/ontology#countryCode"){
				countryCode = LinkData.getObjects(workId, fileValue, subjValue, propValue)[0];
			}
			if(propValue == "http://linkdata.org/property/"+workId+"#value"){
				measured = LinkData.getObjects(workId, fileValue, subjValue, propValue)[0];
			}
		}
		data[data.length] = [countryCode, parseInt(measured, 10)];
//		$("#debug").append(countryCode + " <-> "+measured + "<br>");
	});
	drawMarkersMap(data);
}

	function generatePng(){
		var svg = $("#paintedMap").children().children();
		canvg('canvas', svg.html(), { ignoreMouse: true, ignoreAnimation: true } );
		var c = document.getElementById('canvas');

 		var type = 'image/png'; 
		var data = c.toDataURL(type);

      	$('#png').attr('download', GenerateHeatmap.fileName + ".png");
      	$('#png').attr('href', data);
	}
