if (!YP) {
	var YP = {};
}

YP.main = function() {
	this._init.apply(this, arguments);
};

YP.main.prototype = {
	
	_infoList : null,
	_property : null,
	_subjectList : null,
	
	_cons : {
		MAX_ITEM_COUNT			: 10,
		INFO_SELECTOR			: ".info",
		KEY_WORD_SELECTOR		: "#keyword",
		INFO_LIST_SELECTOR		: "#infoList",
		MORE_INFO_SELECTOR		: ".moreInfo",
		TAG_SELECTOR			: ".tag",
		SEARCH_IMAGE_SELECTOR	: ".searchImage",
		EXPAND_ALL_SELECTOR		: ".expandAll",
		EXTRA_INFO_SELECTOR		: ".extraInfo",
		PAGE_TITLE_SELECTOR		: ".pageTitle",
		SHOW_ALL_BUTTON_SELECTOR: ".showAllButton"
		
	},
	
	_init : function() {
		this._infoList = [];
		this._property = new YP.property();
		this._initInfoList();
		this._initView();
		this._initListener();
	},
	
	_initInfoList : function() {
		var self = this, workId = self._property.getWorkId(), fileName = self._property.getFileName();
		var subjectList = LinkData.getSubjects(workId, fileName);
		for (var i = 0; i < subjectList.length; i++) {
			var subject = subjectList[i];
			var info = new YP.info();
			info.setName(LinkData.getObjects(workId, fileName, subject, self._property.getNameProperty())[0]);
			info.setKana(LinkData.getObjects(workId, fileName, subject, self._property.getKanaProperty())[0]);
			info.setBirthday(LinkData.getObjects(workId, fileName, subject, self._property.getBirthdayProperty())[0]);
			info.setChair(LinkData.getObjects(workId, fileName, subject, self._property.getChairProperty())[0]);
			info.setViceChair(LinkData.getObjects(workId, fileName, subject, self._property.getViceChairProperty())[0]);
			info.setGroup(LinkData.getObjects(workId, fileName, subject, self._property.getGroupProperty())[0]);
			info.setParty(LinkData.getObjects(workId, fileName, subject, self._property.getPartyProperty())[0]);
			info.setElected(LinkData.getObjects(workId, fileName, subject, self._property.getElectedProperty())[0]);
			info.setAddress(LinkData.getObjects(workId, fileName, subject, self._property.getAddressProperty())[0]);
			info.setPhone(LinkData.getObjects(workId, fileName, subject, self._property.getPhoneProperty())[0]);
			info.setCellPhone(LinkData.getObjects(workId, fileName, subject, self._property.getCellPhoneProperty())[0]);
			info.setFax(LinkData.getObjects(workId, fileName, subject, self._property.getFaxProperty())[0]);
			info.setEmail(LinkData.getObjects(workId, fileName, subject, self._property.getEmailProperty())[0]);
			info.setHomePage(LinkData.getObjects(workId, fileName, subject, self._property.getHomePageProperty())[0]);
			info.setRemark(LinkData.getObjects(workId, fileName, subject, self._property.getRemarkProperty())[0]);
			info.setDepiction(LinkData.getObjects(workId, fileName, subject, self._property.getDepictionProperty())[0]);
			self._infoList.push(info);
		}
	},
	
	_initView : function() {
		var self = this;
		var infoList = self._getInfoListByIndex(1, self._cons.MAX_ITEM_COUNT);
		self._addHtml(infoList);
		$(self._cons.KEY_WORD_SELECTOR).val("");
	},
	
	_initListener : function() {
		this._initPageTitleListener();
		this._initShowAllButtonListener();
		this._initMoreInfoListener();
		this._initAutoCompleter();
		this._initKeywordListener();
		this._initSearchImageListener();
	},
	
	_initPageTitleListener : function() {
		var self = this;
		$(self._cons.PAGE_TITLE_SELECTOR).click(function() {
			$(self._cons.KEY_WORD_SELECTOR).val("");
			var infoList = self._getInfoListByIndex(1, self._cons.MAX_ITEM_COUNT);
			self._addHtml(infoList);
		});
	},
	
	_initShowAllButtonListener : function() {
		var self = this;
		$(self._cons.SHOW_ALL_BUTTON_SELECTOR).click(function() {
			$(self._cons.KEY_WORD_SELECTOR).val("");
			var infoList = self._getInfoListByIndex(1, self._cons.MAX_ITEM_COUNT);
			self._addHtml(infoList);
		});
	},
	
	_initMoreInfoListener : function() {
		var self = this, page = 2;
		$(self._cons.MORE_INFO_SELECTOR).unbind("click");
		$(self._cons.MORE_INFO_SELECTOR).click(function() {
			var keyword = $(self._cons.KEY_WORD_SELECTOR).val();
			var infoList = self._getInfoListByIndex(page, self._cons.MAX_ITEM_COUNT, keyword);
			if (infoList.length != 0) {
				self._appendHtml(infoList, keyword);
				page++;
			} else {
				$(this).hide();
			}
		});
	},
	
	_initAutoCompleter : function() {
		var self = this;
		$(self._cons.KEY_WORD_SELECTOR).autocomplete({
			minLength: 1,
			source: function(req, res) {
				var keyword = req.term;
				res(self._getMatchWordListByKeyword(keyword));
			},
			select : function(event, ui) {
				var keyword = ui.item.value;
				var infoList = self._getInfoListByIndex(1, self._cons.MAX_ITEM_COUNT, keyword);
				self._addHtml(infoList, keyword);
			}
		})
	},
	
	_initKeywordListener : function() {
		var self = this;
		$(self._cons.KEY_WORD_SELECTOR).keydown(function(evt) {
			if (evt.which == 13) {
				$(self._cons.KEY_WORD_SELECTOR).autocomplete("close");
				var keyword = $(this).val();
				var infoList = self._getInfoListByIndex(1, self._cons.MAX_ITEM_COUNT, keyword);
				self._addHtml(infoList, keyword);
			}
		});
	},
	
	_initSearchImageListener : function() {
		var self = this;
		$(self._cons.SEARCH_IMAGE_SELECTOR).click(function() {
			$(self._cons.KEY_WORD_SELECTOR).autocomplete("close");
			var keyword = $(self._cons.KEY_WORD_SELECTOR).val();
			var infoList = self._getInfoListByIndex(1, self._cons.MAX_ITEM_COUNT, keyword);
			self._addHtml(infoList, keyword);
		});
	},
	
	_initTagListener : function() {
		var self = this;
		$(self._cons.INFO_LIST_SELECTOR + " " + self._cons.TAG_SELECTOR).unbind("click");
		$(self._cons.INFO_LIST_SELECTOR + " " + self._cons.TAG_SELECTOR).click(function() {
			var keyword = $(this).text().trim();
			$(self._cons.KEY_WORD_SELECTOR).val(keyword);
			var infoList = self._getInfoListByIndex(1, self._cons.MAX_ITEM_COUNT, keyword);
			self._addHtml(infoList, keyword);
		});
	},
	
	_initExpandAllListener : function() {
		var self = this;
		$(self._cons.INFO_LIST_SELECTOR + " " + self._cons.EXPAND_ALL_SELECTOR).unbind("click");
		$(self._cons.INFO_LIST_SELECTOR + " " + self._cons.EXPAND_ALL_SELECTOR).click(function() {
			var parent = $(this).closest(self._cons.INFO_SELECTOR);
			$(parent).find(self._cons.EXTRA_INFO_SELECTOR).show();
			$(this).hide();
		});
	},
	
	_addHtml : function(infoList, keyword) {
		var self = this;
		if (infoList.length != 0) {
			var html = self._getContentHtml(infoList, keyword);
			$(self._cons.INFO_LIST_SELECTOR).html(html);
			self._initMoreInfoListener();
			self._initTagListener();
			self._hideUnNecessaryExpandAllButton();
			self._initExpandAllListener();
			$(self._cons.MORE_INFO_SELECTOR).show();
		} else {
			var html = self._getNotFoundHtml();
			$(self._cons.INFO_LIST_SELECTOR).html(html);
			$(self._cons.MORE_INFO_SELECTOR).hide();
		}
	},
	
	_appendHtml : function(infoList, keyword) {
		var self = this;
		var html = self._getContentHtml(infoList, keyword);
		$(self._cons.INFO_LIST_SELECTOR).append(html);
		self._initTagListener();
		self._hideUnNecessaryExpandAllButton();
		self._initExpandAllListener();
	},
	
	_hideUnNecessaryExpandAllButton : function() {
		var self = this;
		$.each($(self._cons.INFO_LIST_SELECTOR + " " + self._cons.EXPAND_ALL_SELECTOR), function() {
			var parent = $(this).closest(self._cons.INFO_SELECTOR);
			var html = $(parent).find(self._cons.EXTRA_INFO_SELECTOR).html();
			if (!html || html.trim().length == 0) {
				$(this).hide();
			}
		});
	},
	
	_getInfoList : function(start, itemCount) {
		var self = this, list = [];
		var workId = self._property.getWorkId(), fileName = self._property.getFileName();
		var sList = self._getSubjectList(start, itemCount);
		for (var i = 0; i < sList.length; i++) {
			var subject = sList[i];
			var info = new YP.info();
			info.setName(LinkData.getObjects(workId, fileName, subject, self._property.getNameProperty())[0]);
			info.setKana(LinkData.getObjects(workId, fileName, subject, self._property.getKanaProperty())[0]);
			info.setBirthday(LinkData.getObjects(workId, fileName, subject, self._property.getBirthdayProperty())[0]);
			info.setChair(LinkData.getObjects(workId, fileName, subject, self._property.getChairProperty())[0]);
			info.setViceChair(LinkData.getObjects(workId, fileName, subject, self._property.getViceChairProperty())[0]);
			info.setGroup(LinkData.getObjects(workId, fileName, subject, self._property.getGroupProperty())[0]);
			info.setParty(LinkData.getObjects(workId, fileName, subject, self._property.getPartyProperty())[0]);
			info.setElected(LinkData.getObjects(workId, fileName, subject, self._property.getElectedProperty())[0]);
			info.setAddress(LinkData.getObjects(workId, fileName, subject, self._property.getAddressProperty())[0]);
			info.setPhone(LinkData.getObjects(workId, fileName, subject, self._property.getPhoneProperty())[0]);
			info.setCellPhone(LinkData.getObjects(workId, fileName, subject, self._property.getCellPhoneProperty())[0]);
			info.setFax(LinkData.getObjects(workId, fileName, subject, self._property.getFaxProperty())[0]);			
			info.setEmail(LinkData.getObjects(workId, fileName, subject, self._property.getEmailProperty())[0]);
			info.setHomePage(LinkData.getObjects(workId, fileName, subject, self._property.getHomePageProperty())[0]);
			info.setRemark(LinkData.getObjects(workId, fileName, subject, self._property.getRemarkProperty())[0]);
			info.setDepiction(LinkData.getObjects(workId, fileName, subject, self._property.getDepictionProperty())[0]);	
			list.push(info);
		}
		return list;
	},
	
	_getMatchWordListByKeyword : function(keyword) {
		var self = this, list = [];
		var infoList = self._getInfoListByIndex(2, self._cons.MAX_ITEM_COUNT, keyword);
		$.each(infoList, function(key, info) {
			if (info.getName().toLowerCase().indexOf(keyword.toLowerCase()) > -1 && $.inArray(info.getName(), list)) {
				list.push(info.getName());
			} 
			if (info.getKana().toLowerCase().indexOf(keyword.toLowerCase()) > -1 && $.inArray(info.getKana(), list)) {
				list.push(info.getKana());
			} 
			if (info.getAddress().toLowerCase().indexOf(keyword.toLowerCase()) > -1 && $.inArray(info.getAddress(), list)) {
				list.push(info.getAddress());
			}
			if (info.getGroup().toLowerCase().indexOf(keyword.toLowerCase()) > -1 && $.inArray(info.getGroup(), list)) {
				list.push(info.getGroup());
			}
			if (info.getParty().toLowerCase().indexOf(keyword.toLowerCase()) > -1 && $.inArray(info.getParty(), list)) {
				list.push(info.getParty());
			}
		});
		return list;
	},
	
	_getInfoListByIndex : function(page, itemCount, keyword) {
		var self = this, list = [], count = 0;
		var end = (page * itemCount) - 1;
		var start = end - itemCount + 1;
		for (var i = 0; i < self._infoList.length; i++) {
			var info = self._infoList[i];
			if ((!keyword || keyword.trim().length == 0) || self._isHitInfo(info, keyword)) {
				if (count >= start && count <= end) {
					list.push(info);
				}
				count++;
			}
			if (list.length == itemCount) {
				return list;
			}
		}
		return list;
	},
	
	_isHitInfo : function(info, keyword) {
		if (!keyword || keyword.trim().length == 0) {
			return false;
		}
		if (info.getName().toLowerCase().indexOf(keyword.toLowerCase()) > -1) {
			return true;
		} else if (info.getKana().toLowerCase().indexOf(keyword.toLowerCase()) > -1) {
			return true;
		} else if (info.getAddress().toLowerCase().indexOf(keyword.toLowerCase()) > -1) {
			return true;
		} else if (info.getGroup().toLowerCase().indexOf(keyword.toLowerCase()) > -1) {
			return true;
		} else if (info.getParty().toLowerCase().indexOf(keyword.toLowerCase()) > -1) {
			return true;
		}
		return false;
	},
	
	_getContentHtml : function(infoList, keyword) {
		var self = this, sb = [];
		for (var i = 0; i < infoList.length; i++) {
			var info = infoList[i];
			sb[sb.length] = "<div class='info cf'>";
			sb[sb.length] = "<div class='profileImageArea left'>";
			sb[sb.length] = "<img class='profileImage' src='" + info.getDepiction() + "'/>";
			sb[sb.length] = "<div class='ribbon-wrapper'>";
			sb[sb.length] = "<div class='ribbon-front'>" + info.getElected() + "</div>";
			sb[sb.length] = "<div class='ribbon-edge-topleft'></div>";
			sb[sb.length] = "<div class='ribbon-edge-topright'></div>";
			sb[sb.length] = "<div class='ribbon-edge-bottomleft'></div>";
			sb[sb.length] = "<div class='ribbon-edge-bottomright'></div>";
			sb[sb.length] = "<div class='ribbon-back-left'></div>";
			sb[sb.length] = "<div class='ribbon-back-right'></div>";
			sb[sb.length] = "</div>";
			sb[sb.length] = "</div>";
			sb[sb.length] = "<div class='profileInfoArea left'>";
			sb[sb.length] = "<div class='name'>" + self._getHighLightKeywordHtml(info.getName(), keyword) + "（" + self._getHighLightKeywordHtml(info.getKana(), keyword) + "）";
			if (info.getChair().trim().length != 0) {
				sb[sb.length] = "<span class='chair'>議長</span>";
			}
			if (info.getViceChair().trim().length != 0) {
				sb[sb.length] = "<span class='chair'>副議長</span>";
			}
			sb[sb.length] = "</div>";
			sb[sb.length] = "<div>";
			if (info.getAddress().trim().length != 0) {
				sb[sb.length] = "<span class='address'>〒" + self._getHighLightKeywordHtml(info.getAddress(), keyword) + "</span>";
			}
			if (info.getGroup().trim().length != 0) {
				sb[sb.length] = "<br><span class='nextTo'>会派：" + self._getHighLightKeywordHtml(info.getGroup(), keyword) + "</span>";
			}
			if (info.getParty().trim().length != 0) {
				sb[sb.length] = "<span>所属政党：" + self._getHighLightKeywordHtml(info.getParty(), keyword) + "</span>";
			}
			sb[sb.length] = "</div>";
			sb[sb.length] = "<div class='cf'>";
			sb[sb.length] = "<div class='expandAll right'>&gt;&gt; もっと見る</div>";
			sb[sb.length] = "</div>";
			sb[sb.length] = "<div class='extraInfo hide'>";
			if (info.getPhone().trim().length != 0) {
				sb[sb.length] = "<span class='nextTo'>電話番号：" + info.getPhone();
				sb[sb.length] = "<span class='callButton' <a href='tel:" + info.getPhone() + "'><i class='icon icon-phone'></i>CALL</a></span></span>";
			}
			if (info.getCellPhone().trim().length != 0) {
				sb[sb.length] = "<span class='nextTo'>携帯番号：" + info.getCellPhone();
				sb[sb.length] = "<span class='callButton' <a href='tel:" + info.getCellPhone() + "'><i class='icon icon-phone'></i>CALL</a></span></span>";
			}
			if (info.getFax().trim().length != 0) {
				sb[sb.length] = "<br><span>FAX番号：" + info.getFax() + "</span>";
			}
			if (info.getBirthday().trim().length != 0) {
				sb[sb.length] = "<br><i class='icon icon-birthday'></i>" + info.getBirthday();
			}
			if (info.getEmail().trim().length != 0) {
				sb[sb.length] = "<br><div><i class='icon icon-envelope'></i>" + "<a href='mailto:" + info.getEmail() + "' class='email'>" + info.getEmail() + "</a></div>";
			}
			if (info.getHomePage().trim().length != 0) {
				sb[sb.length] = "<div>";
				sb[sb.length] = "<i class='icon icon-home'></i><a href='" + info.getHomePage() + "' target='_blank' class='homePage'>ホームページを見る</a>";
				sb[sb.length] = "</div>";
			}
			if (info.getRemark().trim().length != 0) {
				sb[sb.length] = "<div><i class='icon icon-comment'></i><a href='" + info.getRemark() + "' target='_blank' class='homePage'>議会での発言を見る</a>";
				sb[sb.length] = "</div>";
			}
			sb[sb.length] = "</div>";
			sb[sb.length] = "</div>";
			sb[sb.length] = "</div>";
		}
		return sb.join("");
	},
	
	_getHighLightKeywordHtml : function(text, keyword) {
		if (!keyword || keyword.trim().length == 0) {
			return text;
		}
		var regex = new RegExp('(' + keyword + ')', 'gi');
		return text.replace(regex, "<span class='highlight'>$1</span>");
	},
	
	_getNotFoundHtml : function() {
		var sb = [];
		sb[sb.length] = "<div class='info error'>議員は見つかりませんでした</div>";
		return sb.join("");
	},
	
	_getTagListHtml : function(tagList, keyword) {
		var self = this, sb = [];
		for (var i = 0; i < tagList.length; i++) {
			var tag = tagList[i];
			sb[sb.length] = "<span class='tag left'>" + self._getHighLightKeywordHtml(tag.trim(), keyword) + "</span>";
		}
		return sb.join("");
	}
};

YP.property = function() {
	this._init.apply(this, arguments);
};

YP.property.prototype = {
	
	_workId : null,
	_fileName : null,
	_nameProperty : null,
	_birthdayProperty : null,
	_kanaProperty : null,
	_chairProperty : null,
	_viceChairProperty : null,
	_groupProperty : null,
	_pertyProperty : null,
	_electedProperty : null,
	_addressProperty : null,
	_phoneProperty : null,
	_cellPhoneProperty : null,
	_faxProperty : null,
	_emailProperty : null,
	_homePageProperty : null,
	_remarkProperty : null,
	_depictionProperty : null,

	_cons : {
		NAME				: "label",
		BIRTHDAY			: "birthday",
		KANA				: "kana",
		CHAIR				: "#chairman",
		VICE_CHAIR			: "#vice-chairman",
		GROUP				: "group",
		PARTY				: "party",
		ELECTED				: "elected",
		ADDRESS				: "address",
		PHONE				: "#phone-number",
		CELL_PHONE			: "#cell-phone-number",
		FAX					: "FAX",
		EMAIL				: "e-mail",
		HOME_PAGE			: "homepage",
		REMARK				: "remark",
		DEPICTION			: "photo"
	},
	
	_init : function() {
		this._initProperty();
	},
	
	_initProperty : function() {
		var self = this;
		$.each(LinkData.getWorks(), function(workKey, workId) {
			$.each(LinkData.getFiles(workId), function(fileKey, fileName) {
				self._workId = workId;
				self._fileName = fileName;
				$.each(LinkData.getProperties(workId, fileName), function(propKey, propValue) {
					if (propValue.indexOf(self._cons.NAME) > -1) {
						self._nameProperty = propValue;
					} else if (propValue.indexOf(self._cons.BIRTHDAY) > -1) {
						self._birthdayProperty = propValue;
					} else if (propValue.indexOf(self._cons.KANA) > -1) {
						self._kanaProperty = propValue;
					} else if (propValue.indexOf(self._cons.CHAIR) > -1) {
						self._chairProperty = propValue;
					} else if (propValue.indexOf(self._cons.VICE_CHAIR) > -1) {
						self._viceChairProperty = propValue;
					} else if (propValue.indexOf(self._cons.GROUP) > -1) {
						self._groupProperty = propValue;
					} else if (propValue.indexOf(self._cons.PARTY) > -1) {
						self._partyProperty = propValue;
					} else if (propValue.indexOf(self._cons.ELECTED) > -1) {
						self._electedProperty = propValue;
					} else if (propValue.indexOf(self._cons.ADDRESS) > -1) {
						self._addressProperty = propValue;
					} else if (propValue.indexOf(self._cons.PHONE) > -1) {
						self._phoneProperty = propValue;
					} else if (propValue.indexOf(self._cons.CELL_PHONE) > -1) {
						self._cellPhoneProperty = propValue;
					} else if (propValue.indexOf(self._cons.EMAIL) > -1) {
						self._emailProperty = propValue;
					} else if (propValue.indexOf(self._cons.HOME_PAGE) > -1) {
						self._homePageProperty = propValue;
					} else if (propValue.indexOf(self._cons.REMARK) > -1) {
						self._remarkProperty = propValue;
					} else if (propValue.indexOf(self._cons.DEPICTION) > -1) {
						self._depictionProperty = propValue;
					}
				});
				return false;
			});
			return false;
		});
	},
	
	getWorkId : function() {
		return this._workId;
	},
	
	getFileName : function() {
		return this._fileName;
	},
	
	getNameProperty : function() {
		return this._nameProperty;
	},
	
	getKanaProperty : function() {
		return this._kanaProperty;
	},
	
	getBirthdayProperty : function() {
		return this._birthdayProperty;
	},
	
	getChairProperty : function() {
		return this._chairProperty;
	},
	
	getViceChairProperty : function() {
		return this._viceChairProperty;
	},
	
	getGroupProperty : function() {
		return this._groupProperty;
	},
	
	getPartyProperty : function() {
		return this._partyProperty;
	},
	
	getElectedProperty : function() {
		return this._electedProperty;
	},
	
	getAddressProperty : function() {
		return this._addressProperty;
	},
	
	getPhoneProperty : function() {
		return this._phoneProperty;
	},
	
	getCellPhoneProperty : function() {
		return this._cellPhoneProperty;
	},
	
	getFaxProperty : function() {
		return this._faxProperty;
	},
	
	getEmailProperty : function() {
		return this._emailProperty;
	},
	
	getHomePageProperty : function() {
		return this._homePageProperty;
	},
	
	getRemarkProperty : function() {
		return this._remarkProperty;
	},
	
	getDepictionProperty : function() {
		return this._depictionProperty;
	}
};

YP.info = function() {
	this._init.apply(this, arguments);
};

YP.info.prototype = {
	
	_name : null,
	_birthday : null,
	_kana : null,
	_chair : null,
	_viceChair : null,
	_group : null,
	_perty : null,
	_elected : null,
	_address : null,
	_phone : null,
	_cellPhone : null,
	_fax : null,
	_email : null,
	_home : null,
	_remark : null,
	_depiction : null,
	_init : function() {},
	
	getName : function() {
		if (!this._name) {
			this._name = "";
		}
		return this._name;
	},
	
	setName : function(name) {
		this._name = name;
	},
	
	getKana : function() {
		if (!this._kana) {
			this._kana = "";
		}
		return this._kana;
	},
	
	setKana : function(kana) {
		this._kana = kana;
	},
	
	getBirthday : function() {
		if (!this._birthday) {
			this._birthday = "";
		}
		return this._birthday;
	},
	
	setBirthday : function(birthday) {
		this._birthday = birthday;
	},
	
	getChair : function() {
		if (!this._chair) {
			this._chair = "";
		}
		return this._chair;
	},
	
	setChair : function(chair) {
		this._chair = chair;
	},
	
	getViceChair : function() {
		if (!this._viceChair) {
			this._viceChair = "";
		}
		return this._viceChair;
	},
	
	setViceChair : function(viceChair) {
		this._viceChair = viceChair;
	},
	
	getGroup : function() {
		if (!this._group) {
			this._group = "";
		}
		return this._group;
	},
	
	setGroup : function(group) {
		this._group = group;
	},
	
	getParty : function() {
		if (!this._party) {
			this._party = "";
		}
		return this._party;
	},
	
	setParty : function(party) {
		this._party = party;
	},
	
	getElected : function() {
		if (!this._elected) {
			this._elected = "";
		}
		return this._elected;
	},
	
	setElected : function(elected) {
		this._elected = elected;
	},
	
	getAddress : function() {
		if (!this._address) {
			this._address = "";
		}
		return this._address;
	},
	
	setAddress : function(address) {
		this._address = address;
	},
	
	getPhone : function() {
		if (!this._phone) {
			this._phone = "";
		}
		return this._phone;
	},
	
	setPhone : function(phone) {
		this._phone = phone;
	},
	
	getCellPhone : function() {
		if (!this._cellPhone) {
			this._cellPhone = "";
		}
		return this._cellPhone;
	},
	
	setCellPhone : function(cellPhone) {
		this._cellPhone = cellPhone;
	},
	
	getFax : function() {
		if (!this._fax) {
			this._fax = "";
		}
		return this._fax;
	},
	
	setFax : function(fax) {
		this._fax = fax;
	},
	
	getEmail : function() {
		if (!this._email) {
			this._email = "";
		}
		return this._email;
	},
	
	setEmail : function(email) {
		this._email = email;
	},
	
	getHomePage : function() {
		if (!this._homePage) {
			this._homePage = "";
		}
		return this._homePage;
	},
	
	setHomePage : function(homePage) {
		this._homePage = homePage;
	},
	
	getRemark : function() {
		if (!this._remark) {
			this._remark = "";
		}
		return this._remark;
	},
	
	setRemark : function(remark) {
		this._remark = remark;
	},
	
	getDepiction : function() {
		if (!this._depiction) {
			this._depiction = "http://app.linkdata.org/asset/83089598.png";
		}
		return this._depiction;
	},
	
	setDepiction : function(depiction) {
		this._depiction = depiction;
	}
};

$(document).ready(function() {
	new YP.main();
});
