LocusSelect = function(containerId, options) {
	new Application.highChart(containerId, options);
};

if (Application === "undefined" || !Application) {
	var Application = {};
}

Application.highChart = function() {
	this._init.apply(this, arguments);
};

Application.highChart.prototype = {
	
	_containerId : null,
	_options : null,
	_workId : null,
	_fileName : null,
	_highChartContainerId : null,
	_appProperty : null,
	
	_default : {
		appName : "LocusSelect",
		filterNamespace : "http://linkdata.org/",
		subjectUriPhrase : "http://atted.jp/data/locus/",
		subjectPPDBUriPhrase : "http://ppdb.agr.gifu-u.ac.jp/ppdb/cgi-bin/display.cgi?organism=At&gene=",
		selectSubjectClass : "selectSubject",
		drawArea : "drawArea",
		loadingImageContainer : "loadingImageContainer",
		acceptPropLabelPrefix : "label:",
		loadingImageUrl : "http://app.linkdata.org/asset/67556085.gif",
		databaseInfoClass : "databaseInfo",
		dbInfoLinkClass : "dbInfoLink",
		geneInfoLinkClass : "geneInfoLink",
		geneInfoAttedLinkClass : "geneInfoAttedLink",
		geneInfoPpdbLinkClass : "geneInfoPpdbLink",
		geneInfoEfpLinkClass : "geneInfoEfpLink",
		geneInfoHannaDbLinkClass : "geneInfoHannaDbLink",
		serverUrl : "http://linkdata.org/",
		yAxisLabel : "Gene Expression Level"
	},
	
	_tooltipName : {
		selectProperty : "selectproperty",
		atted2 : "atted-ii",
		hanaDb : "hanadb",
		efp : "efp",
		ppdb : "ppdb",
		replace : "replace",
		manuallyInputMotif : "userinputmotif",
		locusSelect : "locusSelect"
	},
	
	_init : function(containerId, options) {
		this._containerId = containerId;
		this._options = $.extend({}, this._default, options);
		this._workId = this._options.workId;
		this._fileName = this._options.fileName;
		var date = new Date();
		this._highChartContainerId = "high_chart_" + date.getTime();
		this._initToolTip();
		this._initAppProperty(this._options);
		this._initView();
	},
	
	_initToolTip : function() {
		var self = this;
		self._tooltip = (self._options.tooltip) ? self._options.tooltip : new Application.tooltip();
	},
	
	_initAppProperty : function(opts) {
		var obj = {
			workId : opts.workId,
			fileName : opts.fileName
		};
		this._appProperty = new Application.motifProperty(obj);
	},
	
	_initView : function() {
		var self = this;
		var initView = function(subjectList) {
			var sb = [];
			sb[sb.length] = "<div class='row'>";
			sb[sb.length] = "<div class='label left'>Select Locus</div>";
			sb[sb.length] = "<div class='left'>";
			sb[sb.length] = "<select class='" + self._default.selectSubjectClass + "'>";
			sb[sb.length] = "<option value='" + -1 + "'>-- Select Locus --</option>";
			$.each(subjectList, function(subKey, subValue) {
				var label = self._getLabel(subValue);
				sb[sb.length] = "<option value='" + subValue + "'>" + label + "</option>";
			});
			sb[sb.length] = "</select>";
			sb[sb.length] = "</div>";
			sb[sb.length] = "</div>";
			sb[sb.length] = "<div class='" + self._options.databaseInfoClass + " hidden'></div>";
			sb[sb.length] = "<div id='" + self._highChartContainerId + "'></div>";
			sb[sb.length] = "<div class='" + self._options.loadingImageContainer + " hidden' align='center'>";
			sb[sb.length] = "<img src='" + self._options.loadingImageUrl + "'/>";
			sb[sb.length] = "</div>";
			$("#" + self._containerId).html(sb.join(""));
			self._initSelect();
		}
		LinkData.getSubjects(self._workId, self._fileName, initView);
	},
	
	_initSelect : function() {
		var self = this;
		var timer = new Application.timer();
		var initSelect = function() {
			$select = $("#" + self._containerId + " ." + self._default.selectSubjectClass);
			if ($select.length != 0) {
				$select.change(function() {
					$("#" + self._containerId + " ." + self._options.loadingImageContainer).show();
					var subject = $("option:selected", this).val();
					self._drawHighChart(subject);
				});
			} else {
				timer.call(initSelect);
			}
		}
		initSelect();
	},
	
	_ignore : function(label) {
		var self = this;
		if (label.indexOf(self._default.acceptPropLabelPrefix) > -1) {
			return false;
		}
		return true;
	},
	
	_getDisplayLabel : function(value) {
		var self = this;
		var propLabel = value;
		var arr = value.split(self._default.acceptPropLabelPrefix);
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},
	
	_drawHighChart : function(subject) {
		var self = this;
		var getDataArray = function(tripleList) {
			var dataArray = [];
			var dataObject = {};
			var array = [];
			var duplicateProperty = [];
			$.each (tripleList, function(tKey, tValue) {
				var property = tValue.property;
				if (property.indexOf(self._options.filterNamespace) == -1) {
					return;
				}
				if ($.inArray(property, duplicateProperty) > -1) {
					return;
				}
				var label = self._getLabelAfterHash(property);
				if (!self._ignore(label)) {
					array.push(parseFloat(tValue.object));
					duplicateProperty.push(property);
				}
			});
			dataObject.name = self._getLabel(subject);
			dataObject.data = array;
			dataArray.push(dataObject);
			self._getXCategory(tripleList, dataArray);
			self._showDatabaseInfo(subject);
		}
		LinkData.getTriplesBySubject(self._workId, self._fileName, subject, getDataArray);
	},
	
	_getXCategory : function(tripleList, dataArray) {
		var self = this;
		var array = [];
		var duplicateProperty = [];
		$.each (tripleList, function(tKey, tValue) {
			var property = tValue.property;
			if (property.indexOf(self._options.filterNamespace) == -1) {
				return;
			}
			if ($.inArray(property, duplicateProperty) > -1) {
				return;
			}
			var label = self._getLabelAfterHash(property);
			if (!self._ignore(label)) {
				array.push(self._getDisplayLabel(label));
				duplicateProperty.push(property);
			}
		});
		self._drawChart(self._highChartContainerId, dataArray, array);
		$("#" + self._containerId + " ." + self._options.loadingImageContainer).hide();
	},
	
	_drawChart : function(containerId, dataArray, xCategory) {
		var self = this;
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: containerId,
				type: 'line',
				marginRight: 130,
				marginBottom: 125
			},
			title: {
				text: self._fileName
			},
			xAxis: {
				categories: xCategory,
				labels : {
					rotation: 315
				}
			},
			yAxis: {
				title: {
        			text: self._default.yAxisLabel
    			}
			},
			tooltip: {
				formatter: function() {
					return '<b>'+ this.series.name + '</b><br/>' + this.x + ' [' + this.y + ']';
				}
			},
			legend: {
				layout: 'vertical',
				align: 'right',
				verticalAlign: 'top',
				x: -10,
				y: 100,
				borderWidth: 0
			},
			series: dataArray
 		});
	},
	
	_showDatabaseInfo : function(subject) {
		var self = this, fileName = self._options.fileName, appName = self._options.appName;
		var gene = self._getLabel(subject);
		var dbInfoHtml = self._getDatabaseInfo(fileName, appName, gene);
		$("#" + self._containerId + " ." + self._options.databaseInfoClass).html(dbInfoHtml);
		$("#" + self._containerId + " ." + self._options.databaseInfoClass).show();
		self._previewListener(subject, gene);
	},
	
	_previewListener : function(subject, gene) {
		var self = this;
		self._dbPreviewListener();
		self._genePreviewListener(subject);
		self._attedPreviewListener(subject);
		self._ppdbPreviewListener(gene);
		self._efpPreviewListener(gene);
		self._hannaDbPreviewListener(gene);
	},
	
	_dbPreviewListener : function() {
		var self = this;
		var workId = self._options.workId, fileName = self._options.fileName;
		var url = self._options.serverUrl + "work/" + workId + "/" + fileName + ".html#work_information";
		$("#" + self._containerId + " ." + self._options.dbInfoLinkClass).click(function() {
			self._showPopupWindow(url);
		});
	},
	
	_genePreviewListener : function(subject) {
		var self = this;
		$("#" + self._containerId + " ." + self._options.geneInfoLinkClass).click(function() {
			self._showPopupWindow(subject);
		});
	},
	
	_attedPreviewListener : function(subject) {
		var self = this;
		$("#" + self._containerId + " ." + self._options.geneInfoAttedLinkClass).click(function() {
			self._showPopupWindow(subject);
		});
	},
	
	_ppdbPreviewListener : function(gene) {
		var self = this;
		var url = "http://ppdb.agr.gifu-u.ac.jp/ppdb/cgi-bin/display.cgi?organism=At&gene=" + gene.toString().toUpperCase();
		$("#" + self._containerId + " ." + self._options.geneInfoPpdbLinkClass).click(function() {
			self._showPopupWindow(url);
		});
	},
	
	_efpPreviewListener : function(gene) {
		var self = this;
		var url = "http://bbc.botany.utoronto.ca/efp/cgi-bin/efpWeb.cgi?dataSource=Developmental_Map&modeInput=Absolute&primaryGene=" + gene;
		$("#" + self._containerId + " ." + self._options.geneInfoEfpLinkClass).click(function() {
			self._showPopupWindow(url);
		});
	},
	
	_hannaDbPreviewListener : function(gene) {
		var self = this;
		var url = "http://evolver.psc.riken.jp/seiken/GENE/" + gene.toUpperCase() + ".html";
		$("#" + self._containerId + " ." + self._options.geneInfoHannaDbLinkClass).click(function() {
			self._showPopupWindow(url);
		});
	},
	
	_getDatabaseInfo : function(fileName, method, gene) {
		var self = this;
		var sb = [];
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Database</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<span title='" + self._tooltip.getByKey(fileName) + "'>" + fileName + "</span>";
		sb[sb.length] = "<a href='javascript:void(0);' class='externalLink " + self._options.dbInfoLinkClass + "'>LinkData</a>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Tool</div>";
		sb[sb.length] = "<div class='left' title='" + self._tooltip.getByKey(self._tooltipName.locusSelect) + "'>" + method + "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Gene Locus</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<span>" + gene + "</span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Motif Analysis Links</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.atted2) + "' href='javascript:void(0);' class='externalLink " + self._options.geneInfoAttedLinkClass + "'>ATTED-II</a>";
		sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.ppdb) + "' href='javascript:void(0);' class='externalLink " + self._options.geneInfoPpdbLinkClass + "'>PPDB</a>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Gene Expression Visualization Links</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.efp) + "' href='javascript:void(0);' class='externalLink " + self._options.geneInfoEfpLinkClass + "'>eFP</a>";
		sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.hanaDb) + "' href='javascript:void(0);' class='externalLink " + self._options.geneInfoHannaDbLinkClass + "'>HanaDB</a>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		
		return sb.join("");
	},
	
	_showPopupWindow : function(url) {
		var winWidth = 800;
		var winHeight = 800;
		var winLeft = parseInt((screen.availWidth/2) - (winWidth/2));
		var winTop = parseInt((screen.availHeight/2) - (winHeight/2));
		var winStyle = "width=" + winWidth + ",height=" + winHeight + ",left=" + winLeft + ",top=" + winTop + ",screenX=" + winLeft + ",screenY=" + winTop + ",scrollbars=1";
		window.open(url, "Motif", winStyle);
	},
	
	_getLabel : function(value) {
		var self = this, label;
		if (value.indexOf("#") > -1) {
			label = self._getLabelAfterHash(value);
		} else {
			label = self._appProperty.getGeneBySubject(value);
		}
		if (!label) {
			label = value;
		}
		return label;
	},
	
	_getPropertyLabel : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
			propLabel = this._appProperty.getPropertyNameByLabel(propLabel);
		}
		return propLabel;
	},
	
	_getLabelAfterHash : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	}
	
};

Application.motifProperty = function() {
	this._init.apply(this, arguments);
};

Application.motifProperty.prototype = {

	_options : null,
	_propMap : null,
	_nameMap : null,
	_optionArray : null,
	
	_default : {
		acceptPropLabelPrefix : "label:",
		subjectATTEDUriPhrase : "http://atted.jp/data/locus/",
		subjectPPDBUriPhrase : "http://ppdb.agr.gifu-u.ac.jp/ppdb/cgi-bin/display.cgi?organism=At&gene="
	},
	
	_init : function(options) {
		this._options = $.extend({}, this._default, options);
		this._propMap = [];
		this._nameMap = [];
		this._initPropMap(this._options);
	},
	
	_initPropMap : function(opts) {
		var self = this, workId = opts.workId, fileName = opts.fileName;
		var method = function(properties) {
			self._fillPropMap(self, properties);
			self._initOptionArray(properties);
		}
		LinkData.getProperties(workId, fileName, method);
	},
	
	_fillPropMap : function(self, properties) {
		$.each(properties, function(key, value) {
			var label = self._getLabel(value);
			if (!self._propMap[label]) {
				self._propMap[label] = value;
			}
		});
	},
	
	_initOptionArray : function(propertyList) {
		var self = this, list = new Object();
		var workId = self._options.workId, fileName = self._options.fileName;
		self._optionArray = [];
		$.each(propertyList, function(key, value) {
			var propLabel = self._getLabel(value);
			if (!self._ignore(propLabel)) {
				var obj = {};
				obj.key = propLabel;
				obj.value = self._getDisplayLabel(propLabel);
				self._optionArray.push(obj);
			}
		});
	},
	
	_ignore : function(label) {
		var self = this;
		if (label.indexOf(self._default.acceptPropLabelPrefix) > -1) {
			return false;
		}
		return true;
	},
	
	_getDisplayLabel : function(value) {
		var self = this;
		var propLabel = value;
		var arr = value.split(self._default.acceptPropLabelPrefix);
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},
	
	_getLabel : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},

	getOptionArray : function() {
		return this._optionArray;
	},
	
	getPropertyByLabel : function(label) {
		return this._propMap[label];
	},
	
	getGeneBySubject : function(subject) {
		var self = this, htmlExt = ".html", geneLabel;
		if (subject.indexOf(self._default.subjectATTEDUriPhrase) > -1) {
			geneLabel = subject.replace(self._default.subjectATTEDUriPhrase, "");
		} else if (subject.indexOf(self._default.subjectPPDBUriPhrase) > -1) {
			geneLabel = subject.replace(self._default.subjectPPDBUriPhrase, "");
		}
		if (geneLabel && geneLabel.indexOf(htmlExt) > -1) {
			geneLabel = geneLabel.replace(htmlExt, "");
		}
		return geneLabel;
	}
	
};

Application.timer = function() {
	this._init.apply(this, arguments);
};

Application.timer.prototype = {
	
	_delay : null,
	_retry : null,
	_maxRetry : null,
	
	_init : function() {
		this._delay = 1000;
		this._retry = 0;
		this._maxRetry = 1000;
	},
	
	call : function(func) {
		if (this._retry < this._maxRetry) {
			setTimeout(func, this._delay);
		}
		this._retry++;
	},
	
	setMaxRetryCount : function(no) {
		this._maxRetry = no;
	}
};

Application.tooltip = function() {
	this._init.apply(this, arguments);
};

Application.tooltip.prototype = {
	
	_toolTipList : null,
	
	_default : {
		explanationProperty : "explanation"
	},
	
	_init : function() {
		this._toolTipList = [];
		this._initToolTip();
	},
	
	_initToolTip : function() {
		var self = this;
		var getFilesByTag = function(resultList) {
			$.each(resultList, function(workId, fileList) {
				$.each(fileList, function(fileKey, fileName) {
					self._getFilePropertyList(workId, fileName);
					return false;
				});
			});
		}
		LinkData.getFilesByTag(null, "tooltip", getFilesByTag);
	},
	
	_getFilePropertyList : function(workId, fileName) {
		var self = this;
		var index = new Application.index(1, 10000);
		var getProperties = function(propertyList) {
			$.each(propertyList, function(pKey, pValue) {
				if (pValue.indexOf(self._default.explanationProperty) > -1) {
					self._getSubjectList(workId, fileName, pValue, index);
					return false;
				}
			});
		}
		LinkData.getProperties(workId, fileName, getProperties);
	},
	
	_getSubjectList : function(workId, fileName, property, index) {
		var self = this;
		var getSubjects = function(subjectList) {
			self._getPropertyList(subjectList, workId, fileName, property, index);
		}
		LinkData.getSubjects(workId, fileName, getSubjects, index);
	},
	
	_getPropertyList : function(subjectList, workId, fileName, property, index) {
		var self = this;
		var getTriplesByProperty = function(tripleList) {
			self._addToolTipToList(subjectList, tripleList, workId, fileName, property, index);
		}
		LinkData.getTriplesByProperty(workId, fileName, property, getTriplesByProperty, index);
	},
	
	_addToolTipToList : function(subjectList, tripleList, workId, fileName, property, index) {
		var self = this;
		for (var i = 0; i < subjectList.length; i++) {
			var key = self._getLabelAfterHash(subjectList[i]);
			var value = tripleList[i].object;
			self._addToolTip(key, value);
		}
		if (subjectList && subjectList.length == index.getItemCount()) {
			self._getSubjectList(workId, fileName, property, index.increment());
		}
	},
	
	_addToolTip : function(key, tooltip) {
		var obj = {};
		obj.key = key;
		obj.tooltip = tooltip;
		this._toolTipList.push(obj);
	},
	
	getByKey : function(key) {
		var self = this, tooltip;
		$.each(self._toolTipList, function(objKey, obj) {
			if (obj.key === key) {
				tooltip = obj.tooltip;
				return false;
			}
		});
		return (tooltip) ? tooltip : "";
	},
	
	_getLabelAfterHash : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	}
	
};

$(document).ready(function(){
	var fillDatabase = function(resultList) {
		$(".highChartDatabase").append("<option value='-1' selected='selected'>-- Select Database --</option>");
		$.each(resultList, function(workId, fileList) {
			$.each(fileList, function(fileKey, fileName) {
				$(".highChartDatabase").append("<option value='" + workId + "|" + fileName + "'>" + fileName + "</option>");
			});
		});
		$(".highChartDatabase").change(function() {
			var dbKey = $("option:selected", $(this)).val();
			if (dbKey == -1) {
				$("#container").html("");
				return;
			}
			var array = dbKey.split("|");
			var containerId = "container";
			var options = {
				workId : array[0],
				fileName : array[1],
				baseSequence : "GAAAAAAGACGTTCCAACCACGTCTTCAAAGCAAGTGATTGGATTAAGGTTCTTCCACACGGTAAGGGATGGCACTAACACCTACCATCCTTCGCAAGACCCTTCCTCTATATAAGGAAGTTCATTTCATTTGGAGAGGACCTCGAC"
			};
			new Application.highChart(containerId, options);
		});
	}
	LinkData.getFilesByTag(null, "database", fillDatabase);
});
