if (Application === "undefined" || !Application) {
	var Application = {};
}

ManualInputMotif = function(containerId, options) {
	new Application.ManualInputMotif(containerId, options);
};

Application.ManualInputMotif = function() {
	this._init.apply(this, arguments);
};

Application.ManualInputMotif.prototype = {
	
	_manulaMotifInputAreaId : null,
	_manulaMotifInputAreaInsertButId : null,
	_manulaMotifInputAreaAddButId : null,
	_manulaMotifDialogCancelButId : null,
	_containerId : null,
	_baseSequence : null,
	_workId : null,
	_fileName : null,
	_errorMessageAreaClass : null,
	_motifProperty : null,
	_geneInfoContainerId : null,
	_callBackFunc : null,
	_motifView : null,
	_appSequence : null,
	//_manualMotifErrorDialogId : null,
	_appUtil : null,
	
	defaults : {
		motifSequenceProperty : "motif sequence",
		motifPositionProperty : "motif position",
		replaceSequenceClass : "replaceSequence",
		resultAreaClass : "resultArea",
		databaseInfoClass : "databaseInfo",
		errorMessageAreaClass : "errorMessage",
		replaceButtonAreaClass : "replaceButtonArea",
		geneLabelClass : "geneUrl",
		baseSequenceLength : 550,
		baseSequenceMinLength : 50
	},
	
	_initDefaults : function() {
		var date = new Date();
		this._manulaMotifInputAreaId = "_manulaMotifMotif_Div_" + self._containerId + "_" + date.getTime();
		this._manulaMotifInputAreaInsertButId = "_manulaMotifMotif_Div_Insert_But_" + this._containerId;
		this._manulaMotifInputAreaAddButId = "_manulaMotifMotif_Div_Add_But_" + this._containerId;
		//this._manulaMotifDialogCancelButId = "_manulaMotifMotif_Div_Cancel_But+" + this._containerId;
		//this._manualMotifErrorDialogId = "_manulaMotifMotif_Err_Dialog_" + this._containerId;
	},
	
	_initMotifView : function() {
		var self = this;
		var obj = {
			baseSequenceMinLength : self.defaults.baseSequenceMinLength,
			baseSequence : self._baseSequence,
			replaceSequenceClass : self.defaults.replaceSequenceClass,
			callerObj : self,
			geneLabelClass : self.defaults.geneLabelClass
		};
		 this._motifView = new Application.MotifView(this._containerId,obj);
	},
	
	_initAppUtil : function() {
		var self = this;
		var obj = {
			containerId : self._containerId,
			errTextClass : 'errorText',
			baseSequenceMinLength : self.defaults.baseSequenceMinLength,
			baseSequenceLength : self.defaults.baseSequenceLength
		}
		self._appUtil = new Application.Util(obj);
	},
	
	_init : function(containerId, options) {
		var date = new Date();
		this._containerId = containerId;
		this._baseSequence = options.baseSequence;
		this._workId = options.workId;
		this._fileName = options.fileName;
		this._callBackFunc = options.callback;
		this._geneInfoContainerId = "gene_info_containerId_" + date.getTime();
		//this._errorMessageAreaClass = options.errorMessageAreaClass;
		//this._baseSequenceMinLength = options.baseSequenceMinLength;
		this._initDefaults();
		$("#" + this._containerId).html("");	
		this._initManualMotifComps();
		this._initManualMotifCompButtons();
		this._initConflictConfirmDialogView();
		this._initMotifConflictConfirmDialog();
		var obj = {
			workId : options.workId,
			fileName : options.fileName,
		};
		this._initMotifProperty(obj);
		this._initAppSequence(obj);
		this._initRelatedViews();
		this._initManualMotifInsertButtonListner();
		//this._initMotifView();
		this._initEventsHandlersForManualMotifEntryComps();
		//this._initManualMotifInitErrDialogView();
		//this._initManualMotifErrorDialog();
		this._initAppUtil();
	},
	
	_initManualMotifComps : function() {
		var sb = [], self = this; 
		sb[sb.length] = "<div id='" + this._manulaMotifInputAreaId + "' class='manualMotifView'>";
		//sb[sb.length] = "<div style='float:left'>";
		//sb[sb.length] = "<fieldset class='motifViewDialog'>";
		//sb[sb.length] = "<legend>InputMotif Tool</legend>";
		sb[sb.length] = "<div><h3>Manually enter your own motif and set the center position</h3></div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left' style='width:150px'>Motif Sequence</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<input type='text' class='anotherSequence'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left' style='width:150px'>Motif Center Position</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<input type='text' class='anotherPosition'/>";
		sb[sb.length] = "</div>";
		//sb[sb.length] = "</div>";
		//sb[sb.length] = "</fieldset>";
		sb[sb.length] = "</div>";

		sb[sb.length] = "<fieldset class='manualMotifViewInfo'>";
		sb[sb.length] = "<span> User input Motif Length : </span><span class='motiflength'>0</span></br>";
		sb[sb.length] = "</br>";
		sb[sb.length] = "<span> Acceptable center position range : </span><span class='centerposrange'>0 to 0</span></br>";
		sb[sb.length] = "</fieldset>";
		//sb[sb.length] = "<div class='"+ this.defaults.errorMessageAreaClass +"' hidden'></div>";
		
		$("#" + this._containerId).append(sb.join(""));
	},
	
	_initRelatedViews : function() {
		var self = this;
		var sb = [];
		sb[sb.length] = "<div class='" + self.defaults.databaseInfoClass + " hidden'></div>";
		sb[sb.length] = "<div id='" + self._geneInfoContainerId + "'></div>";
		sb[sb.length] = "<div class='" + self.defaults.resultAreaClass + " hidden'></div>";
		sb[sb.length] = "<div class='" + self.defaults.errorMessageAreaClass + " hidden'>error</div>";
		sb[sb.length] = "<div class='" + self.defaults.replaceButtonAreaClass + " hidden'>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='addbuttoncontainer'></div>";
		sb[sb.length] = "<div class='" + self.defaults.replaceSequenceClass + " hidden'></div>";
		//sb[sb.length] = "<div class='" + self._options.loadingImageContainer + " hidden' align='center'>";
		//sb[sb.length] = "<div class='" + self._options.loadingMessageClass + "'>" + self._options.loadingMessage + "</div>";
		//sb[sb.length] = "<div>";
		//sb[sb.length] = "<img src='" + self._options.loadingImageUrl + "'/>";
		//sb[sb.length] = "</div>";
		//sb[sb.length] = "</div>";
		$("#" + this._containerId).append(sb.join(""));
	},
	
	/*
	_initManualMotifInitErrDialogView : function() {
		var sb = [];
		sb[sb.length] = "<div id='"+ this._manualMotifErrorDialogId +"' class='hidden'>";
		sb[sb.length] = "<div>Following error found while trying to add the manual motif</div>";
		sb[sb.length] = "<ul class='motiferror'></ul>";
		sb[sb.length] = "</br>";
		sb[sb.length] = "<div>Would you like to correct it automatically ?</div>";
		sb[sb.length] = "</div>";
		$("#" + this._containerId).append(sb.join(""));
	},*/
	
	_initManualMotifCompButtons : function() {
		var sb = [];
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "</br>";
		sb[sb.length] = "<a id='"+ this._manulaMotifInputAreaInsertButId +"' class='btn btn-lightblue'>Insert Motif</a>&nbsp;";
		sb[sb.length] = "</div>";
		$("#" + this._containerId).append(sb.join(""));
	},
	
	_initManualMotifAddCancelButtons : function() {
		var sb = [];
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<a id='"+ this._manulaMotifInputAreaAddButId +"' class='btn btn-lightblue'>Add Motif(s)</a>&nbsp;";
		//sb[sb.length] = "<a id='"+ this._manulaMotifInputAreaCancelButId +"' class='btn btn-lightblue'>Cancel this operation</a>";
		sb[sb.length] = "</div>";
		$("#" + this._containerId + " .addbuttoncontainer").append(sb.join(""));
		this._initManualMotifAddButtonListner();
		//this._initManualMotifCancelButtonListner();
	},
	
	_initConflictConfirmDialogView : function() {
		var sb = [], self = this, date = new Date(); 
		self._motifConflictConfirmDialogId = "motifConflictConfirmDialog_id_" + self._containerId + "_" + date.getTime();
		sb[sb.length] = "<div id='" + self._motifConflictConfirmDialogId + "' class='hidden'>";
		sb[sb.length] = "<div>New motif overlaps with old one. Which one should be kept in overalp regions?</div>";
		sb[sb.length] = "<div class='option'>";
		sb[sb.length] = "<div><label><input type='radio' name='motifReplaceOption' value='new'/>&nbsp;New</label></div>";
		sb[sb.length] = "<div><label><input type='radio' name='motifReplaceOption' value='old'/>&nbsp;Old</label></div>";
		sb[sb.length] = "<div><label><input type='radio' name='motifReplaceOption' value='discard'/>&nbsp;Discard new motif</label></div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<label><input type='checkbox' checked='checked' class='motifReplaceApplyToAllMotifMin' value='applytoall'/>&nbsp;Apply to all</label>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		$("#" + this._containerId).append(sb.join(""));
	},
	
	_initAppSequence : function(opts) {
		var self = this;
		var timer = new Application.timer();
		var init = function() {
			var seqProperty = self._motifProperty.getPropertyByLabel(self.defaults.motifSequenceProperty);
			var posProperty = self._motifProperty.getPropertyByLabel(self.defaults.motifPositionProperty);
			if (seqProperty && posProperty) {
				var obj = {
					workId : opts.workId,
					fileName : opts.fileName,
					baseSequence : self._baseSequence,
					motifSequenceProperty : seqProperty,
					motifPositionProperty : posProperty,
					containerId : self._containerId,
					errorMessageClass : self._errorMessageAreaClass,
					baseSequenceMinLength : self.defaults.baseSequenceMinLength
				};
				self._appSequence = new Application.sequence(obj);
				self._initMotifView();
			} else {
				timer.call(init);
			}
		}
		init();
	},
	
	_initManualMotifInsertButtonListner : function() {
		var self = this;
		$("#" + this._manulaMotifInputAreaInsertButId).click(function() {
			var seq = $("#" + self._manulaMotifInputAreaId + " input.anotherSequence").val();
			var pos = Math.abs($("#" + self._manulaMotifInputAreaId + " input.anotherPosition").val());
			if (seq && pos) {
				self._addAnotherMotif(seq, pos);
			}
		});
	},
	
	_initManualMotifAddButtonListner : function() {
		var self = this;
		$("#" + this._manulaMotifInputAreaAddButId).click(function() {
			var seqs = [], nonConflictSeqs = [], seqArray = [], posArray = [], conflictArray = [];
			$("#" + self._containerId + " .userSequence").each(function() {
				seqs.push($(this).text());
				var seq = $(this).find(".hdnSequence").val();
				var pos = $(this).find(".hdnPosition").val();
				seqArray.push(seq);
				posArray.push(pos);
				if (self._hasConfliction(seq, pos)) {
					conflictArray.push(seq + "|" + pos);
				} else {
					nonConflictSeqs.push($(this).text());
				}
			});
			$("#" + self._containerId + " ." + self.defaults.replaceSequenceClass).html("");
			$("#" + self._containerId + " ." + self.defaults.replaceSequenceClass).hide();
			if (conflictArray.length > 0) {
				self._doReplace(nonConflictSeqs, seqArray, posArray);
				self._handleConfliction(conflictArray);
			} else {
				self._doReplace(seqs, seqArray, posArray);
			}
		});
	},
	
	_initEventsHandlersForManualMotifEntryComps : function() {
		var self = this;
		$("#" + self._manulaMotifInputAreaId + " .anotherSequence").keyup(function() {
			var posItion = self._appUtil.getCalculatedMotifInsertRange($(this).val().length);
			$("#" + self._manulaMotifInputAreaId + " .motiflength").html($(this).val().length);
			$("#" + self._manulaMotifInputAreaId + " .centerposrange").html("- " + posItion.startPoint + " to - " + posItion.endPoint);
		});
	},
	
	
	
	_doReplace : function(seqs, seqArray, posArray) {
		var self = this;
		var html = self._appSequence.replace(seqs, seqArray, posArray);
		self._doReplaceWithHtml(html);
	},
	
	/*
	_initManualMotifCancelButtonListner : function() {
		var self = this;
		$("#" + this._manulaMotifInputAreaCancelButId).click(function() {
			
			
		});
	},*/
	
	_initMotifProperty : function(opts) {
		var obj = {
			workId : opts.workId,
			fileName : opts.fileName
		};
		this._motifProperty = new Application.motifProperty(obj);
	},
	
	_initMotifConflictConfirmDialog : function() {
		var self = this;
		$("#" + self._motifConflictConfirmDialogId).dialog({
			autoOpen: false,
			width: 420,
			dialogClass : "motifConflictionDialog"
		});
	},
	/*
	_initManualMotifErrorDialog : function() {
		var self = this;
		$("#" + self._manualMotifErrorDialogId).dialog({
			autoOpen: false,
			width: 600,
			model: true
		});
	},*/
	
	_addAnotherMotif : function(seq, pos) {
		var self = this;
		var position = self._appUtil._validateManulMotifCenterPosition(seq.length,pos);
		
		if (Math.abs(pos) != position) {
			self._appUtil._showMotifErrorDialog(position,$("#" + self._manulaMotifInputAreaId + " input.anotherPosition"));
		} else {
			$("#" + self._manulaMotifInputAreaId + " input.anotherPosition").val("-" + Math.abs(pos));
			self._drawManualSequnce(seq, pos);
			if ($("#" + this._manulaMotifInputAreaAddButId).length == 0) {
				self._initManualMotifAddCancelButtons();
			}
		}
		
		/*
		self._createResultAreaIfNotExists
		var oldSequence = $("#" + self._containerId + " ." + self.defaults.replaceSequenceClass).text();
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self.defaults.resultAreaClass + " .baseSequence").html();
		}
		if (self._hasConfliction(seq, pos, oldSequence)) {
			conflictArray.push(seq + "|" + pos);
		}
		if (conflictArray.length > 0) {
			self._handleConfliction(conflictArray);
		} else {
			self._replaceSequenceByOption("new", seq, pos);
		}*/
	},
	
	_createResultAreaIfNotExists : function() {
		var div = $("#" + this._containerId + " ." + this.defaults.resultAreaClass);
		if (div.length == 0) {
			var resultArea = "<div class='" + this.replaceSequenceClass + " hidden'></div>";
			$("#" + this._containerId).append(resultArea);
		}
	},
	
	_handleConfliction : function(conflictArray) {
		var self = this;
		if (conflictArray.length > 0) {
			var arr = conflictArray[0].split("|");
			var bArray = self._getConflictConfirmDialogButtonArray(conflictArray);
			var dialogTitle =  this.defaults.conflictionDialogTitle + " - " +  arr[0] + "[" + arr[1] + "]";
			$("#" + self._motifConflictConfirmDialogId).find("input[name='motifReplaceOption'][value='new']").attr("checked", "checked");
			var checkBox = $("#" + self._motifConflictConfirmDialogId).find("input[class='motifReplaceApplyToAllMotifMax']");
			$(checkBox).attr("checked",$(checkBox).is(':checked'));
			//$("#" + self._motifConflictConfirmDialogId).find(".motifReplaceApplyToAll").attr("checked", "checked");
			$("#" + self._motifConflictConfirmDialogId).dialog({title : dialogTitle});
			$("#" + self._motifConflictConfirmDialogId).dialog({buttons : bArray});
			$("#" + self._motifConflictConfirmDialogId).dialog("open");
		} else {
			$("#" + self._motifConflictConfirmDialogId).find("input[class='motifReplaceApplyToAllMotifMax']").attr("checked", "checked");	
		}
	},
	
	_getConflictConfirmDialogButtonArray : function(conflictArray) {
		var self = this;
		return [
				{
					text: "Done",
					click : function() {
						$(this).dialog("close");
						var option = $(this).find("input[name='motifReplaceOption']:checked").val();
						var isApplyToAll = $(this).find(".motifReplaceApplyToAll").is(":checked");
						self._replaceWithOption(option, isApplyToAll, conflictArray);
					}
				},
				{
					text: "Cancel",
					click : function() {
						$(this).dialog("close");
					}
				}
			];
	},

	_replaceWithOption : function(option, isApplyToAll, conflictArray) {
		var self = this;
		if (isApplyToAll) {
			self._replaceAllWithOption(option, conflictArray);
			$("#" + self._motifConflictConfirmDialogId).find(".motifReplaceApplyToAll").attr("checked", "checked");
		} else {
			var value = conflictArray.splice(0, 1);
			var arr = value[0].split("|");
			self._replaceSequenceByOption(option, arr[0], arr[1]);
			self._handleConfliction(conflictArray);
		}
	},
	
	_replaceAllWithOption : function(option, conflictArray) {
		var self = this, html = oldSequence;
		var oldSequence = $("#" + self._containerId + " ." + self.defaults.replaceSequenceClass).text();
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self.defaults.resultAreaClass + " .baseSequence").html();
		}
		$.each(conflictArray, function(key, conflict) {
			var arr = conflict.split("|");
			self._replaceSequenceByOption(option, arr[0], arr[1]);
		});
	},
	
	_replaceSequenceByOption : function(option, seq, pos) {
		var self = this;
		var oldSequence = $("#" + self._containerId + " ." + self.defaults.replaceSequenceClass).text();
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self.defaults.resultAreaClass + " .baseSequence").html();
		}
		if (!oldSequence) {
			oldSequence = self._baseSequence;
		}
		var formattedSeq = self._appSequence.getFormattedSequence(self.defaults.baseSequenceLength, seq, pos);
		var seqArray = [formattedSeq];
		var newSequence = self._appSequence._getMergeCharSequence(seqArray);
		var html = oldSequence;
		if (option === "new") {
			html = self._appSequence.getHtmlByReplacingNewSequence(oldSequence, newSequence);
		} else if (option === "old") {
			html = self._appSequence.getHtmlByReplacingOldSequence(oldSequence, newSequence);
		}
		self._doReplaceWithHtml(html);
	},
	
	_hasConfliction : function(seq, pos, oldSequence) {
		var self = this;
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self.defaults.resultAreaClass + " .baseSequence").html();
		}
		if (!oldSequence) {
			oldSequence = self._baseSequence;
		}
		var formattedSeq = self._appSequence.getFormattedSequence(self.defaults.baseSequenceLength, seq, pos);
		var array = [formattedSeq];
		var newSequence = self._appSequence._getMergeCharSequence(array);
		for (var i = 0; i < oldSequence.length; i++) {
			var oChar = oldSequence.charAt(i);
			var nChar = newSequence.charAt(i);
			if (nChar !== "-" && oChar !== "-" && nChar !== oChar) {
				return true;
			}
		}
		return false;
	},
	
	_doReplaceWithHtml : function(html) {
		var self = this, sb = [];
		//var subject = $("#" + self._containerId + " ." + self._options.geneLabelClass).val();
		//var gene = self._motifProperty.getGeneBySubject(subject);
		//var geneType = self._getGeneType();
		sb[sb.length] = html;
		//sb[sb.length] = "<input type='hidden' class='gene' value='" + gene + "'/>";
		//sb[sb.length] = "<input type='hidden' class='geneType' value='" + geneType + "'/>";
		//self._appSequence.hideError();
		$("#" + self._containerId + " ." + self.defaults.replaceSequenceClass).show();
		$("#" + self._containerId + " ." + self.defaults.replaceSequenceClass).html(sb.join(""));
		$("#" + self._containerId + " ." + self.defaults.replaceSequenceClass).scrollLeft(10000);
		//self._showDataBaseInformationList();
		this._callBackFunc();
	},
	
	_drawManualSequnce : function(sequnce, position) {
		var self = this, sb = [];
		if (!sequnce) {
			return;
		}
		var customSeqString = self._appSequence._getCustomSequenceHtml(self._baseSequence, sequnce, position);
		if (customSeqString.length > 0) {
			sb.push("<div class='userSequence'>" + customSeqString + "</div>");
			sb.push("&nbsp;<span class='deletelink "+ sequnce +"' onclick='self._deleteUserSequence("+ "&quot;" + sequnce + "&quot;" +","+ "&quot;" + self._containerId + "&quot;" +");'>");
			sb.push("<img src='http://app.linkdata.org/asset/c6bf2a0f.png' title='Delete' /></span>");
			sb.push("<div>&nbsp;</div>");
		}
		
		self.drawSequence(sb.join("\n"));
	},
	/*
	_getCustomSequenceHtml : function(baseSequence, sequence, position) {
		var self = this;
		var seqLen = sequence.length;
		var tHold = Math.floor(seqLen / 2);
		var pos = parseInt(position);
		var baseSeqLen = baseSequence.length;
		var suffixLen = baseSeqLen - (tHold + pos);
		var motifCorectedStartingPoint = position - (seqLen / 2);
		
		var sb = [];
		if (motifCorectedStartingPoint > this.defaults.baseSequenceMinLength && suffixLen > 0) {
			for (var i = 0; i < suffixLen; i++) {
				sb.push(self.defaults.CHAR_SEQ_EMPTY);
			}
			sb.push("<a href='javascript:void(0)' class='motifSequence'>" + sequence + "</a>");
			sb.push("<input type='hidden' class='hdnSequence' value='" + sequence + "'/>");
			sb.push("<input type='hidden' class='hdnPosition' value='" + pos + "'/>");
			sb.push("<input type='hidden' class='hdnCorPosition' value='-" + position + "'/>");
		} else {
			//_showError($appContainer, opts.msgOutOfRangeSequence.replace("{0}", sequence));
			this._outOfRangeArray.push(sequence + "[-" + position + "]");
			this._showError(this._default.msgOutOfRangeSequence.replace("{0}", this._outOfRangeArray.join(", ")));
		}
		return sb.join("");
	},
	*/
	drawSequence : function(seqHtml) {
		var sb = [], self = this;
		sb[sb.length] = "<input type='hidden' class='" + self.defaults.geneLabelClass + "' value=''/>";
		sb[sb.length] = "<div class='baseSequence'>" + self._baseSequence + "</div>";
		sb[sb.length] = seqHtml;
		$("#" + self._containerId + " ." + self.defaults.resultAreaClass).html(sb.join(""));
		//if (seqHtml.length == 0) {
		//	$("#" + self._containerId + " ." + self._options.replaceButtonAreaClass).hide();
		//}
		self._motifView._initMotifSequenceListener();
		//self._initReplaceButtonLitener();
		//self._showDataBaseInformationList();
		//self._showGenePlot(subject, property);
		$("#" + self._containerId + " ." + self.defaults.resultAreaClass).show();
		$("#" + self._containerId + " ." + self.defaults.resultAreaClass).scrollLeft(10000);
		//$("#" + self._containerId + " ." + self._options.replaceButtonAreaClass).show();
		//$("#" + self._containerId + " ." + self._options.loadingImageContainer).hide();
	},
	
	_showPopupWindow : function(url) {
		var winWidth = 800;
		var winHeight = 800;
		var winLeft = parseInt((screen.availWidth/2) - (winWidth/2));
		var winTop = parseInt((screen.availHeight/2) - (winHeight/2));
		var winStyle = "width=" + winWidth + ",height=" + winHeight + ",left=" + winLeft + ",top=" + winTop + ",screenX=" + winLeft + ",screenY=" + winTop + ",scrollbars=1";
		window.open(url, "Motif", winStyle);
	}
}

Application.Util = function() {
	this._init.apply(this, arguments);		
}

Application.Util.prototype = {
	
	_containerId : null,
	_errTextClass : null,
	_manualMotifErrorDialogId : null,
	_baseSequenceMinLength : null,
	_baseSequenceLength : null,
	
	_init : function(args) {
		this._containerId = args.containerId;
		this._errTextClass = args.errTextClass;
		this._baseSequenceMinLength = args.baseSequenceMinLength;
		this._baseSequenceLength = args.baseSequenceLength;
		
		this._motifErrorDialogId = "_manulaMotifMotif_Err_Dialog_" + this._containerId;
		this._initMotifInitErrDialogView();
		this._initMotifErrorDialog();
	},
	
	_initMotifInitErrDialogView : function() {
		var sb = [];
		sb[sb.length] = "<div id='"+ this._motifErrorDialogId +"' class='hidden'>";
		sb[sb.length] = "<div>Following error(s) found while trying to add the add/place the motif</div>";
		sb[sb.length] = "<ul class='motiferror'></ul>";
		sb[sb.length] = "</br>";
		sb[sb.length] = "<div>Would you like to correct it automatically ?</div>";
		sb[sb.length] = "</div>";
		$("#" + this._containerId).append(sb.join(""));
	},

	_initMotifErrorDialog : function() {
		var self = this;
		$("#" + self._motifErrorDialogId).dialog({
			autoOpen: false,
			width: 600,
			model: true
		});
	},
	
	_validateManulMotifCenterPosition : function(sequnceLength,position) {
		if (sequnceLength > 0) {
			$("#" + this._motifErrorDialogId + " .motiferror").html("");
			var corProsition = this.getCalculatedMotifInsertRange(sequnceLength);
			position = Math.abs(position);
			if ((position < corProsition.startPoint) || (position > corProsition.endPoint)) {
				position = corProsition.startPoint;
				this._putManulMotifError("Defined position is out of range. So assigned the default postion as -" + position);
			}	
			var val = sequnceLength % 2;
			position = Math.abs(position);
			var havingDecimalEntry = (position.toString().indexOf(".") != -1) ? true : false;
			if (val > 0) {
				// odd length case
				if (havingDecimalEntry == true) {
					position = position.toString().split(".")[0];
					this._putManulMotifError("Since the sequnce lenght is an odd no, the correct postion should be - " + position);
				}
			} else {
				//even length case
				if (havingDecimalEntry == false) {
					position = position + 0.5;
					this._putManulMotifError("Since the sequnce lenght is an even no, the correct postion should be - " + position);
				}else {
					var decPart = position.toString().split(".")[1];
					if (decPart != "5") {
						position = position.toString().split(".")[0] + ".5";
						this._putManulMotifError("The sequnce lenght is an odd no. For odd lengths, the correct postion should be - " + position);
					}
				}
			}
		}
		return position;
	},
	
	_putManulMotifError : function(errInfo) {
		var errText = $("#" + this._motifErrorDialogId + " .motiferror");
		var content = errText.html();
		errText.html(content + "</br>" + "<li><span class='"+ this._errTextClass +"'>" + errInfo + "</span></li>");
	},
	
	getCalculatedMotifInsertRange : function(sequnceLength) {
		var centerPos = Math.floor(sequnceLength / 2);
		var corStartPoint = this._baseSequenceMinLength + centerPos;
		var corEndPoint = this._baseSequenceLength - centerPos;
		if (this.isValueEven(sequnceLength) == false) {
			corStartPoint = corStartPoint + 1;
		} else {
			corStartPoint = corStartPoint + 0.5;
			corEndPoint = corEndPoint + 0.5;
		}
		var obj = {
			startPoint : corStartPoint,
			endPoint : corEndPoint
		};
		return obj;
	},
	
	isValueEven : function(val) {
		var val = val % 2;
		if (val > 0) {
			return false;	
		} else {
			return true;
		}
	},
	
	_getMotifEntryErrButtonArray : function(correctPos,textEleRef) {
		var self = this;
		return [
				{
					text: "Yes",
					click : function() {
						$(textEleRef).val("-" + Math.abs(correctPos));
						$(this).dialog("close");
					}
				},
				{
					text: "No",
					click : function() {
						$(this).dialog("close");
					}
				}
			];
	},
	
	_showMotifErrorDialog : function(corectedPos,textEleRef) {
		var bArray = this._getMotifEntryErrButtonArray(corectedPos,textEleRef);
		var dialogTitle =  "Motif Insert/Place Errors";
		$("#" + this._motifErrorDialogId).dialog({title : dialogTitle});
		$("#" + this._motifErrorDialogId).dialog({buttons : bArray});
		$("#" + this._motifErrorDialogId).dialog("open");
	}
};
	
Application.MotifView = function() {
	this._init.apply(this, arguments);		
}

Application.MotifView.prototype = {
	
	_containerId : null,
	_motifViewAreaId : null,	
	_baseSequenceMinLength : null,
	_baseSequence : null,
	_replaceSequenceClass : null,
	_callerObj : null,
	_geneLabelClass : null,
	_motifViewErrDlgId : null,
	_appUtil : null,
	
	_init : function(containerId,args) {
		date = new Date(); 
		this._containerId = containerId;
		this._baseSequenceMinLength = args.baseSequenceMinLength;
		this._baseSequence = args.baseSequence;
		this._replaceSequenceClass = args.replaceSequenceClass;
		this._callerObj = args.callerObj;
		this._geneLabelClass = args.geneLabelClass;
		this._motifViewAreaId = "motifViewDialog_id_" + this._containerId + "_" + date.getTime();
		this._motifViewErrDlgId = "motifViewErrDlg_Id_" + this._containerId + "_" + date.getTime();
		//this._initMotivViewErrDialogView();
		//this._initMotivViewErrDialog();
		this._initAppUtil();
	},
	
	defaults : {
		dialogErrorMessageClass : 'dialogErrorMessage',
		dialogOutRangeValueMessage : "Please input a value between {0} and {1}",
		geneLabelClass : "geneUrl"
	},
	
	/*
	_initMotivViewErrDialogView : function() {
		var sb = [];
		sb[sb.length] = "<div id='"+ this._motifViewErrDlgId +"' class='hidden'>";
		sb[sb.length] = "<div class='errinfo'></div>";
		sb[sb.length] = "</div>";
		$("#" + this._containerId).append(sb.join(""));
	},*/
	/*
	_initMotivViewErrDialog : function() {
		$("#" + this._motifViewErrDlgId).dialog({
			resizable: false,
      		modal: true,
			autoOpen: false,
			title: 'Invalid Motif Position'
		});	
		var buttons = [
				{
					text: "Ok",
					click : function() {
						$(this).dialog("close");
					}
				}
		];
		$("#" + this._motifViewErrDlgId).dialog({buttons:buttons});
	},*/
	
	_initAppUtil : function() {
		var self = this;
		var obj = {
			containerId : self._containerId,
			errTextClass : 'errorText',
			baseSequenceMinLength : self._baseSequenceMinLength,
			baseSequenceLength : self._baseSequence.length
		}
		self._appUtil = new Application.Util(obj);
	},
	
	getMotifViewHtml : function(sequnce) {
		var sb = [], self = this, date = new Date(); 
		sb[sb.length] = "<fieldset class='motifViewDialog'>";
		sb[sb.length] = "<legend>Motif view: edit the position and copy number of a motif</legend>";
		sb[sb.length] = "<div id='" + this._motifViewAreaId + "' class='hidden "+ sequnce +"'>";
		sb[sb.length] = "<input type='hidden' class='sequence'>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<span class='label left'>Place motif at position</span>";
		sb[sb.length] = "<input type='text' class='position'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span class='explanation'>Replace with prefer position between ";
		sb[sb.length] = "<span class='minSeq'></span> and <span class='maxSeq'>";
		sb[sb.length] = "</span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<span class='label left'>Number of extra copies</span>";
		sb[sb.length] = "<input type='text' class='extraCopies' value='0'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<span class='label left'>Space between copies (Base Pairs)</span>";
		sb[sb.length] = "<input type='text' class='basePairs' value='0'/>";
		sb[sb.length] = "</div>";
		//sb[sb.length] = "<div class='motifImageArea'>";
		//sb[sb.length] = "<img src='" + this._options.dialogImageUrl + "'/>";
		//sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span class='explanation explink'>Click ";
		//sb[sb.length] = "<a class='moreInfo'>here</a> to see the additional information about motif from " + self._getDataBaseWebsiteName() + " website";
		sb[sb.length] = "<a class='moreInfo'>here</a> to see the additional information about motif";
		sb[sb.length] = "</span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span class='dialogErrorMessage errorMessage hidden'></span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<a id='motifview_placeMotif' class='btn btn-lightblue'>Place Motif</a>";
		sb[sb.length] = "&nbsp;";
		//sb[sb.length] = "<a id='motifview_cancel' class='btn btn-lightblue'>Cancel</a>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<fieldset class='motifviewinfo'>";
		sb[sb.length] = "<span class='motifsequence' /></br>";
		sb[sb.length] = "<span class='motifmethod' /></br>";
		sb[sb.length] = "<span class='motifrecpos' />";
		sb[sb.length] = "</fieldset>";
		sb[sb.length] = "</fieldset>";
		sb[sb.length] = "</div>";
		return sb.join("");
	},
		
	drawMotifView : function(sequence,appropriatePos) {
		var self = this;
		var htmlContent = this.getMotifViewHtml(sequence);
		var dialogSelector = "#" + self._motifViewAreaId + "." + sequence;
		//$("#" + this._containerId).append(htmlContent);
		$("#" + self._containerId + " ." + self._replaceSequenceClass).before(htmlContent);
		$(dialogSelector).find(".motifsequence").html("Motif Sequence: " + sequence);
		$(dialogSelector).find(".motifmethod").html("Motif Method: ");
		$(dialogSelector).find(".motifrecpos").html("Motif Recommended Position: -" + Math.abs(appropriatePos));
		$(dialogSelector).show();
		
		$(dialogSelector).find("#motifview_placeMotif").click(function() {
			var seq = $(dialogSelector).find(".sequence").val();
			var pos = Math.abs($(dialogSelector).find(".position").val());
			var extraCopies = parseInt($(dialogSelector).find(".extraCopies").val());
			var basePairs = parseInt($(dialogSelector).find(".basePairs").val());
			var minPos = parseFloat($(dialogSelector).find(".minSeq").html());
			var maxPos = parseFloat($(dialogSelector).find(".maxSeq").html());
			//if (minPos > pos || maxPos < pos) {
				//$("#" + self._motifViewErrDlgId + " .errinfo").html(self.defaults.dialogOutRangeValueMessage.replace("{0}", minPos).replace("{1}", maxPos));
				//$dialogError = $("#" + self._motifViewAreaId + " ." + self.defaults.dialogErrorMessageClass);
				//$dialogError.html(self.defaults.dialogOutRangeValueMessage.replace("{0}", minPos).replace("{1}", maxPos));
				//$dialogError.show();
				//$("#" + self._motifViewErrDlgId).dialog('open');
				//self._showMotifErrorDialog(("#" + self._motifViewAreaId).find(".position"));
				return;
			//}
			var position = self._appUtil._validateManulMotifCenterPosition(seq.length,pos);
			if (Math.abs(pos) != position) {
				self._appUtil._showMotifErrorDialog(position,$(dialogSelector).find(".position"));
			} else {
				$(dialogSelector).find(".position").val("-" + Math.abs(pos));
				self._replaceWithSequence(seq, pos, extraCopies, basePairs);
			}
			//self.hideError();
			//$(this).dialog("close");
		});
		
		/*
		$("#" + this._containerId).find("#motifview_cancel").click(function() {
			$("#" + self._motifViewDialogId).remove();
		});*/
	},
	
	_replaceWithSequence : function(seq, pos, extraCopies, basePairs) {
		var self = this, sb = [];
		self._placeMotifViewSequnce(seq, pos, extraCopies, basePairs);
		var html = self._callerObj._appSequence.getReColoredMotifViewSequnce(seq, pos, extraCopies, basePairs, self._replaceSequenceClass);
		var subject = $("#" + self._containerId + " ." + self._geneLabelClass).val();
		var gene = self._callerObj._motifProperty.getGeneBySubject(subject);
		var geneType = "";
		if (self._callerObj._getGeneType) {
			geneType = self._callerObj._getGeneType();
		}
		sb[sb.length] = html;
		sb[sb.length] = "<input type='hidden' class='gene' value='" + gene + "'/>";
		sb[sb.length] = "<input type='hidden' class='geneType' value='" + geneType + "'/>";
		$("#" + self._containerId + " ." + self._replaceSequenceClass).html(sb.join(""));
		$("#" + self._containerId + " ." + self._replaceSequenceClass).show();
		$("#" + self._containerId + " ." + self._replaceSequenceClass).scrollLeft(10000);
		var seqLabel = seq + "[" + pos + "]";
		self._callerObj._showDatabaseInfo(seqLabel);
		self._callerObj._options.callback();
	},
	
	_placeMotifViewSequnce : function(seq, pos, extraCopies, basePairs) {
		var self =this,conflictArray = [];
		var corPos;
		//replaceSequenceByOption 
		var oldSequence = $("#" + self._containerId + " ." + self.defaults.replaceSequenceClass).text();
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self.defaults.resultAreaClass + " .baseSequence").html();
		}
		for (var j = 0; j < extraCopies + 1; j++) {
			if (j == 0) {
				corPos = pos;
			} else {
				corPos = corPos + (basePairs) + (seq.length);
			}
			if (self._callerObj._hasConfliction(seq, corPos, oldSequence)) {
				conflictArray.push(seq + "|" + corPos);
			} else {
				self._callerObj._replaceSequenceByOption("new", seq, corPos);
			}	
			self._callerObj._handleConfliction(conflictArray);
		}
		//return out.join(""); 
	},
	
	isMotifViewExists : function(sequnce) {
		if ($("#" + this._motifViewAreaId + "."+ sequnce).length > 0) {
			return true;	
		} else {
			return false;	
		}
	},
	
	_getMinPosition : function(seq) {
		var self = this;
		var mod = seq.length % 2;
		var tHold = (mod == 1) ? 1 : 0.5;
		return self._baseSequenceMinLength + Math.floor(seq.length / 2) + tHold;
	},
	
	_getMaxPosition : function(seq) {
		var self = this;
		var mod = seq.length % 2;
		var tHold = (mod == 1) ? 0 : 0.5;
		return self._baseSequence.length - 1 - Math.floor(seq.length / 2) + tHold;
	},
		
	_initPositionInsert : function(seq, pos) {
		return;
		var self = this;
		var mod = seq.length % 2;
		$("#" + self._motifViewAreaId + " .position").unbind("keyup");
		$("#" + self._motifViewAreaId + " .position").keyup(function() {
			var val = $(this).val();
			if (isNaN(val)) {
				$(this).val(pos);
				return;
			}
			var tmpVal = new String(Math.abs(val));
			if (mod == 0) {
				if (tmpVal.indexOf(".") == -1) {
					$(this).val(tmpVal + ".5");
				} else {
					$(this).val(tmpVal.split(".")[0] + ".5");
				}
			} else {
				if (tmpVal.indexOf(".") > -1) {
					$(this).val(tmpVal.split(".")[0]);
				}
			}
		});
	},
	
	_initMotifSequenceListener : function() {
		var self = this;
		$("#" + self._containerId + " .motifSequence").click(function() {
			//$("." + self._options.motifViewDialogClass).hide();
			var parent = $(this).closest('.userSequence');
			var container = $(this).closest('.userSequence');
			var seq = $(parent).find(".hdnSequence").val();
			//var pos = $(parent).find(".hdnPosition").val();
			var pos = $(parent).find(".hdnCorPosition").val();
			var appropriatePos = 0;
			var seqEl = null;
			if (self._callerObj._getSeqElBySeq) {
				seqEl = self._callerObj._getSeqElBySeq(seq);
				appropriatePos = (seqEl && seqEl.getAppropriatePos()) ? seqEl.getAppropriatePos() : pos;
			} else {
				appropriatePos = pos;
			}
			if (self.isMotifViewExists(seq) == false) {
				self.drawMotifView(seq,appropriatePos);
				self._initSequencePopup(seqEl,seq);
				var dialogSelector = "#" + self._motifViewAreaId + "." + seq;
				$(dialogSelector + " ." + self.defaults.dialogErrorMessageClass).hide();
				$(dialogSelector + " .sequence").val(seq);
				$(dialogSelector + " .position").val("-" + Math.abs(appropriatePos));
				$(dialogSelector + " .extraCopies").val(0);
				$(dialogSelector + " .basePairs").val(0);
				$(dialogSelector + " .minSeq").html(self._getMinPosition(seq));
				$(dialogSelector + " .maxSeq").html(self._getMaxPosition(seq));
				self._initPositionInsert(seq, appropriatePos);
				$(dialogSelector).show();
			}
			//$("#" + self._motifViewDialogId).dialog({title: self._default.motifViewDialogTitle + " - " + seq});
			//$("#" + self._motifViewDialogId).dialog("open");
			//$("#" + self._motifViewDialogId).closest('.' + self._options.motifViewDialogClass).show();
		});
	},
	
	_initSequencePopup : function(seqEl,sequence) {
		var self = this;
		var dialogSelector = "#" + self._motifViewAreaId + "." + sequence;
		$(dialogSelector + " .moreInfo").unbind("click");
		var url = (seqEl && seqEl.getExternalUrl()) ? seqEl.getExternalUrl() : "#";
		if (url == "#") {
			$(dialogSelector + " .explink").html("&nbsp");
		} else {
			$("#" + self._motifViewAreaId + " .explink").show();
		}
		$(dialogSelector + " .moreInfo").click(function() {
			self._callerObj._showPopupWindow(url);
		});
	}
};
	
Application.timer = function() {
	this._init.apply(this, arguments);
};

Application.timer.prototype = {
	
	_delay : null,
	_retry : null,
	_maxRetry : null,
	
	_init : function() {
		this._delay = 1000;
		this._retry = 0;
		this._maxRetry = 100;
	},
	
	call : function(func) {
		if (this._retry < this._maxRetry) {
			setTimeout(func, this._delay);
		}
		this._retry++;
	}
};

Application.motifProperty = function() {
	this._init.apply(this, arguments);
};

Application.motifProperty.prototype = {

	_options : null,
	_propMap : null,
	_nameMap : null,
	_optionArray : null,
	
	_default : {
		acceptPropLabelPrefix : "label:",
		subjectATTEDUriPhrase : "http://atted.jp/data/locus/",
		subjectPPDBUriPhrase : "http://ppdb.agr.gifu-u.ac.jp/ppdb/cgi-bin/display.cgi?organism=At&gene="
	},
	
	_init : function(options) {
		this._options = $.extend({}, this._default, options);
		this._propMap = [];
		this._nameMap = [];
		this._initPropMap(this._options);
	},
	
	_initPropMap : function(opts) {
		var self = this, workId = opts.workId, fileName = opts.fileName;
		var method = function(properties) {
			self._fillPropMap(self, properties);
			self._initOptionArray(properties);
		}
		LinkData.getProperties(workId, fileName, method);
	},
	
	_fillPropMap : function(self, properties) {
		$.each(properties, function(key, value) {
			var label = self._getLabel(value);
			if (!self._propMap[label]) {
				self._propMap[label] = value;
			}
		});
	},
	
	_initOptionArray : function(propertyList) {
		var self = this, list = new Object();
		var workId = self._options.workId, fileName = self._options.fileName;
		self._optionArray = [];
		$.each(propertyList, function(key, value) {
			var propLabel = self._getLabel(value);
			if (!self._ignore(propLabel)) {
				var obj = {};
				obj.key = propLabel;
				obj.value = self._getDisplayLabel(propLabel);
				self._optionArray.push(obj);
			}
		});
	},
	
	_ignore : function(label) {
		var self = this;
		if (label.indexOf(self._default.acceptPropLabelPrefix) > -1) {
			return false;
		}
		return true;
	},
	
	_getDisplayLabel : function(value) {
		var self = this;
		var propLabel = value;
		var arr = value.split(self._default.acceptPropLabelPrefix);
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},
	
	_getLabel : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},

	getOptionArray : function() {
		return this._optionArray;
	},
	
	getPropertyByLabel : function(label) {
		return this._propMap[label];
	},
	
	getGeneBySubject : function(subject) {
		var self = this, htmlExt = ".html", geneLabel;
		if (subject.indexOf(self._default.subjectATTEDUriPhrase) > -1) {
			geneLabel = subject.replace(self._default.subjectATTEDUriPhrase, "");
		} else if (subject.indexOf(self._default.subjectPPDBUriPhrase) > -1) {
			geneLabel = subject.replace(self._default.subjectPPDBUriPhrase, "");
		}
		if (geneLabel && geneLabel.indexOf(htmlExt) > -1) {
			geneLabel = geneLabel.replace(htmlExt, "");
		}
		return geneLabel;
	}
	
};

Application.sequence = function() {
	this._init.apply(this, arguments);
};

Application.sequence.prototype = {
	
	CHAR_SEQ_EMPTY : "-",
	
	_options : null,
	_workId : null,
	_fileName : null,
	_seqProperty : null,
	_posProperty : null,
	_baseSequence : null,
	_sequenceList : null,
	_positionList : null,
	_containerId : null,
	_errorContainerClass : null,
	_outOfRangeArray : null,
	
	_default : {
		msgInvalidSequence: "invalid sequence.",
		msgOutOfRangeSequence: "out of range sequence : {0}",
	},
	
	_init : function(options) {
		this._options = options;
		this._workId = this._options.workId;
		this._fileName = this._options.fileName;
		this._seqProperty = this._options.motifSequenceProperty;
		this._posProperty = this._options.motifPositionProperty;
		this._baseSequence = this._options.baseSequence;
		this._containerId = this._options.containerId;
		this._errorContainerClass = this._options.errorMessageClass;
	},
	
	_getCustomSequenceHtml : function(baseSequence, sequence, position) {
		var seqLen = sequence.length;
		var tHold = Math.floor(seqLen / 2);
		var pos = parseInt(position);
		var baseSeqLen = baseSequence.length;
		var suffixLen = baseSeqLen - (tHold + pos);
		var motifCorectedStartingPoint = position - (seqLen / 2);
		
		var sb = [];
		if (motifCorectedStartingPoint >= this._options.baseSequenceMinLength && suffixLen >= 0) {
			for (var i = 0; i < suffixLen; i++) {
				sb.push(this.CHAR_SEQ_EMPTY);
			}
			sb.push("<a href='javascript:void(0)' class='motifSequence'>" + sequence + "</a>");
			sb.push("<input type='hidden' class='hdnSequence' value='" + sequence + "'/>");
			sb.push("<input type='hidden' class='hdnPosition' value='" + pos + "'/>");
			sb.push("<input type='hidden' class='hdnCorPosition' value='-" + position + "'/>");
		} else {
			//_showError($appContainer, opts.msgOutOfRangeSequence.replace("{0}", sequence));
			this._outOfRangeArray.push(sequence + "[-" + position + "]");
			this._showError(this._default.msgOutOfRangeSequence.replace("{0}", this._outOfRangeArray.join(", ")));
		}
		return sb.join("");
	},
	
	_isValidSequenceList : function(seqs) {
		var count = seqs.length;
		var maxlength = 0;
		for (var i = 0; i < count; i++) {
			if (seqs[i].length > maxlength) {
				maxlength = seqs[i].length;
			}
		}
		var result = true;
		for (var i = 0; i < maxlength; i++) {
			var chars = [];
			for (var j = 0; j < count; j++) {
				chars.push(seqs[j].charAt(i));
			}
			if (! this._isValidChars(chars.join(""))) {
				result = false;
				break;
			}
		}
		return result;
	},
	
	_isValidBaseReplacementMotif : function(baseSequence, seqs) {
		var self = this;
		var mergeSequence = this._getMergeCharSequence(seqs);
		var length = baseSequence.length;
		for (var i = 0; i < length; i++) {
			var bChar = baseSequence.charAt(i);
			var mChar = mergeSequence.charAt(i);
			if (mChar !== this.CHAR_SEQ_EMPTY && bChar !== this.CHAR_SEQ_EMPTY && mChar !== bChar) {
				return false;
			}
		}
		return true;
	},
	
	_isValidChars : function(charString) {
		var charLen = charString.length;
		var result = true;
		var first = null;
		for (var i = 0; i < charLen; i++) {
			if (charString.charAt(i) == this.CHAR_SEQ_EMPTY) {
				continue;
			}
			if (! first) {
				first = charString.charAt(i);
			}
			var current = charString.charAt(i);
			if (current && first != current) {
				result = false;
				break;
			}
		}
		return result;
	},
	
	_getReplacedCustomSequence : function(seqs) {
		var mergeSequence = this._getMergeCharSequence(seqs);
		var maxlength = this._baseSequence.length;
		var sb = [];
		for (var i = 0; i < maxlength; i++) {
			var bChar = this._baseSequence.charAt(i);
			var mChar = mergeSequence.charAt(i);
			if (mChar !== this.CHAR_SEQ_EMPTY) {
				// replaced
				sb.push(mChar);
			} else {
				sb.push(bChar);
			}
		}
		
		return sb.join("");
	},
	
	_getMergeCharSequence : function(seqs) {
		var count = seqs.length;
		var maxlength = this._baseSequence.length;
		var sb = [];
		for (var i = 0; i < maxlength; i++) {
			var chars = [];
			for (var j = 0; j < count; j++) {
				chars.push(seqs[j].charAt(i) ? seqs[j].charAt(i) : this.CHAR_SEQ_EMPTY);
			}
			sb.push(this._getMergeChar(chars.join("")));
		}
		return sb.join("");
	},
	
	_getMergeChar : function(charString) {
		var charLen = charString.length;
		var result = null;
		for (var i = 0; i < charLen; i++) {
			if (charString.charAt(i) !== this.CHAR_SEQ_EMPTY) {
				result = charString.charAt(i);
				break;
			}
		}
		if (!result) {
			result = this.CHAR_SEQ_EMPTY;
		}
		return result;
	},
	
	_wrappedReplacedSequenceHtml : function(replaceSequence, seqs) {
		var self = this, sb = [];
		var mergeSequence = this._getMergeCharSequence(seqs);
		var length = this._baseSequence.length;
		for (var i = 0; i < length; i++) {
			var bChar = this._baseSequence.charAt(i);
			var rChar = replaceSequence.charAt(i);
			var mChar = mergeSequence.charAt(i);
			var seqChar = (bChar !== rChar) ? "<span class='replace'>" + rChar + "</span>" : rChar;
			if (mChar !== this.CHAR_SEQ_EMPTY) {
				sb.push("<span class='highlight-sequence'>" + seqChar + "</span>");
			} else {
				sb.push(seqChar);
			}
		}
		return sb.join("");
	},
	
	/*
	_getSequenceAndPositionHiddenHtml : function(seqArray, posArray) {
		var self = this, sb = [];
		if (!seqArray || !posArray) {
			return sb.join("");
		}
		for (var i = 0; i < seqArray.length; i++) {
			sb[sb.length] = "<input type='hidden' class='hdnReplacedMotif' value='" + seqArray[i] + "|" + posArray[i] + "'/>";
		}
		return sb.join("");
	},
*/
	
	_showError : function(message) {
		$errorMessageContainer = $("#" + this._containerId + " ." + this._errorContainerClass);
		$errorMessageContainer.html(message);
		$errorMessageContainer.show();
	},
	
	getHtmlByReplacingOldSequence : function(oldSequence, newSequence) {
		var self = this, sb = [];
		for (var i = 0; i < oldSequence.length; i++) {
			var oChar = oldSequence.charAt(i);
			var nChar = newSequence.charAt(i);
			var seqChar = (oChar !== nChar) ? "<span class='replace'>" + oChar + "</span>" : oChar;
			if (nChar !== self.CHAR_SEQ_EMPTY) {
				if (oChar !== self.CHAR_SEQ_EMPTY) {
					sb.push("<span class='highlight-sequence'>" + seqChar + "</span>");
				} else {
					sb.push(nChar);
				}
			} else {
				sb.push(oChar);
			}
		}
		return sb.join("");
	},
	
	getHtmlByReplacingNewSequence : function(oldSequence, newSequence) {
		var self = this, sb = [];
		for (var i = 0; i < oldSequence.length; i++) {
			var oChar = oldSequence.charAt(i);
			var nChar = newSequence.charAt(i);
			var seqChar = (oChar !== nChar) ? "<span class='replace'>" + nChar + "</span>" : nChar;
			if (nChar !== self.CHAR_SEQ_EMPTY) {
				sb.push("<span class='highlight-sequence'>" + seqChar + "</span>");
			} else {
				sb.push(oChar);
			}
		}
		return sb.join("");
	},
	
	getSequenceHtml : function(subject, drawSequence) {
		var self = this;
		self._outOfRangeArray = [];
		var sb = [], baseSequence = self._baseSequence;
		var getTriplesBySequenceProperty = function(sequenceList) {
			self._getTriplesBySequenceProperty(subject, drawSequence, sequenceList);
		}
		LinkData.getObjects(self._workId, self._fileName, subject, self._seqProperty, getTriplesBySequenceProperty);
	},
	
	_getTriplesBySequenceProperty : function(subject, drawSequence, sequenceList) {
		var self = this;
		var getTriplesByPositionProperty = function(positionList) {
			self._drawSequenceList(drawSequence, sequenceList, positionList);
		}
		LinkData.getObjects(self._workId, self._fileName, subject, self._posProperty, getTriplesByPositionProperty);
	},
	
	_drawSequenceList : function(drawSequence, sequenceList, positionList) {
		var self = this, sb = [];
		if (!sequenceList || sequenceList.length == 0) {
			return;
		}
		for (var i = 0; i < sequenceList.length; i++) {
			var customSeqString = self._getCustomSequenceHtml(self._baseSequence, sequenceList[i], positionList[i]);
			if (customSeqString.length > 0) {
				sb.push("<div>");
				sb.push("<div class='userSequence'>" + customSeqString + "</div>");
				sb.push("&nbsp;<span class='deletelink "+ sequenceList[i] +"' onclick='self._deleteUserSequence("+ "&quot;" + sequenceList[i] + "&quot;" +","+ "&quot;" + self._containerId + "&quot;" +");'>");
				sb.push("<img src='http://app.linkdata.org/asset/c6bf2a0f.png' title='Delete' /></span>");
				//sb.push("<div>&nbsp;</div>");
				sb.push("<div>");
			}
		}
		sb.push("<div>&nbsp;</div>");
		drawSequence(sb.join("\n"));
	},
	
	_deleteUserSequence : function(sequence) {
		alert(sequence);
		//$("#" + this._containerId + " .resultArea .userSequence").each(function() {
		///	var seq = $(this).find(".hdnSequence");
			
		//});
	},
	
	getFormattedSequence : function(baseSeqLen, seq, pos) {
		var self = this, sb = [];
		var seqLen = seq.length;
		var tHold = Math.floor(seqLen / 2);
		var pos = parseInt(pos);
		var len = baseSeqLen - (tHold + pos);
		for (var i = 0; i < len; i++) {
			sb[sb.length] = self.CHAR_SEQ_EMPTY;
		}
		sb[sb.length] = seq;
		return sb.join("");
	},
	
	replace : function(seqs, seqArray, posArray) {
		var self = this, isValid = self._isValidSequenceList(seqs);
		if (isValid) {
			if (seqs.length > 0) {
				var sb = [];
				var replaceSeq = self._getReplacedCustomSequence(seqs);
				sb[sb.length] = self._wrappedReplacedSequenceHtml(replaceSeq, seqs);
				//sb[sb.length] = self._getSequenceAndPositionHiddenHtml(seqArray, posArray);
				return sb.join("");
			}
		} else {
			this._showError(self._default.msgInvalidSequence);
		}
	},
	
	replaceWith : function(seq, pos, extraCopies, basePairs) {
		var main = [], seqArray = [], posArray = [], conflictArray = [];
		var seqLen = seq.length;
		var tHold = Math.floor(seqLen / 2);
		var pos = parseInt(pos);
		var baseSeqLen = this._baseSequence.length;
		var len = baseSeqLen - (tHold + pos);
		var corPos;
		seqArray.push(seq);
		posArray.push(pos);
		
		for (var j = 0; j < extraCopies + 1; j++) {
			
			var array = [];
				for (var i = 0; i < len; i++) {
					array.push(this.CHAR_SEQ_EMPTY);
				}
				array.push(seq);
				main.push(array.join(""));
				len = len - seqLen - basePairs;
				if (len < 0) {
					break;
				}	
		}
		//return this.replace(main, seqArray, posArray);
		return main;
	},
		
	getReplacingSeq : function(seq,pos) {
		var sb = [], out = [];	
		var seqLen = seq.length;
		var tHold = Math.floor(seqLen / 2);
		var pos = parseInt(pos);
		var baseSeqLen = this._baseSequence.length;
		var len = baseSeqLen - (tHold + pos);
		
		for (var i = 0; i < len; i++) {
			sb.push(this.CHAR_SEQ_EMPTY);
		} 
		
		sb.push(seq);
		return sb.join("");
	},
	
	getReColoredMotifViewSequnce : function(seq, pos, extraCopies, basePairs, replaceDivClass) {
		
		var self = this;
		var sb = [];
		
		var seqs = self.replaceWith(seq, pos, extraCopies, basePairs);
		var replaceSeq = self._getReplacedCustomSequence(seqs);
		var existingSequence = $("#" + self._containerId + " ." + replaceDivClass).text();
		var repSeqLen = replaceSeq.length;
		
		for (var index = 0 ; index < repSeqLen ; index++) {
			var oChar = existingSequence.charAt(index);
			var nChar = replaceSeq.charAt(index);
			//var seqChar = (oChar !== nChar) ? "<span class='replace'>" + nChar + "</span>" : nChar;
			if (index < (repSeqLen - 50)) {
				if (nChar == oChar && nChar !== self.CHAR_SEQ_EMPTY) {
					sb.push("<span class='highlight-sequence replace'>" + nChar + "</span>");
				} else {
					sb.push(oChar);
				} 
			} else {
				sb.push(oChar);
			}
		}
		//self._doReplaceWithHtml(sb.join(""));
		return sb.join("");
	},
	
	/*
	hideError : function() {Seq.charAt(index);
			//var seqChar = (oChar !== nChar) ? "<span class='replace'>" + nChar + "</span>" : nChar;
			if (index < (exisSeqLen - 50)) {
				if (nChar == oChar && nChar !== self.CHAR_SEQ_EMPTY) {
					sb.push("<span class='highlight-sequence replace'>" + nChar + "</span>");
				} else {
					sb.push(oChar);
				} 
			} else {
				sb.push(oChar);
			}
		}
		//self._doReplaceWithHtml(sb.join(""));
		return sb,join("");
	},*/
	
	hideError : function() {
		$errorMessageContainer = $("#" + this._containerId + " ." + this._errorContainerClass).hide();
	}
	
};
