//ロード完了後に実行
window.onload = function() {
	//コンテンツ領域内のdiv要素を走査してメニューを作る
	$("#statistics_contents > div[data-title]").each(function(i, e) {
		var liElement = $("<li>");
		liElement.html($(e).attr("data-title"));
		liElement.on("click", function() {
			$("#statistics_menu .active_contents").removeClass("active_contents");
			$(this).addClass("active_contents");
			setContents(e);
		});
		$("#statistics_list").append(liElement);
	});
	
	//モバイルメニューにイベントを追加
	$(".mobile_icon").on("click", function() {
		$(".mobile_icon").toggleClass("icon_close");
		
		//メニュー表示・非表示
		if ($("#statistics_list").css("display") == "block") {
			//非表示にする
			$("#statistics_list").slideUp(500);
		} else {
			//表示する
			$("#statistics_list").slideDown(500);
		}
	});
};

//レスポンシブ対応
$(window).on("load resize",function() {
	//大きさを取得
	var ww = $(window).width();
    var wh = $(window).height();
    
    if(window.matchMedia("(max-width:960px)").matches){
		//モバイル
		//モード切替
		$("#result").css("flex-wrap", "wrap")
		$("#statistics_menu").removeClass("pc");
		$("#statistics_menu").addClass("mobile");
    }else{
		//PC
		//モード切替
		$("#result").css("flex-wrap", "nowrap")
		$("#statistics_menu").removeClass("mobile");
		$("#statistics_menu").addClass("pc");
		$("#statistics_list").css("display", "");
		$(".mobile_icon").removeClass("icon_close");
    }
});

/*
 setContents
 @param e コンテンツ(DOM)
 @description 選択された要素からJSONデータを取得して表示します。
*/
function setContents(e) {
	//選択された用要素以外のコンテンツを非表示
	$("#statistics_contents .active_contents").removeClass("active_contents");
	
	//選択されたコンテンツ内のworkidカスタム属性要素を走査
	$(e).children("div[data-workid]").each(function(i, child) {
		//非表示にしておく
		$(child).hide();
		
		//未処理なら処理
		if(!$(child).attr("data-finished")) {
			//番号をつけておく
			$(child).attr("data-contents-count", i);
				
			//データタイプを取得
			var dataType = $(child).attr("data-type");
		
			switch(dataType) {
				case "table":
					setTableElement(child);
					break;
				case "dom":
					setJartyElement(child);
					break;
				default:
					break;
			}
		} else {
			//1番目を表示
			if(i == 0) {
				$(child).show();
			}
		}
	});
	
	//選択されたコンテンツを表示
	$(e).addClass("active_contents");
}

/*
 setJartyElement
 @param child DOM要素対象DOM
 @description 指定された要素にjartyを適用します。
*/
function setJartyElement(child, targetIndex = 0) {
	//ローディング画面を表示
	if($(child).attr("data-contents-count") == targetIndex) {
		$(".loader").show();
	}
	
	//データを取得
	var url = $(child).attr("data-url");
	//HTTP/HTTPSを切り替え
	if(location.protocol == "https:") {
		//HTTPS
		url = url.replace(/^http:/,"https:");
	} else {
		//HTTP
		url = url.replace(/^https:/,"http:");
	}
	
	//データを用意
	var dictionaryData = {};
	var arrayData = [];
	
	//データバインド情報を取得
	var bindData = {};
	$(child).find("[data-bindcol]").each(function(i, data) {
		var name = $(data).attr("data-bindname");
		bindData[$(data).attr("data-bindcol")] = $(data).attr("data-bindname");
	});
	
	//フォーマット情報の連想配列を作る
	var formatCollection = new Map();
	$.ajaxSetup({
		beforeSend : function(xhr) {
        xhr.overrideMimeType('application/javascript;charset=Shift_JIS');
		}
	});
	
	//JSONデータを取得
	$.ajax({
		url: url,
		dataType: 'jsonp',
		crossDomain: true,
		timeout: 20000,
		responsive: true,
		success:function(data){
			//取得したデータからヘッダ名とデータを取り出す
			$.each(data, function(key, item) {
				var tempData = {};
				$.each(item, function(id, value) {
					//登録対象であれば処理
					if(getLastName(id) in bindData) {
						//属性によって分岐
						if("datatype" in value[0]) {
							switch(getLastName(value[0].datatype)) {
								//日付形式
								case "date":
									var tempString = value[0].value.split("-");
									var tempDate = new Date();
									tempDate.setYear(tempString[0]);
									tempDate.setMonth(parseInt(tempString[1]) - 1);
									tempDate.setDate(tempString[2]);
									//表示フォーマット指定があれば準拠
									if(formatCollection.has(getLastName(id))) {
										tempData[bindData[getLastName(id)]] = formatDate(tempDate, formatCollection.get(getLastName(id)));
									} else {
										tempData[bindData[getLastName(id)]] = tempDate;
									}
									break;
								//数値形式
								case "int":
									tempData[bindData[getLastName(id)]] = value[0].value;
									break;
								default:
									tempData[bindData[getLastName(id)]] = value[0].value;
									break;
							}
						} else {
							tempData[bindData[getLastName(id)]] = value[0].value;
						}
					}
				});
				//未登録のデータは空白とする
				$.each(bindData, function(bindKey, bindValue) {
					if(!(bindKey in tempData)) {
						tempData[bindKey] = "";
						//alert(bindKey + "は存在しません");
					}
				});
				//配列にデータを追加
				arrayData.push(tempData);
			});
			
			//データを作成
			dictionaryData["json"] = arrayData;
			var source = $(child).html();
			var result = Jarty.eval(source, dictionaryData);
			$(child).html(result);
			
			//表示
			if($(child).attr("data-contents-count") == targetIndex) {
				$(".loader").hide();
				$(child).fadeIn(500);
			}
		},
		error:function(error){
			$(child).append("<p>Can not load JSON data.</p>");
			//表示
			if($(child).attr("data-contents-count") == targetIndex) {
				$(".loader").hide();
				$(child).fadeIn(500);
			}
		}
	});
	
	//処理済みにする
	$(child).attr("data-finished", "true");
}

/*
 setTableElement
 @param child テーブル作成対象DOM
 @description 指定された要素にdatatablesを作成します。
*/
function setTableElement(child, targetIndex = 0) {
	//エラーフラグ
	var errorFlag = false;
	//処理済みなら何もしない
	if($(child).attr("data-finished")) {
		return;
	}
	
	//インデックスが不一致なら何もしない
	if($(child).attr("data-contents-count") != targetIndex) {
		return;
	}
	
	//ローディング画面を表示
	if($(child).attr("data-contents-count") == targetIndex) {
		$(".loader").show();
	}
	
	//データを取得
	var url = $(child).attr("data-url");
	//HTTP/HTTPSを切り替え
	if(location.protocol == "https:") {
		//HTTPS
		url = url.replace(/^http:/,"https:");
	} else {
		//HTTP
		url = url.replace(/^https:/,"http:");
	}
	
	//検索窓
	var searchingFlag = false;
	if($(child).attr("data-searching")) {
		searchingFlag = toBoolean($(child).attr("data-searching"));
	}
	//ページ表示
	var pagingFlag = false;
	if($(child).attr("data-paging")) {
		pagingFlag = toBoolean($(child).attr("data-paging"));
	}
	//列ソート
	var orderingFlag = false;
	if($(child).attr("data-ordering")) {
		orderingFlag = toBoolean($(child).attr("data-ordering"));
	}
	//ボタン表示
	var buttons = "";
	if($(child).attr("data-display-button")) {
		if(toBoolean($(child).attr("data-display-button"))) {
			buttons = [
				{extend:"copy",text:"コピー"},
				{extend:"csv", text:"CSVダウンロード"},
				{extend:"print",text:"印刷"}
			];
		}
	}
	//件数変更
	var lengthChangeFlag = false;
	if($(child).attr("data-lengthChange")) {
		lengthChangeFlag = toBoolean($(child).attr("data-lengthChange"));
	}
	//件数表示
	var infoFlag = false;
	if($(child).attr("data-info")) {
		infoFlag = toBoolean($(child).attr("data-info"));
	}
	//グループ行
	var columnGroups = [];
	var groupMap = {};
	//列情報を取得
	var columnData = [];
	var columnDefs = [];
	//ヘッダの行列を数える
	var columnCount = 0;
	var rowCount = 0;
	$(child).children("table:first").each(function(j, table) {
		$(table).children("thead:first").each(function(k, thead) {
			$(thead).children("tr").each(function(l, tr) {
				if(l == 0) {
					$(tr).children("th").each(function(m, th) {
						//加算
						columnCount += 1;
						//colspanしていれば加算する
						if($(th).attr("colspan")) {
							columnCount += parseInt($(th).attr("colspan")) - 1;
						}
					});
				}
				//加算
				rowCount += 1;
			});
		});
	});
	//ヘッダの行列の二次元配列を作る
	var headerArray = new Array(rowCount);
	for(var j = 0; j < rowCount; j++) {
		headerArray[j] = new Array(columnCount).fill(0);
	}
	//フォーマット情報の連想配列を作る
	var formatCollection = new Map();
	var renderNumberCollection = new Map();
	//グループ情報の連想配列を作る
	var groupCollection = new Map();
	//数式情報の連想配列を作る
	var expressionCollection = {};
	var expressionOrder = [];
	var expressionRequireCollection = {};
	var bindNameCollection = {};
	//データバインド情報を取得
	$(child).children("table:first").each(function(j, table) {
		$(table).children("thead:first").each(function(k, thead) {
			$(thead).children("tr").each(function(l, tr) {
				//現在の行を取得
				var currentRow = l;
				//現在の列を取得
				var currentColumn = 0;
				var spanedCol = 0;
				while(spanedCol < columnCount) {
					if(Number.isInteger(headerArray[currentRow][spanedCol]) && headerArray[currentRow][spanedCol] >= 0) {
						break;
					}
					spanedCol++;
				}
				currentColumn += spanedCol;
				$(tr).children("th").each(function(m, th) {
					while(Number.isInteger(headerArray[currentRow][currentColumn]) && headerArray[currentRow][currentColumn] < 0) {
						if(currentColumn >= columnCount) {
							break;
						}
						currentColumn += 1;
					}
					//データを登録
					if($(th).attr("data-bindcol")) {
						//元データの列名を登録
						var bindCol = $(th).attr("data-bindcol");
						headerArray[currentRow][currentColumn] = bindCol;
						//表示フォーマットが指定されていれば格納
						if($(th).attr("data-dataformat")) {
							formatCollection.set(bindCol, $(th).attr("data-dataformat"));
						}
						if($(th).attr("data-render-number")) {
							renderNumberCollection.set(bindCol, $(th).attr("data-render-number"));
						}
						//数式がセットされていれば格納
						if($(th).attr("data-expression")) {
							//優先度の指定がなければ0番として登録
							var tempPriority = 0;
							if($(th).attr("data-expression-priority")) {
								//優先度指定あり
								var tempParse = Number($(th).attr("data-expression-priority"));
								if(!isNaN(tempParse)) {
									tempPriority = tempParse;
								}
							}
							//配列が不足していれば追加
							if(expressionOrder.length <= tempPriority) {
								for(var counter = expressionOrder.length; counter <= tempPriority; counter++) {
									var tempExpCollection = {};
									expressionOrder.push(tempExpCollection);
								}
							}
							//該当する優先度のハッシュテーブルに追加
							var expCollection = expressionOrder[tempPriority];
							expCollection[bindCol] = $(th).attr("data-expression");
							
							//必須固有名があれば登録
							if($(th).attr("data-expression-require")) {
								var tempSplit = String($(th).attr("data-expression-require")).split(",");
								expressionRequireCollection[bindCol] = tempSplit;
							}
						}
						//数式用の固有名が定義されていればセット
						if($(th).attr("data-bindname")) {
							bindNameCollection[bindCol] =  $(th).attr("data-bindname");
						}
						//グルーピング指定情報を格納
						if($(th).attr("data-grouping")) {
							groupCollection.set(bindCol, $(th).attr("data-grouping"));
						}
					} else {
						headerArray[currentRow][currentColumn] = -2;
					}
					//行方向に結合していたら、当該セルを無効化
					var rowSpanCount = 0;
					if($(th).attr("rowspan")) {
						var tempRowSpan = parseInt($(th).attr("rowspan"));
						rowSpanCount = tempRowSpan;
						for(var n = 1; n < tempRowSpan; n++) {
							headerArray[currentRow + n][currentColumn] = -1;
						}
					}
					//列方向に結合していたら、当該セルを無効化
					if($(th).attr("colspan")) {
						var tempColSpan = parseInt($(th).attr("colspan"));
						for(var n = 1; n < tempColSpan; n++) {
							headerArray[currentRow][currentColumn + n] = -1;
							for(var tempRowSpan = 0; tempRowSpan < rowSpanCount; tempRowSpan++) {
								headerArray[currentRow + tempRowSpan][currentColumn + n] = -1;
							}
						}
						currentColumn += tempColSpan - 1;
					}
					currentColumn += 1;
				});
			});
		});
	});
	
	//表示順を最適化(列→行の順で生成)
	var currentCol = 0;
	for(var j = 0; j < columnCount; j++) {
		for(var k = 0; k < rowCount; k++) {
			if(!Number.isInteger(headerArray[k][j])) {
				//数値の表示形式に指定があればヘルパーをセット
				if(renderNumberCollection.has(headerArray[k][j])) {
					var tempString = renderNumberCollection.get(headerArray[k][j]).replace(/\'/g, "\"");
					var renderArray = JSON.parse(tempString);
					columnDefs.push({targets:currentCol, render: $.fn.dataTable.render.number(renderArray[0], renderArray[1], renderArray[2], renderArray[3], renderArray[4])});
					columnData.push({data:headerArray[k][j]});
				} else {
					columnData.push({data:headerArray[k][j]});
				}
				
				//グループ情報があれば登録
				if(groupCollection.has(headerArray[k][j])) {
					columnGroups.push(headerArray[k][j]);
				}

				//インクリメント
				currentCol += 1;
			}
		}
	}
	
	//グループ情報を作成
	if(columnGroups.length > 0) {
		groupMap["dataSrc"] = columnGroups;
	}
	
	var arrayData = [];
	//JSONデータを取得
	$.ajax({
		url: url,
		dataType: 'jsonp',
		timeout: 20000,
		crossDomain: true,
		responsive: true,
		success:function(data){
			//取得したデータからヘッダ名とデータを取り出す
			$.each(data, function(key, item) {
				var tempData = {};
				var bindNameData = {};
				$.each(item, function(id, value) {
					//属性によって分岐
					if("datatype" in value[0]) {
						switch(getLastName(value[0].datatype)) {
								//日付形式
							case "date":
								var tempString = value[0].value.split("-");
								var tempDate = new Date();
								tempDate.setYear(tempString[0]);
								tempDate.setMonth(parseInt(tempString[1]) - 1);
								tempDate.setDate(tempString[2]);
								//表示フォーマット指定があれば準拠
								if(formatCollection.has(getLastName(id))) {
									tempData[getLastName(id)] = formatDate(tempDate, formatCollection.get(getLastName(id)));
									//数式計算用のデータを登録
									if(getLastName(id) in bindNameCollection) {
										bindNameData[bindNameCollection[getLastName(id)]] = formatDate(tempDate, formatCollection.get(getLastName(id)));
									}
								} else {
									tempData[getLastName(id)] = tempDate;
									//数式計算用のデータを登録
									if(getLastName(id) in bindNameCollection) {
										bindNameData[bindNameCollection[getLastName(id)]] = tempDate;
									}
								}
								break;
							//数値形式
							case "int":
								tempData[getLastName(id)] = value[0].value;
								//数式計算用のデータを登録
								if(getLastName(id) in bindNameCollection) {
									bindNameData[bindNameCollection[getLastName(id)]] = value[0].value;
								}
								break;
							default:
								tempData[getLastName(id)] = value[0].value;
								//数式計算用のデータを登録
								if(getLastName(id) in bindNameCollection) {
									bindNameData[bindNameCollection[getLastName(id)]] = value[0].value;
								}
								break;
						}
					} else {
						tempData[getLastName(id)] = value[0].value;
						//数式計算用のデータを登録
						if(getLastName(id) in bindNameCollection) {
							bindNameData[bindNameCollection[getLastName(id)]] = value[0].value;
						}
					}
				});
				
				//数式を処理
				for(var counter = expressionOrder.length; counter > 0; counter--) {
					expressionCollection = expressionOrder[counter-1];
					$.each(expressionCollection, function(expKey, expValue) {
						
						//数式エラーがあれば空白
						try {
							//計算用の配列にコピー
							var tempBindNameData = Object.create(bindNameData);
							//必須ヘッダがデータになければ一時的に0で追加
							if(expKey in expressionRequireCollection) {
								var tempRequire = expressionRequireCollection[expKey];
								for(var counter = 0; counter < tempRequire.length; counter++) {
									//なければ追加
									if(!(tempRequire[counter] in tempBindNameData)) {
										tempBindNameData[tempRequire[counter]] = 0;
								}
							}
						}
							//値を計算させる
							var expFunc = Jarty.compile(expValue);
							var expString = expFunc(tempBindNameData);
							expString = expString.replace(/[\"”]/g,"");
							tempData[expKey] = evalCalculation(expString);
							//計算結果で値を更新
							if(expKey in bindNameCollection) {
								bindNameData[bindNameCollection[expKey]] = tempData[expKey];
							}
						} catch(e) {
							//エラー
							tempData[expKey] = "";
						}
					});
				}
				
				//未登録のデータは空白とする
				$.each(columnData, function(columnIndex, columnValue) {
					if(!(columnValue.data in tempData)) {
						tempData[columnValue.data] = "";
					}
				});
				
				//配列にデータを追加
				arrayData.push(tempData);
			});
			
			var tableElement = $(child).children("table:first");
			tableElement.attr("data-main", "true");
			//DataTablesを作成
			if(columnGroups.length > 0) {
				tableElement.DataTable({
					data: arrayData,
					searching: searchingFlag,
					ordering: orderingFlag,
					paging: pagingFlag,
					lengthChange: lengthChangeFlag,
					info: infoFlag,
					responsive: true,
					language: {"url": "//cdn.datatables.net/plug-ins/1.13.5/i18n/ja.json"},
					buttons:buttons,
					columns:columnData,
					columnDefs:columnDefs,
					rowGroup:groupMap,
					lengthMenu: [[10,25,50,100,-1],[10,25,50,100,"全て"]],
					dom: '<lf>rt<ip><"clear"B>'
				});
			} else {
				tableElement.DataTable({
					data: arrayData,
					searching: searchingFlag,
					ordering: orderingFlag,
					paging: pagingFlag,
					lengthChange: lengthChangeFlag,
					info: infoFlag,
					responsive: true,
					language: {"url": "//cdn.datatables.net/plug-ins/1.13.5/i18n/ja.json"},
					buttons:buttons,
					columns:columnData,
					columnDefs:columnDefs,
					lengthMenu: [[10,25,50,100,-1],[10,25,50,100,"全て"]],
					dom: '<lf>rt<ip><"clear"B>'
				});
			}
			
			//表示
			if($(child).attr("data-contents-count") == targetIndex) {
				$(".loader").hide();
				$(child).fadeIn(500);
			}
		},
		error:function(error){
			errorFlag = true;
			var errorP = $("<p>");
			errorP.html("データの読み込みに失敗しました。お手数をおかけしますが、ページを再読み込みしてください。");
			$(child).append(errorP);
			//表示
			if($(child).attr("data-contents-count") == targetIndex) {
				$(".loader").hide();
				$(child).fadeIn(500);
			}
		}
	});
	
	if(!errorFlag) {
		//グラフを表示する場合、要素を作る
	
		//サブメニューを作る
		createSubMenu(child);
	
	
		//処理済みにする
		$(child).attr("data-finished", "true");
	}
}

/*
 createSubMenu
 @param child 処理コンテンツ
 @description 指定されたコンテンツに同階層のサブメニューを作成します。
*/
function createSubMenu(child) {
	//項目が2つ以上あればメニューを作る
	var parentElement = $(child).parent();
	var countentsCount = $(parentElement).children("div[data-workid]").length;
	if(countentsCount > 1) {
		//メニュー要素を作成
		var divElement = $("<div>");
		var ulElement = $("<ul>");
		ulElement.addClass("contents_menu");
		//それぞれの要素の先頭に選択メニューを追加
		$(parentElement).children("div[data-workid]").each(function(i, contentsElement) {
			if($(contentsElement).attr("data-title")) {
				//選択肢を作る
				var liElement = $("<li>");
				var spanElement = $("<span>");
				$(spanElement).html($(contentsElement).attr("data-title"));
				
				//表示中のものは強調表示
				if(contentsElement == child) {
					//表示中のコンテンツ
					$(spanElement).addClass("current_contents");
				} else {
					$(liElement).on("click", function() {
						//現在のコンテンツを非表示にする
						$(child).hide();
						//対象コンテンツが処理済みなら表示する
						if($(contentsElement).attr("data-finished")) {
							//表示
							$(contentsElement).show();
						} else {
							//作成
							var contentsIndex = parseInt($(contentsElement).attr("data-contents-count"));
							//データタイプを取得
							var dataType = $(contentsElement).attr("data-type");
		
							switch(dataType) {
								case "table":
									setTableElement(contentsElement, contentsIndex);
									break;
								case "dom":
									setJartyElement(contentsElement, contentsIndex);
									break;
								default:
									break;
							}
						}
					});
				}
				
				//追加
				$(liElement).append(spanElement);
				$(ulElement).append(liElement);
			}
		});
		//要素を追加
		$(divElement).append(ulElement);
		$(child).prepend(divElement);
	}
}

/*
 alertArrayData
 @param arrayObj 二次元配列
 @description 指定された二次元配列を表示します。
*/
function alertArrayData(arrayObj) {
	//メイン処理
	var displayArray = "";
	//配列を走査して文字列を成形
	for(var i = 0; i < arrayObj.length; i++) {
		displayArray += "[" + arrayObj[i].toString() + "]\n";
	}
	//表示
	alert(displayArray);
}

// Get a parameter value in URL (e.g. ?paramString=value )
function getParameterFromURL( paramString )
{			
	var value = "";
	var topWindow = top.window.location.search;
	if( topWindow ){
		var q = decodeURIComponent(topWindow.substring(1,topWindow.length)).split("&");
		for ( var i = 0; i < q.length; i++ ){
			var r = q[i].split("=");
			if ( r[0] ==  paramString )
				value = r[1];
		}
	}
 	return value;
}



// get the last name of the string separated with # and /
function getLastName( string )
{
	string = decodeURIComponent(string);
	var sharp = string.split("#");
	var slash = sharp[sharp.length-1].split("/");
	var lastName = slash[slash.length-1];
	return lastName;
}

// shortening URL e.g. http://.../123.jpg
function shortenURL( url )
{
	url = decodeURIComponent(url);
	var slash = url.split("/");
	var lastName = slash[slash.length-1];
	return url.split(":")[0]+"://.../"+lastName;
}

/*
 formatNumber
 @param num 数値
 @param format フォーマット文字列
 @return string 成形文字列
 @description 指定された数値をフォーマット文字列に沿って成形します。
*/
function formatNumber(num, format) {
	//引数処理
	//デフォルトフォーマットを作る
	if(!format) {
		format = "0";
	}
	if(format == "none") {
		format = "0";
	}
	
	//メイン処理
	format = format.replace(/&quot;/g, "").replace(/\'/g, "").replace(/\"/g, "").replace(/\\/g, "");
	var numMatch = false;
	format = format.replace(/\.0+/g, function(match) {
		if(match.length > 0) {
			var temp = num.toFixed(match.length - 1);
			if(temp.indexOf(".") > 0) {
				temp = temp.substr(temp.indexOf("."));
			}
			return temp;
		}
	});
	format = format.replace(/#,##0/g, function(match) {
		numMatch = true;
		return Math.floor(num).toString().replace( /(\d)(?=(\d\d\d)+(?!\d))/g, '$1,'); 
	});
	if(!numMatch) {
		format = format.replace(/0+/g, function(match, offset) {
			if(match.length > 0) {
				if(format.indexOf(".") > 0) {
					if(format.indexOf(".") > offset) {
						numMatch = true;
						return (match + Math.floor(num).toString()).slice(-1 * Math.max(match.length, Math.floor(num).toString().length));
					}
				} else {
					numMatch = true;
					return (match + Math.floor(num).toString()).slice(-1 * Math.max(match.length, Math.floor(num).toString().length));
				}
			}
			return match;
		});
	}
	
	//関数終了
	//返り値: 成形文字列
	return format;
}

/*
 formatDate
 @param date 日付
 @param format フォーマット文字列
 @return string 成形文字列
 @description 指定された日付をフォーマット文字列に沿って成形します。
*/
function formatDate(date, format) {
	//引数処理
	//デフォルトフォーマットを指定
	if(!format) {
		format = "YYYY-MM-DD hh:mm:ss.SSS";
	}
	
	//メイン処理
	format = format.replace(/&quot;/g, "").replace(/\'/g, "").replace(/\"/g, "").replace(/\\/g, "");
	//Excel定型フォーマットを置換
	var templateFormat = {"Short Time":"h:m", "General Date":"YYYY/MM/DD hh:mm:ss", "Long Date":"YYYY年M月D日"};
	if(format in templateFormat) {
		format = templateFormat[format];
	}
	//和暦指定を置換
	if(format.search(/^\[JPN\]/) >= 0) {
		format = format.replace(/^\[JPN\]/, "");
		format = format.replace(/y/g, "e");
	}
	//mがhの直後またはsの直前なら「'」に置換
	format = format.replace(/h([^YMDSdms]*)mm/g, "h$1\'\'").replace(/mm([^YMDSdhm]*)s/g, "\'\'$1s").replace(/h([^YMDSdms]*)m/g, "h$1\'").replace(/m([^YMDSdhm]*)s/g, "\'$1s");
	//「'」をmに置換
	format = format.replace(/m/g, "M").replace(/\'/g, "m");
	//フォーマットに準拠して置換
	format = format.replace(/YYYY/g, date.getUTCFullYear());
	format = format.replace(/MM/g, ('0' + (date.getUTCMonth() + 1)).slice(-2));
	format = format.replace(/DD/g, ('0' + date.getUTCDate()).slice(-2));
	format = format.replace(/dd/g, ('0' + date.getUTCDate()).slice(-2));
	format = format.replace(/M/g, (date.getUTCMonth() + 1));
	format = format.replace(/D/g, (date.getUTCDate()));
	format = format.replace(/d/g, (date.getUTCDate()));
	format = format.replace(/hh/g, ('0' + date.getUTCHours()).slice(-2));
	format = format.replace(/mm/g, ('0' + date.getUTCMinutes()).slice(-2));
	format = format.replace(/ss/g, ('0' + date.getUTCSeconds()).slice(-2));
	format = format.replace(/h/g, (date.getUTCHours()));
	format = format.replace(/m/g, (date.getUTCMinutes()));
	format = format.replace(/s/g, (date.getUTCSeconds()));
	if(format.match(/S/g)) {
		var milliSeconds = ('00' + date.getUTCMilliseconds()).slice(-3);
		var length = format.match(/S/g).length;
		for (var i = 0; i < length; i++) {
			format = format.replace(/S/, milliSeconds.substring(i, i + 1));
		}
  	}
	if(format.match(/ggg/)) {
		var opt = {timeZone: "UTC", era:"long", year:"numeric", month:"numeric"};
		var wareki = date.toLocaleDateString("ja-JP-u-ca-japanese", opt);
		wareki = wareki.trim();
		if(wareki.match(/^([^\d]+)\d/)) {
			wareki = wareki.match(/^([^\d]+)\d/)[1].replace(" ", "");
		} else {
			wareki = wareki.slice(0, 4);
		}
		format = format.replace(/ggg/g, wareki);
	}
	if(format.match(/gg/)) {
		var opt = {timeZone: "UTC", era:"short", year:"numeric", month:"numeric"};
		var wareki = date.toLocaleDateString("ja-JP-u-ca-japanese", opt);
		wareki = wareki.trim();
		format = format.replace(/gg/g, wareki.slice(0,2));
	}
	if(format.match(/g/)) {
		var opt = {timeZone:"UTC", era:"narrow", year:"2-digit", month:"short"};
		var wareki = date.toLocaleDateString("ja-JP-u-ca-japanese", opt);
		wareki = wareki.slice(0, 2);
		if(wareki.match(/^[^\x01-\x7E\xA1-\xDF]+$/)) {
			format = format.replace(/g/g, wareki);
		} else {
			format = format.replace(/g/g, wareki[0]);
		}
	}
	if(format.match(/ee/)) {
		var opt = {timeZone: "UTC", year:"2-digit"};
		var wareki = date.toLocaleDateString("ja-JP-u-ca-japanese", opt);
		wareki = wareki.trim();
		if(wareki.match(/^[^\d]+(\d+)[^\d]/)) {
			wareki = wareki.match(/^[^\d]+(\d+)[^\d]/)[1];
			format = format.replace(/ee/g, wareki);
		}
	}
	if(format.match(/e/)) {
		var opt = {timeZone: "UTC", year:"numeric"};
		var wareki = date.toLocaleDateString("ja-JP-u-ca-japanese", opt);
		wareki = wareki.trim();
		if(wareki.match(/^[^\d]+(\d+)[^\d]/)) {
			wareki = wareki.match(/^[^\d]+(\d+)[^\d]/)[1];
			format = format.replace(/e/g, wareki);
		} else if(wareki.match(/^(\d+)[^\d]/)) {
			wareki = wareki.match(/^(\d+)[^\d]/)[1];
			format = format.replace(/e/g, wareki);
		}
	}
	
	//関数終了
	//返り値: 成形文字列
	return format;
}

function toBoolean(data) {
  return data.toLowerCase() === 'true';
}
