/*
This is a Example program to retrieve and display the data. 
Press the Run button on the right of the screen (described the behavior of the Example program below). 
Please create a new application rewrite this program work. 
*/
const WW_DataID	= 'rdf1s4293i';
const WW_LinkDataPropUrl = 'http://linkdata.org/property/' + WW_DataID + '#';
const FS_DataID	= 'rdf1s9408i';
const FS_LinkDataPropUrl = 'http://linkdata.org/property/' + FS_DataID + '#';

var all_data;        
function initialize(){
	all_data = new Array();
	// データをLinkDataから取得 
	tmp_a_data = new Array();
	console.log("*******");
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var tmp_data = {}
				tmp_data["id"] = subjValue;
				tmp_data["kind"] = workValue;
				console.log(workValue);
				$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
						switch (propValue) {
							case WW_LinkDataPropUrl + encodeURIComponent("アクセスポイント"):
							case FS_LinkDataPropUrl + encodeURIComponent("アクセスポイント"):
								tmp_data["name"] = objValue;
								break;
							case WW_LinkDataPropUrl + encodeURIComponent("緯度"):
							case FS_LinkDataPropUrl + encodeURIComponent("緯度"):
							case "http://www.w3.org/2003/01/geo/wgs84_pos#long":
								tmp_data["lat"] = objValue;
								break;
							case WW_LinkDataPropUrl + encodeURIComponent("経度"):
							case FS_LinkDataPropUrl + encodeURIComponent("経度"):
							case "http://www.w3.org/2003/01/geo/wgs84_pos#lat":
								tmp_data["lng"] = objValue;
								break;
							case WW_LinkDataPropUrl + encodeURIComponent("住所"):
							case FS_LinkDataPropUrl + encodeURIComponent("住所"):
								tmp_data["address"] = objValue;
								break;
							case WW_LinkDataPropUrl + encodeURIComponent("SSID"):
								tmp_data["ssid"] = objValue;
								break;
							case WW_LinkDataPropUrl + encodeURIComponent("PASSWORD"):
								tmp_data["passwd"] = objValue;
								break;
						}	//switch
						tmp_data["kind"] = workValue;
						console.log(tmp_data);
					});
				});
				tmp_a_data.push(tmp_data);
			});
		});
	});
	//全データ
	all_data = tmp_a_data;

	//地図センター緯度経度の初期値は「福井市役所」
	var myLatLng = new google.maps.LatLng(36.0640618,136.2195398);
	var myMap = new google.maps.Map(document.getElementById('result'), {
		zoom: 14,
		center: myLatLng,
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		scaleControl: true,
		scrollwheel: true,
		draggable: true
	});
 
	//ポイントの設定
	var latlng;
	var data = new Array();

	for (var i in all_data) {
		console.log(all_data[i]);
		switch (all_data[i].kind) {
			case WW_DataID:
				//避難所の種類で区分する
				var gmarker = new google.maps.Marker({  
					position: new google.maps.LatLng(all_data[i].lat,all_data[i].lng),       // 緯度・経度は地図の中心  
					title: all_data[i].name,// ツールチップ 
					openInfo:true,
					icon: "https://mt.google.com/vt/icon/name=icons/onion/SHARED-mymaps-container-bg_4x.png,icons/onion/SHARED-mymaps-container_4x.png,icons/onion/1895-wifi_4x.png&highlight=ff000000,0288d1,ff000000&scale=2.0",
					map: myMap  
				}); 
				// ウィンドウに表示するデータをつくる

				var spot_info = '<B>[' + i + ']' + all_data[i].name + '</B><small>'
					+ '<br>【SSID】'
					+ ( all_data[i].ssid != undefined ? all_data[i].ssid :　'WiWi_Fukui_City_Free_WiFi' )
					+ '<br>【パスワード】' 
					+ ( all_data[i].passwd != undefined ? all_data[i].passwd : 'なし' )
					+ '<br><a href="https://www.city.fukui.lg.jp/sisei/tkeikaku/tkeikaku/wiwi_fukui_city_free_wi-fi.html" target="_blank")><b>福井市ホームページ</b></a>'
					+ '</small>';
				break;
			case FS_DataID:
				//避難所の種類で区分する
				var gmarker = new google.maps.Marker({  
					position: new google.maps.LatLng(all_data[i].lat,all_data[i].lng),       // 緯度・経度は地図の中心  
					title: all_data[i].name,// ツールチップ 
					openInfo:true,
					icon: "https://mt.google.com/vt/icon/name=icons/onion/SHARED-mymaps-container-bg_4x.png,icons/onion/SHARED-mymaps-container_4x.png,icons/onion/1895-wifi_4x.png&highlight=ff000000,ff5252,ff000000&scale=2.0",
					map: myMap  
				}); 
				// ウィンドウに表示するデータをつくる
				var spot_info = '<B>[' + i + ']' + all_data[i].name + '</B><small>'
					+ '<br>【SSID】'
					+ ( all_data[i].ssid != undefined ? all_data[i].ssid :　'「福井市FREESPOT」をご覧ください' )
					+ '<br>【パスワード】' 
					+ ( all_data[i].passwd != undefined ? all_data[i].passwd : '「福井市FREESPOT」をご覧ください' )
					+ '<br>'
					+ ( all_data[i].address != undefined ? ('【' + all_data[i].address + '】') : '「福井市FREESPOT」をご覧ください' )
					+ '<br><a href="https://www.city.fukui.lg.jp/sisei/tokei/it/p012365.html" target="_blank")><b>福井市FREESPOT</b></a>'
					+ '</small>';
				break;
		}
		//console.log(spot_info);
		
		data.push({
			position: new google.maps.LatLng(all_data[i].lat, all_data[i].lng), 
			content: spot_info
		});
		// 地図上にウィンドウで表示
		attachMessage(gmarker, data[i].content);
	}; //for
};

// 地図のマーカーをクリックするとウィンドウを表示する処理
function attachMessage(marker, msg) {
	google.maps.event.addListener(marker, 'click', function(event) {
    	new google.maps.InfoWindow({
			content: msg
        }).open(marker.getMap(), marker);
    });
};
window.onload = function() {
    $(function(){initialize();});	
};
