/*
This is a Example program to retrieve and display the data. 
Press the Run button on the right of the screen (described the behavior of the Example program below). 
Please create a new application rewrite this program work. 
*/

var all_data;        
function initialize(){
	all_data = new Array();
	// データをLinkDataから取得 
	tmp_a_data = new Array();
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var tmp_data = {}
				tmp_data["NO"] = subjValue;
				$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
						if(propValue == "http://linkdata.org/property/rdf1s8101i#" + encodeURIComponent("名称")){
							tmp_data["name"] = objValue;
						}else if(propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#lat"){
							tmp_data["lat"] = objValue;
						}else if(propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#long"){
							tmp_data["lng"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8101i#" + encodeURIComponent("住所")){
							tmp_data["location"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8101i#" + encodeURIComponent("設置位置")){
							tmp_data["pos"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8101i#" + encodeURIComponent("利用可能曜日")){
							tmp_data["youbi"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8101i#" + encodeURIComponent("開始時間")){
						    tmp_data["start"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8101i#" + encodeURIComponent("終了時間")){
						    tmp_data["end"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8101i#" + encodeURIComponent("利用可能日時特記事項")){
							tmp_data["tokki"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8101i#" + encodeURIComponent("小児対応設備の有無")){
							tmp_data["forchild"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8101i#" + encodeURIComponent("URL")){
							tmp_data["url"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8101i#" + encodeURIComponent("備考")){
						    tmp_data["appendix"] = objValue;
						}
					});
				});
				tmp_a_data.push(tmp_data);
			});
		});
	});
	//全データ
	all_data = tmp_a_data;

	//地図センター緯度経度の初期値は「塩尻市役所」
	var myLatLng = new google.maps.LatLng(36.115241,137.953483);
	var myMap = new google.maps.Map(document.getElementById('result'), {
		zoom: 12,
		center: myLatLng,
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		scaleControl: true,
		scrollwheel: true,
		draggable: true
	});
 
	//ポイントの設定
	var latlng;
	var data = new Array();

	for (var i in all_data) {
		//避難所の種類で区分する
		var gmarker = new google.maps.Marker({  
			position: new google.maps.LatLng(all_data[i].lat,all_data[i].lng),       // 緯度・経度は地図の中心  
			title: all_data[i].name,// ツールチップ 
			openInfo:true,
			icon: (all_data[i].genre == "予備" ? "http://labs.google.com/ridefinder/images/mm_20_blue.png" : "http://app.linkdata.org/asset/627241e3.png"),
			map: myMap  
	 	}); 
		// ウィンドウに表示するデータをつくる
		var spot_info = all_data[i].name + '<small>'
			+ (all_data[i].location != undefined ? ('<br>【住所】' + all_data[i].location) : "")
			+ (all_data[i].pos != undefined ? ('<br>【設置位置】' + all_data[i].pos) : "")
			+ (all_data[i].youbi != undefined ? ('<br>【利用可能曜日】' + all_data[i].youbi) : "")
			+ (all_data[i].start != undefined ? ('<br>【開始時刻】' + all_data[i].start) : "")
			+ (all_data[i].end != undefined ? ('<br>【終了時刻】' + all_data[i].end) : "")
			+ (all_data[i].tokki != undefined ? ('<br>【利用可能日時特記事項】' + all_data[i].tokki) : "")
			+ (all_data[i].forchild != undefined ? ('<br>【小児対応設備の有無】' + all_data[i].forchild) : "")
			+ (all_data[i].url != undefined ? ('<br>【URL】' + all_data[i].url) : "")
			+ (all_data[i].appendix != undefined ? ('<br>【備考】' + all_data[i].appendix) : "")
			+ '</small>';
		data.push({
			position: new google.maps.LatLng(all_data[i].lat, all_data[i].lng), 
			content: spot_info
		});
		// 地図上にウィンドウで表示
		attachMessage(gmarker, data[i].content);
	}; //for toji 
};//initialize toji

// 地図のマーカーをクリックするとウィンドウを表示する処理
function attachMessage(marker, msg) {
	google.maps.event.addListener(marker, 'click', function(event) {
    	new google.maps.InfoWindow({
			content: msg
        }).open(marker.getMap(), marker);
    });
};
window.onload = function() {
    $(function(){initialize();});	
};
