/*
This is a Example program to retrieve and display the data. 
Press the Run button on the right of the screen (described the behavior of the Example program below). 
Please create a new application rewrite this program work. 
*/

var all_data;        
function initialize(){
	all_data = new Array();
	// データをLinkDataから取得 
	tmp_a_data = new Array();
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var tmp_data = {}
				tmp_data["NO"] = subjValue;
				$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
						if(propValue == "http://linkdata.org/property/rdf1s8056i#" + encodeURIComponent("名称")){
							tmp_data["name"] = objValue;
						}else if(propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#lat"){
							tmp_data["lat"] = objValue;
						}else if(propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#long"){
							tmp_data["lng"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8056i#" + encodeURIComponent("住所")){
							tmp_data["location"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8056i#" + encodeURIComponent("災害種別_洪水")){
							tmp_data["kou"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8056i#" + encodeURIComponent("災害種別_崖崩れ、土石流及び地滑り")){
							tmp_data["gake"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8056i#" + encodeURIComponent("災害種別_高潮")){
						    tmp_data["takashio"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8056i#" + encodeURIComponent("災害種別_地震")){
						    tmp_data["earthquake"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8056i#" + encodeURIComponent("災害種別_津波")){
							tmp_data["tsunami"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8056i#" + encodeURIComponent("災害種別_大規模な火事")){
							tmp_data["fire"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8056i#" + encodeURIComponent("災害種別_内水氾濫")){
							tmp_data["hanran"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8056i#" + encodeURIComponent("災害種別_火山現象")){
							tmp_data["volcano"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8056i#" + encodeURIComponent("指定避難所との重複")){
						    tmp_data["hinanjyo"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s8056i#" + encodeURIComponent("備考")){
						    tmp_data["appendix"] = objValue;
						}
					});
				});
				tmp_a_data.push(tmp_data);
			});
		});
	});
	//全データ
	all_data = tmp_a_data;

	//地図センター緯度経度の初期値は「野沢温泉村役場」
	var myLatLng = new google.maps.LatLng(36.9230877,138.4405571);
	var myMap = new google.maps.Map(document.getElementById('result'), {
		zoom: 12,
		center: myLatLng,
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		scaleControl: true,
		scrollwheel: true,
		draggable: true
	});
 
	//ポイントの設定
	var latlng;
	var data = new Array();

	for (var i in all_data) {
		//避難所の種類で区分する
		var gmarker = new google.maps.Marker({  
			position: new google.maps.LatLng(all_data[i].lat,all_data[i].lng),       // 緯度・経度は地図の中心  
			title: all_data[i].name,// ツールチップ 
			openInfo:true,
			icon: (all_data[i].genre == "予備" ? "http://labs.google.com/ridefinder/images/mm_20_blue.png" : "http://app.linkdata.org/asset/ce65058e.png"),
			map: myMap  
	 	}); 
		// ウィンドウに表示するデータをつくる
		var spot_info = all_data[i].name + '<small>'
			+ (all_data[i].location != undefined ? ('<br>【住所】' + all_data[i].location) : "")
			+ (all_data[i].kou != undefined ? ('<br>【洪水】〇') : ('<br>【洪水】×'))
			+ (all_data[i].gake != undefined ? ('<br>【崖崩れ、土石流及び地滑り】〇') : ('<br>【崖崩れ、土石流及び地滑り】×'))
			+ (all_data[i].takashio != undefined ? ('<br>【高潮】〇') : ('<br>【高潮】×'))
			+ (all_data[i].earthquake != undefined ? ('<br>【地震】〇') : ('<br>【地震】×'))
			+ (all_data[i].tsunami != undefined ? ('<br>【津波】〇') : ('<br>【津波】×'))
			+ (all_data[i].fire != undefined ? ('<br>【大規模な火事】〇') : ('<br>【大規模な火事】×'))
			+ (all_data[i].hanran != undefined ? ('<br>【内水氾濫】〇') : ('<br>【内水氾濫】×'))
			+ (all_data[i].volcano != undefined ? ('<br>【火山現象】〇') : ('<br>【火山現象】×'))
			+ (all_data[i].hinanjyo != undefined ? ('<br>【指定避難所との重複】〇') : ('<br>【指定避難所との重複】×'))
			+ (all_data[i].apendix != undefined ? ('<br>【備考】' + all_data[i].kou) : "")
			+ '</small>';
		data.push({
			position: new google.maps.LatLng(all_data[i].lat, all_data[i].lng), 
			content: spot_info
		});
		// 地図上にウィンドウで表示
		attachMessage(gmarker, data[i].content);
	}; //for toji 
};//initialize toji

// 地図のマーカーをクリックするとウィンドウを表示する処理
function attachMessage(marker, msg) {
	google.maps.event.addListener(marker, 'click', function(event) {
    	new google.maps.InfoWindow({
			content: msg
        }).open(marker.getMap(), marker);
    });
};
window.onload = function() {
    $(function(){initialize();});	
};
