/*
This is a Example program to retrieve and display the data. 
Press the Run button on the right of the screen (described the behavior of the Example program below). 
Please create a new application rewrite this program work. 
*/
var max = 10;
var category_q_num = 4;
var count = 0;
var correct_num = 0;
var all_q_data;
var q_data;

Array.prototype.shuffle = function() {
    var i = this.length;
    while(i){
        var j = Math.floor(Math.random()*i);
        var t = this[--i];
        this[i] = this[j];
        this[j] = t;
    }
    return this;
}

function initialize(){	
	// 初期化
	count = 0;
	correct_num = 0;
	all_q_data = new Array();
	q_data = new Array();
	
	// データをLinkDataから取得 
	tmp_q_data = new Array();
	$.each(LinkData.getWorks(), function(workKey, workValue) {
	$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
		$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
			var tmp_data = {}
			tmp_data["id"] = subjValue;
			$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
				$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
					if(propValue == "http://linkdata.org/property/rdf1s7943i#question"){
						tmp_data["q"] = objValue;
					}else if(propValue == "http://linkdata.org/property/rdf1s7943i#choice1"){
						tmp_data["c1"] = objValue;
					}else if(propValue == "http://linkdata.org/property/rdf1s7943i#choice2"){
						tmp_data["c2"] = objValue;
					}else if(propValue == "http://linkdata.org/property/rdf1s7943i#choice3"){
						tmp_data["c3"] = objValue;
					}else if(propValue == "http://linkdata.org/property/rdf1s7943i#choice4"){
						tmp_data["c4"] = objValue;
					}else if(propValue == "http://linkdata.org/property/rdf1s7943i#answer"){
						tmp_data["a"] = objValue;
					}else if(propValue == "http://linkdata.org/property/rdf1s7943i#category"){
						tmp_data["category"] = objValue;
					}else if(propValue == "http://linkdata.org/property/rdf1s7943i#kaisetsu"){
						tmp_data["detail"] = objValue;
					}
				});
			});
			tmp_q_data.push(tmp_data);
		});	
	});
	});			
	all_q_data = tmp_q_data;
	
	// TODO: カテゴリごとに出題する問題を10問選ぶ
	var data_h = new Array();
	var data_c = new Array();
	var data_l = new Array();
	all_q_data.forEach(function(e, i, a){
		if(e.category == "社会"){
			data_h.push(e);
		}else if (e.category == "神社・仏閣"){
			data_c.push(e);
		}else if (e.category == "文化"){
			data_l.push(e);
		}
	});
	var selected_h = random(data_h, category_q_num);
	var selected_c = random(data_c, category_q_num);
	var selected_l = random(data_l, category_q_num);
	[].push.apply(q_data, selected_h);
	[].push.apply(q_data, selected_c);
	[].push.apply(q_data, selected_l);
	q_data = q_data.shuffle();
	
	$("#contents").empty();
	var intro = "<div id='introduction'><H1>千駄ヶ谷クイズ</H1><H3>あなたの千駄ヶ谷の知識力をチェック！</H3><div><div>下のボタンを押して<br/>検定をはじめましょう。</div><div class='button'><input type='submit' value='スタート' onclick='next();'/></div></div></div>";
	$("#contents").append(intro);
}

function next(){
                $("#contents").empty();
                if(count < max){
                    count++;
                    var tmp_q = q_data[count-1];                    
                    var q = $("<div id='question'>"); 
                    var c = $("<h1>第<span id='count'>"+count+"</span>問</h1>");
                    var h3 = $("<h3>"+tmp_q.q+"</h3>");
                    var choices = $("<div id='choices'/>"); 
                    var choice = [$("<div><input type='radio' name='answer' value='1'>"+tmp_q.c1+"</div>"),$("<div><input type='radio' name='answer' value='2'>"+tmp_q.c2+"</div>"),$("<div><input type='radio' name='answer' value='3'>"+tmp_q.c3+"</div>"),$("<div><input type='radio' name='answer' value='4'>"+tmp_q.c4+"</div>")];
                    choice.forEach(function(e, i, a){
                        choices.append(e);        
                    });
                    var checkbtn = $("<div class='button'><input type='submit' value='解答' onclick='check()'></div>");

                    q.append(c);
                    q.append(h3);
                    q.append(choices);
                    q.append(checkbtn);
					$("#contents").append(q);
                }else{
                    finish();
                }  
}
            function check(){
				// 解答が選択されているかチェック
				if ($("input:radio[name='answer']:checked").val()){
	                // 正解をチェック
                	var flg = false;
					var user_a = $("input:radio[name='answer']:checked").val();
                	var a_idx = q_data[count-1].a;
					var a_str = q_data[count-1]["c"+a_idx]
					if (user_a == a_idx){
						flg = true
					}
                	var detail_url = q_data[count-1].detail;
					
					$("#contents").empty(); 
                	var a = $("<div id='answer'/>"); 
                	a.append("正解は，「<span id='correct_answer'>"+a_str+"</span>」です！");
                
                	if(flg){
                    	a.append("<div id='correct'>○</div>");
                    	correct_num++; 
                	}else{
                   		a.append("<div id='wrong'>×</div>");
                	}
                    if(detail_url.match(/(http|ftp):\/\/[!#-9A-~]+\.+[a-z0-9]+/i)){
                	a.append("<div id='detail'>詳しい解説は下のリンクからどうぞ．<br/><a href='"+detail_url+"' target='_blank'>"+detail_url+"</a></div>");
					}else{
                	a.append("<div id='detail'>＜出典＞<br/>"+detail_url+"</div>");
					}
                
                	if (count < max){
                	    a.append("<div class='button'><input type='button' value='次の問題へ' onclick='next()'></div>");
            	    }else{
        	            a.append("<div class='button'><input type='button' value='最終結果' onclick='finish()'></div>");
    	            }
	                $("#contents").append(a);

				}else{
					alert("解答を選択してください");
				}
            }

function finish(){
	// TODO: レベル分け or タイプ分けをして結果を表示する
	var message;
	if (correct_num >= 10){
		message = "<h1>合格!</h1>あなたの千駄ヶ谷の知識力、すばらしいですね！<br/>ぜひ千駄ヶ谷の魅力を色んな人に<br/>伝えてください。";
	}else if (correct_num >= 8 && correct_num < 10){
		message = "<h1>合格!</h1>さすが、よくご存知ですね。<br/>これからももっと千駄ヶ谷を<br/>楽しんでください。";
	}else if (correct_num >= 5 && correct_num < 8){
		message = "<h1>惜しい！</h1>もう少しで合格です。<br/>さらに上を目指して、資料館や博物館で<br/>学んでみてください。";
	}else{
		message = "<h1>がんばろう</h1>とりあえず千駄ヶ谷で食べて遊んで<br/>千駄ヶ谷を好きになってください。";
	}
	
	$("#contents").empty(); 
	$("#contents").append("<div id='result'><h3>検定結果</h3><h2><span id='correct_num'>"+max+　"問中 "+correct_num+"問 </span>正解</h2><div class='message'>"+message+"</div></div>");
	$("#contents").append("<div class='button'><input type='button' value='もう一度挑戦する' onclick='initialize()'></div>");
}

window.onload = function() {
    $(function(){
    	initialize();        
    });	
};

function random(array, num) {	// http://d.hatena.ne.jp/miya2000/20080607/p0
    var a = array;
    var t = {};
    var r = [];
    var l = a.length;
    var n = num < l ? num : l;
    while (n-- > 0) {
        var i = Math.random() * l | 0; // http://d.hatena.ne.jp/amachang/20070813/1186980089
        r[n] = t[i] || a[i];
        --l;
        t[i] = t[l] || a[l];
    }
    return r;
}
