/*
This is a Example program to retrieve and display the data. 
Press the Run button on the right of the screen (described the behavior of the Example program below). 
Please create a new application rewrite this program work. 
*/

var all_data;        
function initialize(){
	all_data = new Array();
	// データをLinkDataから取得 
	tmp_a_data = new Array();
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var tmp_data = {}
				tmp_data["id"] = subjValue;
				$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
						if(propValue == "http://imi.ipa.go.jp/ns/core/rdf#名称"){
							tmp_data["name"] = objValue;
						}else if(propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#lat"){
							tmp_data["lat"] = objValue;
						}else if(propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#long"){
							tmp_data["lng"] = objValue;
						}else if(propValue == "http://imi.ipa.go.jp/ns/core/rdf#住所"){
							tmp_data["location"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s7532i#" + encodeURIComponent("利用時間")){
							tmp_data["genre"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s7532i#" + encodeURIComponent("利用日")){
						    tmp_data["capacity"] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s7532i#" + encodeURIComponent("備考")){
							tmp_data["area"] = objValue;
						}
					});
				});
				tmp_a_data.push(tmp_data);
			});
		});
	});
	//全データ
	all_data = tmp_a_data;

	//地地図センター緯度経度の初期値は「燕市役所」
	var myLatLng = new google.maps.LatLng(37.673215,138.882446);
	var myMap = new google.maps.Map(document.getElementById('result'), {
		zoom: 12,
		center: myLatLng,
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		scaleControl: true,
		scrollwheel: true,
		draggable: true
	});
 
	//ポイントの設定
	var latlng;
	var data = new Array();

	for (var i in all_data) {
		var gmarker = new google.maps.Marker({  
			position: new google.maps.LatLng(all_data[i].lat,all_data[i].lng),       // 緯度・経度は地図の中心  
			title: all_data[i].name,// ツールチップ 
			openInfo:true,
			icon: (all_data[i].genre == "予備" ? "http://labs.google.com/ridefinder/images/mm_20_blue.png" : "http://app.linkdata.org/asset/24dafff0.jpg"),
			map: myMap  
	 	}); 
		// ウィンドウに表示するデータをつくる
		var spot_info = all_data[i].name + '<small>'
			+ (all_data[i].location != undefined ? ('<br>【住所】' + all_data[i].location) : "")
			+ (all_data[i].genre != undefined ? ('<br>【利用時間】' + all_data[i].genre) : "")
			+ (all_data[i].capacity != undefined ? ('<br>【利用日】' + all_data[i].capacity) : "")
			+ (all_data[i].area != undefined ? ('<br>【備考】' + all_data[i].area) : "")
			+ '</small>';
		data.push({
			position: new google.maps.LatLng(all_data[i].lat, all_data[i].lng), 
			content: spot_info
		});
		// 地図上にウィンドウで表示
		attachMessage(gmarker, data[i].content);
	}; //for toji 
};//initialize toji

// 地図のマーカーをクリックするとウィンドウを表示する処理
function attachMessage(marker, msg) {
	google.maps.event.addListener(marker, 'click', function(event) {
    	new google.maps.InfoWindow({
			content: msg
        }).open(marker.getMap(), marker);
    });
};
window.onload = function() {
    $(function(){initialize();});	
};
