var LV = LV || {};
// ※テーブルの項目名とプロパティの対応の設定
LV.property = [
	["施設名称", "施設名称"],
	["区", "区"],
	["施設種別", "施設種別"],
	["種別", "種別"],	
	["エコ保育所", "エコ保育所"],
	["設置者名", "設置者名"],
	["施設所在地", "施設所在地"],
	["最寄りの交通機関", "最寄りの交通機関"],
	["保育方針", "保育方針"],
	["主な行事", "年間の主な行事"],
	["保育サービス", "独自の保育サービスと保育料以外の保護者負担"],
	["保護者との約束事", "保護者との約束事"]
]
window.onload = function() {
	$("#result").append("<table class='display' id='data_list'></table>" );
	var colList=[];
	$('#data_list').dataTable({
		"aoColumns": setColName(colList),
		"asSorting": [[0,"desc"]],
		"bJQueryUI": true,
		"bAutoWidth": false,
		"bJQueryUI": true,
		
		/* 空の値が来たらハイフン表示（alert対策） */
		"columnDefs": [{
   			 "defaultContent": "-",
			"targets": "_all"
		}],
		/* 日本語化 */
		"language": {
  			"emptyTable" : "データが登録されていません。",
  			"info" : "_TOTAL_ 件中 _START_ 件から _END_ 件までを表示",
			"infoEmpty" : "",
			"infoFiltered" : "(_MAX_ 件からの絞り込み表示)",
			"infoPostFix" : "",
			"thousands" : ",",
			"lengthMenu" : "1ページあたりの表示件数: _MENU_",
			"loadingRecords" : "ロード中",
			"processing" : "処理中...",
			"search" : "検索：",
			"zeroRecords" : "該当するデータが見つかりませんでした。",
			"paginate" : {
				"first" : "先頭",
				"previous" : "前へ",
				"next" : "次へ",
				"last" : "末尾"
			}
		}

	});
	
	/* LinkDataからデータを取得 */
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		var propList = stringToUri(LV.property, workValue);
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var dataList = [];
				
				/* その他の列のデータを取得 */
				$.each( LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					$.each (propList, function(i, propUri){
						if (propUri == propValue) {
							var objList = [];
							$.each( LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objkey, objValue) {
								objList.push(objValue);
							});
							dataList[i] = objList.toString();
						}
					});
				});
				/* テーブルにデータを追加 */
				$('#data_list').dataTable().fnAddData(dataList);
			});
		});
	});
}
/* プロパティがリテラルで指定された場合にURIに変換 */
function stringToUri (p, workId) {
	var arr = [];
	$.each (p, function(){
		if(this[1].indexOf("http") != 0){
			arr.push("http://linkdata.org/property/" + workId + "#" + encodeURIComponent(this[1]));
		} else {
			arr.push(this[1]);
		}
	})
	return arr;
}
/* カラム名を設定 */
function setColName(arr) {
	$.each(LV.property, function(){
		var col = {};
		col.sTitle = this[0];
		arr.push(col);
	})
	return arr;
}
