/**************************************/
/*****逆マッシュアップ用設定**************/
/*
「入力データ」タブから、位置情報付きの任意のデータに
差し替えるだけでマッピングが反映されます。
（※1つデータに複数データある場合は、1つだけ選択してください）
*/
var	
	//表示させたい項目の「テキスト文字」と「列番号」
	lists = [
		"名称：", 3,
		"住所：", 4,
		"利用時間：", 6,
		"休日：", 7,
		"SSID：", 9
	];
/*************************************/
/*************************************/


   
//データの取得
var topTitle = document.getElementById('topTitle');
var workId = LinkData.getWorks();
var workName = LinkData.getWorkName(workId);
var fileName = LinkData.getFiles(workId);
var subjects = LinkData.getSubjects(workId, fileName);
var markers = [];
var infoList = {};
var infoState = null;


//タイトル生成
topTitle.textContent = fileName;


//データオブジェクト生成
for(var subject in subjects) {
	infoList[subject] = LinkData.getTriplesBySubject(workId, fileName, subjects[subject]);
}






//************マップ生成処理****************************************
var mapBox = document.getElementById('mapBox');
for(var i=0; i<infoList[1].length; i++) {
	var lat = infoList[1][i].property.indexOf('#lat');
	var lat2 = infoList[1][i].property.indexOf('#latitude');
	var lat3 = infoList[1][i].property.indexOf('#%E7%B7%AF%E5%BA%A6');
	if(lat > 0 || lat2 > 0 || lat3 > 0) {
		var latlng = new google.maps.LatLng(infoList[1][i].object, infoList[1][i+1].object);
		createMarker(latlng, map, item);
	}
}

var mapOptions = {
	zoom: 14,
	center: latlng,
	mapTypeControl: false,
	mapTypeId: google.maps.MapTypeId.TERRAIN,
	scrollwheel: false
};
var map = new google.maps.Map(mapBox, mapOptions);


//マーカーの配置処理
for (var item in infoList) {
	for(var i=0; i<infoList[item].length; i++) {
		var lat = infoList[item][i].property.indexOf('#lat');
		var lat2 = infoList[item][i].property.indexOf('#latitude');
		var lat3 = infoList[item][i].property.indexOf('#%E7%B7%AF%E5%BA%A6');
		if(lat > 0 || lat2 > 0 || lat3 > 0) {
			var latlng = new google.maps.LatLng(infoList[item][i].object, infoList[item][i+1].object);
			createMarker(latlng, map, item);
		}
	}
}

function createMarker(latlng, map, item) {
  var infoWindow = new google.maps.InfoWindow();
  var marker = new google.maps.Marker({
    position: latlng,
    map: map
  });
	//クリックイベント処理
  google.maps.event.addListener(marker, 'click', function() {
	  if(infoState) {
	  	infoState.close();
	  }
    infoWindow.setContent(getInfo(item));
    infoWindow.open(map, marker);
	infoState = infoWindow;
  });
}

//表示項目の生成
function getInfo(data) {
	var dataList = "<ul style='list-style-type: none;'>";
	for(var i=0; i<lists.length;i+=2) {
		dataList += "<li>" + lists[i] + infoList[data][lists[i+1]].object + "</li>";
	}
	dataList += "</ul>";
	
	return dataList;
}




/*********************************************************/
/*********JavaScriptでの各種データ取得API一覧***********/
/*
１，workIdの取得
LinkData.getWorks()

２，workNameの取得(データ名)
LinkData.getWorkName(workId)

３，fileNameの取得(データファイル名)
LinkData.getFiles(workId)

４，property(データの縦軸)のリストを取得
LinkData.getProperties(workId, fileName)

５，property毎のデータ取得
LinkData.getTriplesByProperty(workId, fileName, property)

６，subject(データの横軸)のリストを取得
LinkData.getSubjects(workId, fileName)

７，subject毎のデータ取得
LinkData.getTriplesBySubject(workId, fileName, subject)

８，全データの取得
LinkData.getTriples(workId, fileName)
*/


/********データ取得例*****************************/
//subject毎のデータ取得
/*
for(var subject in subjects) {
	var subjectList = LinkData.getTriplesBySubject(workId, fileName, subjects[subject])
		for(var item in subjectList) {
			console.log(subjectList[item]);
		}
}
*/

//property毎のデータ取得
/*
for(var property in properties) {
	var propertyList = LinkData.getTriplesBySubject(workId, fileName, properties[property])
		for(var item in propertyList) {
			console.log(propertyList[property]);
		}
}
*/
/***********************************************************/
