/*
This is a Example program to retrieve and display the list of the data. Press the play/reload button on the right of the upper screen, and the program is executed. The program first displayes the subjects that match the keyword completely. The program highlights the list fragments that match the keyword. The keyword is retrieved from the query following "subject=" in the URL, where the keyword must be encoded. Please create a new application by rewriting this program work. The following is the same content in Japanese.
このサンプルプログラムはデータを取得してリスト表示します。画面右上のplay又はreloadボタンを押すとプログラムが実行されます。プログラムはキーワードに完全一致するサブジェクトを最初に表示します。またプログラムはキーワードに部分一致するリスト中の部分をハイライトします。キーワードはURLの中で"subject="に続くクエリーから取得されます。ただし、キーワードはURIエンコードされている必要があります。このプログラムを書き変えて新しいアプリケーションを作成してください。
*/

window.onload = function() {
	var keyword = getParameterFromURL("subject"); // obtain keyword from the URL "?subject="
	var list = ""; // list to be displayed
	var line_data = new Array();
	// Work loop
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		$("#result").append("<h3>" + LinkData.getWorkName(workValue) + "</h3>");
		line_data[0] = "章";
		line_data[1] = "分類";
		line_data[2] = "表";
		line_data[3] = "表（再詳細化後）";
		line_data[4] = "データセット情報へのリンク";
		line_data[5] = "ファイル名";
		list = "<tr><td>" + line_data[0] + "</td><td>" + line_data[1] + "</td><td>" + line_data[2] + "</td><td>" + line_data[3] + "</td><td>" + line_data[4] + "</td><td>" + line_data[5] + "</td></tr>";
		line_data[0] = "";
		line_data[1] = "";
		line_data[2] = "";
		line_data[3] = "";
		line_data[4] = "";
		line_data[5] = "";
		$("#result").append( list );
		// File loop
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			var hit = ""; // list of subjects whose URI matches keyword
			var nHit = 0; // number of subjects whose URI matches keyword
			list += "<hr><h4>Viewing file: " + fileValue + "</h4>";
			// Subject loop
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				//list = "123";
				//list += " ";
				//list += "</h4>";
				//$("#result").append( list );
				//list += "<hr><h4>subjValue: " + subjValue + "</h4>";
				//$("#result").append( list );
				$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					list = "";
					$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
						if(propValue == "http://linkdata.org/property/rdf1s3986i#Class"){
							//list += "<hr><h4>"
							//list += objValue;
							//list += " ";
							line_data[0] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s3986i#FirstName"){
							//list += objValue;
							//list += " ";
							line_data[1] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s3986i#SecondName"){
							//list += objValue;
							//list += " ";
							line_data[2] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s3986i#TableName"){
							//list += objValue;
							//list += " ";
							line_data[3] = objValue;
						}else if(propValue == "http://linkdata.org/property/rdf1s3986i#DataSet"){
							if(objValue == "-"){
								//list += "- ";
								//list += "<br>";
								line_data[4] = "-";
							}else{
								//list += "<a href=\"" + objValue + "\" target=\"_blank\"><span class=\"object\">" + shortenURL(objValue) + "</span></a>";
								//list += " ";
								//list += "<br>";
								line_data[4] = "<a href=\"" + objValue + "\" target=\"_blank\"><span class=\"object\">" + shortenURL(objValue) + "</span></a>";
							}
						}else if(propValue == "http://linkdata.org/property/rdf1s3986i#FileName"){
							if(objValue == "-"){
								//list += "- ";
								//list += "<br>";
								line_data[5] = "-";
							}else{
								//list += "<a href=\"" + objValue + "\" target=\"_blank\"><span class=\"object\">" + shortenURL(objValue) + "</span></a>";
								//list += " ";
								//list += "<br>";
								line_data[5] = objValue;
							}
						}
					});
				});
				list = "<tr><td>" + line_data[0] + "</td><td>" + line_data[1] + "</td><td>" + line_data[2] + "</td><td>" + line_data[3] + "</td><td>" + line_data[4] + "</td><td>" + line_data[5] + "</td></tr>";
				$("#result").append( list );
				line_data[0] = "";
				line_data[1] = "";
				line_data[2] = "";
				line_data[3] = "";
				line_data[4] = "";
				line_data[5] = "";
				list = "";
			});
		});
	});
//var derivers = $.pivotUtilities.derivers;
//line_data[0] = "12345";
//line_data[1] = "12345";
//line_data[2] = "12345";
//list = "<tr><td>" + line_data[0] + "</td><td>" + line_data[1] + "</td><td>" + line_data[2] + "</td></tr>";
//$("#result").append( list );
//line_data[0] = "999";
//line_data[1] = "99";
//line_data[2] = "9999";
//list = "<tr><td>" + line_data[0] + "</td><td>" + line_data[1] + "</td><td>" + line_data[2] + "</td></tr>";
//$("#result").append( list );
//line_data[0] = "999999";
//line_data[1] = "99";
//line_data[2] = "9999999";
//list = "<tr><td>" + line_data[0] + "</td><td>" + line_data[1] + "</td><td>" + line_data[2] + "</td></tr>";
//$("#result").append( list );
//$("#output").pivotUI(line_data, {
//rows: ["保育所名"],
//cols: ["児童年齢"],
//vals:["児童人数"],
//aggregatorName:"sum",
//effectsName: "Heatmap"
//});
$("#result").append( list );
window.find(highlight);
};

// Get a parameter value in URL (e.g. ?paramString=value )
function getParameterFromURL( paramString )
{			
	var value = "";
	var topWindow = top.window.location.search;
	if( topWindow ){
		var q = decodeURIComponent(topWindow.substring(1,topWindow.length)).split("&");
		for ( var i = 0; i < q.length; i++ ){
			var r = q[i].split("=");
			if ( r[0] ==  paramString )
				value = r[1];
		}
	}
 	return value;
}

// Highlight keyword in the string
function highlight( string, keyword )
{
	if ( keyword.length > 0 ) {
		var ss = string.split(keyword);
		var len = ss.length;
		if ( len > 1 ) {
			string = ss[0];
			for ( i = 1; i < len; i++ )
//				string += "<font color=\"red\">"+keyword+"</font>"+ss[i];
				string += "<span class=\"highlight\">"+keyword+"</span>"+ss[i];
		}
	}
	return string;
}

// get the last name of the string separated with # and /
function getLastName( string )
{
	string = decodeURIComponent(string);
	var sharp = string.split("#");
	var slash = sharp[sharp.length-1].split("/");
	var lastName = slash[slash.length-1];
	return lastName;
}

// return a link to Google map search
function addLinkToMap( latitude, longitude )
{
	var s = "<br><a target=\"_blank\" href=\"http://www.google.com/maps/?q=" + latitude + "," + longitude + "\">Show map</a>";
	return s;
}

// shortening URL e.g. http://.../123.jpg
function shortenURL( url )
{
	url = decodeURIComponent(url);
	var slash = url.split("/");
	var lastName = slash[slash.length-1];
	return url.split(":")[0]+"://.../"+lastName;
}
