window.onload = function() {
	$(function() {
		initialize();
	});	
};

function initialize() {
	var allFacilities = new Array();

	// fetch data from LinkData
	// refer to databaseAddr
	LinkData.getWorks().forEach(function(workValue) {
		LinkData.getFiles(workValue).forEach(function(fileValue) {
			LinkData.getSubjects(workValue, fileValue).forEach(function(subjValue) {
				var tmpFacility = {}
				tmpFacility.urlId = subjValue;
				LinkData.getProperties(workValue, fileValue).forEach(function(propValue) {
					LinkData.getObjects(workValue, fileValue, subjValue, propValue).forEach(function(objValue) {
						var databaseAddr = propValue.replace(/#.*$/, '');
						switch (propValue) {
							case databaseAddr + "#" + encodeURIComponent("name"):
								tmpFacility.name = objValue;
								break;
							case databaseAddr + "#" + encodeURIComponent("address_main"):
								tmpFacility.addr = objValue;
								break;
							case databaseAddr + "#" + encodeURIComponent("tel"):
								tmpFacility.tel = objValue;
								break;
							case databaseAddr + "#" + encodeURIComponent("capacity"):
								tmpFacility.capacity = objValue;
								break;
							case databaseAddr + "#" + encodeURIComponent("age"):
								tmpFacility.acceptableAge = objValue;
								break;
							case "http://www.w3.org/2003/01/geo/wgs84_pos#lat":
								tmpFacility.lat = objValue;
								break;
							case "http://www.w3.org/2003/01/geo/wgs84_pos#long":
								tmpFacility.lng = objValue;
								break;
						}
					});
				});
				allFacilities.push(tmpFacility);
			});
		});
	});
	
	// set the center latitude and longitude on map.
	// default is Nagano City Office.
	var myLatLng = new google.maps.LatLng(36.648529,138.194672); // Nagano City Office
	var myMap = new google.maps.Map(document.getElementById('result'), {
		zoom: 14,
		center: myLatLng,
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		scaleControl: true,
		scrollwheel: true
	});

	// show all facilities
	allFacilities.forEach(function(data) {
		var spotName          = data.name;
		var spotAddr          = data.addr;
		var spotTel           = (data.tel)           ? "Tel：" + data.tel                  : null;
		var spotCapacity      = (data.capacity)      ? "定員：" + data.capacity + "人"      : null;
		var spotAcceptableAge = (data.acceptableAge) ? "受け入れ年齢：" + data.acceptableAge : null;
		var spotPos  = new google.maps.LatLng(data.lat,data.lng);
		var googleMarker = new google.maps.Marker({
			position: spotPos,
			title: spotName,
			openInfo: true,
			icon: "http://labs.google.com/ridefinder/images/mm_20_blue.png", // pointer image
			map: myMap
		});

		// content to show on window
		var content = [spotName, spotAddr, spotTel, spotCapacity, spotAcceptableAge]
			.filter(function(elem) {
				return elem != null && elem != undefined;
			})
			.join('<br>')

		// show content on google map by a window
		attachMessage(googleMarker, content);
	});
};

// show content on google map by a window, if a marker clicked
function attachMessage(googleMarker, msg) {
	google.maps.event.addListener(googleMarker, 'click', function(event) {
		var infoWindow = new google.maps.InfoWindow({
			content: msg
		})
		infoWindow.open(googleMarker.getMap(), googleMarker);
	});
};



