DrawWordCloud = {};
DrawWordCloud.propList = ["政治家を志した理由", "地域のありたい姿", "解決したい課題"];
DrawWordCloud.keyProp = "政治家名";
DrawWordCloud.areaProp = "対象の市区町村または都道府県";
DrawWordCloud.area = "海老名市";
DrawWordCloud.sourceURL = "http://www.maniken.jp/id#";
DrawWordCloud.manifestURL = "http://manifestoswitchebina.strikingly.com/";
DrawWordCloud.subList = [];
DrawWordCloud.workID = "";
DrawWordCloud.fileName = "";

$(function(){
	DrawWordCloud.loadInputData();

	$("#generate").click(function() {
		var sub = "";
		var propList = [];
		$("#wordcrowd, #original").empty();
		if ($('#subjects').val() != "all") {
			sub = $('#subjects').val();
		}
		$('.property:checked').each(function(){
			propList.push($(this).val());
		});
		var str = DrawWordCloud.getData(DrawWordCloud.workID, DrawWordCloud.fileName, sub, propList);
		DrawWordCloud.analyze(str);
	});
});

DrawWordCloud.loadInputData = function() {
	var pList=[];
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		DrawWordCloud.workID = workValue;
		var workURl = "http://linkdata.org/work/" + workValue;
		var keyPropURI = "http://linkdata.org/property/" + workValue + "#" +encodeURIComponent(DrawWordCloud.keyProp);
		var areaPropURI = "http://linkdata.org/property/" + workValue + "#" +encodeURIComponent(DrawWordCloud.areaProp);
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			DrawWordCloud.fileName = fileValue;
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				$.each( LinkData.getTriplesBySubject(workValue, fileValue, subjValue), function( tripleKey, tripleValue ) {
					if ( tripleValue.property == keyPropURI &&
							LinkData.getObjects(workValue , fileValue , subjValue , areaPropURI) == DrawWordCloud.area) {
						var subMap = {uri:subjValue, label:tripleValue.object};
						DrawWordCloud.subList.push(subMap);
					}
				});
			});
		});
	});
	$.each(LinkData.getProperties(DrawWordCloud.workID, DrawWordCloud.fileName), function(propKey, propValue){
		pList.push(propValue);
	});
	DrawWordCloud.initPreference(DrawWordCloud.subList, pList);
};

DrawWordCloud.initPreference = function(sList, pList){
	// サブジェクトのセレクトボックス初期化
	$.each(sList, function(subKey, subValue) {
		var $option = "<option value=\"" + subValue.uri + "\">"+ subValue.label +"</option>";
		$("#subjects").append($option);
	});
	// プロパティのチェックボックス初期化
	$.each(pList, function(index, propURI) {
		var decode = decodeURIComponent(propURI);
		var sharp = decode.split("#");
		var slash = sharp[sharp.length-1].split("/");
		var propName = slash[slash.length-1];
		$.each(DrawWordCloud.propList, function(i, prop) {
			if (propName == prop) {
				var $input = $('<input type="checkbox" />').attr({value: propURI}).attr({name: propName}).attr({class: "property"});
				var $label = $('<label for="'+ propName +'">'+ propName +'</label>');
				$("#properties").append($input).append($label);
			}
		});
	});
};

DrawWordCloud.getData = function(work, file, sub, prop) {
	var originalStr="";
	$.each (prop, function(i, propValue) {
		if (sub == ""){
			$.each(DrawWordCloud.subList, function(sbjKey, subjValue) {
				originalStr += " " + LinkData.getObjects(work, file, subjValue.uri, propValue);
			});
		} else {
			originalStr += " " + LinkData.getObjects(work, file, sub, propValue);
		}
	});
	var subStr = sub.split("#");
	var subValue = subStr[subStr.length-1];
	var url = DrawWordCloud.sourceURL + subValue;
	if (sub == ""){
		$("#seeManifest").attr("href", DrawWordCloud.manifestURL).text("→マニフェストを見る");
	} else {
		$("#seeManifest").attr("href", url).text("→マニフェストを見る");
	}
	var inputStr = originalStr.substr(0,900); // APIの字数制限対策
	$("#original").append('<p id="props"><b>元の文章</b>：' + inputStr + '</p>');
	return inputStr;
};

DrawWordCloud.analyze = function(str) {
	// 日本語形態素解析API http://140note.hitonobetsu.com/apipage/mp
	$.ajax({
	    type: 'POST',
		url: 'http://api.hitonobetsu.com/mp/analysis',
		dataType: 'jsonp',
		crossDomain: true,
		data: {
	        str: str
		}
	})
	.done(function(data) {
		DrawWordCloud.createNounList(data);
	})
	.fail(function() {
		alert("形態素解析に失敗しました。時間を置いてお試し下さい。");
	});
};

DrawWordCloud.createNounList = function (data) {
	var list = [];
	var table = [];
	// 名詞のうち、意味のあるもののみ抽出
	$.each(data, function(i, result) {
		if (result.part == '名詞' && result.subtyping1 != ("非自立" || "代名詞" || "接尾")) {
			list.push(result.surface);
		}
	});
	// 頻度表作成
	$.each(list, function(i, noun) {
		var array = {};
		var counter = 0;
		if (!(noun == null || DrawWordCloud.checkDuplicate(table, noun) == true)) {
			$.each(list, function(j, value) {
				if (noun == value) {
					counter++;
				}
			});
			array = {word:noun, count:counter};
			table.push(array);
		}
	});
	DrawWordCloud.generate(table);
};

DrawWordCloud.checkDuplicate = function(array, str){
	var bool = new Boolean(false);
	if (array.length > 0){
		array.filter(function(item, index){
		  if (item.word == str) bool=true;
		});
	}
    return bool;
};

DrawWordCloud.generate = function(data) {

	var layout_width = 500;
	var layout_height = 500;
	var random = d3.random.irwinHall(2);
	var countMax = d3.max(data, function(d){ return d.count; });
	var sizeScale = d3.scale.linear().domain([0, countMax]).range([10, 100]);

	var words = data.sort(function(a, b) {
        	return (a.count > b.count) ? -1 : 1; // 頻出カウントで降順ソート
    	})
		.map(function(d) {
		return {
			text: d.word,
			size: sizeScale(d.count) //頻出カウントを文字サイズに反映
		};
	});
	d3.layout.cloud().size([layout_width, layout_height])
		.words(words)
		.timeInterval(10)
		.rotate(function() { return Math.round(1-random()) *90; }) //ランダムに文字を90度回転
		.font("Impact")
		.fontSize(function(d) { return d.size; })
		.on("end", draw) //描画関数の読み込み
		.start();

	//wordcloud 描画
	  function draw(words) {
		var fill = d3.scale.category20();
	    d3.select("#wordcrowd").append("svg")
	        .attr("width", layout_width)
	        .attr("height", layout_height)
	      .append("g")
	        .attr("transform", "translate(250,250)")
	      .selectAll("text")
	        .data(words)
	      .enter().append("text")
	        .style("font-size", function(d) { return d.size + "px"; })
	        .style("font-family", "Impact")
	        .style("fill", function(d, i) { return fill(i); })
	        .attr("text-anchor", "middle")
	        .attr("transform", function(d) {
	          return "translate(" + [d.x, d.y] + ")rotate(" + d.rotate + ")";
	        })
	        .text(function(d) { return d.text; });
	  }
};
