MotifMinCircadian = function(containerId, options) {
	new Application.motifMinCircadian(containerId, options);
};

if (Application === "undefined" || !Application) {
	var Application = {};
}


// Application.motifMinCircadian method
Application.motifMinCircadian = function() {
	this._init.apply(this, arguments);
};

Application.motifMinCircadian.prototype = {
	
	// Initialization
	_containerId : null,
	_baseSequence : null,
	_options : null,
	_motifProperty : null,
	_heptamer : null,
	_octamer : null,
	_appSequence : null,
	_filteredSubjectList : null,
	_motifViewDialogId : null,
	
	_default : {
		appName : "MotifMinCircadian",
		selectRangeCaption : "Select Range",
		selectPropertyAreaClass : "selectPropertyArea",
		selectPropertyClass : "selectProperty",
		resultAreaClass : "resultArea",
		replaceButtonAreaClass : "replaceButtonArea",
		replaceButtonClass : "replaceButton",
		nextButtonAreaClass : "nextButtonArea",
		replaceSequenceClass : "replaceSequence",
		errorMessageAreaClass : "errorMessage",
		dialogErrorMessageClass : "dialogErrorMessage",
		dialogOutRangeValueMessage : "Please input a value between {0} and {1}",
		noSequenceForThisRange : "No sequence found for this range",
		databaseInfoClass : "databaseInfo",
		motifSequenceProperty : "motif sequence",
		motifPositionProperty : "motif position",
		sinePhaseProperty : "Sine Phase",
		sineAmplitudeProperty : "Sine Amplitude",
		typeProperty : "type",
		validType : "REG",
		motifViewDialogId : "motifViewDialog",
		motifViewDialogClass : "motifViewDialog",
		motifViewDialogTitle : "Motif View",
		minSequenceClass : "minSeq",
		maxSequenceClass : "maxSeq",
		websiteNameAtted : "ATTED",
		websiteNamePpdb : "PPDB",
		baseSequenceMinLength : 50,
		dialogImageUrl : "http://app.linkdata.org/asset/0aea5a0d.png",
		callback : function() {}
	},
	
	_init : function(containerId, options) {
		this._containerId = containerId;
		this._options = $.extend({}, this._default, options);
		this._baseSequence = this._options.baseSequence;
		this.filteredSubjectList = [];
		this._initMotifProperty(this._options);
		this._initAppSequence(this._options);
		this._initHeptamer();
		this._initOctamer();
		this._initFiltering(this._options);
		this._initView();
		this._initListener();
		this._initMotifViewDialog();
	},
	
	_initMotifProperty : function(opts) {
		var obj = {
			workId : opts.workId,
			fileName : opts.fileName
		};
		this._motifProperty = new Application.motifProperty(obj);
	},
	
	_initAppSequence : function(opts) {
		var seqProperty = this._motifProperty.getPropertyByLabel(this._options.motifSequenceProperty);
		var posProperty = this._motifProperty.getPropertyByLabel(this._options.motifPositionProperty);
		var obj = {
			workId : opts.workId,
			fileName : opts.fileName,
			baseSequence : this._baseSequence,
			motifSequenceProperty : seqProperty,
			motifPositionProperty : posProperty,
			containerId : this._containerId,
			errorMessageClass : this._options.errorMessageAreaClass,
			baseSequenceMinLength : this._options.baseSequenceMinLength
		};
		this._appSequence = new Application.sequence(obj);
	},
	
	_initHeptamer : function() {
		this._heptamer = new Application.heptamer();
	},
	
	_initOctamer : function() {
		this._octamer = new Application.octamer();
	},
	
	_initView : function() {
		this._initMainView();
		this._initDialogView();
	},
	
	_initMainView : function() {
		var self = this;
		var optionArray = this._motifProperty.getOptionArray();
		var sb = [];
		sb[sb.length] = "<div class='" + this._options.selectPropertyAreaClass + " row'>";
		sb[sb.length] = "<div class='label left'>" + this._options.selectRangeCaption + "</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<select class='" + this._options.selectPropertyClass + "'>";
		sb[sb.length] = "<option value='-1'>-- Select Range --</option>";
		sb[sb.length] = "<option value='0-4'>0 to 4</option>";
		sb[sb.length] = "<option value='4-8'>4 to 8</option>";
		sb[sb.length] = "<option value='8-12'>8 to 12</option>";
		sb[sb.length] = "<option value='12-16'>12 to 16</option>";
		sb[sb.length] = "<option value='16-20'>16 to 20</option>";
		sb[sb.length] = "<option value='20-24'>20 to 24</option>";
		sb[sb.length] = "</select>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='" + this._options.resultAreaClass + " hidden'></div>";
		sb[sb.length] = "<div class='" + this._options.replaceButtonAreaClass + " hidden'>";
		sb[sb.length] = "<a class='" + this._options.replaceButtonClass + " btn btn-lightblue'>Replace</a>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='" + this._options.databaseInfoClass + " hidden'></div>";
		sb[sb.length] = "<div class='" + this._options.replaceSequenceClass + " hidden'></div>";
		sb[sb.length] = "<div class='" + this._options.errorMessageAreaClass + " hidden'>error</div>";
		$("#" + this._containerId).append(sb.join(""));
	},
	
	_initDialogView : function() {
		var sb = [], self = this, date = new Date();
		this._motifViewDialogId = "motifViewDialog_id_" + self._containerId;
		sb[sb.length] = "<div id='" + this._motifViewDialogId + "' class='hidden'>";
		sb[sb.length] = "<input type='hidden' class='sequence'>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span>Place motif at position</span>";
		sb[sb.length] = "<input type='text' class='position'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span class='explanation'>Replace with prefer position between ";
		sb[sb.length] = "<span class='minSeq'></span> and <span class='maxSeq'>";
		sb[sb.length] = "</span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span>Number of extra copies</span>";
		sb[sb.length] = "<input type='text' class='extraCopies' value='0'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span>Space between copies (Base Pairs)</span>";
		sb[sb.length] = "<input type='text' class='basePairs' value='0'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='motifImageArea'>";
		sb[sb.length] = "<img src='" + this._options.dialogImageUrl + "'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span class='explanation'>Click ";
		sb[sb.length] = "<a class='moreInfo'>here</a> to see the additional information about motif from " + self._getDataBaseWebsiteName() + " website";
		sb[sb.length] = "</span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span class='dialogErrorMessage errorMessage hidden'></span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		$("#" + this._containerId).append(sb.join(""));
	},
	
	_initFiltering : function(opts) {
		var self = this;
		var seqProperty = self._motifProperty.getPropertyByLabel(opts.motifSequenceProperty);
		var posProperty = self._motifProperty.getPropertyByLabel(opts.motifPositionProperty);
		var typeProperty = self._motifProperty.getPropertyByLabel(opts.typeProperty);
		var tripleList = LinkData.getTriplesByProperty(opts.workId, opts.fileName, seqProperty);
		$.each(tripleList, function(key, value) {
			var validPos = false;
			var validType = true;
			$.each(LinkData.getObjects(opts.workId, opts.fileName, value.subject, posProperty), function(posKey, posValue) {
				var tmpPos = parseInt(posValue);
				if (opts.baseSequenceMinLength < tmpPos && opts.baseSequence.length >= tmpPos) {
					validPos = true;
				}
			});
			$.each(LinkData.getObjects(opts.workId, opts.fileName, value.subject, typeProperty), function(typeKey, typeValue) {
				if (opts.validType !== typeValue) {
					validType = false;
				}
			});
			var valid = validPos && validType;
			if (valid && value.object.length > 0 && $.inArray(value.subject, self.filteredSubjectList) < 0) {
				self.filteredSubjectList.push(value.subject);
			}
		});
	},
	
	_initListener : function() {
		this._initSelectPropertyListener();
		this._initReplaceButtonLitener();
	},
	
	_initSelectPropertyListener : function() {
		var self = this, workId = self._options.workId, fileName = self._options.fileName;
		var property = self._motifProperty.getPropertyByLabel(self._options.sinePhaseProperty);
		$("#" + self._containerId + " ." + self._options.selectPropertyClass).change(function() {
			self._appSequence.hideError();
			$("#" + self._containerId + " ." + self._options.resultAreaClass).show();
			$("#" + self._containerId + " ." + self._options.replaceButtonAreaClass).show();
			$("#" + self._containerId + " ." + self._options.replaceSequenceClass).hide();
			$("#" + self._containerId + " ." + self._options.databaseInfoClass).hide();
			var range = $("option:selected", this).val();
			if (range && range != -1) {
				var triple = self._getMotifMinCircadianTriple(workId, fileName, range);
				if (triple) {
					self._motifMinCircadianSequence(workId, fileName, triple.subject);
					self._initMotifSequenceListener();
				} else {
					self._appSequence._showError(self._options.noSequenceForThisRange);
					$("#" + self._containerId + " ." + self._options.resultAreaClass).hide();
					$("#" + self._containerId + " ." + self._options.replaceButtonAreaClass).hide();
				}
			}
		});
	},
	
	_initReplaceButtonLitener : function() {
		var self = this, workId = self._options.workId, fileName = self._options.fileName;
		$("#" + self._containerId + " ." + self._options.replaceButtonClass).click(function() {
			self._appSequence.hideError();
			$("#" + self._containerId + " ." + self._options.replaceSequenceClass).show();
			var seqs = [];
			$("#" + self._containerId + " .userSequence").each(function() {
				seqs.push($(this).text());
			});
			var seqVal = [];
			$("#" + self._containerId + " .userSequence .hdnSequence").each(function() {
				seqVal.push($(this).val());
			});
			var html = self._appSequence.replace(seqs);
			$("#" + self._containerId + " ." + self._options.replaceSequenceClass).html(html);
			self._showDatabaseInfo(seqVal);
			self._options.callback();
		});
	},
	
	_initMotifSequenceListener : function() {
		var self = this;
		$("#" + self._containerId + " .motifSequence").click(function() {
			$("." + self._options.motifViewDialogClass).hide();
			var parent = $(this).closest('.userSequence');
			var container = $(this).closest('.userSequence');
			var seq = $(parent).find(".hdnSequence").val();
			var pos = $(parent).find(".hdnPosition").val();
			var seqEl = self._getSeqElBySeq(seq);
			var appropriatePos = (seqEl && seqEl.getAppropriatePos()) ? seqEl.getAppropriatePos() : pos;
			self._initSequencePopup(seqEl);
			$("#" + self._motifViewDialogId + " ." + self._options.dialogErrorMessageClass).hide();
			$("#" + self._motifViewDialogId + " .sequence").val(seq);
			$("#" + self._motifViewDialogId + " .position").val(appropriatePos);
			$("#" + self._motifViewDialogId + " .minSeq").html(self._getMinPosition(seq));
			$("#" + self._motifViewDialogId + " .maxSeq").html(self._getMaxPosition(seq));
			self._initPositionInsert(seq, appropriatePos);
			$("#" + self._motifViewDialogId).dialog({title: self._default.motifViewDialogTitle + " - " + seq});
			$("#" + self._motifViewDialogId).dialog("open");
			$("#" + self._motifViewDialogId).closest('.' + self._options.motifViewDialogClass).show();
		});
	},
	
	_initSequencePopup : function(seqEl) {
		var self = this;
		$("#" + self._motifViewDialogId + " .moreInfo").unbind("click");
		var url = (seqEl && seqEl.getExternalUrl()) ? seqEl.getExternalUrl() : "#";
		$("#" + self._motifViewDialogId + " .moreInfo").click(function() {
			var winWidth = 800;
			var winHeight = 800;
			var winLeft = parseInt((screen.availWidth/2) - (winWidth/2));
			var winTop = parseInt((screen.availHeight/2) - (winHeight/2));
			var winStyle = "width=" + winWidth + ",height=" + winHeight + ",left=" + winLeft + ",top=" + winTop + ",screenX=" + winLeft + ",screenY=" + winTop + ",scrollbars=1";
			window.open(url, "Motif", winStyle);
		});
	},
	
	_initPositionInsert : function(seq, pos) {
		var self = this;
		var mod = seq.length % 2;
		$("#" + self._motifViewDialogId + " .position").unbind("keyup");
		$("#" + self._motifViewDialogId + " .position").keyup(function() {
			var val = $(this).val();
			if (isNaN(val)) {
				$(this).val(pos);
				return;
			}
			var tmpVal = new String(val);
			if (mod == 0) {
				if (tmpVal.indexOf(".") == -1) {
					$(this).val(tmpVal + ".5");
				} else {
					$(this).val(tmpVal.split(".")[0] + ".5");
				}
			} else {
				if (tmpVal.indexOf(".") > -1) {
					$(this).val(tmpVal.split(".")[0]);
				}
			}
		});
	},
	
	_initMotifViewDialog : function() {
		var self = this;
		$("#" + self._motifViewDialogId).dialog({
			autoOpen: false,
			title: self._default.motifViewDialogTitle,
			width: 520,
			dialogClass : self._options.motifViewDialogClass,
			buttons : [
				{
					text: "Replace",
					click : function() {
						var seq = $("#" + self._motifViewDialogId).find(".sequence").val();
						var pos = $("#" + self._motifViewDialogId).find(".position").val();
						var extraCopies = parseInt($("#" + self._motifViewDialogId).find(".extraCopies").val());
						var basePairs = parseInt($("#" + self._motifViewDialogId).find(".basePairs").val());
						var minPos = parseFloat($("#" + self._motifViewDialogId).find(".minSeq").html());
						var maxPos = parseFloat($("#" + self._motifViewDialogId).find(".maxSeq").html());
						if (minPos > pos || maxPos < pos) {
							$dialogError = $("#" + self._motifViewDialogId + " ." + self._options.dialogErrorMessageClass);
							$dialogError.html(self._options.dialogOutRangeValueMessage.replace("{0}", minPos).replace("{1}", maxPos));
							$dialogError.show();
							return;
						}
						self._replaceWithSequence(seq, pos, extraCopies, basePairs);
						$(this).dialog("close");
					}
				},
				{
					text: "Cancel",
					click : function() {
						$(this).dialog("close");
					}
				}
			]
		});
	},
	
	// Get triples of motif with minimum circadian amplitude
	_getMotifMinCircadianTriple : function(workId, fileName, range) {
		var self = this;
		var property = self._motifProperty.getPropertyByLabel(self._options.sinePhaseProperty);
		var amplitudeProperty = self._motifProperty.getPropertyByLabel(self._options.sineAmplitudeProperty);
		var triples = LinkData.getTriplesByProperty(workId, fileName, property);
		var arr = range.split("-");
		var startValue = arr[0];
		var endValue = arr[1];
//		var maxIndex = -1;
//		var maxValue = -99999;
		var minIndex = -1;
		var minValue = 99999;
		$.each (triples, function(tKey, tValue) {
			var tmpVal = parseFloat(tValue.object);
			if ($.inArray(tValue.subject, self.filteredSubjectList) >= 0 &&
				tmpVal >= startValue && tmpVal < endValue) {
				var amplitude = LinkData.getObjects(workId, fileName, tValue.subject, amplitudeProperty)[0];
//				if (maxValue < amplitude) {
//					maxValue = amplitude;
//					maxIndex = tKey;
//				}
				if (minValue > amplitude) {
					minValue = amplitude;
					minIndex = tKey;
				}
			}
		});
//		if (maxIndex != -1) {
//			return triples[maxIndex];
//		}
		if (minIndex != -1) {
			return triples[minIndex];
		}
		return;
	},
	
	_getDataBaseWebsiteName : function() {
		var self = this;
		var fileName = self._options.fileName
		if (fileName.indexOf(self._options.websiteNameAtted) > -1) {
			return self._options.websiteNameAtted;
		} else if (fileName.indexOf(self._options.websiteNamePpdb) > -1) {
			return self._options.websiteNamePpdb;
		} else {
			return "UNKNOWN";
		}
	},
	
	_motifMinCircadianSequence : function(workId, fileName, subject) {
		var self = this, seqHtml = self._appSequence.getSequenceHtml(subject);
		var sb = [];
		sb[sb.length] = "<div class='baseSequence'>" + self._baseSequence + "</div>";
		sb[sb.length] = seqHtml;
		$("#" + self._containerId + " ." + self._options.resultAreaClass).html(sb.join(""));
		if (seqHtml.length == 0) {
			$("#" + self._containerId + " ." + self._options.replaceButtonAreaClass).hide();
		}
	},
	
	_getMinPosition : function(seq) {
		var self = this;
		var mod = seq.length % 2;
		var tHold = (mod == 1) ? 1 : 0.5;
		return self._default.baseSequenceMinLength + Math.floor(seq.length / 2) + tHold;
	},
	
	_getMaxPosition : function(seq) {
		var self = this;
		var mod = seq.length % 2;
		var tHold = (mod == 1) ? 0 : 0.5;
		return self._baseSequence.length - 1 - Math.floor(seq.length / 2) + tHold;
	},
	
	_getSeqElBySeq : function(seq) {
		if (seq && seq.trim().length == 7) {
			return this._heptamer.getBySequence(seq);
		} else if (seq && seq.trim().length == 8) {
			return this._octamer.getBySequence(seq);
		}
	},
	
	_showDatabaseInfo : function(seqVal) {
		var self = this, fileName = self._options.fileName, appName = self._options.appName;
		var propLabel = $("option:selected", "#" + self._containerId + " ." + self._options.selectPropertyClass).val();
		var label = self._motifProperty.getPropertyNameByLabel(propLabel);
		label = (label && label.trim().length != 0) ? label : propLabel;
		var usedMotif = (seqVal.length != 0) ? seqVal.toString() : "-";
		var dbInfoHtml = self._getDatabaseInfo(fileName, appName, label, usedMotif);
		$("#" + self._containerId + " ." + self._options.databaseInfoClass).html(dbInfoHtml);
		$("#" + self._containerId + " ." + self._options.databaseInfoClass).show();
	},
	
	_getDatabaseInfo : function(fileName, method, property, motif) {
		var sb = [];
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Database</div>";
		sb[sb.length] = "<div class='left'>" + fileName + "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Application</div>";
		sb[sb.length] = "<div class='left'>" + method + "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Range</div>";
		sb[sb.length] = "<div class='left'>" + property + "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Motif</div>";
		sb[sb.length] = "<div class='left'>" + motif + "</div>";
		sb[sb.length] = "</div>";
		return sb.join("");
	},
	
	_replaceWithSequence : function(seq, pos, extraCopies, basePairs) {
		var self = this;
		var html = self._appSequence.replaceWith(seq, pos, extraCopies, basePairs);
		$("#" + self._containerId + " ." + self._options.replaceSequenceClass).html(html);
		$("#" + self._containerId + " ." + self._options.replaceSequenceClass).show();
		self._showDatabaseInfo(seq);
		self._options.callback();
	}
	
};


// Application.motifProperty method
Application.motifProperty = function() {
	this._init.apply(this, arguments);
};

Application.motifProperty.prototype = {

	_options : null,
	_propMap : null,
	_nameMap : null,
	
	_default : {
		nameMappingNamespace : "http://atted.jp/help/slide_GeneExp_v3.shtml#",
		nameMappingProperty : "http://purl.org/dc/elements/1.1/title",
		propertyMappingExpression : "Expression",
		propertyMappingWorkUri : "http://linkdata.org/work"
	},
	
	_init : function(options) {
		this._options = $.extend({}, this._default, options);
		this._propMap = [];
		this._nameMap = [];
		this._initPropMap(this._options);
		this._initNameMap();
	},
	
	_initPropMap : function(opts) {
		var self = this, workId = opts.workId, fileName = opts.fileName;
		$.each(LinkData.getProperties(workId, fileName), function(key, value) {
			var label = self._getLabel(value);
			if (!self._propMap[label]) {
				self._propMap[label] = value;
			}
		});
	},
	
	_initNameMap : function() {
		var self = this, nameKey;
		$.each(LinkData.getWorks(), function(workKey, workId) {
			$.each(LinkData.getFiles(workId), function(fileKey, fileName) {
				$.each(LinkData.getSubjects(workId, fileName), function(subKey, subValue) {
					nameKey = self._getNameKey(subValue);
					if (nameKey) {
						var nameArray = LinkData.getObjects(workId, fileName, subValue, self._options.nameMappingProperty);
						if (nameArray && nameArray.length > 0) {
							self._nameMap[nameKey] = nameArray[0];
						}
					}
				});
			});
		});
	},
	
	_getNameKey : function(value) {
		var key;
		if (value && value.indexOf(this._options.nameMappingNamespace) >= 0) {
			key = value.split("#")[1];
		}
		return key;
	},
	
	_getLabel : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},
	
	getOptionArray : function() {
		var self = this, list = new Object();
		var workId = self._options.workId, fileName = self._options.fileName;
		$.each(LinkData.getProperties(workId, fileName), function(key, value) {
			if (value.indexOf(self._options.propertyMappingWorkUri) > -1 || value.indexOf(self._options.propertyMappingExpression) > -1) {
				var propLabel = self._getLabel(value);
				var name = self._nameMap[propLabel];
				list[propLabel] = (name) ? name : propLabel;
			}
		});
		return list;
	},
	
	getPropertyByLabel : function(label) {
		return this._propMap[label];
	},
	
	getPropertyNameByLabel : function(label) {
		return this._nameMap[label];
	}

};


// Application.sequence method
Application.sequence = function() {
	this._init.apply(this, arguments);
};

Application.sequence.prototype = {
	
	CHAR_SEQ_EMPTY : "-",
	
	_options : null,
	_workId : null,
	_fileName : null,
	_seqProperty : null,
	_posProperty : null,
	_baseSequence : null,
	_sequenceList : null,
	_positionList : null,
	_containerId : null,
	_errorContainerClass : null,
	_outOfRangeArray : null,
	
	_default : {
		msgInvalidSequence: "invalid sequence.",
		msgOutOfRangeSequence: "out of range sequence : {0}",
	},
	
	_init : function(options) {
		this._options = options;
		this._workId = this._options.workId;
		this._fileName = this._options.fileName;
		this._seqProperty = this._options.motifSequenceProperty;
		this._posProperty = this._options.motifPositionProperty;
		this._baseSequence = this._options.baseSequence;
		this._containerId = this._options.containerId;
		this._errorContainerClass = this._options.errorMessageClass;
	},
	
	_getCustomSequenceHtml : function(baseSequence, sequence, position) {
		var seqLen = sequence.length;
		var tHold = Math.floor(seqLen / 2) + 1;
		var pos = parseInt(position);
		var baseSeqLen = baseSequence.length;
		var suffixLen = baseSeqLen - tHold - pos;
		var sb = [];
		if (pos > this._options.baseSequenceMinLength && suffixLen > 0) {
			for (var i = 0; i < suffixLen; i++) {
				sb.push(this.CHAR_SEQ_EMPTY);
			}
			sb.push("<a href='javascript:void(0)' class='motifSequence'>" + sequence + "</a>");
			sb.push("<input type='hidden' class='hdnSequence' value='" + sequence + "'/>");
			sb.push("<input type='hidden' class='hdnPosition' value='" + pos + "'/>");
		} else {
			//_showError($appContainer, opts.msgOutOfRangeSequence.replace("{0}", sequence));
			this._outOfRangeArray.push(sequence + "[" + pos + "]");
			this._showError(this._default.msgOutOfRangeSequence.replace("{0}", this._outOfRangeArray.toString()));
		}
		return sb.join("");
	},
	
	_isValidSequenceList : function(seqs) {
		var count = seqs.length;
		var maxlength = 0;
		for (var i = 0; i < count; i++) {
			if (seqs[i].length > maxlength) {
				maxlength = seqs[i].length;
			}
		}
		var result = true;
		for (var i = 0; i < maxlength; i++) {
			var chars = [];
			for (var j = 0; j < count; j++) {
				chars.push(seqs[j].charAt(i));
			}
			if (! this._isValidChars(chars.join(""))) {
				result = false;
				break;
			}
		}
		return result;
	},
	
	_isValidChars : function(charString) {
		var charLen = charString.length;
		var result = true;
		var first = null;
		for (var i = 0; i < charLen; i++) {
			if (charString.charAt(i) == this.CHAR_SEQ_EMPTY) {
				continue;
			}
			if (! first) {
				first = charString.charAt(i);
			}
			var current = charString.charAt(i);
			if (current && first != current) {
				result = false;
				break;
			}
		}
		return result;
	},
	
	_getReplacedCustomSequence : function(seqs) {
		var mergeSequence = this._getmergeCharSequence(seqs);
		var maxlength = this._baseSequence.length;
		
		var sb = [];
		for (var i = 0; i < maxlength; i++) {
			var bChar = this._baseSequence.charAt(i);
			var mChar = mergeSequence.charAt(i);
			if (mChar !== this.CHAR_SEQ_EMPTY) {
				// replaced
				sb.push(mChar);
			} else {
				sb.push(bChar);
			}
		}
		
		return sb.join("");
	},
	
	_getmergeCharSequence : function(seqs) {
		var count = seqs.length;
		var maxlength = this._baseSequence.length;
		var sb = [];
		for (var i = 0; i < maxlength; i++) {
			var chars = [];
			for (var j = 0; j < count; j++) {
				chars.push(seqs[j].charAt(i) ? seqs[j].charAt(i) : this.CHAR_SEQ_EMPTY);
			}
			sb.push(this._getMergeChar(chars.join("")));
		}
		return sb.join("");
	},
	
	_getMergeChar : function(charString) {
		var charLen = charString.length;
		var result = null;
		for (var i = 0; i < charLen; i++) {
			if (charString.charAt(i) !== this.CHAR_SEQ_EMPTY) {
				result = charString.charAt(i);
				break;
			}
		}
		if (!result) {
			result = this.CHAR_SEQ_EMPTY;
		}
		return result;
	},
	
	_wrappedReplacedSequenceHtml : function(replaceSequence, seqs) {
		var mergeSequence = this._getmergeCharSequence(seqs);
		var length = this._baseSequence.length;
		var sb = [];
		for (var i = 0; i < length; i++) {
			var bChar = this._baseSequence.charAt(i);
			var rChar = replaceSequence.charAt(i);
			var mChar = mergeSequence.charAt(i);
			var seqChar = (bChar !== rChar) ? "<span class='replace'>" + rChar + "</span>" : rChar;
			if (mChar !== this.CHAR_SEQ_EMPTY) {
				sb.push("<span class='highlight-sequence'>" + seqChar + "</span>");
			} else {
				sb.push(seqChar);
			}
		}
		return sb.join("");
	},
	
	_showError : function(message) {
		$errorMessageContainer = $("#" + this._containerId + " ." + this._errorContainerClass);
		$errorMessageContainer.html(message);
		$errorMessageContainer.show();
	},
	
	getSequenceHtml : function(subject) {
		var self = this;
		self._outOfRangeArray = [];
		var sequenceList = LinkData.getObjects(self._workId, self._fileName, subject, self._seqProperty);
		var positionList = LinkData.getObjects(self._workId, self._fileName, subject, self._posProperty);
		var sb = [], baseSequence = self._baseSequence;
		for (var i = 0; i < sequenceList.length; i++) {
			var customSeqString = this._getCustomSequenceHtml(baseSequence, sequenceList[i], positionList[i]);
			if (customSeqString.length > 0) {
				sb.push("<div class='userSequence'>" + customSeqString + "</div>");
			}
		}
		return sb.join("\n");
	},
	
	replace : function(seqs) {
		var isValid = this._isValidSequenceList(seqs);
		if (isValid) {
			if (seqs.length > 0) {
				var replaceSeq = this._getReplacedCustomSequence(seqs);
				var replaceSeqHtml = this._wrappedReplacedSequenceHtml(replaceSeq, seqs);
				return replaceSeqHtml;
			}
		} else {
			//$appContainer.find("." + opts.appReplaceResultAreaContainerClz).hide();
			//_showError($appContainer, opts.msgInvalidSequence);
			this._showError(this._default.msgInvalidSequence);
		}
	},
	
	replaceWith : function(seq, pos, extraCopies, basePairs) {
		var main = [];
		var seqLen = seq.length;
		var tHold = Math.floor(seqLen / 2) + 1;
		var pos = parseInt(pos);
		var baseSeqLen = this._baseSequence.length;
		var len = baseSeqLen - tHold - pos;
		for (var j = 0; j < extraCopies + 1; j++) {
			var array = [];
			for (var i = 0; i < len; i++) {
				array.push(this.CHAR_SEQ_EMPTY);
			}
			array.push(seq);
			main.push(array.join(""));
			len = len - seqLen - basePairs;
			if (len < 0) {
				break;
			}
		}
		return this.replace(main);
	},
	
	hideError : function() {
		$errorMessageContainer = $("#" + this._containerId + " ." + this._errorContainerClass).hide();
	}
	
};


// Application.heptamer method
Application.heptamer = function() {
	this._init.apply(this, arguments);
};

Application.heptamer.prototype = {
	
	_heptamerMap : null,
	
	_default : {
		filterSubjectUrlPhrase : "http://atted.jp/data/cis/",
		filterSequencePropertyPhrase : "motif%20sequence",
		filterMaxCEGPropertyPhrase : "maxCEG",
		filterAppropriatePosition : "Appropriateposition(%C2%B1%2040%20bp)"
	},
	
	_init : function() {
		this._heptamerMap = new Object();
		this._initHeptamerList();
	},
	
	_initHeptamerList : function() {
		var self = this;
		$.each(LinkData.getWorks(), function(workKey, workId) {
			$.each(LinkData.getFiles(workId), function(fileKey, fileName) {
				$.each(LinkData.getSubjects(workId, fileName), function(subKey, subValue) {
					if (self._isHeptamerSubject(subValue)) {
						var triples = LinkData.getTriplesBySubject(workId, fileName, subValue);
						//var obj = self._getObjectByTriple(triples);
						var seqEl = self._getObjectByTriple(triples);
						var seq = seqEl.getSequence();
						if (seq && seq.trim().length != 0) {
							seqEl.setExternalUrl(subValue);
							//obj.url = subValue;
							self._heptamerMap[seq] = seqEl;
						}
					}
				});
			});
		});
	},
	
	_getObjectByTriple : function(triples) {
		var self = this;
		//var obj = {};
		var seqEl = new Application.seqElement();
		$.each(triples, function(key, value) {
			var property = value.property;
			if (property.indexOf(self._default.filterSequencePropertyPhrase) >= 0) {
				seqEl.setSequence(value.object);
				//obj.sequence = value.object;
			} else if (property.indexOf(self._default.filterAppropriatePosition) >= 0) {
				seqEl.setAppropriatePos(value.object);
				//obj.appropriatePos = value.object;
			}
		});
		return seqEl;
	},
	
	_isHeptamerSubject : function(subject) {
		var self = this;
		if (!subject) {
			return false;
		}
		if (subject.indexOf(self._default.filterSubjectUrlPhrase) > -1) {
			return true;
		}
		return false;
	},
	
	getBySequence : function(sequence) {
		return this._heptamerMap[sequence];
	}
	
};


// Application.octamer method
Application.octamer = function() {
	this._init.apply(this, arguments);
};

Application.octamer.prototype = {
	
	_octamerMap : null,
	
	_default : {
		filterSubjectUrlPhrase : "http://ppdb.agr.gifu-u.ac.jp/ppdb/cgi-bin/",
		filterSequencePropertyPhrase : "sequence",
		filterAppropriatePosition : "Appropriate%20position"
	},
	
	_init : function() {
		this._octamerMap = new Object();
		this._initOctamerList();
	},
	
	_initOctamerList : function() {
		var self = this;
		$.each(LinkData.getWorks(), function(workKey, workId) {
			$.each(LinkData.getFiles(workId), function(fileKey, fileName) {
				$.each(LinkData.getSubjects(workId, fileName), function(subKey, subValue) {
					if (self._isOctamerSubject(subValue)) {
						var triples = LinkData.getTriplesBySubject(workId, fileName, subValue);
						var seqEl = self._getObjectByTriple(triples);
						var seq = seqEl.getSequence();
						if (seq && seq.trim().length != 0) {
							seqEl.setExternalUrl(subValue);
							//obj.url = subValue;
							self._octamerMap[seq] = seqEl;
						}
					}
				});
			});
		});
	},
	
	_getObjectByTriple : function(triples) {
		var self = this;
		//var obj = {};
		var seqEl = new Application.seqElement();
		$.each(triples, function(key, value) {
			var property = value.property;
			if (property.indexOf(self._default.filterSequencePropertyPhrase) >= 0) {
				seqEl.setSequence(value.object);
				//obj.sequence = value.object;
			} else if (property.indexOf(self._default.filterAppropriatePosition) >= 0) {
				seqEl.setAppropriatePos(value.object);
				//obj.appropriatePos = value.object;
			}
		});
		return seqEl;
	},
	
	_isOctamerSubject : function(subject) {
		var self = this;
		if (!subject) {
			return false;
		}
		if (subject.indexOf(self._default.filterSubjectUrlPhrase) > -1) {
			return true;
		}
		return false;
	},
	
	getBySequence : function(sequence) {
		return this._octamerMap[sequence];
	}
	
};


// Application.seqElement method
Application.seqElement = function() {
	this._init.apply(this, arguments);
};

Application.seqElement.prototype = {
	
	_externalUrl : null,
	_sequence : null,
	_appropriatePos : null,
	
	_init : function() {},
	
	getExternalUrl : function() {
		return this._externalUrl;
	},

	setExternalUrl : function(externalUrl) {
		this._externalUrl = externalUrl;
	},
	
	getSequence : function() {
		return this._sequence;
	},
	
	setSequence : function(sequence) {
		this._sequence = sequence;
	},
	
	getAppropriatePos : function() {
		return this._appropriatePos;
	},
	
	setAppropriatePos : function(appropriatePos) {
		this._appropriatePos = appropriatePos;
	}
	
};


// Main function
$(document).ready(function() {
	var containerId = "container";
	
	// Set work ID, file name, and base sequence
	var options = {
		workId : "rdf1s288i",
		fileName : "DiurnalHours_ATTED_COL_LDHH",
		baseSequence : "GAAAAAAGACGTTCCAACCACGTCTTCAAAGCAAGTGATTGGATTAAGGTTCTTCCACACGGTAAGGGATGGCACTAACACCTACCATCCTTCGCAAGACCCTTCCTCTATATAAGGAAGTTCATTTCATTTGGAGAGGACCTCGAC"
	};
	
	// Application.motifMinCircadian method
	new Application.motifMinCircadian(containerId, options);
});
